/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.nativo.jlibaio.util;

import org.apache.activemq.artemis.nativo.jlibaio.SubmitInfo;

public class CallbackCache<Callback extends SubmitInfo> {
    private final SubmitInfo[] pool;
    private int put = 0;
    private int get = 0;
    private int available = 0;
    private final int size;
    private final Object lock = new Object();

    public CallbackCache(int size) {
        this.pool = new SubmitInfo[size];
        this.size = size;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Callback get() {
        Object object = this.lock;
        synchronized (object) {
            if (this.available <= 0) {
                return null;
            }
            SubmitInfo retValue = this.pool[this.get];
            this.pool[this.get] = null;
            if (retValue == null) {
                throw new NullPointerException("You should initialize the pool before using it");
            }
            --this.available;
            ++this.get;
            if (this.get >= this.size) {
                this.get = 0;
            }
            return (Callback)retValue;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CallbackCache put(Callback callback) {
        if (callback == null) {
            return null;
        }
        Object object = this.lock;
        synchronized (object) {
            if (this.available < this.size) {
                ++this.available;
                this.pool[this.put++] = callback;
                if (this.put >= this.size) {
                    this.put = 0;
                }
            }
        }
        return this;
    }
}

