/*
 * Decompiled with CFR 0.152.
 */
package akka.serialization.jackson;

import akka.actor.ActorSystem;
import akka.actor.ExtendedActorSystem;
import akka.annotation.InternalApi;
import akka.event.LogMarker$;
import akka.event.LogSource$;
import akka.event.Logging$;
import akka.event.MarkerLoggingAdapter;
import akka.serialization.BaseSerializer$;
import akka.serialization.Serialization;
import akka.serialization.SerializationExtension$;
import akka.serialization.Serializer;
import akka.serialization.SerializerWithStringManifest;
import akka.serialization.jackson.Compression;
import akka.serialization.jackson.Compression$Off$;
import akka.serialization.jackson.JacksonMigration;
import akka.serialization.jackson.JacksonObjectMapperProvider$;
import akka.serialization.jackson.JacksonSerializer$;
import akka.serialization.jackson.JacksonSerializer$LZ4Meta$;
import akka.util.Helpers$;
import akka.util.OptionVal;
import akka.util.OptionVal$;
import akka.util.ccompat.package;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.jsontype.impl.SubTypeValidator;
import com.typesafe.config.Config;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.NotSerializableException;
import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.nio.ByteBuffer;
import java.util.Set;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import net.jpountz.lz4.LZ4Compressor;
import net.jpountz.lz4.LZ4Factory;
import net.jpountz.lz4.LZ4SafeDecompressor;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.SeqFactory;
import scala.collection.SeqOps;
import scala.collection.StringOps$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Vector;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0005\u0011\u0005vAB3g\u0011\u0003QGN\u0002\u0004oM\"\u0005!n\u001c\u0005\u0006m\u0006!\t\u0001\u001f\u0004\u0005s\u0006\u0001!\u0010\u0003\u0004w\u0007\u0011\u0005\u0011Q\u0003\u0005\b\u00037\u0019A\u0011BA\u000f\u0011%\t)e\u0001b\u0001\n\u0013\t9\u0005\u0003\u0005\u0002J\r\u0001\u000b\u0011BA\u0018\u0011%\tYe\u0001b\u0001\n\u0013\t9\u0005\u0003\u0005\u0002N\r\u0001\u000b\u0011BA\u0018\u0011\u001d\tye\u0001C\u0001\u0003#Bq!!\u0018\u0004\t\u0003\ty\u0006C\u0004\u0002\u0004\u000e!I!!\"\t\u0013\u0005\u0005\u0016A1A\u0005\u0002\u0005\r\u0006\u0002CAZ\u0003\u0001\u0006I!!*\t\u000f\u0005U\u0016\u0001\"\u0001\u00028\u001a1\u0011\u0011Z\u0001C\u0003\u0017D!\"!:\u0011\u0005+\u0007I\u0011AAt\u0011)\ty\u000f\u0005B\tB\u0003%\u0011\u0011\u001e\u0005\u000b\u0003c\u0004\"Q3A\u0005\u0002\u0005\u001d\bBCAz!\tE\t\u0015!\u0003\u0002j\"1a\u000f\u0005C\u0001\u0003kDq!!@\u0011\t\u0003\ty\u0010C\u0004\u0003\u0018A!\tA!\u0007\t\u0013\tu\u0001#!A\u0005\u0002\t}\u0001\"\u0003B\u0013!E\u0005I\u0011\u0001B\u0014\u0011%\u0011I\u0004EI\u0001\n\u0003\u00119\u0003C\u0005\u0003<A\t\t\u0011\"\u0011\u0003>!I!\u0011\n\t\u0002\u0002\u0013\u0005\u0011q\u001d\u0005\n\u0005\u0017\u0002\u0012\u0011!C\u0001\u0005\u001bB\u0011Ba\u0015\u0011\u0003\u0003%\tE!\u0016\t\u0013\t\r\u0004#!A\u0005\u0002\t\u0015\u0004\"\u0003B5!\u0005\u0005I\u0011\tB6\u0011%\u0011y\u0007EA\u0001\n\u0003\u0012\t\bC\u0005\u0003tA\t\t\u0011\"\u0011\u0003v!I!q\u000f\t\u0002\u0002\u0013\u0005#\u0011P\u0004\b\u0005{\n\u0001\u0012\u0001B@\r\u001d\tI-\u0001E\u0001\u0005\u0003CaA^\u0013\u0005\u0002\t5\u0005\"\u0003BHK\t\u0007I\u0011AAt\u0011!\u0011\t*\nQ\u0001\n\u0005%\bb\u0002BJK\u0011\u0005!Q\u0013\u0005\b\u00053+C\u0011\u0001BN\u0011\u001d\u0011I*\nC\u0001\u0005SC\u0011Ba%&\u0003\u0003%\tI!,\t\u0013\tMV%!A\u0005\u0002\nU\u0006\"\u0003BdK\u0005\u0005I\u0011\u0002Be\u0011\u001d\u0011\t.\u0001C\u0001\u0005'4qA\u001c4\u0002\u0002)\u0014)\u000f\u0003\u0006\u0003pB\u0012)\u0019!C\u0001\u0005cD!Ba@1\u0005\u0003\u0005\u000b\u0011\u0002Bz\u0011)\u0019\t\u0001\rBC\u0002\u0013\u0005\u0011q\t\u0005\u000b\u0007\u0007\u0001$\u0011!Q\u0001\n\u0005=\u0002BCB\u0003a\t\u0015\r\u0011\"\u0001\u0004\b!Q1\u0011\u0003\u0019\u0003\u0002\u0003\u0006Ia!\u0003\t\rY\u0004D\u0011AB\n\u0011%\u0019i\u0002\rb\u0001\n\u0013\u0019y\u0002\u0003\u0005\u0004.A\u0002\u000b\u0011BB\u0011\u0011%\u0019y\u0003\rb\u0001\n\u0013\u0019\t\u0004\u0003\u0005\u0004DA\u0002\u000b\u0011BB\u001a\u0011%\u0019)\u0005\rb\u0001\n\u0013\u00199\u0005\u0003\u0005\u0004JA\u0002\u000b\u0011BA*\u0011%\u0019Y\u0005\rb\u0001\n\u001b\u0019i\u0005\u0003\u0005\u0004TA\u0002\u000bQBB(\u0011%\u0019)\u0006\rb\u0001\n\u0013\u00199\u0006\u0003\u0005\u0004hA\u0002\u000b\u0011BB-\u0011%\u0019I\u0007\rb\u0001\n\u0013\u0019Y\u0007\u0003\u0005\u0004zA\u0002\u000b\u0011BB7\u0011%\u0019Y\b\rb\u0001\n\u0013\u0019i\b\u0003\u0005\u0004\u0004B\u0002\u000b\u0011BB@\u0011%\u0019)\t\rb\u0001\n\u0013\u00199\t\u0003\u0005\u0004\u0016B\u0002\u000b\u0011BBE\u0011%\u00199\n\rb\u0001\n\u0013\u00199\u0005\u0003\u0005\u0004\u001aB\u0002\u000b\u0011BA*\u0011%\u0019Y\n\rb\u0001\n\u0013\u0019i\n\u0003\u0005\u0004,B\u0002\u000b\u0011BBP\u0011%I\u0007\u0007#b\u0001\n\u0013\u0019y\u000b\u0003\u0006\u00048BB)\u0019!C\u0005\u0007sC\u0011ba21\u0001\u0004%Iaa\u0012\t\u0013\r%\u0007\u00071A\u0005\n\r-\u0007\u0002CBha\u0001\u0006K!a\u0015\t\u0015\rE\u0007\u0007#b\u0001\n\u0013\u0019\u0019\u000e\u0003\u0006\u0004jBB)\u0019!C\u0005\u0007WD!ba=1\u0011\u000b\u0007I\u0011BB{\u0011%\u0019i\u0010\rb\u0001\n\u0003\n9\u000f\u0003\u0005\u0004\u0000B\u0002\u000b\u0011BAu\u0011\u001d!\t\u0001\rC!\t\u0007Aq\u0001\"\u00031\t\u0003\"Y\u0001C\u0004\u0005\u0010A\"I\u0001\"\u0005\t\u000f\u0011\u0015\u0002\u0007\"\u0011\u0005(!9AQ\u0006\u0019\u0005\n\u0011=\u0002b\u0002C#a\u0011%Aq\t\u0005\b\t\u0017\u0002D\u0011\u0002C'\u0011\u001d!\t\u0006\rC\u0005\t'Bq\u0001\"\u00191\t\u0013!\u0019\u0007C\u0004\u0005rA\"I\u0001b\u001d\t\u000f\u0011\u0005\u0005\u0007\"\u0003\u0005\u0004\"9Aq\u0011\u0019\u0005\n\u0011%\u0005b\u0002CFa\u0011%AQ\u0012\u0005\b\t'\u0003D\u0011\u0001CK\u0011\u001d!I\n\rC\u0001\t7\u000b\u0011CS1dWN|gnU3sS\u0006d\u0017N_3s\u0015\t9\u0007.A\u0004kC\u000e\\7o\u001c8\u000b\u0005%T\u0017!D:fe&\fG.\u001b>bi&|gNC\u0001l\u0003\u0011\t7n[1\u0011\u00055\fQ\"\u00014\u0003#)\u000b7m[:p]N+'/[1mSj,'o\u0005\u0002\u0002aB\u0011\u0011\u000f^\u0007\u0002e*\t1/A\u0003tG\u0006d\u0017-\u0003\u0002ve\n1\u0011I\\=SK\u001a\fa\u0001P5oSRt4\u0001\u0001\u000b\u0002Y\n\u0019r)\u00193hKR\u001cE.Y:t\t\u0016t\u0017\u0010T5tiN\u00111a\u001f\t\u0004y\u0006EQ\"A?\u000b\u0005y|\u0018\u0001B5na2TA!!\u0001\u0002\u0004\u0005A!n]8oif\u0004XM\u0003\u0003\u0002\u0006\u0005\u001d\u0011\u0001\u00033bi\u0006\u0014\u0017N\u001c3\u000b\u0007\u001d\fIA\u0003\u0003\u0002\f\u00055\u0011!\u00034bgR,'\u000f_7m\u0015\t\ty!A\u0002d_6L1!a\u0005~\u0005A\u0019VO\u0019+za\u00164\u0016\r\\5eCR|'\u000f\u0006\u0002\u0002\u0018A\u0019\u0011\u0011D\u0002\u000e\u0003\u0005\t\u0001\u0004Z3gCVdGOT8EKN,'o\u00117bgNt\u0015-\\3t+\t\ty\u0002\u0005\u0004\u0002\"\u0005-\u0012qF\u0007\u0003\u0003GQA!!\n\u0002(\u0005!Q\u000f^5m\u0015\t\tI#\u0001\u0003kCZ\f\u0017\u0002BA\u0017\u0003G\u00111aU3u!\u0011\t\t$a\u0010\u000f\t\u0005M\u00121\b\t\u0004\u0003k\u0011XBAA\u001c\u0015\r\tId^\u0001\u0007yI|w\u000e\u001e \n\u0007\u0005u\"/\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003\u0003\n\u0019E\u0001\u0004TiJLgn\u001a\u0006\u0004\u0003{\u0011\u0018\u0001\u00049sK\u001aL\u0007p\u00159sS:<WCAA\u0018\u00035\u0001(/\u001a4jqN\u0003(/\u001b8hA\u0005Q\u0001O]3gSb\u001c5\u0007\u0015\u0019\u0002\u0017A\u0014XMZ5y\u0007N\u0002\u0006\u0007I\u0001\u0013SN\fE\u000e\\8xK\u0012\u001cE.Y:t\u001d\u0006lW\r\u0006\u0003\u0002T\u0005e\u0003cA9\u0002V%\u0019\u0011q\u000b:\u0003\u000f\t{w\u000e\\3b]\"9\u00111\f\u0006A\u0002\u0005=\u0012!C2mCN\u001ch*Y7f\u00039I7/\u00117m_^,Gm\u00117bgN$B!a\u0015\u0002b!9\u00111M\u0006A\u0002\u0005\u0015\u0014!B2mCjT\b\u0007BA4\u0003c\u0002b!!\r\u0002j\u00055\u0014\u0002BA6\u0003\u0007\u0012Qa\u00117bgN\u0004B!a\u001c\u0002r1\u0001A\u0001DA:\u0003C\n\t\u0011!A\u0003\u0002\u0005U$aA0%cE!\u0011qOA?!\r\t\u0018\u0011P\u0005\u0004\u0003w\u0012(a\u0002(pi\"Lgn\u001a\t\u0004c\u0006}\u0014bAAAe\n\u0019\u0011I\\=\u0002)%\u001c\u0018\t\u001c7po\u0016$7\u000b\u001d:j]\u001e\u001cE.Y:t)\u0011\t\u0019&a\"\t\u000f\u0005\rD\u00021\u0001\u0002\nB\"\u00111RAH!\u0019\t\t$!\u001b\u0002\u000eB!\u0011qNAH\t1\t\t*a\"\u0002\u0002\u0003\u0005)\u0011AA;\u0005\ryFE\r\u0015\u0004\u0019\u0005U\u0005\u0003BAL\u0003;k!!!'\u000b\u0007\u0005m%/\u0001\u0006b]:|G/\u0019;j_:LA!a(\u0002\u001a\n9A/Y5me\u0016\u001c\u0017a\b3jg\u0006dGn\\<fIN+'/[1mSj\fG/[8o\u0005&tG-\u001b8hgV\u0011\u0011Q\u0015\t\u0007\u0003c\t9+!+\n\t\u00055\u00121\t\u0019\u0005\u0003W\u000by\u000b\u0005\u0004\u00022\u0005%\u0014Q\u0016\t\u0005\u0003_\ny\u000bB\u0006\u00022:\t\t\u0011!A\u0003\u0002\u0005U$aA0%g\u0005\u0001C-[:bY2|w/\u001a3TKJL\u0017\r\\5{CRLwN\u001c\"j]\u0012LgnZ:!\u0003%I7o\u0012.jaB,G\r\u0006\u0003\u0002T\u0005e\u0006bBA^\u001f\u0001\u0007\u0011QX\u0001\u0006Ef$Xm\u001d\t\u0006c\u0006}\u00161Y\u0005\u0004\u0003\u0003\u0014(!B!se\u0006L\bcA9\u0002F&\u0019\u0011q\u0019:\u0003\t\tKH/\u001a\u0002\b\u0019j#T*\u001a;b'\u0019\u0001\u0002/!4\u0002TB\u0019\u0011/a4\n\u0007\u0005E'OA\u0004Qe>$Wo\u0019;\u0011\t\u0005U\u0017q\u001c\b\u0005\u0003/\fYN\u0004\u0003\u00026\u0005e\u0017\"A:\n\u0007\u0005u'/A\u0004qC\u000e\\\u0017mZ3\n\t\u0005\u0005\u00181\u001d\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.\u001a\u0006\u0004\u0003;\u0014\u0018AB8gMN,G/\u0006\u0002\u0002jB\u0019\u0011/a;\n\u0007\u00055(OA\u0002J]R\fqa\u001c4gg\u0016$\b%\u0001\u0004mK:<G\u000f[\u0001\bY\u0016tw\r\u001e5!)\u0019\t90!?\u0002|B\u0019\u0011\u0011\u0004\t\t\u000f\u0005\u0015X\u00031\u0001\u0002j\"9\u0011\u0011_\u000bA\u0002\u0005%\u0018a\u00029vi&sGo\u001c\u000b\u0005\u0005\u0003\u00119\u0001E\u0002r\u0005\u0007I1A!\u0002s\u0005\u0011)f.\u001b;\t\u000f\t%a\u00031\u0001\u0003\f\u00051!-\u001e4gKJ\u0004BA!\u0004\u0003\u00145\u0011!q\u0002\u0006\u0005\u0005#\t9#A\u0002oS>LAA!\u0006\u0003\u0010\tQ!)\u001f;f\u0005V4g-\u001a:\u0002\u0013A\u0014X\r]3oIR{G\u0003BA_\u00057Aq!a/\u0018\u0001\u0004\ti,\u0001\u0003d_BLHCBA|\u0005C\u0011\u0019\u0003C\u0005\u0002fb\u0001\n\u00111\u0001\u0002j\"I\u0011\u0011\u001f\r\u0011\u0002\u0003\u0007\u0011\u0011^\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00132+\t\u0011IC\u000b\u0003\u0002j\n-2F\u0001B\u0017!\u0011\u0011yC!\u000e\u000e\u0005\tE\"\u0002\u0002B\u001a\u00033\u000b\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\n\t\t]\"\u0011\u0007\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017AD2paf$C-\u001a4bk2$HEM\u0001\u000eaJ|G-^2u!J,g-\u001b=\u0016\u0005\t}\u0002\u0003\u0002B!\u0005\u000fj!Aa\u0011\u000b\t\t\u0015\u0013qE\u0001\u0005Y\u0006tw-\u0003\u0003\u0002B\t\r\u0013\u0001\u00049s_\u0012,8\r^!sSRL\u0018A\u00049s_\u0012,8\r^#mK6,g\u000e\u001e\u000b\u0005\u0003{\u0012y\u0005C\u0005\u0003Ru\t\t\u00111\u0001\u0002j\u0006\u0019\u0001\u0010J\u0019\u0002\u001fA\u0014x\u000eZ;di&#XM]1u_J,\"Aa\u0016\u0011\r\te#qLA?\u001b\t\u0011YFC\u0002\u0003^I\f!bY8mY\u0016\u001cG/[8o\u0013\u0011\u0011\tGa\u0017\u0003\u0011%#XM]1u_J\f\u0001bY1o\u000bF,\u0018\r\u001c\u000b\u0005\u0003'\u00129\u0007C\u0005\u0003R}\t\t\u00111\u0001\u0002~\u0005\u0011\u0002O]8ek\u000e$X\t\\3nK:$h*Y7f)\u0011\u0011yD!\u001c\t\u0013\tE\u0003%!AA\u0002\u0005%\u0018\u0001\u00035bg\"\u001cu\u000eZ3\u0015\u0005\u0005%\u0018\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u0005\t}\u0012AB3rk\u0006d7\u000f\u0006\u0003\u0002T\tm\u0004\"\u0003B)G\u0005\u0005\t\u0019AA?\u0003\u001da%\fN'fi\u0006\u00042!!\u0007&'\u0011)\u0003Oa!\u0011\t\t\u0015%1R\u0007\u0003\u0005\u000fSAA!#\u0002(\u0005\u0011\u0011n\\\u0005\u0005\u0003C\u00149\t\u0006\u0002\u0003\u0000\u0005IAJ\u0017\u001b`\u001b\u0006;\u0015jQ\u0001\u000b\u0019j#t,T!H\u0013\u000e\u0003\u0013!B1qa2LH\u0003BA|\u0005/Cq!a/*\u0001\u0004\ti,A\u0002hKR$BA!(\u0003(B1!q\u0014BR\u0003ol!A!)\u000b\u0007\u0005\u0015\".\u0003\u0003\u0003&\n\u0005&!C(qi&|gNV1m\u0011\u001d\u0011IA\u000ba\u0001\u0005\u0017!BA!(\u0003,\"9\u00111X\u0016A\u0002\u0005uFCBA|\u0005_\u0013\t\fC\u0004\u0002f2\u0002\r!!;\t\u000f\u0005EH\u00061\u0001\u0002j\u00069QO\\1qa2LH\u0003\u0002B\\\u0005\u0007\u0004R!\u001dB]\u0005{K1Aa/s\u0005\u0019y\u0005\u000f^5p]B9\u0011Oa0\u0002j\u0006%\u0018b\u0001Bae\n1A+\u001e9mKJB\u0011B!2.\u0003\u0003\u0005\r!a>\u0002\u0007a$\u0003'\u0001\u0007xe&$XMU3qY\u0006\u001cW\r\u0006\u0002\u0003LB!!\u0011\tBg\u0013\u0011\u0011yMa\u0011\u0003\r=\u0013'.Z2u\u0003\u0015I7\u000f\u0014.5)\u0011\t\u0019F!6\t\u000f\u0005mv\u00061\u0001\u0002>\"\u001a\u0011A!7\u0011\t\tm'q\\\u0007\u0003\u0005;T1!a'k\u0013\u0011\u0011\tO!8\u0003\u0017%sG/\u001a:oC2\f\u0005/\u001b\u0015\u0004\u0001\te7c\u0001\u0019\u0003hB!!\u0011\u001eBv\u001b\u0005A\u0017b\u0001BwQ\na2+\u001a:jC2L'0\u001a:XSRD7\u000b\u001e:j]\u001el\u0015M\\5gKN$\u0018AB:zgR,W.\u0006\u0002\u0003tB!!Q\u001fB~\u001b\t\u00119PC\u0002\u0003z*\fQ!Y2u_JLAA!@\u0003x\n\u0019R\t\u001f;f]\u0012,G-Q2u_J\u001c\u0016p\u001d;f[\u000691/_:uK6\u0004\u0013a\u00032j]\u0012Lgn\u001a(b[\u0016\fABY5oI&twMT1nK\u0002\nAb\u001c2kK\u000e$X*\u00199qKJ,\"a!\u0003\u0011\t\r-1QB\u0007\u0003\u0003\u0007IAaa\u0004\u0002\u0004\taqJ\u00196fGRl\u0015\r\u001d9fe\u0006iqN\u00196fGRl\u0015\r\u001d9fe\u0002\"\u0002b!\u0006\u0004\u0018\re11\u0004\t\u0003[BBqAa<8\u0001\u0004\u0011\u0019\u0010C\u0004\u0004\u0002]\u0002\r!a\f\t\u000f\r\u0015q\u00071\u0001\u0004\n\u0005\u0019An\\4\u0016\u0005\r\u0005\u0002\u0003BB\u0012\u0007Si!a!\n\u000b\u0007\r\u001d\".A\u0003fm\u0016tG/\u0003\u0003\u0004,\r\u0015\"\u0001F'be.,'\u000fT8hO&tw-\u00113baR,'/\u0001\u0003m_\u001e\u0004\u0013\u0001B2p]\u001a,\"aa\r\u0011\t\rU2qH\u0007\u0003\u0007oQAa!\u000f\u0004<\u000511m\u001c8gS\u001eTAa!\u0010\u0002\u000e\u0005AA/\u001f9fg\u00064W-\u0003\u0003\u0004B\r]\"AB\"p]\u001aLw-A\u0003d_:4\u0007%\u0001\bjg\u0012+'-^4F]\u0006\u0014G.\u001a3\u0016\u0005\u0005M\u0013aD5t\t\u0016\u0014WoZ#oC\ndW\r\u001a\u0011\u0002\u0015\t+hMZ3s'&TX-\u0006\u0002\u0004P=\u00111\u0011K\u000f\u0003!\u0001\t1BQ;gM\u0016\u00148+\u001b>fA\u0005!2m\\7qe\u0016\u001c8/[8o\u00032<wN]5uQ6,\"a!\u0017\u0011\t\rm3\u0011\r\b\u0004[\u000eu\u0013bAB0M\u0006Y1i\\7qe\u0016\u001c8/[8o\u0013\u0011\u0019\u0019g!\u001a\u0003\u0011\u0005cwm\u001c:ji6T1aa\u0018g\u0003U\u0019w.\u001c9sKN\u001c\u0018n\u001c8BY\u001e|'/\u001b;i[\u0002\n!\"\\5he\u0006$\u0018n\u001c8t+\t\u0019i\u0007\u0005\u0005\u00022\r=\u0014qFB:\u0013\u0011\u0019\t(a\u0011\u0003\u00075\u000b\u0007\u000fE\u0002n\u0007kJ1aa\u001eg\u0005AQ\u0015mY6t_:l\u0015n\u001a:bi&|g.A\u0006nS\u001e\u0014\u0018\r^5p]N\u0004\u0013\u0001\u00033f]fd\u0015n\u001d;\u0016\u0005\r}\u0004cABA\u00079\u0011Q\u000eA\u0001\nI\u0016t\u0017\u0010T5ti\u0002\n!#\u00197m_^,Gm\u00117bgN\u0004&/\u001a4jqV\u00111\u0011\u0012\t\u0007\u0007\u0017\u001b\tJa\u0010\u000e\u0005\r5%\u0002BBH\u00057\n\u0011\"[7nkR\f'\r\\3\n\t\rM5Q\u0012\u0002\u0007-\u0016\u001cGo\u001c:\u0002'\u0005dGn\\<fI\u000ec\u0017m]:Qe\u00164\u0017\u000e\u001f\u0011\u0002\u001dQL\b/Z%o\u001b\u0006t\u0017NZ3ti\u0006yA/\u001f9f\u0013:l\u0015M\\5gKN$\b%A\u000fd_:4\u0017nZ;sK\u0012$Um]3sS\u0006d\u0017N_1uS>tG+\u001f9f+\t\u0019y\nE\u0003r\u0005s\u001b\t\u000b\r\u0003\u0004$\u000e\u001d\u0006CBA\u0019\u0003S\u001a)\u000b\u0005\u0003\u0002p\r\u001dFaCBU\u0017\u0006\u0005\t\u0011!B\u0001\u0007[\u00131a\u0018\u00136\u0003y\u0019wN\u001c4jOV\u0014X\r\u001a#fg\u0016\u0014\u0018.\u00197ju\u0006$\u0018n\u001c8UsB,\u0007%E\u0002\u0002xA,\"a!-\u0011\t\t%81W\u0005\u0004\u0007kC'!D*fe&\fG.\u001b>bi&|g.A\neKN,'/[1mSj\fG/[8o)f\u0004X-\u0006\u0002\u0004<B)\u0011O!/\u0004>B\"1qXBb!\u0019\t\t$!\u001b\u0004BB!\u0011qNBb\t-\u0019)-TA\u0001\u0002\u0003\u0015\ta!,\u0003\u0007}#c'\u0001\u0010tKJL\u0017\r\\5{CRLwN\u001c\"j]\u0012LgnZ:DQ\u0016\u001c7.\u001a3PW\u0006\u00113/\u001a:jC2L'0\u0019;j_:\u0014\u0015N\u001c3j]\u001e\u001c8\t[3dW\u0016$wj[0%KF$BA!\u0001\u0004N\"I!\u0011K(\u0002\u0002\u0003\u0007\u00111K\u0001 g\u0016\u0014\u0018.\u00197ju\u0006$\u0018n\u001c8CS:$\u0017N\\4t\u0007\",7m[3e\u001f.\u0004\u0013A\u00037{i\u0019\u000b7\r^8ssV\u00111Q\u001b\t\u0005\u0007/\u001c)/\u0004\u0002\u0004Z*!11\\Bo\u0003\ra'\u0010\u000e\u0006\u0005\u0007?\u001c\t/A\u0004ka>,h\u000e\u001e>\u000b\u0005\r\r\u0018a\u00018fi&!1q]Bm\u0005)a%\f\u000e$bGR|'/_\u0001\u000eYj$4i\\7qe\u0016\u001c8o\u001c:\u0016\u0005\r5\b\u0003BBl\u0007_LAa!=\u0004Z\niAJ\u0017\u001bD_6\u0004(/Z:t_J\fq\u0002\u001c>5\t\u0016\u001cw.\u001c9sKN\u001cxN]\u000b\u0003\u0007o\u0004Baa6\u0004z&!11`Bm\u0005Ma%\fN*bM\u0016$UmY8naJ,7o]8s\u0003)IG-\u001a8uS\u001aLWM]\u0001\fS\u0012,g\u000e^5gS\u0016\u0014\b%\u0001\u0005nC:Lg-Z:u)\u0011\ty\u0003\"\u0002\t\r\u0011\u001da\u000b1\u0001q\u0003\ry'M[\u0001\ti>\u0014\u0015N\\1ssR!\u0011Q\u0018C\u0007\u0011\u0019!9a\u0016a\u0001a\u0006\u0019Bn\\4U_\nKg.\u0019:z\tV\u0014\u0018\r^5p]RQ!\u0011\u0001C\n\t+!y\u0002\"\t\t\r\u0011\u001d\u0001\f1\u0001q\u0011\u001d!9\u0002\u0017a\u0001\t3\t\u0011b\u001d;beR$\u0016.\\3\u0011\u0007E$Y\"C\u0002\u0005\u001eI\u0014A\u0001T8oO\"9\u00111\u0018-A\u0002\u0005u\u0006b\u0002C\u00121\u0002\u0007\u0011QX\u0001\u0007e\u0016\u001cX\u000f\u001c;\u0002\u0015\u0019\u0014x.\u001c\"j]\u0006\u0014\u0018\u0010F\u0003q\tS!Y\u0003C\u0004\u0002<f\u0003\r!!0\t\u000f\u0011\u0005\u0011\f1\u0001\u00020\u0005)Bn\\4Ge>l')\u001b8bef$UO]1uS>tGC\u0003B\u0001\tc!\u0019\u0004b\u000e\u0005:!9\u00111\u0018.A\u0002\u0005u\u0006b\u0002C\u001b5\u0002\u0007\u0011QX\u0001\u0010I\u0016\u001cw.\u001c9sKN\u001c()\u001f;fg\"9Aq\u0003.A\u0002\u0011e\u0001bBA25\u0002\u0007A1\b\u0019\u0005\t{!\t\u0005\u0005\u0004\u00022\u0005%Dq\b\t\u0005\u0003_\"\t\u0005\u0002\u0007\u0005D\u0011e\u0012\u0011!A\u0001\u0006\u0003\u0019iKA\u0002`I]\nA\"[:DCN,wJ\u00196fGR$B!a\u0015\u0005J!9\u00111L.A\u0002\u0005=\u0012!F2iK\u000e\\\u0017\t\u001c7po\u0016$7\t\\1tg:\u000bW.\u001a\u000b\u0005\u0005\u0003!y\u0005C\u0004\u0002\\q\u0003\r!a\f\u0002#\rDWmY6BY2|w/\u001a3DY\u0006\u001c8\u000f\u0006\u0003\u0003\u0002\u0011U\u0003bBA2;\u0002\u0007Aq\u000b\u0019\u0005\t3\"i\u0006\u0005\u0004\u00022\u0005%D1\f\t\u0005\u0003_\"i\u0006\u0002\u0007\u0005`\u0011U\u0013\u0011!A\u0001\u0006\u0003\t)HA\u0002`Ia\nQ\"[:J]\u0006cGn\\<MSN$H\u0003BA*\tKBq!a\u0019_\u0001\u0004!9\u0007\r\u0003\u0005j\u00115\u0004CBA\u0019\u0003S\"Y\u0007\u0005\u0003\u0002p\u00115D\u0001\u0004C8\tK\n\t\u0011!A\u0003\u0002\u0005U$aA0%s\u0005Q\u0012n\u001d\"pk:$Gk\u001c&bG.\u001cxN\\*fe&\fG.\u001b>feR!\u00111\u000bC;\u0011\u001d\t\u0019g\u0018a\u0001\to\u0002D\u0001\"\u001f\u0005~A1\u0011\u0011GA5\tw\u0002B!a\u001c\u0005~\u0011aAq\u0010C;\u0003\u0003\u0005\tQ!\u0001\u0002v\t!q\fJ\u00191\u0003UA\u0017m]!mY><X\rZ\"mCN\u001c\bK]3gSb$B!a\u0015\u0005\u0006\"9\u00111\f1A\u0002\u0005=\u0012!I2iK\u000e\\\u0017\t\u001c7po\u0016$7+\u001a:jC2L'0\u0019;j_:\u0014\u0015N\u001c3j]\u001e\u001cHC\u0001B\u0001\u00035\u0001\u0018M]:f\u001b\u0006t\u0017NZ3tiR!Aq\u0012CI!\u001d\t(qXAu\u0003_Aq\u0001\"\u0001c\u0001\u0004\ty#\u0001\u0005d_6\u0004(/Z:t)\u0011\ti\fb&\t\u000f\u0005m6\r1\u0001\u0002>\u0006QA-Z2p[B\u0014Xm]:\u0015\t\u0005uFQ\u0014\u0005\b\u0003w#\u0007\u0019AA_Q\r\u0001$\u0011\u001c")
@InternalApi
public abstract class JacksonSerializer
extends SerializerWithStringManifest {
    private Serialization serialization;
    private Option<Class<?>> deserializationType;
    private LZ4Factory lz4Factory;
    private LZ4Compressor lz4Compressor;
    private LZ4SafeDecompressor lz4Decompressor;
    private final ExtendedActorSystem system;
    private final String bindingName;
    private final ObjectMapper objectMapper;
    private final MarkerLoggingAdapter log;
    private final Config conf;
    private final boolean isDebugEnabled;
    private final Compression.Algoritm compressionAlgorithm;
    private final Map<String, JacksonMigration> migrations;
    private final GadgetClassDenyList denyList;
    private final Vector<String> allowedClassPrefix;
    private final boolean typeInManifest;
    private Option<Class<?>> configuredDeserializationType;
    private boolean serializationBindingsCheckedOk;
    private final int identifier;
    private volatile byte bitmap$0;

    public static boolean isLZ4(byte[] bytes) {
        return JacksonSerializer$.MODULE$.isLZ4(bytes);
    }

    public static boolean isGZipped(byte[] bytes) {
        return JacksonSerializer$.MODULE$.isGZipped(bytes);
    }

    public static scala.collection.immutable.Set<Class<?>> disallowedSerializationBindings() {
        return JacksonSerializer$.MODULE$.disallowedSerializationBindings();
    }

    public ExtendedActorSystem system() {
        return this.system;
    }

    public String bindingName() {
        return this.bindingName;
    }

    public ObjectMapper objectMapper() {
        return this.objectMapper;
    }

    private MarkerLoggingAdapter log() {
        return this.log;
    }

    private Config conf() {
        return this.conf;
    }

    private boolean isDebugEnabled() {
        return this.isDebugEnabled;
    }

    private final int BufferSize() {
        return 4096;
    }

    private Compression.Algoritm compressionAlgorithm() {
        return this.compressionAlgorithm;
    }

    private Map<String, JacksonMigration> migrations() {
        return this.migrations;
    }

    private GadgetClassDenyList denyList() {
        return this.denyList;
    }

    private Vector<String> allowedClassPrefix() {
        return this.allowedClassPrefix;
    }

    private boolean typeInManifest() {
        return this.typeInManifest;
    }

    private Option<Class<?>> configuredDeserializationType() {
        return this.configuredDeserializationType;
    }

    private Serialization serialization$lzycompute() {
        JacksonSerializer jacksonSerializer = this;
        synchronized (jacksonSerializer) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.serialization = (Serialization)SerializationExtension$.MODULE$.apply((ActorSystem)this.system());
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.serialization;
    }

    private Serialization serialization() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.serialization$lzycompute() : this.serialization;
    }

    private Option<Class<?>> deserializationType$lzycompute() {
        JacksonSerializer jacksonSerializer = this;
        synchronized (jacksonSerializer) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.deserializationType = this.typeInManifest() ? None$.MODULE$ : this.configuredDeserializationType().orElse((Function0 & Serializable)() -> {
                    Tuple2 tuple2;
                    SeqOps seqOps;
                    Seq bindings;
                    Seq seq = bindings = (Seq)this.serialization().bindings().filter((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)JacksonSerializer.$anonfun$deserializationType$2(this, x$1)));
                    Nil$ nil$ = package$.MODULE$.Nil();
                    Seq seq2 = seq;
                    if (!(nil$ != null ? !nil$.equals(seq2) : seq2 != null)) {
                        throw new IllegalArgumentException(new StringBuilder(88).append(new StringBuilder(72).append("Jackson serializer [").append(this.bindingName()).append("] with type-in-manifest disabled must either declare").toString()).append(" a deserialization-type or have exactly one binding configured, but none were configured").toString());
                    }
                    if (seq == null || SeqFactory.UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps = package$.MODULE$.Seq().unapplySeq((SeqOps)seq)) || new SeqFactory.UnapplySeqWrapper(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps)) == null || SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 1) != 0 || (tuple2 = (Tuple2)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 0)) == null) {
                        throw new IllegalArgumentException(new StringBuilder(85).append(new StringBuilder(72).append("Jackson serializer [").append(this.bindingName()).append("] with type-in-manifest disabled must either declare").toString()).append(" a deserialization-type or have exactly one binding configured, but multiple bindings").append(new StringBuilder(19).append(" were configured [").append(seq.mkString(", ")).append("]").toString()).toString());
                    }
                    Class clazz = (Class)tuple2._1();
                    Some some = new Some(clazz.asSubclass(Object.class));
                    return some;
                });
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        this.configuredDeserializationType = null;
        return this.deserializationType;
    }

    private Option<Class<?>> deserializationType() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.deserializationType$lzycompute() : this.deserializationType;
    }

    private boolean serializationBindingsCheckedOk() {
        return this.serializationBindingsCheckedOk;
    }

    private void serializationBindingsCheckedOk_$eq(boolean x$1) {
        this.serializationBindingsCheckedOk = x$1;
    }

    private LZ4Factory lz4Factory$lzycompute() {
        JacksonSerializer jacksonSerializer = this;
        synchronized (jacksonSerializer) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                this.lz4Factory = LZ4Factory.fastestInstance();
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
        }
        return this.lz4Factory;
    }

    private LZ4Factory lz4Factory() {
        return (byte)(this.bitmap$0 & 4) == 0 ? this.lz4Factory$lzycompute() : this.lz4Factory;
    }

    private LZ4Compressor lz4Compressor$lzycompute() {
        JacksonSerializer jacksonSerializer = this;
        synchronized (jacksonSerializer) {
            if ((byte)(this.bitmap$0 & 8) == 0) {
                this.lz4Compressor = this.lz4Factory().fastCompressor();
                this.bitmap$0 = (byte)(this.bitmap$0 | 8);
            }
        }
        return this.lz4Compressor;
    }

    private LZ4Compressor lz4Compressor() {
        return (byte)(this.bitmap$0 & 8) == 0 ? this.lz4Compressor$lzycompute() : this.lz4Compressor;
    }

    private LZ4SafeDecompressor lz4Decompressor$lzycompute() {
        JacksonSerializer jacksonSerializer = this;
        synchronized (jacksonSerializer) {
            if ((byte)(this.bitmap$0 & 0x10) == 0) {
                this.lz4Decompressor = this.lz4Factory().safeDecompressor();
                this.bitmap$0 = (byte)(this.bitmap$0 | 0x10);
            }
        }
        return this.lz4Decompressor;
    }

    private LZ4SafeDecompressor lz4Decompressor() {
        return (byte)(this.bitmap$0 & 0x10) == 0 ? this.lz4Decompressor$lzycompute() : this.lz4Decompressor;
    }

    public int identifier() {
        return this.identifier;
    }

    public String manifest(Object obj) {
        String string;
        this.checkAllowedSerializationBindings();
        Option<Class<?>> option = this.deserializationType();
        if (option instanceof Some) {
            String string2;
            Some some = (Some)option;
            Class clazz = (Class)some.value();
            Option option2 = this.migrations().get((Object)clazz.getName());
            if (option2 instanceof Some) {
                Some some2 = (Some)option2;
                JacksonMigration transformer = (JacksonMigration)some2.value();
                string2 = new StringBuilder(1).append("#").append(transformer.currentVersion()).toString();
            } else if (None$.MODULE$.equals(option2)) {
                string2 = "";
            } else {
                throw new MatchError((Object)option2);
            }
            string = string2;
        } else if (None$.MODULE$.equals(option)) {
            String string3;
            String className = obj.getClass().getName();
            this.checkAllowedClassName(className);
            this.checkAllowedClass(obj.getClass());
            Option option3 = this.migrations().get((Object)className);
            if (option3 instanceof Some) {
                Some some = (Some)option3;
                JacksonMigration transformer = (JacksonMigration)some.value();
                string3 = new StringBuilder(1).append(className).append("#").append(transformer.currentVersion()).toString();
            } else if (None$.MODULE$.equals(option3)) {
                string3 = className;
            } else {
                throw new MatchError((Object)option3);
            }
            string = string3;
        } else {
            throw new MatchError(option);
        }
        return string;
    }

    public byte[] toBinary(Object obj) {
        this.checkAllowedSerializationBindings();
        long startTime = this.isDebugEnabled() ? System.nanoTime() : 0L;
        byte[] bytes = this.objectMapper().writeValueAsBytes(obj);
        byte[] result = this.compress(bytes);
        this.logToBinaryDuration(obj, startTime, bytes, result);
        return result;
    }

    private void logToBinaryDuration(Object obj, long startTime, byte[] bytes, byte[] result) {
        block2: {
            if (!this.isDebugEnabled()) break block2;
            long durationMicros = (System.nanoTime() - startTime) / 1000L;
            if (bytes.length == result.length) {
                this.log().debug("Serialization of [{}] took [{}] \u00b5s, size [{}] bytes", (Object)obj.getClass().getName(), (Object)BoxesRunTime.boxToLong((long)durationMicros), (Object)BoxesRunTime.boxToInteger((int)result.length));
            } else {
                this.log().debug("Serialization of [{}] took [{}] \u00b5s, compressed size [{}] bytes, uncompressed size [{}] bytes", (Object)obj.getClass().getName(), (Object)BoxesRunTime.boxToLong((long)durationMicros), (Object)BoxesRunTime.boxToInteger((int)result.length), (Object)BoxesRunTime.boxToInteger((int)bytes.length));
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    public Object fromBinary(byte[] bytes, String manifest) {
        block20: {
            block19: {
                this.checkAllowedSerializationBindings();
                startTime = this.isDebugEnabled() != false ? System.nanoTime() : 0L;
                var10_4 = this.parseManifest(manifest);
                if (var10_4 == null) {
                    throw new MatchError(var10_4);
                }
                fromVersion = var10_4._1$mcI$sp();
                manifestClassName = (String)var10_4._2();
                var6_7 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)fromVersion), (Object)manifestClassName);
                var9_8 = var6_7;
                fromVersion = var9_8._1$mcI$sp();
                manifestClassName = (String)var9_8._2();
                if (this.typeInManifest()) {
                    this.checkAllowedClassName(manifestClassName);
                }
                migration = this.migrations().get(this.deserializationType().fold((Function0)(Function0 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$fromBinary$1(java.lang.String ), ()Ljava/lang/String;)((String)manifestClassName), (Function1)(Function1 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$fromBinary$2(java.lang.Class ), (Ljava/lang/Class;)Ljava/lang/String;)()));
                var17_12 = false;
                var18_13 = null;
                var19_14 = migration;
                if (!(var19_14 instanceof Some)) ** GOTO lbl-1000
                var17_12 = true;
                var18_13 = (Some)var19_14;
                transformer = (JacksonMigration)var18_13.value();
                if (fromVersion < transformer.currentVersion()) {
                    var5_16 = transformer.transformClassName(fromVersion, manifestClassName);
                } else if (var17_12 && fromVersion == (transformer = (JacksonMigration)var18_13.value()).currentVersion()) {
                    var5_16 = manifestClassName;
                } else if (var17_12 && fromVersion <= (transformer = (JacksonMigration)var18_13.value()).supportedForwardVersion()) {
                    var5_16 = transformer.transformClassName(fromVersion, manifestClassName);
                } else {
                    if (var17_12 && fromVersion > (transformer = (JacksonMigration)var18_13.value()).supportedForwardVersion()) {
                        throw new IllegalStateException(new StringBuilder(0).append(new StringBuilder(22).append("Migration version ").append(transformer.supportedForwardVersion()).append(" is ").toString()).append(new StringBuilder(39).append("behind version ").append(fromVersion).append(" of deserialized type [").append(manifestClassName).append("]").toString()).toString());
                    }
                    var5_16 = manifestClassName;
                }
                className = var5_16;
                if (this.typeInManifest() && className != manifestClassName) {
                    this.checkAllowedClassName(className);
                }
                if (!this.isCaseObject(className)) break block19;
                var25_21 = this.system().dynamicAccess().getObjectFor(className, ClassTag$.MODULE$.AnyRef());
                if (!(var25_21 instanceof Success)) {
                    if (var25_21 instanceof Failure) {
                        throw new NotSerializableException(new StringBuilder(54).append("Cannot find manifest case object [").append(className).append("] for serializer [").append(this.getClass().getName()).append("].").toString());
                    }
                    throw new MatchError((Object)var25_21);
                }
                var26_22 = (Success)var25_21;
                var4_24 = obj = var26_22.value();
                result = var4_24;
                clazz = result.getClass();
                this.checkAllowedClass(clazz);
                this.logFromBinaryDuration(bytes, bytes, startTime, clazz);
                v0 = result;
                break block20;
            }
            clazz = (Class)this.deserializationType().getOrElse((Function0)(Function0 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$fromBinary$3(akka.serialization.jackson.JacksonSerializer java.lang.String ), ()Ljava/lang/Class;)((JacksonSerializer)this, (String)className));
            if (this.typeInManifest()) {
                this.checkAllowedClass(clazz);
            }
            decompressedBytes = this.decompress(bytes);
            var32_29 = false;
            var33_30 = null;
            var34_31 = migration;
            if (!(var34_31 instanceof Some)) ** GOTO lbl-1000
            var32_29 = true;
            var33_30 = (Some)var34_31;
            transformer = (JacksonMigration)var33_30.value();
            if (fromVersion < transformer.currentVersion()) {
                jsonTree = this.objectMapper().readTree(decompressedBytes);
                newJsonTree = transformer.transform(fromVersion, jsonTree);
                var3_35 = this.objectMapper().treeToValue((TreeNode)newJsonTree, clazz);
            } else if (var32_29 && fromVersion == (transformer = (JacksonMigration)var33_30.value()).currentVersion()) {
                var3_35 = this.objectMapper().readValue(decompressedBytes, clazz);
            } else if (var32_29 && fromVersion <= (transformer = (JacksonMigration)var33_30.value()).supportedForwardVersion()) {
                jsonTree = this.objectMapper().readTree(decompressedBytes);
                newJsonTree = transformer.transform(fromVersion, jsonTree);
                var3_35 = this.objectMapper().treeToValue((TreeNode)newJsonTree, clazz);
            } else {
                var3_35 = this.objectMapper().readValue(decompressedBytes, clazz);
            }
            result = var3_35;
            this.logFromBinaryDuration(bytes, decompressedBytes, startTime, clazz);
            v0 = result;
        }
        return v0;
    }

    private void logFromBinaryDuration(byte[] bytes, byte[] decompressBytes, long startTime, Class<?> clazz) {
        block2: {
            if (!this.isDebugEnabled()) break block2;
            long durationMicros = (System.nanoTime() - startTime) / 1000L;
            if (bytes.length == decompressBytes.length) {
                this.log().debug("Deserialization of [{}] took [{}] \u00b5s, size [{}] bytes", (Object)clazz.getName(), (Object)BoxesRunTime.boxToLong((long)durationMicros), (Object)BoxesRunTime.boxToInteger((int)decompressBytes.length));
            } else {
                this.log().debug("Deserialization of [{}] took [{}] \u00b5s, compressed size [{}] bytes, uncompressed size [{}] bytes", (Object)clazz.getName(), (Object)BoxesRunTime.boxToLong((long)durationMicros), (Object)BoxesRunTime.boxToInteger((int)bytes.length), (Object)BoxesRunTime.boxToInteger((int)decompressBytes.length));
            }
        }
    }

    private boolean isCaseObject(String className) {
        return className.length() > 0 && className.charAt(className.length() - 1) == '$';
    }

    private void checkAllowedClassName(String className) {
        if (!this.denyList().isAllowedClassName(className)) {
            String warnMsg = new StringBuilder(0).append(new StringBuilder(53).append("Can't serialize/deserialize object of type [").append(className).append("] in [").append(this.getClass().getName()).append("]. ").toString()).append("Disallowed (on deny list) for security reasons.").toString();
            this.log().warning(LogMarker$.MODULE$.Security(), warnMsg);
            throw new IllegalArgumentException(warnMsg);
        }
    }

    private void checkAllowedClass(Class<?> clazz) {
        if (!this.denyList().isAllowedClass(clazz)) {
            String warnMsg = new StringBuilder(0).append(new StringBuilder(53).append("Can't serialize/deserialize object of type [").append(clazz.getName()).append("] in [").append(this.getClass().getName()).append("]. ").toString()).append("Not allowed for security reasons.").toString();
            this.log().warning(LogMarker$.MODULE$.Security(), warnMsg);
            throw new IllegalArgumentException(warnMsg);
        }
        if (!this.isInAllowList(clazz)) {
            String warnMsg = new StringBuilder(190).append(new StringBuilder(53).append("Can't serialize/deserialize object of type [").append(clazz.getName()).append("] in [").append(this.getClass().getName()).append("]. ").toString()).append("Only classes that are listed as allowed are allowed for security reasons. ").append("Configure allowed classes with akka.actor.serialization-bindings or ").append("akka.serialization.jackson.allowed-class-prefix.").toString();
            this.log().warning(LogMarker$.MODULE$.Security(), warnMsg);
            throw new IllegalArgumentException(warnMsg);
        }
    }

    private boolean isInAllowList(Class<?> clazz) {
        return this.isBoundToJacksonSerializer(clazz) || this.hasAllowedClassPrefix(clazz.getName());
    }

    private boolean isBoundToJacksonSerializer(Class<?> clazz) {
        boolean bl;
        try {
            Serializer boundSerializer = this.serialization().serializerFor(clazz);
            bl = boundSerializer instanceof JacksonSerializer;
        }
        catch (Throwable throwable) {
            Option option;
            Throwable throwable2 = throwable;
            if (throwable2 == null || (option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                throw throwable;
            }
            boolean bl2 = false;
            bl = bl2;
        }
        return bl;
    }

    private boolean hasAllowedClassPrefix(String className) {
        return this.allowedClassPrefix().exists((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)className.startsWith(x$1)));
    }

    private void checkAllowedSerializationBindings() {
        block0: {
            if (this.serializationBindingsCheckedOk()) break block0;
            JacksonSerializer$.MODULE$.disallowedSerializationBindings().foreach((Function1 & Serializable)clazz -> {
                JacksonSerializer.$anonfun$checkAllowedSerializationBindings$1(this, clazz);
                return BoxedUnit.UNIT;
            });
            this.serializationBindingsCheckedOk_$eq(true);
        }
    }

    private Tuple2<Object, String> parseManifest(String manifest) {
        int i = manifest.lastIndexOf(35);
        int fromVersion = i == -1 ? 1 : StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(manifest.substring(i + 1)));
        String manifestClassName = i == -1 ? manifest : manifest.substring(0, i);
        return new Tuple2((Object)BoxesRunTime.boxToInteger((int)fromVersion), (Object)manifestClassName);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public byte[] compress(byte[] bytes) {
        boolean bl = false;
        Compression.GZip gZip = null;
        boolean bl2 = false;
        Compression.LZ4 lZ4 = null;
        Compression.Algoritm algoritm = this.compressionAlgorithm();
        if (Compression$Off$.MODULE$.equals(algoritm)) {
            return bytes;
        }
        if (algoritm instanceof Compression.GZip) {
            bl = true;
            gZip = (Compression.GZip)algoritm;
            long largerThan = gZip.largerThan();
            if ((long)bytes.length <= largerThan) {
                return bytes;
            }
        }
        if (bl) {
            ByteArrayOutputStream bos = new ByteArrayOutputStream(4096);
            try (GZIPOutputStream zip = new GZIPOutputStream(bos);){
                zip.write(bytes);
                return bos.toByteArray();
            }
        }
        if (algoritm instanceof Compression.LZ4) {
            bl2 = true;
            lZ4 = (Compression.LZ4)algoritm;
            long largerThan = lZ4.largerThan();
            if ((long)bytes.length <= largerThan) {
                return bytes;
            }
        }
        if (!bl2) throw new MatchError((Object)algoritm);
        LZ4Meta meta = JacksonSerializer$LZ4Meta$.MODULE$.apply(bytes);
        byte[] compressed = this.lz4Compressor().compress(bytes);
        return meta.prependTo(compressed);
    }

    public byte[] decompress(byte[] bytes) {
        byte[] byArray;
        if (JacksonSerializer$.MODULE$.isGZipped(bytes)) {
            GZIPInputStream in = new GZIPInputStream(new ByteArrayInputStream(bytes));
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            byte[] buffer = new byte[4096];
            try {
                this.readChunk$1(in, buffer, out);
            }
            finally {
                in.close();
            }
            byArray = out.toByteArray();
        } else {
            byte[] byArray2;
            LZ4Meta lZ4Meta;
            LZ4Meta lZ4Meta2 = JacksonSerializer$LZ4Meta$.MODULE$.get(bytes);
            if (new OptionVal((Object)lZ4Meta2) != null && !OptionVal$.MODULE$.isEmpty$extension((Object)(lZ4Meta = (LZ4Meta)OptionVal.Some$.MODULE$.unapply((Object)lZ4Meta2)))) {
                LZ4Meta meta = (LZ4Meta)OptionVal$.MODULE$.get$extension((Object)lZ4Meta);
                int srcLen = bytes.length - meta.offset();
                byArray2 = this.lz4Decompressor().decompress(bytes, meta.offset(), srcLen, meta.length());
            } else {
                byArray2 = bytes;
            }
            byArray = byArray2;
        }
        return byArray;
    }

    public static final /* synthetic */ boolean $anonfun$deserializationType$2(JacksonSerializer $this, Tuple2 x$1) {
        return ((Serializer)x$1._2()).identifier() == $this.identifier();
    }

    public static final /* synthetic */ String $anonfun$fromBinary$1(String manifestClassName$1) {
        return manifestClassName$1;
    }

    public static final /* synthetic */ String $anonfun$fromBinary$2(Class x$3) {
        return x$3.getName();
    }

    public static final /* synthetic */ Class $anonfun$fromBinary$3(JacksonSerializer $this, String className$1) {
        Class c;
        Try try_ = $this.system().dynamicAccess().getClassFor(className$1, ClassTag$.MODULE$.AnyRef());
        if (!(try_ instanceof Success)) {
            if (try_ instanceof Failure) {
                throw new NotSerializableException(new StringBuilder(48).append("Cannot find manifest class [").append(className$1).append("] for serializer [").append($this.getClass().getName()).append("].").toString());
            }
            throw new MatchError((Object)try_);
        }
        Success success = (Success)try_;
        Class clazz = c = (Class)success.value();
        return clazz;
    }

    private final boolean isBindingOk$1(Class clazz) {
        boolean bl;
        block4: {
            try {
                if (this.serialization().serializerFor(clazz) != this) {
                    bl = true;
                    break block4;
                }
                bl = false;
            }
            catch (Throwable throwable) {
                Option option;
                Throwable throwable2 = throwable;
                if (throwable2 == null || (option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                    throw throwable;
                }
                boolean bl2 = true;
                bl = bl2;
            }
        }
        return bl;
    }

    public static final /* synthetic */ void $anonfun$checkAllowedSerializationBindings$1(JacksonSerializer $this, Class clazz) {
        if (!$this.isBindingOk$1(clazz)) {
            String warnMsg = new StringBuilder(133).append("For security reasons it's not allowed to bind open-ended interfaces like ").append(new StringBuilder(10).append("[").append(clazz.getName()).append("] to [").append($this.getClass().getName()).append("]. ").toString()).append("Change your akka.actor.serialization-bindings configuration.").toString();
            $this.log().warning(LogMarker$.MODULE$.Security(), warnMsg);
            throw new IllegalArgumentException(warnMsg);
        }
    }

    private final void readChunk$1(GZIPInputStream in$1, byte[] buffer$1, ByteArrayOutputStream out$1) {
        block3: while (true) {
            int n = in$1.read(buffer$1);
            switch (n) {
                case -1: {
                    break block3;
                }
                default: {
                    out$1.write(buffer$1, 0, n);
                    break;
                }
            }
        }
    }

    public JacksonSerializer(ExtendedActorSystem system, String bindingName, ObjectMapper objectMapper) {
        None$ none$;
        block11: {
            Compression.Algoritm algoritm;
            block10: {
                this.system = system;
                this.bindingName = bindingName;
                this.objectMapper = objectMapper;
                this.log = Logging$.MODULE$.withMarker((ActorSystem)system, JacksonSerializer.class, LogSource$.MODULE$.fromAnyClass());
                this.conf = JacksonObjectMapperProvider$.MODULE$.configForBinding(bindingName, system.settings().config());
                this.isDebugEnabled = this.conf().getBoolean("verbose-debug-logging") && this.log().isDebugEnabled();
                String string = Helpers$.MODULE$.toRootLowerCase(this.conf().getString("compression.algorithm"));
                switch (string == null ? 0 : string.hashCode()) {
                    case 107622: {
                        if (!"lz4".equals(string)) break;
                        Long compressLargerThan = this.conf().getBytes("compression.compress-larger-than");
                        algoritm = new Compression.LZ4(Predef$.MODULE$.Long2long(compressLargerThan));
                        break block10;
                    }
                    case 109935: {
                        if (!"off".equals(string)) break;
                        algoritm = Compression$Off$.MODULE$;
                        break block10;
                    }
                    case 3189082: {
                        if (!"gzip".equals(string)) break;
                        Long compressLargerThan = this.conf().getBytes("compression.compress-larger-than");
                        algoritm = new Compression.GZip(Predef$.MODULE$.Long2long(compressLargerThan));
                        break block10;
                    }
                }
                throw new IllegalArgumentException(new StringBuilder(15).append(new StringBuilder(54).append("Unknown compression algorithm [").append(string).append("], possible values are ").toString()).append("\"off\" or \"gzip\"").toString());
            }
            this.compressionAlgorithm = algoritm;
            this.migrations = (Map)package.JavaConverters$.MODULE$.MapHasAsScala(this.conf().getConfig("migrations").root().unwrapped()).asScala().toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()).map((Function1 & Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                String k = (String)tuple2._1();
                Object v = tuple2._2();
                JacksonMigration transformer = (JacksonMigration)this.system().dynamicAccess().createInstanceFor(v.toString(), (Seq)package$.MODULE$.Nil(), ClassTag$.MODULE$.apply(JacksonMigration.class)).get();
                Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)k), (Object)transformer);
                return tuple22;
            });
            this.denyList = new GadgetClassDenyList();
            this.allowedClassPrefix = package.JavaConverters$.MODULE$.ListHasAsScala(this.conf().getStringList("allowed-class-prefix")).asScala().toVector();
            this.typeInManifest = this.conf().getBoolean("type-in-manifest");
            String string = this.conf().getString("deserialization-type");
            switch (string == null ? 0 : string.hashCode()) {
                case 0: {
                    if (!"".equals(string)) break;
                    none$ = None$.MODULE$;
                    break block11;
                }
            }
            Try try_ = system.dynamicAccess().getClassFor(string, ClassTag$.MODULE$.AnyRef());
            if (!(try_ instanceof Success)) {
                if (try_ instanceof Failure) {
                    throw new IllegalArgumentException(new StringBuilder(61).append("Cannot find deserialization-type [").append(string).append("] for Jackson serializer [").append(bindingName).append("]").toString());
                }
                throw new MatchError((Object)try_);
            }
            Success success = (Success)try_;
            Class c = (Class)success.value();
            Some some = new Some((Object)c);
            none$ = some;
        }
        this.configuredDeserializationType = none$;
        this.serializationBindingsCheckedOk = false;
        this.identifier = BaseSerializer$.MODULE$.identifierFromConfig(bindingName, system);
    }

    public static class GadgetClassDenyList
    extends SubTypeValidator {
        private final String prefixSpring;
        private final String prefixC3P0;

        private Set<String> defaultNoDeserClassNames() {
            return SubTypeValidator.DEFAULT_NO_DESER_CLASS_NAMES;
        }

        private String prefixSpring() {
            return this.prefixSpring;
        }

        private String prefixC3P0() {
            return this.prefixC3P0;
        }

        public boolean isAllowedClassName(String className) {
            return this.defaultNoDeserClassNames().contains(className) ? false : !className.startsWith(this.prefixC3P0()) || !className.endsWith("DataSource");
        }

        public boolean isAllowedClass(Class<?> clazz) {
            return clazz.getName().startsWith(this.prefixSpring()) ? this.isAllowedSpringClass(clazz) : true;
        }

        private boolean isAllowedSpringClass(Class<?> clazz) {
            boolean bl;
            while (true) {
                if (clazz == null || clazz.equals(Object.class)) {
                    bl = true;
                    break;
                }
                String name = clazz.getSimpleName();
                if ("AbstractPointcutAdvisor".equals(name) || "AbstractApplicationContext".equals(name)) {
                    bl = false;
                    break;
                }
                clazz = clazz.getSuperclass();
            }
            return bl;
        }

        public GadgetClassDenyList() {
            this.prefixSpring = "org.springframework.";
            this.prefixC3P0 = "com.mchange.v2.c3p0.";
        }
    }

    public static final class LZ4Meta
    implements Product,
    Serializable {
        private final int offset;
        private final int length;

        public Iterator<String> productElementNames() {
            return Product.productElementNames$((Product)this);
        }

        public int offset() {
            return this.offset;
        }

        public int length() {
            return this.length;
        }

        public void putInto(ByteBuffer buffer) {
            buffer.putInt(JacksonSerializer$LZ4Meta$.MODULE$.LZ4_MAGIC());
            buffer.putInt(this.length());
        }

        public byte[] prependTo(byte[] bytes) {
            ByteBuffer buffer = ByteBuffer.allocate(bytes.length + this.offset());
            this.putInto(buffer);
            buffer.put(bytes);
            return buffer.array();
        }

        public LZ4Meta copy(int offset, int length) {
            return new LZ4Meta(offset, length);
        }

        public int copy$default$1() {
            return this.offset();
        }

        public int copy$default$2() {
            return this.length();
        }

        public String productPrefix() {
            return "LZ4Meta";
        }

        public int productArity() {
            return 2;
        }

        public Object productElement(int x$1) {
            Object object;
            int n = x$1;
            switch (n) {
                case 0: {
                    object = BoxesRunTime.boxToInteger((int)this.offset());
                    break;
                }
                case 1: {
                    object = BoxesRunTime.boxToInteger((int)this.length());
                    break;
                }
                default: {
                    object = Statics.ioobe((int)x$1);
                    break;
                }
            }
            return object;
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof LZ4Meta;
        }

        public String productElementName(int x$1) {
            String string;
            int n = x$1;
            switch (n) {
                case 0: {
                    string = "offset";
                    break;
                }
                case 1: {
                    string = "length";
                    break;
                }
                default: {
                    string = (String)Statics.ioobe((int)x$1);
                    break;
                }
            }
            return string;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)this.offset());
            n = Statics.mix((int)n, (int)this.length());
            return Statics.finalizeHash((int)n, (int)2);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof LZ4Meta)) return false;
            boolean bl = true;
            if (!bl) return false;
            LZ4Meta lZ4Meta = (LZ4Meta)x$1;
            if (this.offset() != lZ4Meta.offset()) return false;
            if (this.length() != lZ4Meta.length()) return false;
            return true;
        }

        public LZ4Meta(int offset, int length) {
            this.offset = offset;
            this.length = length;
            Product.$init$((Product)this);
        }
    }
}

