/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.protocol.core.impl.wireformat;

import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.core.protocol.core.impl.PacketImpl;

public final class Ping
extends PacketImpl {
    private long connectionTTL;

    public Ping(long connectionTTL) {
        super((byte)10);
        this.connectionTTL = connectionTTL;
    }

    public Ping() {
        super((byte)10);
    }

    public long getConnectionTTL() {
        return this.connectionTTL;
    }

    @Override
    public void encodeRest(ActiveMQBuffer buffer) {
        buffer.writeLong(this.connectionTTL);
    }

    @Override
    public void decodeRest(ActiveMQBuffer buffer) {
        this.connectionTTL = buffer.readLong();
    }

    @Override
    public boolean isRequiresConfirmations() {
        return false;
    }

    @Override
    public int expectedEncodeSize() {
        return 21;
    }

    @Override
    public String toString() {
        StringBuffer buf = new StringBuffer(this.getParentString());
        buf.append(", connectionTTL=" + this.connectionTTL);
        buf.append("]");
        return buf.toString();
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (int)(this.connectionTTL ^ this.connectionTTL >>> 32);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof Ping)) {
            return false;
        }
        Ping other = (Ping)obj;
        return this.connectionTTL == other.connectionTTL;
    }
}

