/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.management.impl;

import java.util.List;
import java.util.Map;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanOperationInfo;
import org.apache.activemq.artemis.api.core.JsonUtil;
import org.apache.activemq.artemis.api.core.management.ClusterConnectionControl;
import org.apache.activemq.artemis.core.config.ClusterConnectionConfiguration;
import org.apache.activemq.artemis.core.management.impl.AbstractControl;
import org.apache.activemq.artemis.core.management.impl.MBeanInfoHelper;
import org.apache.activemq.artemis.core.persistence.StorageManager;
import org.apache.activemq.artemis.core.server.cluster.ClusterConnection;
import org.apache.activemq.artemis.core.server.cluster.impl.BridgeMetrics;
import org.apache.activemq.artemis.logs.AuditLogger;

public class ClusterConnectionControlImpl
extends AbstractControl
implements ClusterConnectionControl {
    private final ClusterConnection clusterConnection;
    private final ClusterConnectionConfiguration configuration;

    public ClusterConnectionControlImpl(ClusterConnection clusterConnection, StorageManager storageManager, ClusterConnectionConfiguration configuration) throws Exception {
        super(ClusterConnectionControl.class, storageManager);
        this.clusterConnection = clusterConnection;
        this.configuration = configuration;
    }

    public String getAddress() {
        if (AuditLogger.isBaseLoggingEnabled()) {
            AuditLogger.getAddress((Object)this.clusterConnection);
        }
        this.clearIO();
        try {
            String string = this.configuration.getAddress();
            return string;
        }
        finally {
            this.blockOnIO();
        }
    }

    public String getDiscoveryGroupName() {
        if (AuditLogger.isBaseLoggingEnabled()) {
            AuditLogger.getDiscoveryGroupName((Object)this.clusterConnection);
        }
        this.clearIO();
        try {
            String string = this.configuration.getDiscoveryGroupName();
            return string;
        }
        finally {
            this.blockOnIO();
        }
    }

    public int getMaxHops() {
        if (AuditLogger.isBaseLoggingEnabled()) {
            AuditLogger.getMaxHops((Object)this.clusterConnection);
        }
        this.clearIO();
        try {
            int n = this.configuration.getMaxHops();
            return n;
        }
        finally {
            this.blockOnIO();
        }
    }

    public String getName() {
        if (AuditLogger.isBaseLoggingEnabled()) {
            AuditLogger.getName((Object)this.clusterConnection);
        }
        this.clearIO();
        try {
            String string = this.configuration.getName();
            return string;
        }
        finally {
            this.blockOnIO();
        }
    }

    public long getRetryInterval() {
        if (AuditLogger.isBaseLoggingEnabled()) {
            AuditLogger.getRetryInterval((Object)this.clusterConnection);
        }
        this.clearIO();
        try {
            long l = this.configuration.getRetryInterval();
            return l;
        }
        finally {
            this.blockOnIO();
        }
    }

    public String getNodeID() {
        if (AuditLogger.isBaseLoggingEnabled()) {
            AuditLogger.getNodeID((Object)this.clusterConnection);
        }
        this.clearIO();
        try {
            String string = this.clusterConnection.getNodeID();
            return string;
        }
        finally {
            this.blockOnIO();
        }
    }

    public String[] getStaticConnectors() {
        if (AuditLogger.isBaseLoggingEnabled()) {
            AuditLogger.getStaticConnectors((Object)this.clusterConnection);
        }
        this.clearIO();
        try {
            List<String> staticConnectors = this.configuration.getStaticConnectors();
            if (staticConnectors == null) {
                String[] stringArray = null;
                return stringArray;
            }
            String[] stringArray = staticConnectors.toArray(new String[staticConnectors.size()]);
            return stringArray;
        }
        finally {
            this.blockOnIO();
        }
    }

    public String getStaticConnectorsAsJSON() throws Exception {
        if (AuditLogger.isBaseLoggingEnabled()) {
            AuditLogger.getStaticConnectorsAsJSON((Object)this.clusterConnection);
        }
        this.clearIO();
        try {
            String string = JsonUtil.toJsonArray(this.configuration.getStaticConnectors()).toString();
            return string;
        }
        finally {
            this.blockOnIO();
        }
    }

    public boolean isDuplicateDetection() {
        if (AuditLogger.isBaseLoggingEnabled()) {
            AuditLogger.isDuplicateDetection((Object)this.clusterConnection);
        }
        this.clearIO();
        try {
            boolean bl = this.configuration.isDuplicateDetection();
            return bl;
        }
        finally {
            this.blockOnIO();
        }
    }

    public String getMessageLoadBalancingType() {
        if (AuditLogger.isBaseLoggingEnabled()) {
            AuditLogger.getMessageLoadBalancingType((Object)this.clusterConnection);
        }
        this.clearIO();
        try {
            String string = this.configuration.getMessageLoadBalancingType().getType();
            return string;
        }
        finally {
            this.blockOnIO();
        }
    }

    public String getTopology() {
        if (AuditLogger.isBaseLoggingEnabled()) {
            AuditLogger.getTopology((Object)this.clusterConnection);
        }
        this.clearIO();
        try {
            String string = this.clusterConnection.getTopology().describe();
            return string;
        }
        finally {
            this.blockOnIO();
        }
    }

    public Map<String, String> getNodes() throws Exception {
        if (AuditLogger.isBaseLoggingEnabled()) {
            AuditLogger.getNodes((Object)this.clusterConnection);
        }
        this.clearIO();
        try {
            Map<String, String> map = this.clusterConnection.getNodes();
            return map;
        }
        finally {
            this.blockOnIO();
        }
    }

    public boolean isStarted() {
        if (AuditLogger.isBaseLoggingEnabled()) {
            AuditLogger.isStarted((Object)this.clusterConnection);
        }
        this.clearIO();
        try {
            boolean bl = this.clusterConnection.isStarted();
            return bl;
        }
        finally {
            this.blockOnIO();
        }
    }

    public void start() throws Exception {
        if (AuditLogger.isBaseLoggingEnabled()) {
            AuditLogger.startClusterConnection((Object)this.clusterConnection);
        }
        this.clearIO();
        try {
            this.clusterConnection.start();
            this.clusterConnection.flushExecutor();
        }
        finally {
            this.blockOnIO();
        }
    }

    public void stop() throws Exception {
        if (AuditLogger.isBaseLoggingEnabled()) {
            AuditLogger.stopClusterConnection((Object)this.clusterConnection);
        }
        this.clearIO();
        try {
            this.clusterConnection.stop();
            this.clusterConnection.flushExecutor();
        }
        finally {
            this.blockOnIO();
        }
    }

    @Override
    protected MBeanOperationInfo[] fillMBeanOperationInfo() {
        return MBeanInfoHelper.getMBeanOperationsInfo(ClusterConnectionControl.class);
    }

    @Override
    protected MBeanAttributeInfo[] fillMBeanAttributeInfo() {
        return MBeanInfoHelper.getMBeanAttributesInfo(ClusterConnectionControl.class);
    }

    public long getMessagesPendingAcknowledgement() {
        if (AuditLogger.isBaseLoggingEnabled()) {
            AuditLogger.getMessagesPendingAcknowledgement((Object)this.clusterConnection);
        }
        this.clearIO();
        try {
            long l = this.clusterConnection.getMetrics().getMessagesPendingAcknowledgement();
            return l;
        }
        finally {
            this.blockOnIO();
        }
    }

    public long getMessagesAcknowledged() {
        if (AuditLogger.isBaseLoggingEnabled()) {
            AuditLogger.getMessagesAcknowledged((Object)this.clusterConnection);
        }
        this.clearIO();
        try {
            long l = this.clusterConnection.getMetrics().getMessagesAcknowledged();
            return l;
        }
        finally {
            this.blockOnIO();
        }
    }

    public Map<String, Object> getMetrics() {
        if (AuditLogger.isBaseLoggingEnabled()) {
            AuditLogger.getMetrics((Object)this.clusterConnection);
        }
        this.clearIO();
        try {
            Map<String, Object> map = this.clusterConnection.getMetrics().convertToMap();
            return map;
        }
        finally {
            this.blockOnIO();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Object> getBridgeMetrics(String nodeId) {
        if (AuditLogger.isBaseLoggingEnabled()) {
            AuditLogger.getBridgeMetrics((Object)this.clusterConnection, (Object[])new Object[]{nodeId});
        }
        this.clearIO();
        try {
            BridgeMetrics bridgeMetrics = this.clusterConnection.getBridgeMetrics(nodeId);
            Map<String, Object> map = bridgeMetrics != null ? bridgeMetrics.convertToMap() : null;
            return map;
        }
        finally {
            this.blockOnIO();
        }
    }
}

