/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.util;

import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.jgroups.logging.Log;
import org.jgroups.logging.LogFactory;
import org.jgroups.util.ThreadFactory;
import org.jgroups.util.TimeScheduler;
import org.jgroups.util.Util;

@Deprecated
public class TimeScheduler2
implements TimeScheduler,
Runnable {
    private final ThreadPoolExecutor pool;
    private final ConcurrentSkipListMap<Long, Entry> tasks = new ConcurrentSkipListMap();
    private Thread runner = null;
    private final Lock lock = new ReentrantLock();
    private final Condition tasks_available = this.lock.newCondition();
    private long next_execution_time = 0L;
    protected final AtomicBoolean no_tasks = new AtomicBoolean(true);
    protected volatile boolean running = false;
    protected static final Log log = LogFactory.getLog(TimeScheduler2.class);
    protected ThreadFactory timer_thread_factory = null;
    protected static final long SLEEP_TIME = 10000L;

    public TimeScheduler2() {
        this.pool = new ThreadPoolExecutor(4, 10, 5000L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(5000), Executors.defaultThreadFactory(), new ThreadPoolExecutor.CallerRunsPolicy());
        this.init();
    }

    public TimeScheduler2(ThreadFactory factory, int min_threads, int max_threads, long keep_alive_time, int max_queue_size, String rejection_policy) {
        this.timer_thread_factory = factory;
        RejectedExecutionHandler tmp = Util.parseRejectionPolicy(rejection_policy);
        this.pool = new ThreadPoolExecutor(min_threads, max_threads, keep_alive_time, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(max_queue_size), factory, tmp);
        this.init();
    }

    public TimeScheduler2(int corePoolSize) {
        this.pool = new ThreadPoolExecutor(corePoolSize, corePoolSize * 2, 5000L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(5000), Executors.defaultThreadFactory(), new ThreadPoolExecutor.CallerRunsPolicy());
        this.init();
    }

    @Override
    public void setThreadFactory(ThreadFactory f) {
        this.pool.setThreadFactory(f);
    }

    @Override
    public int getMinThreads() {
        return this.pool.getCorePoolSize();
    }

    @Override
    public void setMinThreads(int size) {
        this.pool.setCorePoolSize(size);
    }

    @Override
    public int getMaxThreads() {
        return this.pool.getMaximumPoolSize();
    }

    @Override
    public void setMaxThreads(int size) {
        this.pool.setMaximumPoolSize(size);
    }

    @Override
    public long getKeepAliveTime() {
        return this.pool.getKeepAliveTime(TimeUnit.MILLISECONDS);
    }

    @Override
    public void setKeepAliveTime(long time) {
        this.pool.setKeepAliveTime(time, TimeUnit.MILLISECONDS);
    }

    @Override
    public int getCurrentThreads() {
        return this.pool.getPoolSize();
    }

    public int getQueueSize() {
        return this.pool.getQueue().size();
    }

    @Override
    public String dumpTimerTasks() {
        StringBuilder sb = new StringBuilder();
        for (Entry entry : this.tasks.values()) {
            sb.append(entry.dump()).append("\n");
        }
        return sb.toString();
    }

    @Override
    public void execute(Runnable task) {
        this.schedule(task, 0L, TimeUnit.MILLISECONDS);
    }

    @Override
    public Future<?> schedule(Runnable work, long delay, TimeUnit unit) {
        if (work == null) {
            return null;
        }
        Future<?> retval = null;
        long key = System.currentTimeMillis() + TimeUnit.MILLISECONDS.convert(delay, unit);
        Entry task = new Entry(work);
        while (!this.isShutdown()) {
            Entry existing = this.tasks.putIfAbsent(key, task);
            if (existing == null) {
                retval = task.getFuture();
                break;
            }
            retval = existing.add(work);
            if (retval == null) continue;
            break;
        }
        if (key < this.next_execution_time || this.no_tasks.compareAndSet(true, false)) {
            if (key >= this.next_execution_time) {
                key = 0L;
            }
            this.taskReady(key);
        }
        return retval;
    }

    @Override
    public Future<?> scheduleWithFixedDelay(Runnable task, long initial_delay, long delay, TimeUnit unit) {
        if (task == null) {
            throw new NullPointerException();
        }
        if (this.isShutdown()) {
            return null;
        }
        FixedIntervalTask wrapper = new FixedIntervalTask(task, delay);
        wrapper.doSchedule(initial_delay);
        return wrapper;
    }

    @Override
    public Future<?> scheduleAtFixedRate(Runnable task, long initial_delay, long delay, TimeUnit unit) {
        if (task == null) {
            throw new NullPointerException();
        }
        if (this.isShutdown()) {
            return null;
        }
        FixedRateTask wrapper = new FixedRateTask(task, delay);
        wrapper.doSchedule(initial_delay);
        return wrapper;
    }

    @Override
    public Future<?> scheduleWithDynamicInterval(TimeScheduler.Task task) {
        if (task == null) {
            throw new NullPointerException();
        }
        if (this.isShutdown()) {
            return null;
        }
        DynamicIntervalTask task_wrapper = new DynamicIntervalTask(task);
        task_wrapper.doSchedule();
        return task_wrapper;
    }

    @Override
    public int size() {
        int retval = 0;
        Collection<Entry> values = this.tasks.values();
        for (Entry entry : values) {
            retval += entry.size();
        }
        return retval;
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }

    @Override
    public void stop() {
        this.stopRunner();
        List<Runnable> remaining_tasks = this.pool.shutdownNow();
        for (Runnable task : remaining_tasks) {
            if (!(task instanceof Future)) continue;
            Future future = (Future)((Object)task);
            future.cancel(true);
        }
        this.pool.getQueue().clear();
        try {
            this.pool.awaitTermination(3000L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        for (Entry entry : this.tasks.values()) {
            entry.cancel();
        }
        this.tasks.clear();
    }

    @Override
    public boolean isShutdown() {
        return this.pool.isShutdown();
    }

    @Override
    public void run() {
        while (this.running) {
            try {
                this._run();
            }
            catch (Throwable t) {
                log.error(Util.getMessage("FailedExecutingTasksS"), t);
            }
        }
    }

    protected void _run() {
        NavigableMap head_map = this.tasks.headMap((Object)System.currentTimeMillis(), true);
        if (!head_map.isEmpty()) {
            LinkedList<Long> keys = new LinkedList<Long>();
            for (Map.Entry entry : head_map.entrySet()) {
                Long key = (Long)entry.getKey();
                final Entry val = (Entry)entry.getValue();
                Runnable task = new Runnable(){

                    @Override
                    public void run() {
                        val.execute();
                    }
                };
                try {
                    this.pool.execute(task);
                }
                catch (RejectedExecutionException rejected) {
                    Thread thread = this.timer_thread_factory != null ? this.timer_thread_factory.newThread(task, "Timer temp thread") : new Thread(task, "Timer temp thread");
                    thread.start();
                }
                keys.add(key);
            }
            for (Long key : keys) {
                this.tasks.remove(key);
            }
        }
        if (this.tasks.isEmpty()) {
            this.no_tasks.compareAndSet(false, true);
            this.waitFor();
        } else {
            this.waitUntilNextExecution();
        }
    }

    protected void init() {
        this.startRunner();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void waitUntilNextExecution() {
        this.lock.lock();
        try {
            if (!this.running) {
                return;
            }
            this.next_execution_time = this.tasks.firstKey();
            long sleep_time = this.next_execution_time - System.currentTimeMillis();
            this.tasks_available.await(sleep_time, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException interruptedException) {
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void waitFor() {
        this.lock.lock();
        try {
            if (!this.running) {
                return;
            }
            this.tasks_available.await(10000L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException interruptedException) {
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void taskReady(long trigger_time) {
        this.lock.lock();
        try {
            if (trigger_time > 0L) {
                this.next_execution_time = trigger_time;
            }
            this.tasks_available.signal();
        }
        finally {
            this.lock.unlock();
        }
    }

    protected void startRunner() {
        this.running = true;
        this.runner = this.timer_thread_factory != null ? this.timer_thread_factory.newThread(this, "Timer runner") : new Thread((Runnable)this, "Timer runner");
        this.runner.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void stopRunner() {
        this.lock.lock();
        try {
            this.running = false;
            this.tasks_available.signal();
        }
        finally {
            this.lock.unlock();
        }
    }

    private class DynamicIntervalTask<V>
    extends RecurringTask<V> {
        private DynamicIntervalTask(TimeScheduler.Task task) {
            super(task);
        }

        @Override
        protected long nextInterval() {
            if (this.task instanceof TimeScheduler.Task) {
                return ((TimeScheduler.Task)this.task).nextInterval();
            }
            return 0L;
        }
    }

    private class FixedRateTask<V>
    extends RecurringTask<V> {
        final long interval;
        final long first_execution;
        int num_executions;

        private FixedRateTask(Runnable task, long interval) {
            super(task);
            this.num_executions = 0;
            this.interval = interval;
            this.first_execution = System.currentTimeMillis();
        }

        @Override
        protected long nextInterval() {
            long target_time = this.first_execution + this.interval * (long)(++this.num_executions);
            return target_time - System.currentTimeMillis();
        }

        @Override
        protected boolean rescheduleOnZeroDelay() {
            return true;
        }
    }

    private class FixedIntervalTask<V>
    extends RecurringTask<V> {
        final long interval;

        private FixedIntervalTask(Runnable task, long interval) {
            super(task);
            this.interval = interval;
        }

        @Override
        protected long nextInterval() {
            return this.interval;
        }
    }

    private abstract class RecurringTask<V>
    implements Runnable,
    Future<V> {
        protected final Runnable task;
        protected volatile Future<?> future;
        protected volatile boolean cancelled = false;

        private RecurringTask(Runnable task) {
            this.task = task;
        }

        protected abstract long nextInterval();

        protected boolean rescheduleOnZeroDelay() {
            return false;
        }

        public void doSchedule() {
            long next_interval = this.nextInterval();
            if (next_interval <= 0L && !this.rescheduleOnZeroDelay()) {
                if (log.isTraceEnabled()) {
                    log.trace("task will not get rescheduled as interval is " + next_interval);
                }
                return;
            }
            this.future = TimeScheduler2.this.schedule(this, next_interval, TimeUnit.MILLISECONDS);
            if (this.cancelled) {
                this.future.cancel(true);
            }
        }

        public void doSchedule(long next_interval) {
            this.future = TimeScheduler2.this.schedule(this, next_interval, TimeUnit.MILLISECONDS);
            if (this.cancelled) {
                this.future.cancel(true);
            }
        }

        @Override
        public void run() {
            if (this.cancelled) {
                if (this.future != null) {
                    this.future.cancel(true);
                }
                return;
            }
            try {
                this.task.run();
            }
            catch (Throwable t) {
                log.error(Util.getMessage("FailedRunningTask") + this.task, t);
            }
            if (!this.cancelled) {
                this.doSchedule();
            }
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            boolean retval = !this.isDone();
            this.cancelled = true;
            if (this.future != null) {
                this.future.cancel(mayInterruptIfRunning);
            }
            return retval;
        }

        @Override
        public boolean isCancelled() {
            return this.cancelled;
        }

        @Override
        public boolean isDone() {
            return this.cancelled || this.future == null || this.future.isDone();
        }

        @Override
        public V get() throws InterruptedException, ExecutionException {
            return null;
        }

        @Override
        public V get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            return null;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(this.task + ", cancelled=" + this.isCancelled());
            return sb.toString();
        }
    }

    protected static class MyTask
    implements Future,
    Runnable {
        protected final Runnable task;
        protected volatile boolean cancelled = false;
        protected volatile boolean done = false;
        protected MyTask next;

        protected MyTask(Runnable task) {
            this.task = task;
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            boolean retval = !this.isDone();
            this.cancelled = true;
            return retval;
        }

        @Override
        public boolean isCancelled() {
            return this.cancelled;
        }

        @Override
        public boolean isDone() {
            return this.done || this.cancelled;
        }

        public Object get() throws InterruptedException, ExecutionException {
            return null;
        }

        public Object get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (this.isDone()) {
                return;
            }
            try {
                this.task.run();
            }
            catch (Throwable t) {
                log.error(Util.getMessage("FailedExecutingTask") + this.task, t);
            }
            finally {
                this.done = true;
            }
        }

        public String toString() {
            return this.task.toString();
        }
    }

    private static class Entry {
        private final MyTask task;
        private MyTask last;
        private final Lock lock = new ReentrantLock();
        private boolean completed = false;

        private Entry(Runnable task) {
            this.last = this.task = new MyTask(task);
        }

        Future<?> getFuture() {
            return this.task;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        Future<?> add(Runnable task) {
            this.lock.lock();
            try {
                MyTask retval;
                if (this.completed) {
                    Future<?> future = null;
                    return future;
                }
                this.last = this.last.next = (retval = new MyTask(task));
                MyTask myTask = retval;
                return myTask;
            }
            finally {
                this.lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void execute() {
            this.lock.lock();
            try {
                if (this.completed) {
                    return;
                }
                this.completed = true;
                MyTask tmp = this.task;
                while (tmp != null) {
                    if (!tmp.isCancelled() && !tmp.isDone()) {
                        try {
                            tmp.run();
                        }
                        catch (Throwable t) {
                            log.error(Util.getMessage("TaskExecutionFailed"), t);
                        }
                        finally {
                            tmp.done = true;
                        }
                    }
                    tmp = tmp.next;
                }
            }
            finally {
                this.lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void cancel() {
            this.lock.lock();
            try {
                if (this.completed) {
                    return;
                }
                MyTask tmp = this.task;
                while (tmp != null) {
                    tmp.cancel(true);
                    tmp = tmp.next;
                }
            }
            finally {
                this.lock.unlock();
            }
        }

        int size() {
            int retval = 1;
            MyTask tmp = this.task.next;
            while (tmp != null) {
                ++retval;
                tmp = tmp.next;
            }
            return retval;
        }

        public String toString() {
            return this.size() + " tasks";
        }

        public String dump() {
            StringBuilder sb = new StringBuilder();
            boolean first = true;
            MyTask tmp = this.task;
            while (tmp != null) {
                if (!first) {
                    sb.append(", ");
                } else {
                    first = false;
                }
                sb.append(tmp);
                tmp = tmp.next;
            }
            return sb.toString();
        }
    }
}

