/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.fs;

import java.io.InputStream;
import java.io.OutputStream;
import org.apache.jackrabbit.core.fs.FileSystem;
import org.apache.jackrabbit.core.fs.FileSystemException;
import org.apache.jackrabbit.core.fs.RandomAccessOutputStream;

public class BasedFileSystem
implements FileSystem {
    protected final FileSystem fsBase;
    protected final String basePath;

    public BasedFileSystem(FileSystem fsBase, String relRootPath) {
        if (fsBase == null) {
            throw new IllegalArgumentException("invalid file system argument");
        }
        this.fsBase = fsBase;
        if (relRootPath == null) {
            throw new IllegalArgumentException("invalid null path argument");
        }
        if (relRootPath.equals("/")) {
            throw new IllegalArgumentException("invalid path argument");
        }
        if (!relRootPath.startsWith("/")) {
            relRootPath = "/" + relRootPath;
        }
        if (relRootPath.endsWith("/")) {
            relRootPath = relRootPath.substring(0, relRootPath.length() - 1);
        }
        this.basePath = relRootPath;
    }

    protected String buildBasePath(String path) {
        if (path.startsWith("/")) {
            if (path.length() == 1) {
                return this.basePath;
            }
            return this.basePath + path;
        }
        return this.basePath + "/" + path;
    }

    public void init() throws FileSystemException {
        if (!this.fsBase.isFolder(this.basePath)) {
            this.fsBase.createFolder(this.basePath);
        }
    }

    public void close() throws FileSystemException {
    }

    public void copy(String srcPath, String destPath) throws FileSystemException {
        this.fsBase.copy(this.buildBasePath(srcPath), this.buildBasePath(destPath));
    }

    public void createFolder(String folderPath) throws FileSystemException {
        this.fsBase.createFolder(this.buildBasePath(folderPath));
    }

    public void deleteFile(String filePath) throws FileSystemException {
        this.fsBase.deleteFile(this.buildBasePath(filePath));
    }

    public void deleteFolder(String folderPath) throws FileSystemException {
        this.fsBase.deleteFolder(this.buildBasePath(folderPath));
    }

    public boolean exists(String path) throws FileSystemException {
        return this.fsBase.exists(this.buildBasePath(path));
    }

    public InputStream getInputStream(String filePath) throws FileSystemException {
        return this.fsBase.getInputStream(this.buildBasePath(filePath));
    }

    public OutputStream getOutputStream(String filePath) throws FileSystemException {
        return this.fsBase.getOutputStream(this.buildBasePath(filePath));
    }

    public RandomAccessOutputStream getRandomAccessOutputStream(String filePath) throws FileSystemException {
        return this.fsBase.getRandomAccessOutputStream(this.buildBasePath(filePath));
    }

    public boolean hasChildren(String path) throws FileSystemException {
        return this.fsBase.hasChildren(this.buildBasePath(path));
    }

    public boolean isFile(String path) throws FileSystemException {
        return this.fsBase.isFile(this.buildBasePath(path));
    }

    public boolean isFolder(String path) throws FileSystemException {
        return this.fsBase.isFolder(this.buildBasePath(path));
    }

    public long lastModified(String path) throws FileSystemException {
        return this.fsBase.lastModified(this.buildBasePath(path));
    }

    public long length(String filePath) throws FileSystemException {
        return this.fsBase.length(this.buildBasePath(filePath));
    }

    public void touch(String filePath) throws FileSystemException {
        this.fsBase.touch(this.buildBasePath(filePath));
    }

    public String[] list(String folderPath) throws FileSystemException {
        return this.fsBase.list(this.buildBasePath(folderPath));
    }

    public String[] listFiles(String folderPath) throws FileSystemException {
        return this.fsBase.listFiles(this.buildBasePath(folderPath));
    }

    public String[] listFolders(String folderPath) throws FileSystemException {
        return this.fsBase.listFolders(this.buildBasePath(folderPath));
    }

    public void move(String srcPath, String destPath) throws FileSystemException {
        this.fsBase.move(this.buildBasePath(srcPath), this.buildBasePath(destPath));
    }
}

