/*
 * Decompiled with CFR 0.152.
 */
package org.dbunit.operation;

import java.util.ArrayList;
import java.util.BitSet;
import org.dbunit.database.IDatabaseConnection;
import org.dbunit.dataset.Column;
import org.dbunit.dataset.Columns;
import org.dbunit.dataset.DataSetException;
import org.dbunit.dataset.ITableMetaData;
import org.dbunit.dataset.NoPrimaryKeyException;
import org.dbunit.operation.AbstractBatchOperation;
import org.dbunit.operation.OperationData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpdateOperation
extends AbstractBatchOperation {
    private static final Logger logger = LoggerFactory.getLogger(UpdateOperation.class);

    UpdateOperation() {
    }

    @Override
    public OperationData getOperationData(ITableMetaData metaData, BitSet ignoreMapping, IDatabaseConnection connection) throws DataSetException {
        String columnName;
        Column column;
        if (logger.isDebugEnabled()) {
            logger.debug("getOperationData(metaData={}, ignoreMapping={}, connection={}) - start", new Object[]{metaData, ignoreMapping, connection});
        }
        Column[] columns = metaData.getColumns();
        Column[] primaryKeys = metaData.getPrimaryKeys();
        if (primaryKeys.length == 0) {
            throw new NoPrimaryKeyException(metaData.getTableName());
        }
        StringBuffer sqlBuffer = new StringBuffer(128);
        sqlBuffer.append("update ");
        sqlBuffer.append(this.getQualifiedName(connection.getSchema(), metaData.getTableName(), connection));
        boolean firstSet = true;
        ArrayList<Column> columnList = new ArrayList<Column>(columns.length);
        sqlBuffer.append(" set ");
        int i = 0;
        while (i < columns.length) {
            column = columns[i];
            if (Columns.getColumn(column.getColumnName(), primaryKeys) == null) {
                if (!firstSet) {
                    sqlBuffer.append(", ");
                }
                firstSet = false;
                columnName = this.getQualifiedName(null, column.getColumnName(), connection);
                sqlBuffer.append(columnName);
                sqlBuffer.append(" = ?");
                columnList.add(column);
            }
            ++i;
        }
        sqlBuffer.append(" where ");
        i = 0;
        while (i < primaryKeys.length) {
            column = primaryKeys[i];
            if (i > 0) {
                sqlBuffer.append(" and ");
            }
            columnName = this.getQualifiedName(null, column.getColumnName(), connection);
            sqlBuffer.append(columnName);
            sqlBuffer.append(" = ?");
            columnList.add(column);
            ++i;
        }
        return new OperationData(sqlBuffer.toString(), columnList.toArray(new Column[0]));
    }
}

