/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.protocol.core.impl.wireformat;

import javax.transaction.xa.Xid;
import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.core.protocol.core.impl.PacketImpl;
import org.apache.activemq.artemis.utils.XidCodecSupport;

public class SessionXACommitMessage
extends PacketImpl {
    private boolean onePhase;
    private Xid xid;

    public SessionXACommitMessage(Xid xid, boolean onePhase) {
        super((byte)53);
        this.xid = xid;
        this.onePhase = onePhase;
    }

    public SessionXACommitMessage() {
        super((byte)53);
    }

    public Xid getXid() {
        return this.xid;
    }

    public boolean isOnePhase() {
        return this.onePhase;
    }

    @Override
    public void encodeRest(ActiveMQBuffer buffer) {
        XidCodecSupport.encodeXid(this.xid, buffer);
        buffer.writeBoolean(this.onePhase);
    }

    @Override
    public void decodeRest(ActiveMQBuffer buffer) {
        this.xid = XidCodecSupport.decodeXid(buffer);
        this.onePhase = buffer.readBoolean();
    }

    @Override
    public String toString() {
        return this.getParentString() + ", xid=" + this.xid + ", onePhase=" + this.onePhase + "]";
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.onePhase ? 1231 : 1237);
        result = 31 * result + (this.xid == null ? 0 : this.xid.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof SessionXACommitMessage)) {
            return false;
        }
        SessionXACommitMessage other = (SessionXACommitMessage)obj;
        if (this.onePhase != other.onePhase) {
            return false;
        }
        return !(this.xid == null ? other.xid != null : !this.xid.equals(other.xid));
    }
}

