/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.postoffice.impl;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.activemq.artemis.api.core.Pair;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.postoffice.Binding;

final class CopyOnWriteBindings {
    private final ConcurrentHashMap<SimpleString, BindingsAndPosition> map = new ConcurrentHashMap();
    private static final Binding[] TOMBSTONE_BINDINGS = new Binding[0];

    CopyOnWriteBindings() {
    }

    public void addBindingIfAbsent(Binding binding) {
        BindingsAndPosition bindings;
        Objects.requireNonNull(binding);
        SimpleString routingName = binding.getRoutingName();
        Objects.requireNonNull(routingName);
        do {
            if ((bindings = this.map.get(routingName)) != null && bindings.get() != TOMBSTONE_BINDINGS) continue;
            BindingsAndPosition newBindings = new BindingsAndPosition(new Binding[]{binding});
            bindings = this.map.compute(routingName, (ignored, bindingsAndPosition) -> {
                if (bindingsAndPosition == null || bindingsAndPosition.get() == TOMBSTONE_BINDINGS) {
                    return newBindings;
                }
                return bindingsAndPosition;
            });
            assert (bindings != null);
            if (bindings != newBindings) continue;
            return;
        } while (!CopyOnWriteBindings.addBindingIfAbsent(bindings, binding));
    }

    public void removeBinding(Binding binding) {
        Objects.requireNonNull(binding);
        SimpleString routingName = binding.getRoutingName();
        Objects.requireNonNull(routingName);
        BindingsAndPosition bindings = this.map.get(routingName);
        if (bindings == null) {
            return;
        }
        Binding[] newBindings = CopyOnWriteBindings.removeBindingIfPresent(bindings, binding);
        if (newBindings == TOMBSTONE_BINDINGS) {
            this.map.computeIfPresent(routingName, (bindingsRoutingName, existingBindings) -> {
                if (existingBindings.get() == TOMBSTONE_BINDINGS) {
                    return null;
                }
                return existingBindings;
            });
        }
    }

    public Pair<Binding[], BindingIndex> getBindings(SimpleString routingName) {
        Objects.requireNonNull(routingName);
        BindingsAndPosition bindings = this.map.get(routingName);
        if (bindings == null) {
            return null;
        }
        Binding[] bindingsSnapshot = (Binding[])bindings.get();
        if (bindingsSnapshot == TOMBSTONE_BINDINGS) {
            return null;
        }
        assert (bindingsSnapshot != null && bindingsSnapshot.length > 0);
        return new Pair((Object)bindingsSnapshot, (Object)bindings);
    }

    public <T extends Throwable> void forEach(BindingsConsumer<T> bindingsConsumer) throws T {
        Objects.requireNonNull(bindingsConsumer);
        if (this.map.isEmpty()) {
            return;
        }
        for (Map.Entry<SimpleString, BindingsAndPosition> entry : this.map.entrySet()) {
            BindingsAndPosition value = entry.getValue();
            Binding[] bindings = (Binding[])value.get();
            if (bindings == TOMBSTONE_BINDINGS) continue;
            assert (bindings != null && bindings.length > 0);
            bindingsConsumer.accept(entry.getKey(), bindings, value);
        }
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    public Map<SimpleString, List<Binding>> copyAsMap() {
        if (this.map.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<SimpleString, List<Binding>> copy = new HashMap<SimpleString, List<Binding>>(this.map.size());
        this.map.forEach((? super K routingName, ? super V bindings) -> {
            Binding[] bindingArray = (Binding[])bindings.get();
            if (bindingArray == TOMBSTONE_BINDINGS) {
                return;
            }
            copy.put((SimpleString)routingName, Arrays.asList(bindingArray));
        });
        return copy;
    }

    private static int indexOfBinding(Binding[] bindings, Binding toFind) {
        int size = bindings.length;
        for (int i = 0; i < size; ++i) {
            Binding binding = bindings[i];
            if (!binding.equals(toFind)) continue;
            return i;
        }
        return -1;
    }

    private static Binding[] removeBindingIfPresent(AtomicReference<Binding[]> bindings, Binding bindingToRemove) {
        Binding[] newBindings;
        Binding[] oldBindings;
        Objects.requireNonNull(bindings);
        Objects.requireNonNull(bindingToRemove);
        do {
            int found;
            if ((found = CopyOnWriteBindings.indexOfBinding(oldBindings = bindings.get(), bindingToRemove)) == -1) {
                return null;
            }
            int oldBindingsCount = oldBindings.length;
            if (oldBindingsCount == 1) {
                newBindings = TOMBSTONE_BINDINGS;
                continue;
            }
            int newBindingsCount = oldBindingsCount - 1;
            newBindings = new Binding[newBindingsCount];
            System.arraycopy(oldBindings, 0, newBindings, 0, found);
            int remaining = newBindingsCount - found;
            if (remaining <= 0) continue;
            System.arraycopy(oldBindings, found + 1, newBindings, found, remaining);
        } while (!bindings.compareAndSet(oldBindings, newBindings));
        return newBindings;
    }

    private static boolean addBindingIfAbsent(AtomicReference<Binding[]> bindings, Binding newBinding) {
        Binding[] newBindings;
        Binding[] oldBindings;
        Objects.requireNonNull(bindings);
        Objects.requireNonNull(newBinding);
        do {
            if ((oldBindings = bindings.get()) == TOMBSTONE_BINDINGS) {
                return false;
            }
            if (CopyOnWriteBindings.indexOfBinding(oldBindings, newBinding) >= 0) {
                return true;
            }
            int oldLength = oldBindings.length;
            newBindings = Arrays.copyOf(oldBindings, oldLength + 1);
            assert (newBindings[oldLength] == null);
            newBindings[oldLength] = newBinding;
        } while (!bindings.compareAndSet(oldBindings, newBindings));
        return true;
    }

    @FunctionalInterface
    public static interface BindingsConsumer<T extends Throwable> {
        public void accept(SimpleString var1, Binding[] var2, BindingIndex var3) throws T;
    }

    private static final class BindingsAndPosition
    extends AtomicReference<Binding[]>
    implements BindingIndex {
        private static final AtomicIntegerFieldUpdater<BindingsAndPosition> NEXT_POSITION_UPDATER = AtomicIntegerFieldUpdater.newUpdater(BindingsAndPosition.class, "nextPosition");
        public volatile int nextPosition;

        BindingsAndPosition(Binding[] bindings) {
            super(bindings);
            NEXT_POSITION_UPDATER.lazySet(this, 0);
        }

        @Override
        public int getIndex() {
            return this.nextPosition;
        }

        @Override
        public void setIndex(int v) {
            if (v < 0) {
                throw new IllegalArgumentException("cannot set a negative position");
            }
            NEXT_POSITION_UPDATER.lazySet(this, v);
        }
    }

    public static interface BindingIndex {
        public int getIndex();

        public void setIndex(int var1);
    }
}

