/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.server.balancing;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import org.apache.activemq.artemis.core.server.ActiveMQComponent;
import org.apache.activemq.artemis.core.server.balancing.policies.Policy;
import org.apache.activemq.artemis.core.server.balancing.pools.Pool;
import org.apache.activemq.artemis.core.server.balancing.targets.Target;
import org.apache.activemq.artemis.core.server.balancing.targets.TargetKey;
import org.apache.activemq.artemis.core.server.balancing.targets.TargetKeyResolver;
import org.apache.activemq.artemis.spi.core.remoting.Connection;
import org.jboss.logging.Logger;

public class BrokerBalancer
implements ActiveMQComponent {
    private static final Logger logger = Logger.getLogger(BrokerBalancer.class);
    public static final String CLIENT_ID_PREFIX = "$.artemis.internal.balancer.client.";
    private final String name;
    private final TargetKey targetKey;
    private final TargetKeyResolver targetKeyResolver;
    private final Target localTarget;
    private final Pattern localTargetFilter;
    private final Pool pool;
    private final Policy policy;
    private final Cache<String, Target> cache;
    private volatile boolean started = false;

    public String getName() {
        return this.name;
    }

    public TargetKey getTargetKey() {
        return this.targetKey;
    }

    public Target getLocalTarget() {
        return this.localTarget;
    }

    public String getLocalTargetFilter() {
        return this.localTargetFilter != null ? this.localTargetFilter.pattern() : null;
    }

    public Pool getPool() {
        return this.pool;
    }

    public Policy getPolicy() {
        return this.policy;
    }

    public Cache<String, Target> getCache() {
        return this.cache;
    }

    public boolean isStarted() {
        return this.started;
    }

    public BrokerBalancer(String name, TargetKey targetKey, String targetKeyFilter, Target localTarget, String localTargetFilter, Pool pool, Policy policy, int cacheTimeout) {
        this.name = name;
        this.targetKey = targetKey;
        this.targetKeyResolver = new TargetKeyResolver(targetKey, targetKeyFilter);
        this.localTarget = localTarget;
        this.localTargetFilter = localTargetFilter != null ? Pattern.compile(localTargetFilter) : null;
        this.pool = pool;
        this.policy = policy;
        this.cache = cacheTimeout == -1 ? CacheBuilder.newBuilder().build() : (cacheTimeout > 0 ? CacheBuilder.newBuilder().expireAfterAccess((long)cacheTimeout, TimeUnit.MILLISECONDS).build() : null);
    }

    public void start() throws Exception {
        this.pool.start();
        this.started = true;
    }

    public void stop() throws Exception {
        this.started = false;
        this.pool.stop();
    }

    public Target getTarget(Connection connection, String clientID, String username) {
        if (clientID != null && clientID.startsWith(CLIENT_ID_PREFIX)) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("The clientID [" + clientID + "] starts with BrokerBalancer.CLIENT_ID_PREFIX"));
            }
            return this.localTarget;
        }
        return this.getTarget(this.targetKeyResolver.resolve(connection, clientID, username));
    }

    public Target getTarget(String key) {
        if (this.localTargetFilter != null && this.localTargetFilter.matcher(key).matches()) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("The " + (Object)((Object)this.targetKey) + "[" + key + "] matches the localTargetFilter " + this.localTargetFilter.pattern()));
            }
            return this.localTarget;
        }
        Target target = null;
        if (this.cache != null) {
            target = (Target)this.cache.getIfPresent((Object)key);
        }
        if (target != null) {
            if (this.pool.isTargetReady(target)) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("The cache returns [" + target + "] ready for " + (Object)((Object)this.targetKey) + "[" + key + "]"));
                }
                return target;
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("The cache returns [" + target + "] not ready for " + (Object)((Object)this.targetKey) + "[" + key + "]"));
            }
        }
        List<Target> targets = this.pool.getTargets();
        target = this.policy.selectTarget(targets, key);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("The policy selects [" + target + "] from " + targets + " for " + (Object)((Object)this.targetKey) + "[" + key + "]"));
        }
        if (target != null && this.cache != null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Caching " + (Object)((Object)this.targetKey) + "[" + key + "] for [" + target + "]"));
            }
            this.cache.put((Object)key, (Object)target);
        }
        return target;
    }
}

