/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.server.balancing.transformer;

import java.util.HashMap;
import java.util.Map;
import java.util.ServiceLoader;
import org.apache.activemq.artemis.core.server.balancing.BrokerBalancer;
import org.apache.activemq.artemis.core.server.balancing.transformer.ConsistentHashModulo;
import org.apache.activemq.artemis.core.server.balancing.transformer.TransformerFactory;

public class TransformerFactoryResolver {
    private static TransformerFactoryResolver instance;
    private final Map<String, TransformerFactory> factories = new HashMap<String, TransformerFactory>();

    public static TransformerFactoryResolver getInstance() {
        if (instance == null) {
            instance = new TransformerFactoryResolver();
        }
        return instance;
    }

    private TransformerFactoryResolver() {
        this.factories.put("CONSISTENT_HASH_MODULO", () -> new ConsistentHashModulo());
        this.loadFactories();
    }

    public TransformerFactory resolve(String policyName) throws ClassNotFoundException {
        TransformerFactory factory = this.factories.get(policyName);
        if (factory == null) {
            throw new ClassNotFoundException("No TransformerFactory found for " + policyName);
        }
        return factory;
    }

    private void loadFactories() {
        ServiceLoader<TransformerFactory> serviceLoader = ServiceLoader.load(TransformerFactory.class, BrokerBalancer.class.getClassLoader());
        for (TransformerFactory factory : serviceLoader) {
            this.factories.put(this.keyFromClassName(factory.getClass().getName()), factory);
        }
    }

    String keyFromClassName(String name) {
        return name.substring(0, name.indexOf("TransformerFactory"));
    }
}

