/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.api.core.client;

import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import org.apache.activemq.artemis.api.config.ServerLocatorConfig;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.api.core.DiscoveryGroupConfiguration;
import org.apache.activemq.artemis.api.core.Interceptor;
import org.apache.activemq.artemis.api.core.TransportConfiguration;
import org.apache.activemq.artemis.api.core.client.ClientSessionFactory;
import org.apache.activemq.artemis.api.core.client.ClusterTopologyListener;
import org.apache.activemq.artemis.core.client.impl.Topology;
import org.apache.activemq.artemis.spi.core.remoting.ClientProtocolManagerFactory;

public interface ServerLocator
extends AutoCloseable {
    public boolean isClosed();

    public ClientSessionFactory createSessionFactory() throws Exception;

    public ClientSessionFactory createSessionFactory(String var1) throws Exception;

    public ClientSessionFactory createSessionFactory(TransportConfiguration var1) throws Exception;

    public ClientSessionFactory createSessionFactory(TransportConfiguration var1, int var2) throws Exception;

    @Deprecated
    public ClientSessionFactory createSessionFactory(TransportConfiguration var1, int var2, boolean var3) throws Exception;

    public long getClientFailureCheckPeriod();

    public ServerLocator setClientFailureCheckPeriod(long var1);

    public boolean isCacheLargeMessagesClient();

    public ServerLocator setCacheLargeMessagesClient(boolean var1);

    public long getConnectionTTL();

    public ServerLocator setConnectionTTL(long var1);

    public long getCallTimeout();

    public ServerLocator setCallTimeout(long var1);

    public long getCallFailoverTimeout();

    public ServerLocator setCallFailoverTimeout(long var1);

    public int getMinLargeMessageSize();

    public ServerLocator setMinLargeMessageSize(int var1);

    public int getConsumerWindowSize();

    public ServerLocator setConsumerWindowSize(int var1);

    public int getConsumerMaxRate();

    public ServerLocator setConsumerMaxRate(int var1);

    public int getConfirmationWindowSize();

    public ServerLocator setConfirmationWindowSize(int var1);

    public int getProducerWindowSize();

    public ServerLocator setProducerWindowSize(int var1);

    public int getProducerMaxRate();

    public ServerLocator setProducerMaxRate(int var1);

    public boolean isBlockOnAcknowledge();

    public ServerLocator setBlockOnAcknowledge(boolean var1);

    public boolean isBlockOnDurableSend();

    public ServerLocator setBlockOnDurableSend(boolean var1);

    public boolean isBlockOnNonDurableSend();

    public ServerLocator setBlockOnNonDurableSend(boolean var1);

    public boolean isAutoGroup();

    public ServerLocator setAutoGroup(boolean var1);

    public String getGroupID();

    public ServerLocator setGroupID(String var1);

    public boolean isPreAcknowledge();

    public ServerLocator setPreAcknowledge(boolean var1);

    public int getAckBatchSize();

    public ServerLocator setAckBatchSize(int var1);

    public TransportConfiguration[] getStaticTransportConfigurations();

    public DiscoveryGroupConfiguration getDiscoveryGroupConfiguration();

    public boolean isUseGlobalPools();

    public ServerLocator setUseGlobalPools(boolean var1);

    public int getScheduledThreadPoolMaxSize();

    public ServerLocator setScheduledThreadPoolMaxSize(int var1);

    public int getThreadPoolMaxSize();

    public ServerLocator setThreadPoolMaxSize(int var1);

    public long getRetryInterval();

    public ServerLocator setRetryInterval(long var1);

    public double getRetryIntervalMultiplier();

    public ServerLocator setRetryIntervalMultiplier(double var1);

    public long getMaxRetryInterval();

    public ServerLocator setMaxRetryInterval(long var1);

    public int getReconnectAttempts();

    public ServerLocator setReconnectAttempts(int var1);

    public ServerLocator setInitialConnectAttempts(int var1);

    public int getInitialConnectAttempts();

    @Deprecated
    public boolean isFailoverOnInitialConnection();

    @Deprecated
    public ServerLocator setFailoverOnInitialConnection(boolean var1);

    public String getConnectionLoadBalancingPolicyClassName();

    public ServerLocator setConnectionLoadBalancingPolicyClassName(String var1);

    public int getInitialMessagePacketSize();

    public ServerLocator setInitialMessagePacketSize(int var1);

    public ServerLocator addIncomingInterceptor(Interceptor var1);

    public ServerLocator addOutgoingInterceptor(Interceptor var1);

    public boolean removeIncomingInterceptor(Interceptor var1);

    public boolean removeOutgoingInterceptor(Interceptor var1);

    @Override
    public void close();

    public ServerLocator setUseTopologyForLoadBalancing(boolean var1);

    public boolean getUseTopologyForLoadBalancing();

    public Topology getTopology();

    public boolean isHA();

    public boolean allInVM();

    public boolean isCompressLargeMessage();

    public ServerLocator setCompressLargeMessage(boolean var1);

    public ServerLocator addClusterTopologyListener(ClusterTopologyListener var1);

    public void removeClusterTopologyListener(ClusterTopologyListener var1);

    public ClientProtocolManagerFactory getProtocolManagerFactory();

    public ServerLocator setProtocolManagerFactory(ClientProtocolManagerFactory var1);

    public ServerLocator setIncomingInterceptorList(String var1);

    public String getIncomingInterceptorList();

    public ServerLocator setOutgoingInterceptorList(String var1);

    public String getOutgoingInterceptorList();

    public boolean setThreadPools(Executor var1, ScheduledExecutorService var2);

    public void initialize() throws ActiveMQException;

    public ServerLocatorConfig getLocatorConfig();

    public void setLocatorConfig(ServerLocatorConfig var1);
}

