/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.satellite.streaming;

import akka.NotUsed;
import akka.actor.ActorSystem;
import akka.stream.Client$;
import akka.stream.FlowShape;
import akka.stream.Graph;
import akka.stream.TLSClientAuth;
import akka.stream.TLSProtocol;
import akka.stream.TLSRole;
import akka.stream.scaladsl.BidiFlow;
import akka.stream.scaladsl.Flow;
import akka.stream.scaladsl.Flow$;
import akka.stream.scaladsl.GraphDSL;
import akka.stream.scaladsl.GraphDSL$;
import akka.stream.scaladsl.TLS$;
import akka.stream.scaladsl.TLSPlacebo$;
import akka.util.ByteString;
import com.xebialabs.satellite.streaming.SslStreamingSupport;
import com.xebialabs.xlplatform.settings.SecuritySettings;
import com.xebialabs.xlplatform.utils.ClassLoaderUtils$;
import com.xebialabs.xlplatform.utils.SecureRandomHolder;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.security.KeyStore;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import org.slf4j.Marker;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some;
import scala.collection.ArrayOps$;
import scala.collection.immutable.Seq;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.ScalaRunTime$;

public final class SslStreamingSupport$
implements Logging {
    public static final SslStreamingSupport$ MODULE$ = new SslStreamingSupport$();
    private static transient Logger grizzled$slf4j$Logging$$_logger;
    private static volatile transient boolean bitmap$trans$0;

    static {
        Logging.$init$((Logging)MODULE$);
    }

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        SslStreamingSupport$ sslStreamingSupport$ = this;
        synchronized (sslStreamingSupport$) {
            if (!bitmap$trans$0) {
                grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                bitmap$trans$0 = true;
            }
        }
        return grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        return !bitmap$trans$0 ? this.grizzled$slf4j$Logging$$_logger$lzycompute() : grizzled$slf4j$Logging$$_logger;
    }

    public <Mat> Flow<ByteString, ByteString, Mat> wrapWithSsl(SslStreamingSupport.SslConfig sslConfig, Flow<ByteString, ByteString, Mat> tcpConnection, ActorSystem system) {
        return this.sslWrapper(this.sslFlow(sslConfig, system), tcpConnection, sslConfig.role());
    }

    private BidiFlow<TLSProtocol.SslTlsOutbound, ByteString, ByteString, TLSProtocol.SslTlsInbound, NotUsed> sslFlow(SslStreamingSupport.SslConfig sslConfig, ActorSystem system) {
        BidiFlow bidiFlow;
        if (sslConfig.enabled()) {
            this.debug((Function0<Object>)(Function0 & Serializable)() -> "Real ssl config");
            Function0 & Serializable createSSLEngine = (Function0 & Serializable)() -> {
                void var2_2;
                SSLContext sslContext = sslConfig.sslContext();
                SSLEngine engine = sslContext.createSSLEngine();
                engine.setSSLParameters(sslContext.getDefaultSSLParameters());
                engine.setEnabledProtocols((String[])((Object[])new String[]{sslConfig.protocol()}));
                engine.setEnabledCipherSuites((String[])sslConfig.enabledAlgorithms().toArray(ClassTag$.MODULE$.apply(String.class)));
                TLSRole tLSRole = sslConfig.role();
                Client$ client$ = Client$.MODULE$;
                engine.setUseClientMode(!(tLSRole != null ? !tLSRole.equals(client$) : client$ != null));
                TLSProtocol.NegotiateNewSession paramsWithHostnameVerification = MODULE$.newSessionNegotiation(sslConfig.enabledAlgorithms());
                MODULE$.applySessionParameters(engine, paramsWithHostnameVerification);
                return var2_2;
            };
            TLS$.MODULE$.apply((Function0)createSSLEngine, sslConfig.closing());
            bidiFlow = TLS$.MODULE$.apply(sslConfig.sslContext(), (Option)None$.MODULE$, this.newSessionNegotiation(sslConfig.enabledAlgorithms()), sslConfig.role(), sslConfig.closing(), TLS$.MODULE$.apply$default$6());
        } else {
            this.debug((Function0<Object>)(Function0 & Serializable)() -> "Placebo ssl config");
            bidiFlow = TLSPlacebo$.MODULE$.apply();
        }
        return bidiFlow;
    }

    /*
     * Unable to fully structure code
     */
    private void applySessionParameters(SSLEngine engine, TLSProtocol.NegotiateNewSession sessionParameters) {
        sessionParameters.enabledCipherSuites().foreach((Function1)(Function1 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$applySessionParameters$1$adapted(javax.net.ssl.SSLEngine scala.collection.immutable.Seq ), (Lscala/collection/immutable/Seq;)Ljava/lang/Object;)((SSLEngine)engine));
        sessionParameters.enabledProtocols().foreach((Function1)(Function1 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$applySessionParameters$2$adapted(javax.net.ssl.SSLEngine scala.collection.immutable.Seq ), (Lscala/collection/immutable/Seq;)Ljava/lang/Object;)((SSLEngine)engine));
        var4_3 = false;
        var5_4 = null;
        var6_5 = sessionParameters.clientAuth();
        if (!(var6_5 instanceof Some)) ** GOTO lbl-1000
        var4_3 = true;
        var5_4 = (Some)var6_5;
        var7_6 = (TLSClientAuth)var5_4.value();
        if (TLSClientAuth.None$.MODULE$.equals(var7_6)) {
            engine.setNeedClientAuth(false);
            var3_7 = BoxedUnit.UNIT;
        } else if (var4_3 && TLSClientAuth.Want$.MODULE$.equals(var8_11 = (TLSClientAuth)var5_4.value())) {
            engine.setWantClientAuth(true);
            var3_8 = BoxedUnit.UNIT;
        } else if (var4_3 && TLSClientAuth.Need$.MODULE$.equals(var9_12 = (TLSClientAuth)var5_4.value())) {
            engine.setNeedClientAuth(true);
            var3_9 = BoxedUnit.UNIT;
        } else {
            var3_10 = BoxedUnit.UNIT;
        }
        sessionParameters.sslParameters().foreach((Function1)(Function1 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$applySessionParameters$3$adapted(javax.net.ssl.SSLEngine javax.net.ssl.SSLParameters ), (Ljavax/net/ssl/SSLParameters;)Ljava/lang/Object;)((SSLEngine)engine));
    }

    private TLSProtocol.NegotiateNewSession newSessionNegotiation(Seq<String> cypherSuites) {
        return TLSProtocol.NegotiateNewSession$.MODULE$.withCipherSuites(cypherSuites);
    }

    private <Mat> Flow<ByteString, ByteString, Mat> sslWrapper(BidiFlow<TLSProtocol.SslTlsOutbound, ByteString, ByteString, TLSProtocol.SslTlsInbound, ?> sslFlow, Flow<ByteString, ByteString, Mat> tcpConnection, TLSRole role) {
        return Flow$.MODULE$.fromGraph(GraphDSL$.MODULE$.create(sslFlow, tcpConnection, (Function2 & Serializable)(x$1, c) -> c, (Function1 & Serializable)builder -> (Function2 & Serializable)(sslFlow, conn) -> {
            FlowShape sendBytes = (FlowShape)builder.add((Graph)Flow$.MODULE$.apply().map((Function1 & Serializable)bs -> new TLSProtocol.SendBytes(bs)));
            GraphDSL.Implicits$.MODULE$.port2flow(GraphDSL.Implicits$.MODULE$.flow2flow(sendBytes, builder).outlet(), builder).$tilde$greater(sslFlow.in1(), builder);
            GraphDSL.Implicits$.MODULE$.port2flow(sslFlow.out1(), builder).$tilde$greater(conn, builder).$tilde$greater(sslFlow.in2(), builder);
            GraphDSL.Implicits$.PortOps inboundFlow = (GraphDSL.Implicits$.PortOps)GraphDSL.Implicits$.MODULE$.port2flow(sslFlow.out2(), builder).collect((PartialFunction)new Serializable(){
                private static final long serialVersionUID = 0L;

                public final <A1 extends TLSProtocol.SslTlsInbound, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                    Object object;
                    A1 A1 = x1;
                    if (A1 instanceof TLSProtocol.SessionBytes) {
                        TLSProtocol.SessionBytes sessionBytes = (TLSProtocol.SessionBytes)A1;
                        ByteString bytes = sessionBytes.bytes();
                        object = bytes;
                    } else {
                        object = function1.apply(x1);
                    }
                    return (B1)object;
                }

                public final boolean isDefinedAt(TLSProtocol.SslTlsInbound x1) {
                    TLSProtocol.SslTlsInbound sslTlsInbound = x1;
                    boolean bl = sslTlsInbound instanceof TLSProtocol.SessionBytes;
                    return bl;
                }
            });
            return new FlowShape(sendBytes.in(), inboundFlow.outlet());
        }));
    }

    /*
     * WARNING - void declaration
     */
    public SSLContext initSslContext(SecuritySettings settings) {
        void var2_2;
        SSLContext context = SSLContext.getInstance(settings.protocol());
        context.init(this.createKeyManagersIfPossible(settings), this.createTrustManagers(settings), SecureRandomHolder.get());
        return var2_2;
    }

    private KeyManager[] createKeyManagersIfPossible(SecuritySettings settings) {
        return (KeyManager[])ArrayOps$.MODULE$.flatten$extension(Predef$.MODULE$.refArrayOps((Object[])Option$.MODULE$.option2Iterable(settings.keyStore().map((Function1 & Serializable)ks -> this.createKeyManager$1((String)ks, settings.keyStorePassword().toCharArray(), settings.keyPassword().toCharArray()))).toArray(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(KeyManager.class)))), (Function1 & Serializable)xs -> Predef$.MODULE$.wrapRefArray((Object[])xs), ClassTag$.MODULE$.apply(KeyManager.class));
    }

    private TrustManager[] createTrustManagers(SecuritySettings settings) {
        KeyStore trustStore = KeyStore.getInstance(KeyStore.getDefaultType());
        trustStore.load(this.loadResource(settings.trustStore()), settings.trustStorePassword().toCharArray());
        TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        trustManagerFactory.init(trustStore);
        return trustManagerFactory.getTrustManagers();
    }

    private InputStream loadResource(String resource) {
        return (InputStream)Option$.MODULE$.apply((Object)ClassLoaderUtils$.MODULE$.classLoader().getResourceAsStream(resource)).getOrElse((Function0 & Serializable)() -> new FileInputStream(resource));
    }

    private final KeyManager[] createKeyManager$1(String keyStoreResource, char[] keyStorePassword, char[] keyPassword) {
        KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
        keyStore.load(this.loadResource(keyStoreResource), keyStorePassword);
        KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        keyManagerFactory.init(keyStore, keyPassword);
        return keyManagerFactory.getKeyManagers();
    }

    private SslStreamingSupport$() {
    }

    public static final /* synthetic */ Object $anonfun$applySessionParameters$1$adapted(SSLEngine engine$1, Seq cs) {
        engine$1.setEnabledCipherSuites((String[])cs.toArray(ClassTag$.MODULE$.apply(String.class)));
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$applySessionParameters$2$adapted(SSLEngine engine$1, Seq p) {
        engine$1.setEnabledProtocols((String[])p.toArray(ClassTag$.MODULE$.apply(String.class)));
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$applySessionParameters$3$adapted(SSLEngine engine$1, SSLParameters x$1) {
        engine$1.setSSLParameters(x$1);
        return BoxedUnit.UNIT;
    }
}

