/*
 * Decompiled with CFR 0.152.
 */
package org.agrona.collections;

import java.lang.reflect.Array;
import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.agrona.BitUtil;
import org.agrona.collections.CollectionUtil;
import org.agrona.collections.Hashing;

public class Object2ObjectHashMap<K, V>
implements Map<K, V> {
    static final int MIN_CAPACITY = 8;
    private final float loadFactor;
    private int resizeThreshold;
    private int size = 0;
    private final boolean shouldAvoidAllocation;
    private Object[] entries;
    private KeySet keySet;
    private ValueCollection valueCollection;
    private EntrySet entrySet;

    public Object2ObjectHashMap() {
        this(8, 0.65f);
    }

    public Object2ObjectHashMap(int initialCapacity, float loadFactor) {
        this(initialCapacity, loadFactor, true);
    }

    public Object2ObjectHashMap(int initialCapacity, float loadFactor, boolean shouldAvoidAllocation) {
        CollectionUtil.validateLoadFactor(loadFactor);
        this.loadFactor = loadFactor;
        this.shouldAvoidAllocation = shouldAvoidAllocation;
        this.capacity(BitUtil.findNextPositivePowerOfTwo(Math.max(8, initialCapacity)));
    }

    public float loadFactor() {
        return this.loadFactor;
    }

    public int resizeThreshold() {
        return this.resizeThreshold;
    }

    public int capacity() {
        return this.entries.length >> 1;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public V get(Object key) {
        return this.unmapNullValue(this.getMapped(key));
    }

    private V getMapped(Object key) {
        Objects.requireNonNull(key);
        int mask = this.entries.length - 1;
        int index = Hashing.evenHash(key.hashCode(), mask);
        Object value = null;
        while (this.entries[index + 1] != null) {
            if (this.entries[index] == key || this.entries[index].equals(key)) {
                value = this.entries[index + 1];
                break;
            }
            index = Object2ObjectHashMap.next(index, mask);
        }
        return (V)value;
    }

    @Override
    public V put(K key, V value) {
        Object val = this.mapNullValue(value);
        Objects.requireNonNull(val, "value cannot be null");
        int mask = this.entries.length - 1;
        int index = Hashing.evenHash(key.hashCode(), mask);
        Object oldValue = null;
        while (this.entries[index + 1] != null) {
            if (this.entries[index] == key || this.entries[index].equals(key)) {
                oldValue = this.entries[index + 1];
                break;
            }
            index = Object2ObjectHashMap.next(index, mask);
        }
        if (oldValue == null) {
            ++this.size;
            this.entries[index] = key;
        }
        this.entries[index + 1] = val;
        this.increaseCapacity();
        return this.unmapNullValue(oldValue);
    }

    private void increaseCapacity() {
        if (this.size > this.resizeThreshold) {
            int newCapacity = this.entries.length;
            this.rehash(newCapacity);
        }
    }

    private void rehash(int newCapacity) {
        Object[] oldEntries = this.entries;
        int length = this.entries.length;
        this.capacity(newCapacity);
        Object[] newEntries = this.entries;
        int mask = this.entries.length - 1;
        for (int keyIndex = 0; keyIndex < length; keyIndex += 2) {
            Object value = oldEntries[keyIndex + 1];
            if (value == null) continue;
            Object key = oldEntries[keyIndex];
            int index = Hashing.evenHash(key.hashCode(), mask);
            while (newEntries[index + 1] != null) {
                index = Object2ObjectHashMap.next(index, mask);
            }
            newEntries[index] = key;
            newEntries[index + 1] = value;
        }
    }

    @Override
    public boolean containsValue(Object value) {
        Object val = this.mapNullValue(value);
        boolean found = false;
        if (val != null) {
            int length = this.entries.length;
            for (int valueIndex = 1; valueIndex < length; valueIndex += 2) {
                if (val != this.entries[valueIndex] && !val.equals(this.entries[valueIndex])) continue;
                found = true;
                break;
            }
        }
        return found;
    }

    @Override
    public void clear() {
        if (this.size > 0) {
            Arrays.fill(this.entries, null);
            this.size = 0;
        }
    }

    public void compact() {
        int idealCapacity = (int)Math.round((double)this.size() * (1.0 / (double)this.loadFactor));
        this.rehash(BitUtil.findNextPositivePowerOfTwo(Math.max(8, idealCapacity)));
    }

    @Override
    public void forEach(BiConsumer<? super K, ? super V> consumer) {
        int remaining = this.size;
        int length = this.entries.length;
        for (int i = 1; remaining > 0 && i < length; i += 2) {
            if (null == this.entries[i]) continue;
            consumer.accept(this.entries[i - 1], this.unmapNullValue(this.entries[i]));
            --remaining;
        }
    }

    @Override
    public boolean containsKey(Object key) {
        return this.getMapped(key) != null;
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> map) {
        for (Map.Entry<K, V> entry : map.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    public KeySet keySet() {
        if (null == this.keySet) {
            this.keySet = new KeySet();
        }
        return this.keySet;
    }

    public ValueCollection values() {
        if (null == this.valueCollection) {
            this.valueCollection = new ValueCollection();
        }
        return this.valueCollection;
    }

    public EntrySet entrySet() {
        if (null == this.entrySet) {
            this.entrySet = new EntrySet();
        }
        return this.entrySet;
    }

    @Override
    public V remove(Object key) {
        Object[] entries = this.entries;
        int mask = entries.length - 1;
        int keyIndex = Hashing.evenHash(key.hashCode(), mask);
        Object oldValue = null;
        while (entries[keyIndex + 1] != null) {
            if (entries[keyIndex] == key || entries[keyIndex].equals(key)) {
                oldValue = entries[keyIndex + 1];
                entries[keyIndex] = null;
                entries[keyIndex + 1] = null;
                --this.size;
                this.compactChain(keyIndex);
                break;
            }
            keyIndex = Object2ObjectHashMap.next(keyIndex, mask);
        }
        return this.unmapNullValue(oldValue);
    }

    private void compactChain(int deleteKeyIndex) {
        Object[] entries = this.entries;
        int mask = entries.length - 1;
        int keyIndex = deleteKeyIndex;
        while (entries[(keyIndex = Object2ObjectHashMap.next(keyIndex, mask)) + 1] != null) {
            int hash = Hashing.evenHash(entries[keyIndex].hashCode(), mask);
            if ((keyIndex >= hash || hash > deleteKeyIndex && deleteKeyIndex > keyIndex) && (hash > deleteKeyIndex || deleteKeyIndex > keyIndex)) continue;
            entries[deleteKeyIndex] = entries[keyIndex];
            entries[deleteKeyIndex + 1] = entries[keyIndex + 1];
            entries[keyIndex] = null;
            entries[keyIndex + 1] = null;
            deleteKeyIndex = keyIndex;
        }
    }

    public String toString() {
        if (this.isEmpty()) {
            return "{}";
        }
        EntryIterator entryIterator = new EntryIterator();
        entryIterator.reset();
        StringBuilder sb = new StringBuilder().append('{');
        while (true) {
            entryIterator.next();
            sb.append(entryIterator.getKey()).append('=').append(this.unmapNullValue(entryIterator.getValue()));
            if (!entryIterator.hasNext()) {
                return sb.append('}').toString();
            }
            sb.append(',').append(' ');
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Map)) {
            return false;
        }
        Map that = (Map)o;
        return this.size == that.size() && this.entrySet().equals(that.entrySet());
    }

    @Override
    public int hashCode() {
        return this.entrySet().hashCode();
    }

    protected Object mapNullValue(Object value) {
        return value;
    }

    protected V unmapNullValue(Object value) {
        return (V)value;
    }

    private static int next(int index, int mask) {
        return index + 2 & mask;
    }

    private void capacity(int newCapacity) {
        int entriesLength = newCapacity * 2;
        if (entriesLength < 0) {
            throw new IllegalStateException("max capacity reached at size=" + this.size);
        }
        this.resizeThreshold = (int)((float)newCapacity * this.loadFactor);
        this.entries = new Object[entriesLength];
    }

    public final class EntrySet
    extends AbstractSet<Map.Entry<K, V>> {
        private final EntryIterator entryIterator;

        public EntrySet() {
            this.entryIterator = Object2ObjectHashMap.this.shouldAvoidAllocation ? new EntryIterator() : null;
        }

        public EntryIterator iterator() {
            EntryIterator entryIterator = this.entryIterator;
            if (null == entryIterator) {
                entryIterator = new EntryIterator();
            }
            entryIterator.reset();
            return entryIterator;
        }

        @Override
        public int size() {
            return Object2ObjectHashMap.this.size();
        }

        @Override
        public boolean isEmpty() {
            return Object2ObjectHashMap.this.isEmpty();
        }

        @Override
        public void clear() {
            Object2ObjectHashMap.this.clear();
        }

        @Override
        public boolean contains(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)o;
            Object value = Object2ObjectHashMap.this.getMapped(entry.getKey());
            return value != null && value.equals(Object2ObjectHashMap.this.mapNullValue(entry.getValue()));
        }

        @Override
        public Object[] toArray() {
            return this.toArray(new Object[this.size()]);
        }

        @Override
        public <T> T[] toArray(T[] a) {
            T[] array = a.length >= Object2ObjectHashMap.this.size ? a : (Object[])Array.newInstance(a.getClass().getComponentType(), Object2ObjectHashMap.this.size);
            EntryIterator it = this.iterator();
            for (int i = 0; i < array.length; ++i) {
                if (!it.hasNext()) {
                    array[i] = null;
                    break;
                }
                it.next();
                array[i] = it.allocateDuplicateEntry();
            }
            return array;
        }
    }

    public final class ValueCollection
    extends AbstractCollection<V> {
        private final ValueIterator valueIterator;

        public ValueCollection() {
            this.valueIterator = Object2ObjectHashMap.this.shouldAvoidAllocation ? new ValueIterator() : null;
        }

        public ValueIterator iterator() {
            ValueIterator valueIterator = this.valueIterator;
            if (null == valueIterator) {
                valueIterator = new ValueIterator();
            }
            valueIterator.reset();
            return valueIterator;
        }

        @Override
        public int size() {
            return Object2ObjectHashMap.this.size();
        }

        @Override
        public boolean contains(Object o) {
            return Object2ObjectHashMap.this.containsValue(o);
        }

        @Override
        public void forEach(Consumer<? super V> action) {
            int remaining = Object2ObjectHashMap.this.size;
            int length = Object2ObjectHashMap.this.entries.length;
            for (int i = 1; remaining > 0 && i < length; i += 2) {
                if (null == Object2ObjectHashMap.this.entries[i]) continue;
                action.accept(Object2ObjectHashMap.this.unmapNullValue(Object2ObjectHashMap.this.entries[i]));
                --remaining;
            }
        }
    }

    public final class KeySet
    extends AbstractSet<K> {
        private final KeyIterator keyIterator;

        public KeySet() {
            this.keyIterator = Object2ObjectHashMap.this.shouldAvoidAllocation ? new KeyIterator() : null;
        }

        public KeyIterator iterator() {
            KeyIterator keyIterator = this.keyIterator;
            if (null == keyIterator) {
                keyIterator = new KeyIterator();
            }
            keyIterator.reset();
            return keyIterator;
        }

        @Override
        public int size() {
            return Object2ObjectHashMap.this.size();
        }

        @Override
        public boolean isEmpty() {
            return Object2ObjectHashMap.this.isEmpty();
        }

        @Override
        public void clear() {
            Object2ObjectHashMap.this.clear();
        }

        @Override
        public boolean contains(Object o) {
            return Object2ObjectHashMap.this.containsKey(o);
        }

        @Override
        public void forEach(Consumer<? super K> action) {
            int remaining = Object2ObjectHashMap.this.size;
            int length = Object2ObjectHashMap.this.entries.length;
            for (int i = 1; remaining > 0 && i < length; i += 2) {
                if (null == Object2ObjectHashMap.this.entries[i]) continue;
                action.accept(Object2ObjectHashMap.this.entries[i - 1]);
                --remaining;
            }
        }
    }

    public final class EntryIterator
    extends AbstractIterator
    implements Iterator<Map.Entry<K, V>>,
    Map.Entry<K, V> {
        @Override
        public K getKey() {
            return Object2ObjectHashMap.this.entries[this.keyPosition()];
        }

        @Override
        public V getValue() {
            return Object2ObjectHashMap.this.unmapNullValue(Object2ObjectHashMap.this.entries[this.keyPosition() + 1]);
        }

        @Override
        public V setValue(V value) {
            Object val = Object2ObjectHashMap.this.mapNullValue(value);
            if (!this.isPositionValid) {
                throw new IllegalStateException();
            }
            if (null == val) {
                throw new IllegalArgumentException();
            }
            int keyPosition = this.keyPosition();
            Object prevValue = Object2ObjectHashMap.this.entries[keyPosition + 1];
            ((Object2ObjectHashMap)Object2ObjectHashMap.this).entries[keyPosition + 1] = val;
            return Object2ObjectHashMap.this.unmapNullValue(prevValue);
        }

        @Override
        public Map.Entry<K, V> next() {
            this.findNext();
            if (Object2ObjectHashMap.this.shouldAvoidAllocation) {
                return this;
            }
            return this.allocateDuplicateEntry();
        }

        private Map.Entry<K, V> allocateDuplicateEntry() {
            return new MapEntry(this.getKey(), this.getValue());
        }

        @Override
        public int hashCode() {
            return this.getKey().hashCode() ^ this.getValue().hashCode();
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry that = (Map.Entry)o;
            return Objects.equals(this.getKey(), that.getKey()) && Objects.equals(this.getValue(), that.getValue());
        }

        public final class MapEntry
        implements Map.Entry<K, V> {
            private final K k;
            private final V v;

            public MapEntry(K k, V v) {
                this.k = k;
                this.v = v;
            }

            @Override
            public K getKey() {
                return this.k;
            }

            @Override
            public V getValue() {
                return this.v;
            }

            @Override
            public V setValue(V value) {
                return Object2ObjectHashMap.this.put(this.k, value);
            }

            @Override
            public int hashCode() {
                Object v = this.getValue();
                return this.getKey().hashCode() ^ (v != null ? v.hashCode() : 0);
            }

            @Override
            public boolean equals(Object o) {
                if (!(o instanceof Map.Entry)) {
                    return false;
                }
                Map.Entry e = (Map.Entry)o;
                return e.getKey() != null && e.getKey().equals(this.k) && (e.getValue() == null && this.v == null || e.getValue().equals(this.v));
            }

            public String toString() {
                return this.k + "=" + this.v;
            }
        }
    }

    public final class ValueIterator
    extends AbstractIterator
    implements Iterator<V> {
        @Override
        public V next() {
            this.findNext();
            return Object2ObjectHashMap.this.unmapNullValue(Object2ObjectHashMap.this.entries[this.keyPosition() + 1]);
        }
    }

    public final class KeyIterator
    extends AbstractIterator
    implements Iterator<K> {
        @Override
        public K next() {
            this.findNext();
            return Object2ObjectHashMap.this.entries[this.keyPosition()];
        }
    }

    abstract class AbstractIterator {
        protected boolean isPositionValid = false;
        private int remaining;
        private int positionCounter;
        private int stopCounter;

        AbstractIterator() {
        }

        final void reset() {
            int capacity;
            this.isPositionValid = false;
            this.remaining = Object2ObjectHashMap.this.size;
            Object[] entries = Object2ObjectHashMap.this.entries;
            int keyIndex = capacity = entries.length;
            if (null != entries[capacity - 1]) {
                for (int i = 1; i < capacity; i += 2) {
                    if (entries[i] != null) continue;
                    keyIndex = i - 1;
                    break;
                }
            }
            this.stopCounter = keyIndex;
            this.positionCounter = keyIndex + capacity;
        }

        final int keyPosition() {
            return this.positionCounter & Object2ObjectHashMap.this.entries.length - 1;
        }

        public int remaining() {
            return this.remaining;
        }

        public boolean hasNext() {
            return this.remaining > 0;
        }

        protected final void findNext() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            Object[] entries = Object2ObjectHashMap.this.entries;
            int mask = entries.length - 1;
            for (int keyIndex = this.positionCounter - 2; keyIndex >= this.stopCounter; keyIndex -= 2) {
                int index = keyIndex & mask;
                if (entries[index + 1] == null) continue;
                this.isPositionValid = true;
                this.positionCounter = keyIndex;
                --this.remaining;
                return;
            }
            this.isPositionValid = false;
            throw new IllegalStateException();
        }

        public void remove() {
            if (!this.isPositionValid) {
                throw new IllegalStateException();
            }
            int position = this.keyPosition();
            ((Object2ObjectHashMap)Object2ObjectHashMap.this).entries[position] = null;
            ((Object2ObjectHashMap)Object2ObjectHashMap.this).entries[position + 1] = null;
            --Object2ObjectHashMap.this.size;
            Object2ObjectHashMap.this.compactChain(position);
            this.isPositionValid = false;
        }
    }
}

