/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.checks.config;

import com.datical.liquibase.ext.checks.config.CheckSettingsConfigHelper;
import com.datical.liquibase.ext.checks.config.FileAccessor$FileAccessorDTO;
import com.datical.liquibase.ext.checks.config.FileEncoder;
import com.datical.liquibase.ext.checks.config.FileEncoder$FileEncoderDTO;
import com.datical.liquibase.ext.checks.config.IFileAccessor;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import liquibase.Scope;
import liquibase.exception.CommandExecutionException;
import liquibase.util.FileUtil;
import liquibase.util.StringUtil;

public class FileAccessor
implements IFileAccessor {
    @Override
    public FileAccessor$FileAccessorDTO loadFileContents(String string) {
        File file = new File(string);
        if (!file.exists()) {
            Scope.getCurrentScope().getLog(CheckSettingsConfigHelper.class).info("No configuration file named '" + string + "' found.");
            throw new FileNotFoundException("Check settings configuration file not found.");
        }
        Scope.getCurrentScope().getLog(CheckSettingsConfigHelper.class).info("Check settings configuration file located at '" + file.getAbsolutePath() + "'.");
        string = FileUtil.getContents(file);
        FileAccessor$FileAccessorDTO fileAccessor$FileAccessorDTO = new FileAccessor$FileAccessorDTO();
        new FileAccessor$FileAccessorDTO().versioned = FileEncoder.isVersioned(string);
        Object object = FileEncoder.decode(string);
        fileAccessor$FileAccessorDTO.contents = ((FileEncoder$FileEncoderDTO)object).contents;
        fileAccessor$FileAccessorDTO.encoded = ((FileEncoder$FileEncoderDTO)object).encoded;
        if (fileAccessor$FileAccessorDTO.encoded) {
            object = file.getAbsolutePath() + ".v4.5";
            try {
                FileUtil.write(string, new File((String)object));
                string = "The file '" + file.getAbsolutePath() + "' has been updated so it can be used by your current version of Liquibase, and to simplify resolving merge conflicts in Source Control. No action is required from you. Your original file was backed up as '" + (String)object + "', and will work with Liquibase 4.5.0 users who specify it using the --checks-settings-file argument.";
                Scope.getCurrentScope().getLog(FileAccessor.class).warning(string);
                Scope.getCurrentScope().getUI().sendMessage("WARNING: ".concat(String.valueOf(string)));
            }
            catch (IOException iOException) {
                String string2 = "Error creating backup file '" + (String)object + "' " + iOException.getMessage();
                Scope.getCurrentScope().getLog(FileAccessor.class).warning(string2);
                Scope.getCurrentScope().getUI().sendMessage(string2);
            }
        }
        return fileAccessor$FileAccessorDTO;
    }

    @Override
    public void writeFileContents(String string, String string2) {
        File file = new File(string);
        if (!file.exists()) {
            Scope.getCurrentScope().getLog(CheckSettingsConfigHelper.class).info("No configuration file named '" + string + "' found.");
            file = this.createNewFile(string);
            Scope.getCurrentScope().getLog(CheckSettingsConfigHelper.class).info("Creating new file: " + file.getAbsolutePath());
        }
        Scope.getCurrentScope().getLog(CheckSettingsConfigHelper.class).info("Check settings configuration file located at '" + file.getAbsolutePath() + "'.");
        FileUtil.write("Quality Checks Version: 1.0\nIMPORTANT: DO NOT MODIFY THIS FILE DIRECTLY. UNRECOVERABLE and UNSUPPORTED ERRORS ARE LIKELY IF YOU EDIT THIS FILE DIRECTLY.\nThis file is created and modified by running commands in the Liquibase CLI.\nFor help using quality checks, visit the documentation at https://docs.liquibase.com/quality-checks\n\n-----------------------------------------------------------------------------------------------\n".concat(String.valueOf(string2)), file, false);
    }

    private File createNewFile(String string) {
        File file = new File(string);
        if (!StringUtil.isEmpty(file.getParent())) {
            file.getParentFile().mkdirs();
        }
        try {
            if (file.createNewFile()) {
                Scope.getCurrentScope().getLog(CheckSettingsConfigHelper.class).fine("Existing check settings configuration file not found, it is being created at '" + file.getAbsolutePath() + "'.");
            }
        }
        catch (IOException iOException) {
            throw new CommandExecutionException("Unable to create the file '" + string + "'. Make sure the location is accessible and that files can be created there.", iOException);
        }
        return file;
    }
}

