/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.server.routing.pools;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.LockSupport;
import java.util.stream.Collectors;
import org.apache.activemq.artemis.api.core.TransportConfiguration;
import org.apache.activemq.artemis.core.server.routing.pools.Pool;
import org.apache.activemq.artemis.core.server.routing.targets.Target;
import org.apache.activemq.artemis.core.server.routing.targets.TargetFactory;
import org.apache.activemq.artemis.core.server.routing.targets.TargetMonitor;
import org.apache.activemq.artemis.core.server.routing.targets.TargetProbe;
import org.jboss.logging.Logger;

public abstract class AbstractPool
implements Pool {
    private static final Logger logger = Logger.getLogger(AbstractPool.class);
    private final TargetFactory targetFactory;
    private final ScheduledExecutorService scheduledExecutor;
    private final int checkPeriod;
    private final List<TargetProbe> targetProbes = new ArrayList<TargetProbe>();
    private final Map<Target, TargetMonitor> targets = new ConcurrentHashMap<Target, TargetMonitor>();
    private final List<TargetMonitor> targetMonitors = new CopyOnWriteArrayList<TargetMonitor>();
    private String username;
    private String password;
    private int quorumSize;
    private int quorumTimeout;
    private long quorumTimeoutNanos;
    private final long quorumParkNanos = TimeUnit.MILLISECONDS.toNanos(100L);
    private volatile boolean started = false;

    @Override
    public String getUsername() {
        return this.username;
    }

    @Override
    public void setUsername(String username) {
        this.username = username;
    }

    @Override
    public String getPassword() {
        return this.password;
    }

    @Override
    public void setPassword(String password) {
        this.password = password;
    }

    @Override
    public int getCheckPeriod() {
        return this.checkPeriod;
    }

    @Override
    public int getQuorumSize() {
        return this.quorumSize;
    }

    @Override
    public int getQuorumTimeout() {
        return this.quorumTimeout;
    }

    @Override
    public void setQuorumTimeout(int quorumTimeout) {
        this.quorumTimeout = quorumTimeout;
        this.quorumTimeoutNanos = TimeUnit.MILLISECONDS.toNanos(quorumTimeout);
    }

    @Override
    public void setQuorumSize(int quorumSize) {
        this.quorumSize = quorumSize;
    }

    @Override
    public List<Target> getAllTargets() {
        return this.targetMonitors.stream().map(targetMonitor -> targetMonitor.getTarget()).collect(Collectors.toList());
    }

    @Override
    public List<Target> getTargets() {
        List targets = this.targetMonitors.stream().filter(targetMonitor -> targetMonitor.isTargetReady()).map(targetMonitor -> targetMonitor.getTarget()).collect(Collectors.toList());
        if (this.quorumTimeout > 0 && targets.size() < this.quorumSize) {
            long deadline = System.nanoTime() + this.quorumTimeoutNanos;
            while (targets.size() < this.quorumSize && System.nanoTime() - deadline < 0L) {
                targets = this.targetMonitors.stream().filter(targetMonitor -> targetMonitor.isTargetReady()).map(targetMonitor -> targetMonitor.getTarget()).collect(Collectors.toList());
                LockSupport.parkNanos(this.quorumParkNanos);
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debugf("Ready targets are " + targets + " / " + this.targetMonitors + " and quorumSize is " + this.quorumSize, new Object[0]);
        }
        return targets.size() < this.quorumSize ? Collections.emptyList() : targets;
    }

    @Override
    public List<TargetProbe> getTargetProbes() {
        return this.targetProbes;
    }

    public boolean isStarted() {
        return this.started;
    }

    public AbstractPool(TargetFactory targetFactory, ScheduledExecutorService scheduledExecutor, int checkPeriod) {
        this.targetFactory = targetFactory;
        this.scheduledExecutor = scheduledExecutor;
        this.checkPeriod = checkPeriod;
    }

    @Override
    public Target getTarget(String nodeId) {
        for (TargetMonitor targetMonitor : this.targetMonitors) {
            if (!nodeId.equals(targetMonitor.getTarget().getNodeID())) continue;
            return targetMonitor.getTarget();
        }
        return null;
    }

    @Override
    public boolean isTargetReady(Target target) {
        TargetMonitor targetMonitor = this.targets.get(target);
        return targetMonitor != null ? targetMonitor.isTargetReady() : false;
    }

    @Override
    public Target getReadyTarget(String nodeId) {
        int readyTargets;
        long deadline = this.quorumTimeout > 0 ? System.nanoTime() + this.quorumTimeoutNanos : 0L;
        do {
            readyTargets = 0;
            for (TargetMonitor targetMonitor : this.targetMonitors) {
                if (!targetMonitor.isTargetReady()) continue;
                ++readyTargets;
                if (!nodeId.equals(targetMonitor.getTarget().getNodeID())) continue;
                return targetMonitor.getTarget();
            }
        } while (readyTargets < this.quorumSize && deadline > 0L && System.nanoTime() - deadline < 0L);
        return null;
    }

    @Override
    public void addTargetProbe(TargetProbe probe) {
        this.targetProbes.add(probe);
    }

    @Override
    public void removeTargetProbe(TargetProbe probe) {
        this.targetProbes.remove(probe);
    }

    public void start() throws Exception {
        this.started = true;
        for (TargetMonitor targetMonitor : this.targetMonitors) {
            targetMonitor.start();
        }
    }

    public void stop() throws Exception {
        this.started = false;
        ArrayList<TargetMonitor> targetMonitors = new ArrayList<TargetMonitor>(this.targetMonitors);
        for (TargetMonitor targetMonitor : targetMonitors) {
            this.removeTarget(targetMonitor.getTarget());
        }
    }

    protected void addTarget(TransportConfiguration connector, String nodeID) {
        this.addTarget(this.targetFactory.createTarget(connector, nodeID));
    }

    @Override
    public boolean addTarget(Target target) {
        TargetMonitor targetMonitor = new TargetMonitor(this.scheduledExecutor, this.checkPeriod, target, this.targetProbes);
        if (this.targets.putIfAbsent(target, targetMonitor) != null) {
            return false;
        }
        this.targetMonitors.add(targetMonitor);
        if (this.started) {
            targetMonitor.start();
        }
        return true;
    }

    @Override
    public boolean removeTarget(Target target) {
        TargetMonitor targetMonitor = this.targets.remove(target);
        if (targetMonitor == null) {
            return false;
        }
        this.targetMonitors.remove(targetMonitor);
        targetMonitor.stop();
        return true;
    }
}

