/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.core;

import com.xebialabs.deployit.core.EncryptedStringValue;
import com.xebialabs.deployit.core.StringValue;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Iterator;
import java.util.stream.Collectors;

public abstract class AbstractStringView<T extends Collection<StringValue>>
implements Collection<String>,
Serializable {
    protected final T wrapped;

    protected AbstractStringView(T wrapped) {
        this.wrapped = wrapped;
    }

    @Override
    public int size() {
        return this.wrapped.size();
    }

    @Override
    public boolean isEmpty() {
        return this.wrapped.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.wrapped.contains(this.stringToStringValue(o));
    }

    @Override
    public Iterator<String> iterator() {
        return this.wrapped.stream().map(StringValue::toString).iterator();
    }

    @Override
    public Object[] toArray() {
        Object[] objects = new Object[this.size()];
        Iterator<String> iterator = this.iterator();
        for (int i = 0; i < objects.length; ++i) {
            objects[i] = iterator.next();
        }
        return objects;
    }

    @Override
    public <U> U[] toArray(U[] a) {
        int size = this.size();
        U[] r = a.length >= size ? a : (Object[])Array.newInstance(a.getClass().getComponentType(), size);
        Iterator<String> iterator = this.iterator();
        for (int i = 0; i < r.length; ++i) {
            r[i] = iterator.next();
        }
        return r;
    }

    @Override
    public boolean add(String stringValue) {
        return this.wrapped.add((StringValue)new StringValue(stringValue));
    }

    @Override
    public boolean add(StringValue stringValue) {
        return this.wrapped.add((StringValue)stringValue);
    }

    public boolean addEncrypted(String stringValue) {
        return this.wrapped.add((EncryptedStringValue)new EncryptedStringValue(stringValue));
    }

    public abstract AbstractStringView<T> encrypt();

    @Override
    public boolean remove(Object o) {
        return this.wrapped.remove(this.stringToStringValue(o));
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.wrapped.containsAll(this.transformToStringValue(c));
    }

    @Override
    public boolean addAll(Collection<? extends String> c) {
        boolean changed = false;
        for (String string : c) {
            changed |= this.add(string);
        }
        return changed;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return this.wrapped.retainAll(this.transformToStringValue(c));
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return this.wrapped.removeAll(this.transformToStringValue(c));
    }

    protected Collection<StringValue> transformToStringValue(Collection<?> c) {
        return c.stream().map(o -> {
            if (o instanceof String) {
                return new StringValue((String)o);
            }
            if (o instanceof StringValue) {
                return (StringValue)o;
            }
            throw new IllegalStateException("Cannot convert input [" + o + "]");
        }).collect(Collectors.toList());
    }

    protected Object stringToStringValue(Object o) {
        if (o instanceof String) {
            return new StringValue((String)o);
        }
        return o;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof AbstractStringView) {
            AbstractStringView object = (AbstractStringView)obj;
            return this.wrapped == null && object.wrapped == null || this.wrapped != null && this.wrapped.equals(object.wrapped);
        }
        return false;
    }

    public String toString() {
        return String.format("%s%s", this.getClass().getSimpleName(), this.wrapped);
    }

    @Override
    public int hashCode() {
        return this.wrapped.hashCode();
    }

    @Override
    public void clear() {
        this.wrapped.clear();
    }

    public T getWrapped() {
        return this.wrapped;
    }
}

