/*
 * Decompiled with CFR 0.152.
 */
package akka.http.impl.util;

import akka.NotUsed;
import akka.annotation.InternalApi;
import akka.event.Logging$;
import akka.event.LoggingAdapter;
import akka.stream.Attributes;
import akka.stream.Attributes$;
import akka.stream.TLSProtocol;
import akka.stream.scaladsl.BidiFlow;
import akka.stream.scaladsl.BidiFlow$;
import akka.stream.scaladsl.Flow;
import akka.stream.scaladsl.Flow$;
import akka.util.ByteString;
import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.collection.IterableOnceOps;
import scala.collection.Iterator;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ClassTag;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@InternalApi
public final class LogByteStringTools$ {
    public static final LogByteStringTools$ MODULE$ = new LogByteStringTools$();
    private static final int MaxBytesPrinted = 80;
    private static final Attributes LogFailuresOnDebugAttributes;

    static {
        int x$1 = Logging$.MODULE$.DebugLevel();
        int x$2 = Attributes$.MODULE$.logLevels$default$1();
        int x$3 = Attributes$.MODULE$.logLevels$default$2();
        LogFailuresOnDebugAttributes = Attributes$.MODULE$.logLevels(x$2, x$3, x$1);
    }

    public int MaxBytesPrinted() {
        return MaxBytesPrinted;
    }

    private Attributes LogFailuresOnDebugAttributes() {
        return LogFailuresOnDebugAttributes;
    }

    public BidiFlow<ByteString, ByteString, ByteString, ByteString, NotUsed> logByteStringBidi(String name, int maxBytes) {
        return BidiFlow$.MODULE$.fromFlows(this.logByteString(new StringBuilder(5).append(name).append(" DOWN").toString(), maxBytes), this.logByteString(new StringBuilder(5).append(name).append(" UP  ").toString(), maxBytes));
    }

    public <A, B> BidiFlow<A, A, B, B, NotUsed> logToStringBidi(String name, int maxBytes, ClassTag<A> evidence$1, ClassTag<B> evidence$2) {
        return BidiFlow$.MODULE$.fromFlows(this.logToString(new StringBuilder(1).append(name).append(" ").append(LogByteStringTools$.limitedName$1(evidence$1)).toString(), maxBytes), this.logToString(new StringBuilder(1).append(name).append(" ").append(LogByteStringTools$.limitedName$1(evidence$2)).toString(), maxBytes));
    }

    public Flow<ByteString, ByteString, NotUsed> logByteString(String name, int maxBytes) {
        Flow qual$1 = Flow$.MODULE$.apply();
        String x$12 = name;
        Function1 & Serializable x$2 = (Function1 & Serializable)x$1 -> MODULE$.printByteString((ByteString)x$1, maxBytes, MODULE$.printByteString$default$3(), MODULE$.printByteString$default$4());
        LoggingAdapter x$3 = qual$1.log$default$3(x$12, (Function1)x$2);
        return ((Flow)qual$1.log(x$12, (Function1)x$2, x$3)).addAttributes(this.LogFailuresOnDebugAttributes());
    }

    public int logByteStringBidi$default$2() {
        return this.MaxBytesPrinted();
    }

    public int logByteString$default$2() {
        return this.MaxBytesPrinted();
    }

    public <A> Flow<A, A, NotUsed> logToString(String name, int maxBytes) {
        Flow qual$1 = Flow$.MODULE$.apply();
        String x$1 = name;
        Function1 & Serializable x$22 = (Function1 & Serializable)x$2 -> StringOps$.MODULE$.take$extension(Predef$.MODULE$.augmentString(x$2.toString()), maxBytes);
        LoggingAdapter x$3 = qual$1.log$default$3(x$1, (Function1)x$22);
        return ((Flow)qual$1.log(x$1, (Function1)x$22, x$3)).addAttributes(this.LogFailuresOnDebugAttributes());
    }

    public <A, B> int logToStringBidi$default$2() {
        return this.MaxBytesPrinted();
    }

    public <A> int logToString$default$2() {
        return this.MaxBytesPrinted();
    }

    public BidiFlow<TLSProtocol.SslTlsOutbound, TLSProtocol.SslTlsOutbound, TLSProtocol.SslTlsInbound, TLSProtocol.SslTlsInbound, NotUsed> logTLSBidi(String name, int maxBytes) {
        return BidiFlow$.MODULE$.fromFlows(this.logTlsOutbound(new StringBuilder(8).append(name).append(" ToNet  ").toString(), maxBytes), this.logTlsInbound(new StringBuilder(8).append(name).append(" FromNet").toString(), maxBytes));
    }

    public int logTLSBidi$default$2() {
        return this.MaxBytesPrinted();
    }

    public Flow<TLSProtocol.SslTlsOutbound, TLSProtocol.SslTlsOutbound, NotUsed> logTlsOutbound(String name, int maxBytes) {
        Flow qual$1 = Flow$.MODULE$.apply();
        String x$1 = name;
        Function1 & Serializable x$2 = (Function1 & Serializable)x0$1 -> {
            String string;
            TLSProtocol.SslTlsOutbound sslTlsOutbound = x0$1;
            if (sslTlsOutbound instanceof TLSProtocol.SendBytes) {
                TLSProtocol.SendBytes sendBytes = (TLSProtocol.SendBytes)sslTlsOutbound;
                ByteString bytes = sendBytes.bytes();
                string = new StringBuilder(10).append("SendBytes ").append(MODULE$.printByteString(bytes, maxBytes, MODULE$.printByteString$default$3(), MODULE$.printByteString$default$4())).toString();
            } else if (sslTlsOutbound instanceof TLSProtocol.NegotiateNewSession) {
                TLSProtocol.NegotiateNewSession negotiateNewSession = (TLSProtocol.NegotiateNewSession)sslTlsOutbound;
                string = negotiateNewSession.toString();
            } else {
                throw new MatchError((Object)sslTlsOutbound);
            }
            return string;
        };
        LoggingAdapter x$3 = qual$1.log$default$3(x$1, (Function1)x$2);
        return ((Flow)qual$1.log(x$1, (Function1)x$2, x$3)).addAttributes(this.LogFailuresOnDebugAttributes());
    }

    public int logTlsOutbound$default$2() {
        return this.MaxBytesPrinted();
    }

    public Flow<TLSProtocol.SslTlsInbound, TLSProtocol.SslTlsInbound, NotUsed> logTlsInbound(String name, int maxBytes) {
        Flow qual$1 = Flow$.MODULE$.apply();
        String x$1 = name;
        Function1 & Serializable x$2 = (Function1 & Serializable)x0$1 -> {
            Object object;
            TLSProtocol.SslTlsInbound sslTlsInbound = x0$1;
            if (sslTlsInbound instanceof TLSProtocol.SessionTruncated) {
                TLSProtocol.SessionTruncated sessionTruncated;
                object = sessionTruncated = (TLSProtocol.SessionTruncated)sslTlsInbound;
            } else if (sslTlsInbound instanceof TLSProtocol.SessionBytes) {
                TLSProtocol.SessionBytes sessionBytes = (TLSProtocol.SessionBytes)sslTlsInbound;
                ByteString bytes = sessionBytes.bytes();
                object = new StringBuilder(13).append("SessionBytes ").append(MODULE$.printByteString(bytes, maxBytes, MODULE$.printByteString$default$3(), MODULE$.printByteString$default$4())).toString();
            } else {
                throw new MatchError((Object)sslTlsInbound);
            }
            return object;
        };
        LoggingAdapter x$3 = qual$1.log$default$3(x$1, (Function1)x$2);
        return ((Flow)qual$1.log(x$1, (Function1)x$2, x$3)).addAttributes(this.LogFailuresOnDebugAttributes());
    }

    public int logTlsInbound$default$2() {
        return this.MaxBytesPrinted();
    }

    public String printByteString(ByteString bytes, int maxBytes, boolean addPrefix, String indent) {
        return LogByteStringTools$.formatBytes$1(bytes, indent, maxBytes, addPrefix).mkString("");
    }

    public int printByteString$default$2() {
        return this.MaxBytesPrinted();
    }

    public boolean printByteString$default$3() {
        return true;
    }

    public String printByteString$default$4() {
        return " ";
    }

    public char asASCII(byte b) {
        return b >= 32 && b < 127 ? (char)b : (char)'.';
    }

    public BidiFlow<TLSProtocol.SslTlsOutbound, TLSProtocol.SslTlsOutbound, TLSProtocol.SslTlsInbound, TLSProtocol.SslTlsInbound, Object> logTLSBidiBySetting(String tag, Option<Object> maxBytesSetting) {
        return (BidiFlow)maxBytesSetting.map((Function1 & Serializable)x$3 -> LogByteStringTools$.MODULE$.logTLSBidi(tag, BoxesRunTime.unboxToInt((Object)x$3))).getOrElse((Function0 & Serializable)() -> BidiFlow$.MODULE$.identity());
    }

    private static final String limitedName$1(ClassTag tag) {
        return StringOps$.MODULE$.mkString$extension(Predef$.MODULE$.augmentString(StringOps$.MODULE$.take$extension(Predef$.MODULE$.augmentString(Logging$.MODULE$.simpleName(tag.runtimeClass())), 20)));
    }

    private static final String asHex$1(byte b) {
        return StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("%02X"), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToByte((byte)b)}));
    }

    private static final String formatLine$1(ByteString bs, String indent$1) {
        String hex = ((IterableOnceOps)bs.map((Function1 & Serializable)b -> LogByteStringTools$.asHex$1(BoxesRunTime.unboxToByte((Object)b)))).mkString(" ");
        String ascii = ((IterableOnceOps)bs.map((Function1 & Serializable)b -> BoxesRunTime.boxToCharacter((char)LogByteStringTools$.MODULE$.asASCII(BoxesRunTime.unboxToByte((Object)b))))).mkString();
        String arg$macro$1 = indent$1;
        String arg$macro$2 = hex;
        String arg$macro$3 = ascii;
        return StringOps$.MODULE$.format$extension("%s%-48s | %s", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{arg$macro$1, arg$macro$2, arg$macro$3}));
    }

    private static final String formatBytes$2(ByteString bs2, String indent$1) {
        return bs2.grouped(16).map((Function1 & Serializable)bs -> LogByteStringTools$.formatLine$1(bs, indent$1)).mkString("\n");
    }

    private static final Iterator formatBytes$1(ByteString bs, String indent$1, int maxBytes$5, boolean addPrefix$1) {
        String prefix = new StringBuilder(18).append(indent$1).append("ByteString(").append(bs.size()).append(" bytes)").toString();
        return bs.size() <= maxBytes$5 * 2 ? package$.MODULE$.Iterator().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{addPrefix$1 ? new StringBuilder(1).append(prefix).append("\n").toString() : "", LogByteStringTools$.formatBytes$2(bs, indent$1)})) : package$.MODULE$.Iterator().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{addPrefix$1 ? new StringBuilder(16).append(prefix).append(" first + last ").append(maxBytes$5).append(":\n").toString() : "", LogByteStringTools$.formatBytes$2(bs.take(maxBytes$5), indent$1), new StringBuilder(46).append("\n").append(indent$1).append("                    ... [").append(bs.size() - maxBytes$5 * 2).append(" bytes omitted] ...\n").toString(), LogByteStringTools$.formatBytes$2(bs.takeRight(maxBytes$5), indent$1)}));
    }

    private LogByteStringTools$() {
    }
}

