/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j.security;

import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.snmp4j.log.LogAdapter;
import org.snmp4j.log.LogFactory;
import org.snmp4j.security.UsmUserEntry;
import org.snmp4j.smi.OctetString;

public class UsmUserTable
implements Serializable {
    private static final long serialVersionUID = 6936547777550957622L;
    private static final LogAdapter logger = LogFactory.getLogger(UsmUserTable.class);
    private Map table = new TreeMap();

    public synchronized UsmUserEntry addUser(UsmUserEntry usmUserEntry) {
        if (logger.isDebugEnabled()) {
            logger.debug("Adding user " + usmUserEntry.getUserName() + " = " + usmUserEntry.getUsmUser());
        }
        return this.table.put(new UsmUserKey(usmUserEntry), usmUserEntry);
    }

    public synchronized void setUsers(Collection collection) {
        if (logger.isDebugEnabled()) {
            logger.debug("Setting users to " + collection);
        }
        this.table.clear();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            UsmUserEntry usmUserEntry = (UsmUserEntry)iterator.next();
            this.table.put(new UsmUserKey(usmUserEntry), usmUserEntry);
        }
    }

    public synchronized List getUserEntries(OctetString octetString) {
        LinkedList<UsmUserEntry> linkedList = new LinkedList<UsmUserEntry>();
        Iterator iterator = this.table.values().iterator();
        while (iterator.hasNext()) {
            UsmUserEntry usmUserEntry = (UsmUserEntry)iterator.next();
            if (!octetString.equals(usmUserEntry.getUserName())) continue;
            linkedList.add(usmUserEntry);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Returning user entries for " + octetString + " = " + linkedList);
        }
        return linkedList;
    }

    public synchronized List getUserEntries() {
        LinkedList linkedList = new LinkedList();
        Iterator iterator = this.table.values().iterator();
        while (iterator.hasNext()) {
            linkedList.add(iterator.next());
        }
        return linkedList;
    }

    public synchronized UsmUserEntry removeUser(OctetString octetString, OctetString octetString2) {
        UsmUserEntry usmUserEntry = (UsmUserEntry)this.table.remove(new UsmUserKey(octetString, octetString2));
        if (logger.isDebugEnabled()) {
            logger.debug("Removed user with secName=" + octetString2 + " and engineID=" + octetString);
        }
        return usmUserEntry;
    }

    public synchronized UsmUserEntry getUser(OctetString octetString, OctetString octetString2) {
        return (UsmUserEntry)this.table.get(new UsmUserKey(octetString, octetString2));
    }

    public synchronized UsmUserEntry getUser(OctetString octetString) {
        return (UsmUserEntry)this.table.get(new UsmUserKey(new OctetString(), octetString));
    }

    public synchronized void clear() {
        this.table.clear();
        if (logger.isDebugEnabled()) {
            logger.debug("Cleared UsmUserTable");
        }
    }

    public static class UsmUserKey
    implements Comparable {
        OctetString engineID;
        OctetString securityName;

        public UsmUserKey(UsmUserEntry usmUserEntry) {
            this.setEngineID(usmUserEntry.getEngineID());
            this.securityName = usmUserEntry.getUsmUser().getSecurityName();
        }

        public UsmUserKey(OctetString octetString, OctetString octetString2) {
            this.setEngineID(octetString);
            this.securityName = octetString2;
        }

        private void setEngineID(OctetString octetString) {
            this.engineID = octetString == null ? new OctetString() : octetString;
        }

        public int hashCode() {
            return this.engineID.hashCode() ^ 2 + this.securityName.hashCode();
        }

        public boolean equals(Object object) {
            if (object instanceof UsmUserEntry || object instanceof UsmUserKey) {
                return this.compareTo(object) == 0;
            }
            return false;
        }

        public int compareTo(Object object) {
            if (object instanceof UsmUserEntry) {
                return this.compareTo(new UsmUserKey((UsmUserEntry)object));
            }
            UsmUserKey usmUserKey = (UsmUserKey)object;
            int n = 0;
            if (this.engineID != null && usmUserKey.engineID != null) {
                n = this.engineID.compareTo(usmUserKey.engineID);
            } else if (this.engineID != null && usmUserKey.engineID == null) {
                n = 1;
            } else if (this.engineID == null && usmUserKey.engineID != null) {
                n = -1;
            }
            if (n == 0) {
                n = this.securityName.compareTo(usmUserKey.securityName);
            }
            return n;
        }
    }
}

