/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.gax.rpc.mtls;

import com.google.api.client.json.JsonParser;
import com.google.api.client.json.gson.GsonFactory;
import com.google.api.client.util.SecurityUtils;
import com.google.api.core.BetaApi;
import com.google.api.gax.rpc.internal.EnvironmentProvider;
import com.google.api.gax.rpc.mtls.ContextAwareMetadataJson;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.util.List;

@BetaApi
public class MtlsProvider {
    private static final String DEFAULT_CONTEXT_AWARE_METADATA_PATH = System.getProperty("user.home") + "/.secureConnect/context_aware_metadata.json";
    private String metadataPath;
    private EnvironmentProvider envProvider;
    private ProcessProvider processProvider;

    @VisibleForTesting
    MtlsProvider(EnvironmentProvider envProvider, ProcessProvider processProvider, String metadataPath) {
        this.envProvider = envProvider;
        this.processProvider = processProvider;
        this.metadataPath = metadataPath;
    }

    public MtlsProvider() {
        this(System::getenv, new DefaultProcessProvider(), DEFAULT_CONTEXT_AWARE_METADATA_PATH);
    }

    public boolean useMtlsClientCertificate() {
        String useClientCertificate = this.envProvider.getenv("GOOGLE_API_USE_CLIENT_CERTIFICATE");
        return "true".equals(useClientCertificate);
    }

    public MtlsEndpointUsagePolicy getMtlsEndpointUsagePolicy() {
        String mtlsEndpointUsagePolicy = this.envProvider.getenv("GOOGLE_API_USE_MTLS_ENDPOINT");
        if ("never".equals(mtlsEndpointUsagePolicy)) {
            return MtlsEndpointUsagePolicy.NEVER;
        }
        if ("always".equals(mtlsEndpointUsagePolicy)) {
            return MtlsEndpointUsagePolicy.ALWAYS;
        }
        return MtlsEndpointUsagePolicy.AUTO;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public KeyStore getKeyStore() throws IOException {
        try (FileInputStream stream = new FileInputStream(this.metadataPath);){
            KeyStore keyStore = MtlsProvider.getKeyStore(stream, this.processProvider);
            return keyStore;
        }
        catch (InterruptedException e) {
            throw new IOException("Interrupted executing certificate provider command", e);
        }
        catch (GeneralSecurityException e) {
            return null;
        }
        catch (FileNotFoundException exception) {
            return null;
        }
    }

    @VisibleForTesting
    static KeyStore getKeyStore(InputStream metadata, ProcessProvider processProvider) throws IOException, InterruptedException, GeneralSecurityException {
        Process process = processProvider.createProcess(metadata);
        int exitCode = MtlsProvider.runCertificateProviderCommand(process, 1000L);
        if (exitCode != 0) {
            throw new IOException("Cert provider command failed with exit code: " + exitCode);
        }
        return SecurityUtils.createMtlsKeyStore((InputStream)process.getInputStream());
    }

    @VisibleForTesting
    static ImmutableList<String> extractCertificateProviderCommand(InputStream contextAwareMetadata) throws IOException {
        JsonParser parser = new GsonFactory().createJsonParser(contextAwareMetadata);
        ContextAwareMetadataJson json = (ContextAwareMetadataJson)((Object)parser.parse(ContextAwareMetadataJson.class));
        return json.getCommands();
    }

    @VisibleForTesting
    static int runCertificateProviderCommand(Process commandProcess, long timeoutMilliseconds) throws IOException, InterruptedException {
        long startTime = System.currentTimeMillis();
        for (long remainTime = timeoutMilliseconds; remainTime > 0L; remainTime -= System.currentTimeMillis() - startTime) {
            Thread.sleep(Math.min(remainTime + 1L, 100L));
            try {
                return commandProcess.exitValue();
            }
            catch (IllegalThreadStateException illegalThreadStateException) {
                continue;
            }
        }
        commandProcess.destroy();
        throw new IOException("cert provider command timed out");
    }

    public static enum MtlsEndpointUsagePolicy {
        NEVER,
        AUTO,
        ALWAYS;

    }

    static class DefaultProcessProvider
    implements ProcessProvider {
        DefaultProcessProvider() {
        }

        @Override
        public Process createProcess(InputStream metadata) throws IOException {
            if (metadata == null) {
                return null;
            }
            ImmutableList<String> command = MtlsProvider.extractCertificateProviderCommand(metadata);
            return new ProcessBuilder((List<String>)command).start();
        }
    }

    static interface ProcessProvider {
        public Process createProcess(InputStream var1) throws IOException;
    }
}

