/*
 * Decompiled with CFR 0.152.
 */
package liquibase.repackaged.net.sf.jsqlparser.statement.alter;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import liquibase.repackaged.net.sf.jsqlparser.schema.Table;
import liquibase.repackaged.net.sf.jsqlparser.statement.Statement;
import liquibase.repackaged.net.sf.jsqlparser.statement.StatementVisitor;

public class RenameTableStatement
implements Statement {
    private final LinkedHashMap<Table, Table> tableNames = new LinkedHashMap();
    private boolean usingTableKeyword = false;
    private boolean usingIfExistsKeyword = false;
    private String waitDirective = "";

    public RenameTableStatement(Table table, Table table2) {
        this.tableNames.put(Objects.requireNonNull(table, "The OLD NAME of the Rename Statement must not be null."), Objects.requireNonNull(table2, "The NEW NAME of the Rename Statement must not be null."));
    }

    public RenameTableStatement(Table table, Table table2, boolean bl2, boolean bl3, String string) {
        this.tableNames.put(Objects.requireNonNull(table, "The OLD NAME of the Rename Statement must not be null."), Objects.requireNonNull(table2, "The NEW NAME of the Rename Statement must not be null."));
        this.usingTableKeyword = bl2;
        this.usingIfExistsKeyword = bl3;
        this.waitDirective = string;
    }

    public void addTableNames(Table table, Table table2) {
        this.tableNames.put(Objects.requireNonNull(table, "The OLD NAME of the Rename Statement must not be null."), Objects.requireNonNull(table2, "The NEW NAME of the Rename Statement must not be null."));
    }

    public boolean isUsingTableKeyword() {
        return this.usingTableKeyword;
    }

    public void setUsingTableKeyword(boolean bl2) {
        this.usingTableKeyword = bl2;
    }

    public RenameTableStatement withUsingTableKeyword(boolean bl2) {
        this.usingTableKeyword = bl2;
        return this;
    }

    public boolean isUsingIfExistsKeyword() {
        return this.usingIfExistsKeyword;
    }

    public void setUsingIfExistsKeyword(boolean bl2) {
        this.usingIfExistsKeyword = bl2;
    }

    public RenameTableStatement withUsingIfExistsKeyword(boolean bl2) {
        this.usingIfExistsKeyword = bl2;
        return this;
    }

    public String getWaitDirective() {
        return this.waitDirective;
    }

    public void setWaitDirective(String string) {
        this.waitDirective = string;
    }

    public RenameTableStatement withWaitDirective(String string) {
        this.waitDirective = string;
        return this;
    }

    public int getTableNamesSize() {
        return this.tableNames.size();
    }

    public boolean isTableNamesEmpty() {
        return this.tableNames.isEmpty();
    }

    public Set<Map.Entry<Table, Table>> getTableNames() {
        return this.tableNames.entrySet();
    }

    @Override
    public void accept(StatementVisitor statementVisitor) {
        statementVisitor.visit(this);
    }

    public StringBuilder appendTo(StringBuilder stringBuilder) {
        int n2 = 0;
        for (Map.Entry<Table, Table> entry : this.tableNames.entrySet()) {
            if (n2 == 0) {
                stringBuilder.append("RENAME").append(this.usingTableKeyword ? " TABLE " : " ").append(this.usingIfExistsKeyword ? " IF EXISTS " : " ").append(entry.getKey()).append(this.waitDirective != null && this.waitDirective.length() > 0 ? " " + this.waitDirective : "").append(" TO ").append(entry.getValue());
            } else {
                stringBuilder.append(", ").append(entry.getKey()).append(" TO ").append(entry.getValue());
            }
            ++n2;
        }
        return stringBuilder;
    }

    public String toString() {
        return this.appendTo(new StringBuilder()).toString();
    }
}

