/*
 * Decompiled with CFR 0.152.
 */
package ai.digital.deploy.permissions.service.impl;

import ai.digital.deploy.permissions.jpa.ReadOnlyTransactionalPermissionService;
import ai.digital.deploy.permissions.model.view.HistoryEntity;
import ai.digital.deploy.permissions.model.view.ReferencedPermissionHistory;
import ai.digital.deploy.permissions.model.view.RolePrincipalHistory;
import ai.digital.deploy.permissions.repository.ReferencedPermissionHistoryRepository;
import ai.digital.deploy.permissions.repository.RolePrincipalHistoryRepository;
import ai.digital.deploy.permissions.service.ReferencedPermissionHistoryService;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.UUID;
import org.hibernate.envers.RevisionType;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import scala.Byte$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option$;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.List;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@Service
@ReadOnlyTransactionalPermissionService
@ScalaSignature(bytes="\u0006\u0005\u0005\u0015h\u0001B\b\u0011\u0001uA\u0001\u0002\u000b\u0001\u0003\u0002\u0003\u0006I!\u000b\u0005\t_\u0001\u0011\t\u0011)A\u0005a!)1\u0007\u0001C\u0001i!)\u0011\b\u0001C!u!)Q\u000e\u0001C!]\")A\u000f\u0001C!k\")A\u0010\u0001C!{\"9\u0011q\u0001\u0001\u0005\n\u0005%\u0001bBA#\u0001\u0011%\u0011q\t\u0005\b\u00037\u0002A\u0011BA/\u0011\u001d\t\t\b\u0001C!\u0003gBq!a)\u0001\t\u0003\n)\u000bC\u0004\u0002,\u0002!\t%!,\t\u000f\u0005e\u0006\u0001\"\u0011\u0002<\n1#+\u001a4fe\u0016t7-\u001a3QKJl\u0017n]:j_:D\u0015n\u001d;pef\u001cVM\u001d<jG\u0016LU\u000e\u001d7\u000b\u0005E\u0011\u0012\u0001B5na2T!a\u0005\u000b\u0002\u000fM,'O^5dK*\u0011QCF\u0001\fa\u0016\u0014X.[:tS>t7O\u0003\u0002\u00181\u00051A-\u001a9m_fT!!\u0007\u000e\u0002\u000f\u0011Lw-\u001b;bY*\t1$\u0001\u0002bS\u000e\u00011c\u0001\u0001\u001fIA\u0011qDI\u0007\u0002A)\t\u0011%A\u0003tG\u0006d\u0017-\u0003\u0002$A\t1\u0011I\\=SK\u001a\u0004\"!\n\u0014\u000e\u0003II!a\n\n\u0003EI+g-\u001a:f]\u000e,G\rU3s[&\u001c8/[8o\u0011&\u001cHo\u001c:z'\u0016\u0014h/[2f\u0003\u0015\u0012XMZ3sK:\u001cW\r\u001a)fe6L7o]5p]\"K7\u000f^8ssJ+\u0007o\\:ji>\u0014\u0018\u0010\u0005\u0002+[5\t1F\u0003\u0002-)\u0005Q!/\u001a9pg&$xN]=\n\u00059Z#!\n*fM\u0016\u0014XM\\2fIB+'/\\5tg&|g\u000eS5ti>\u0014\u0018PU3q_NLGo\u001c:z\u0003y\u0011x\u000e\\3Qe&t7-\u001b9bY\"K7\u000f^8ssJ+\u0007o\\:ji>\u0014\u0018\u0010\u0005\u0002+c%\u0011!g\u000b\u0002\u001f%>dW\r\u0015:j]\u000eL\u0007/\u00197ISN$xN]=SKB|7/\u001b;pef\fa\u0001P5oSRtDcA\u001b8qA\u0011a\u0007A\u0007\u0002!!)\u0001f\u0001a\u0001S!)qf\u0001a\u0001a\u0005\u0011C.[:u%\u00164WM]3oG\u0016\u001c()\u001f*pY\u0016\fe\u000e\u001a)fe6L7o]5p]N$RaO(ZG.\u00042\u0001\u0010#H\u001d\ti$I\u0004\u0002?\u00036\tqH\u0003\u0002A9\u00051AH]8pizJ\u0011!I\u0005\u0003\u0007\u0002\nq\u0001]1dW\u0006<W-\u0003\u0002F\r\n!A*[:u\u0015\t\u0019\u0005\u0005\u0005\u0002I\u001b6\t\u0011J\u0003\u0002K\u0017\u0006!a/[3x\u0015\taE#A\u0003n_\u0012,G.\u0003\u0002O\u0013\nY\"+\u001a4fe\u0016t7-\u001a3QKJl\u0017n]:j_:D\u0015n\u001d;pefDQ\u0001\u0015\u0003A\u0002E\u000baA]8mK&#\u0007C\u0001*X\u001b\u0005\u0019&B\u0001+V\u0003\u0011)H/\u001b7\u000b\u0003Y\u000bAA[1wC&\u0011\u0001l\u0015\u0002\u0005+VKE\tC\u0003\u0016\t\u0001\u0007!\fE\u0002=\tn\u0003\"\u0001\u00181\u000f\u0005us\u0006C\u0001 !\u0013\ty\u0006%\u0001\u0004Qe\u0016$WMZ\u0005\u0003C\n\u0014aa\u0015;sS:<'BA0!\u0011\u0015!G\u00011\u0001f\u0003%\u0019H/\u0019:u)&lW\r\u0005\u0002gS6\tqM\u0003\u0002i+\u0006!A/[7f\u0013\tQwMA\u0007M_\u000e\fG\u000eR1uKRKW.\u001a\u0005\u0006Y\u0012\u0001\r!Z\u0001\bK:$G+[7f\u0003\u001db\u0017n\u001d;SK\u001a,'/\u001a8dKN\u0014\u0015\u0010\u0015:j]\u000eL\u0007/\u00197B]\u0012\u0004VM]7jgNLwN\\:\u0015\u000bmz\u0017O]:\t\u000bA,\u0001\u0019A.\u0002\u001bA\u0014\u0018N\\2ja\u0006dg*Y7f\u0011\u0015)R\u00011\u0001[\u0011\u0015!W\u00011\u0001f\u0011\u0015aW\u00011\u0001f\u00039b\u0017n\u001d;SK\u001a,'/\u001a8dKN\u0014\u0015PU8mK\u0006sGMU3gKJ,gnY3B]\u0012\u0004VM]7jgNLwN\\:\u0015\rm2x/\u001f>|\u0011\u0015\u0001f\u00011\u0001R\u0011\u0015Ah\u00011\u0001R\u0003%\u0011XMZ3sK:\u001cW\rC\u0003\u0016\r\u0001\u0007!\fC\u0003e\r\u0001\u0007Q\rC\u0003m\r\u0001\u0007Q-A\u001amSN$(+\u001a4fe\u0016t7-Z:CsB\u0013\u0018N\\2ja\u0006d\u0017I\u001c3SK\u001a,'/\u001a8dK\u0006sG\rU3s[&\u001c8/[8ogRI1H`@\u0002\u0002\u0005\r\u0011Q\u0001\u0005\u0006a\u001e\u0001\ra\u0017\u0005\u0006q\u001e\u0001\r!\u0015\u0005\u0006+\u001d\u0001\rA\u0017\u0005\u0006I\u001e\u0001\r!\u001a\u0005\u0006Y\u001e\u0001\r!Z\u0001\u0016M&dG/\u001a:U_6\u000bGo\u00195J]R,'O^1m+\u0011\tY!a\b\u0015\u0015\u00055\u0011\u0011GA\u001c\u0003\u0003\n\u0019\u0005\u0005\u0004\u0002\u0010\u0005e\u00111D\u0007\u0003\u0003#QA!a\u0005\u0002\u0016\u0005I\u0011.\\7vi\u0006\u0014G.\u001a\u0006\u0004\u0003/\u0001\u0013AC2pY2,7\r^5p]&\u0019Q)!\u0005\u0011\t\u0005u\u0011q\u0004\u0007\u0001\t\u001d\t\t\u0003\u0003b\u0001\u0003G\u0011\u0011\u0001V\t\u0005\u0003K\tY\u0003E\u0002 \u0003OI1!!\u000b!\u0005\u001dqu\u000e\u001e5j]\u001e\u00042\u0001SA\u0017\u0013\r\ty#\u0013\u0002\u000e\u0011&\u001cHo\u001c:z\u000b:$\u0018\u000e^=\t\u000f\u0005M\u0002\u00021\u0001\u00026\u0005I\u0001.[:u_JLWm\u001d\t\u0005y\u0011\u000bY\u0002C\u0004\u0002:!\u0001\r!a\u000f\u0002\u0005%$\u0007CB\u0010\u0002>\u0005m\u0011+C\u0002\u0002@\u0001\u0012\u0011BR;oGRLwN\\\u0019\t\u000b\u0011D\u0001\u0019A3\t\u000b1D\u0001\u0019A3\u0002K\u0019LG\u000e^3s\u000fJ|W\u000f]3e\u0011&\u001cHo\u001c:jKN$v.T1uG\"Le\u000e^3sm\u0006dW\u0003BA%\u0003\u001f\"\u0002\"a\u0013\u0002R\u0005M\u0013Q\u000b\t\u0007\u0003\u001f\tI\"!\u0014\u0011\t\u0005u\u0011q\n\u0003\b\u0003CI!\u0019AA\u0012\u0011\u0015!\u0017\u00021\u0001f\u0011\u0015a\u0017\u00021\u0001f\u0011\u001d\t9&\u0003a\u0001\u00033\n\u0001c\u001a:pkB,G\rS5ti>\u0014\u0018.Z:\u0011\tq\"\u0015QJ\u0001$M&dG/\u001a:De\u0016\fG/Z!oI6{G-\u001b4z\u0013:$\u0016.\\3J]R,'O^1m+\u0011\ty&!\u001a\u0015\u0011\u0005\u0005\u0014qMA7\u0003_\u0002b!a\u0004\u0002\u001a\u0005\r\u0004\u0003BA\u000f\u0003K\"q!!\t\u000b\u0005\u0004\t\u0019\u0003C\u0004\u0002j)\u0001\r!a\u001b\u0002+5,H\u000e^5He>,\b/\u001a3ISN$xN]5fgB!A\bRA2\u0011\u0015!'\u00021\u0001f\u0011\u0015a'\u00021\u0001f\u00039:W\r\u001e*fM\u0016\u0014XM\\2f\u0011&\u001cHo\u001c:jKN4uN\u001d*fM\u0016\u0014XM\\2f\u0003:$\u0007+\u001a:nSN\u001c\u0018n\u001c8\u0015\u0019\u0005U\u0014QRAI\u0003+\u000b9*!'\u0011\u000b\u0005]\u0014\u0011R$\u000e\u0005\u0005e$\u0002BA>\u0003{\na\u0001Z8nC&t'\u0002BA@\u0003\u0003\u000bA\u0001Z1uC*!\u00111QAC\u0003=\u0019\bO]5oO\u001a\u0014\u0018-\\3x_J\\'BAAD\u0003\ry'oZ\u0005\u0005\u0003\u0017\u000bIH\u0001\u0003QC\u001e,\u0007BBAH\u0017\u0001\u0007\u0011+A\u0006sK\u001a,'/\u001a8dK&#\u0007BBAJ\u0017\u0001\u00071,\u0001\u0006qKJl\u0017n]:j_:DQ\u0001Z\u0006A\u0002\u0015DQ\u0001\\\u0006A\u0002\u0015Dq!a'\f\u0001\u0004\ti*\u0001\u0005qC\u001e,\u0017M\u00197f!\u0011\t9(a(\n\t\u0005\u0005\u0016\u0011\u0010\u0002\t!\u0006<W-\u00192mK\u0006qr-\u001a;SK\u001a,'/\u001a8dK\"K7\u000f^8sS\u0016\u001chi\u001c:S_2,\u0017\n\u001a\u000b\u0007\u0003k\n9+!+\t\u000bAc\u0001\u0019A)\t\u000f\u0005mE\u00021\u0001\u0002\u001e\u0006Qs-\u001a;SK\u001a,'/\u001a8dK\"K7\u000f^8sS\u0016\u001chi\u001c:SK\u001a,'/\u001a8dK\u0006sGMU8mK&#G\u0003DA;\u0003_\u000b\t,a-\u00026\u0006]\u0006BBAH\u001b\u0001\u0007\u0011\u000bC\u0003Q\u001b\u0001\u0007\u0011\u000bC\u0003e\u001b\u0001\u0007Q\rC\u0003m\u001b\u0001\u0007Q\rC\u0004\u0002\u001c6\u0001\r!!(\u0002u\u001d,GOU3gKJ,gnY3ISN$xN]5fg\u001a{'OU3gKJ,gnY3B]\u0012\u0014VMZ3sK:\u001cW\r\u001a)fe6L7o]5p]&#G\u0003DA;\u0003{\u000by,a1\u0002F\u0006\u001d\u0007BBAH\u001d\u0001\u0007\u0011\u000b\u0003\u0004\u0002B:\u0001\r!U\u0001\u0017e\u00164WM]3oG\u0016$\u0007+\u001a:nSN\u001c\u0018n\u001c8JI\")AM\u0004a\u0001K\")AN\u0004a\u0001K\"9\u00111\u0014\bA\u0002\u0005u\u0005f\u0001\u0001\u0002LB!\u0011QZAj\u001b\t\tyMC\u0002\u0002RR\t1A\u001b9b\u0013\u0011\t).a4\u0003MI+\u0017\rZ(oYf$&/\u00198tC\u000e$\u0018n\u001c8bYB+'/\\5tg&|gnU3sm&\u001cW\rK\u0002\u0001\u00033\u0004B!a7\u0002b6\u0011\u0011Q\u001c\u0006\u0005\u0003?\f\t)\u0001\u0006ti\u0016\u0014Xm\u001c;za\u0016LA!a9\u0002^\n91+\u001a:wS\u000e,\u0007")
public class ReferencedPermissionHistoryServiceImpl
implements ReferencedPermissionHistoryService {
    private final ReferencedPermissionHistoryRepository referencedPermissionHistoryRepository;
    private final RolePrincipalHistoryRepository rolePrincipalHistoryRepository;

    @Override
    public List<ReferencedPermissionHistory> listReferencesByRoleAndPermissions(UUID roleId, List<String> permissions, LocalDateTime startTime, LocalDateTime endTime) {
        return this.filterToMatchInterval(this.referencedPermissionHistoryRepository.getReferencedPermissionHistoriesForRoleAndPermissions(roleId, permissions), (Function1 & Serializable)e -> e.referencedPermissionId(), startTime, endTime);
    }

    @Override
    public List<ReferencedPermissionHistory> listReferencesByPrincipalAndPermissions(String principalName, List<String> permissions, LocalDateTime startTime, LocalDateTime endTime) {
        List<RolePrincipalHistory> rolePrincipals = this.filterToMatchInterval(this.rolePrincipalHistoryRepository.get(principalName), (Function1 & Serializable)e -> e.rolePrincipalId(), startTime, endTime);
        return rolePrincipals.flatMap((Function1 & Serializable)rolePrincipal -> this.filterToMatchInterval($this.referencedPermissionHistoryRepository.getReferencedPermissionHistoriesForRoleAndPermissions(rolePrincipal.roleId(), permissions), (Function1 & Serializable)e -> e.referencedPermissionId(), rolePrincipal.startTime(), (LocalDateTime)Option$.MODULE$.apply((Object)rolePrincipal.endTime()).getOrElse((Function0 & Serializable)() -> endTime)));
    }

    @Override
    public List<ReferencedPermissionHistory> listReferencesByRoleAndReferenceAndPermissions(UUID roleId, UUID reference, List<String> permissions, LocalDateTime startTime, LocalDateTime endTime) {
        return this.filterToMatchInterval(this.referencedPermissionHistoryRepository.getReferencedPermissionHistoriesForRoleAndReference(roleId, reference, permissions), (Function1 & Serializable)e -> e.referencedPermissionId(), startTime, endTime);
    }

    @Override
    public List<ReferencedPermissionHistory> listReferencesByPrincipalAndReferenceAndPermissions(String principalName, UUID reference, List<String> permissions, LocalDateTime startTime, LocalDateTime endTime) {
        List<RolePrincipalHistory> rolePrincipals = this.filterToMatchInterval(this.rolePrincipalHistoryRepository.get(principalName), (Function1 & Serializable)e -> e.rolePrincipalId(), startTime, endTime);
        return rolePrincipals.flatMap((Function1 & Serializable)rolePrincipal -> this.filterToMatchInterval($this.referencedPermissionHistoryRepository.getReferencedPermissionHistoriesForRoleAndReference(rolePrincipal.roleId(), reference, permissions), (Function1 & Serializable)e -> e.referencedPermissionId(), rolePrincipal.startTime(), (LocalDateTime)Option$.MODULE$.apply((Object)rolePrincipal.endTime()).getOrElse((Function0 & Serializable)() -> endTime)));
    }

    private <T extends HistoryEntity> List<T> filterToMatchInterval(List<T> histories, Function1<T, UUID> id, LocalDateTime startTime, LocalDateTime endTime) {
        return ((IterableOnceOps)histories.groupBy(id).flatMap((Function1 & Serializable)x0$1 -> {
            List groupedHistories;
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null || (groupedHistories = (List)tuple2._2()) == null) {
                throw new MatchError((Object)tuple2);
            }
            List list = groupedHistories;
            List list2 = this.filterGroupedHistoriesToMatchInterval(startTime, endTime, list);
            return list2;
        })).toList();
    }

    private <T extends HistoryEntity> List<T> filterGroupedHistoriesToMatchInterval(LocalDateTime startTime, LocalDateTime endTime, List<T> groupedHistories) {
        List<T> list = groupedHistories;
        List<T> list2 = list.size() == 1 ? list.filter((Function1 & Serializable)rp -> BoxesRunTime.boxToBoolean((boolean)ReferencedPermissionHistoryServiceImpl.$anonfun$filterGroupedHistoriesToMatchInterval$1(endTime, rp))) : this.filterCreateAndModifyInTimeInterval(list, startTime, endTime);
        return list2;
    }

    private <T extends HistoryEntity> List<T> filterCreateAndModifyInTimeInterval(List<T> multiGroupedHistories, LocalDateTime startTime, LocalDateTime endTime) {
        return multiGroupedHistories.filter((Function1 & Serializable)rp -> BoxesRunTime.boxToBoolean((boolean)ReferencedPermissionHistoryServiceImpl.$anonfun$filterCreateAndModifyInTimeInterval$1(startTime, endTime, rp)));
    }

    @Override
    public Page<ReferencedPermissionHistory> getReferenceHistoriesForReferenceAndPermission(UUID referenceId, String permission, LocalDateTime startTime, LocalDateTime endTime, Pageable pageable) {
        return this.referencedPermissionHistoryRepository.findReferencedPermissionHistories(permission, referenceId, startTime, endTime, pageable);
    }

    @Override
    public Page<ReferencedPermissionHistory> getReferenceHistoriesForRoleId(UUID roleId, Pageable pageable) {
        return this.referencedPermissionHistoryRepository.findAllReferencedPermissionHistoriesForRole(roleId, pageable);
    }

    @Override
    public Page<ReferencedPermissionHistory> getReferenceHistoriesForReferenceAndRoleId(UUID referenceId, UUID roleId, LocalDateTime startTime, LocalDateTime endTime, Pageable pageable) {
        return this.referencedPermissionHistoryRepository.findAllReferencedPermissionHistoriesForReferenceRoleBetween(roleId, referenceId, startTime, endTime, pageable);
    }

    @Override
    public Page<ReferencedPermissionHistory> getReferenceHistoriesForReferenceAndReferencedPermissionId(UUID referenceId, UUID referencedPermissionId, LocalDateTime startTime, LocalDateTime endTime, Pageable pageable) {
        return this.referencedPermissionHistoryRepository.findReferencedPermissionHistories(referencedPermissionId, referenceId, startTime, endTime, pageable);
    }

    public static final /* synthetic */ boolean $anonfun$filterGroupedHistoriesToMatchInterval$1(LocalDateTime endTime$4, HistoryEntity rp) {
        return rp.startTime().isBefore(endTime$4);
    }

    public static final /* synthetic */ boolean $anonfun$filterCreateAndModifyInTimeInterval$1(LocalDateTime startTime$2, LocalDateTime endTime$5, HistoryEntity rp) {
        return rp.revisionType() != Byte$.MODULE$.byte2int(Predef$.MODULE$.Byte2byte(RevisionType.DEL.getRepresentation())) && (rp.startTime().isAfter(startTime$2) && rp.startTime().isBefore(endTime$5) || rp.startTime().isBefore(startTime$2) && (rp.endTime() == null || rp.endTime().isAfter(endTime$5)) || rp.startTime().isBefore(endTime$5) && (rp.endTime() == null || rp.endTime().isAfter(startTime$2) && rp.endTime().isBefore(endTime$5)));
    }

    public ReferencedPermissionHistoryServiceImpl(ReferencedPermissionHistoryRepository referencedPermissionHistoryRepository, RolePrincipalHistoryRepository rolePrincipalHistoryRepository) {
        this.referencedPermissionHistoryRepository = referencedPermissionHistoryRepository;
        this.rolePrincipalHistoryRepository = rolePrincipalHistoryRepository;
    }
}

