/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xldeploy.authentication.oidc.conf;

import ai.digital.deploy.sql.model.LoginProvider;
import com.nimbusds.jose.Algorithm;
import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jose.jwk.Curve;
import com.nimbusds.jose.jwk.ECKey;
import com.nimbusds.jose.jwk.JWK;
import com.nimbusds.jose.jwk.KeyUse;
import com.nimbusds.jose.jwk.OctetSequenceKey;
import com.nimbusds.jose.jwk.RSAKey;
import com.xebialabs.deployit.ServerConfiguration;
import com.xebialabs.deployit.booter.local.utils.Strings;
import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.deployit.engine.spi.exception.DeployitException;
import com.xebialabs.platform.sso.oidc.authentication.CustomOidcIdTokenDecoderFactory;
import com.xebialabs.platform.sso.oidc.exceptions.UnsupportedOidcConfigurationException;
import com.xebialabs.platform.sso.oidc.policy.ClaimsToGrantedAuthoritiesPolicy;
import com.xebialabs.platform.sso.oidc.policy.impl.DefaultClaimsToGrantedAuthoritiesPolicy;
import com.xebialabs.platform.sso.oidc.policy.impl.GrantedAuthoritiesExtractor;
import com.xebialabs.platform.sso.oidc.service.XLOidcUserService;
import com.xebialabs.platform.sso.oidc.web.CustomAuthorizationRequestResolver;
import com.xebialabs.platform.sso.oidc.web.OidcLogoutSuccessHandler;
import com.xebialabs.xldeploy.authentication.oidc.conf.OidcConfig;
import com.xebialabs.xldeploy.authentication.oidc.conf.OpenIdConnectConfig$;
import com.xebialabs.xlplatform.config.ConfigLoader$;
import com.xebialabs.xlplatform.config.ConfigurationHolder$;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.Serializable;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.nio.charset.StandardCharsets;
import java.security.KeyPair;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.ECPublicKey;
import java.security.interfaces.RSAPublicKey;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.UUID;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import org.slf4j.Marker;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.convert.converter.Converter;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.SimpleClientHttpRequestFactory;
import org.springframework.http.converter.FormHttpMessageConverter;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.oauth2.client.InMemoryOAuth2AuthorizedClientService;
import org.springframework.security.oauth2.client.OAuth2AuthorizedClientService;
import org.springframework.security.oauth2.client.endpoint.DefaultAuthorizationCodeTokenResponseClient;
import org.springframework.security.oauth2.client.endpoint.NimbusJwtClientAuthenticationParametersConverter;
import org.springframework.security.oauth2.client.endpoint.OAuth2AuthorizationCodeGrantRequestEntityConverter;
import org.springframework.security.oauth2.client.http.OAuth2ErrorResponseErrorHandler;
import org.springframework.security.oauth2.client.registration.ClientRegistration;
import org.springframework.security.oauth2.client.registration.ClientRegistrationRepository;
import org.springframework.security.oauth2.client.registration.ClientRegistrations;
import org.springframework.security.oauth2.client.registration.InMemoryClientRegistrationRepository;
import org.springframework.security.oauth2.client.web.AuthenticatedPrincipalOAuth2AuthorizedClientRepository;
import org.springframework.security.oauth2.core.AuthorizationGrantType;
import org.springframework.security.oauth2.core.ClientAuthenticationMethod;
import org.springframework.security.oauth2.core.DelegatingOAuth2TokenValidator;
import org.springframework.security.oauth2.core.OAuth2TokenValidator;
import org.springframework.security.oauth2.core.http.converter.OAuth2AccessTokenResponseHttpMessageConverter;
import org.springframework.security.oauth2.jose.jws.JwsAlgorithm;
import org.springframework.security.oauth2.jose.jws.MacAlgorithm;
import org.springframework.security.oauth2.jose.jws.SignatureAlgorithm;
import org.springframework.security.oauth2.jwt.Jwt;
import org.springframework.security.oauth2.jwt.JwtClaimValidator;
import org.springframework.security.oauth2.jwt.JwtDecoder;
import org.springframework.security.oauth2.jwt.JwtDecoderFactory;
import org.springframework.security.oauth2.jwt.JwtIssuerValidator;
import org.springframework.security.oauth2.jwt.JwtTimestampValidator;
import org.springframework.security.oauth2.jwt.NimbusJwtDecoder;
import org.springframework.security.oauth2.server.resource.authentication.JwtAuthenticationConverter;
import org.springframework.security.web.authentication.AuthenticationFailureHandler;
import org.springframework.security.web.authentication.LoginUrlAuthenticationEntryPoint;
import org.springframework.security.web.authentication.SimpleUrlAuthenticationFailureHandler;
import org.springframework.web.client.ResponseErrorHandler;
import org.springframework.web.client.RestOperations;
import org.springframework.web.client.RestTemplate;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.mutable.ListBuffer;
import scala.jdk.CollectionConverters$;
import scala.jdk.FunctionConverters$;
import scala.jdk.FunctionWrappers;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.ScalaRunTime$;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Using;
import scala.util.Using$;

@ConditionalOnProperty(name={"deploy.server.security.auth.provider"}, havingValue="oidc")
@EnableWebSecurity
@Configuration
@ComponentScan(value={"com.xebialabs.xldeploy.auth.oidc.config"})
@ScalaSignature(bytes="\u0006\u0005\ruv!\u0002\u00180\u0011\u0003ad!\u0002 0\u0011\u0003y\u0004\"\u0002$\u0002\t\u00039\u0005b\u0002%\u0002\u0005\u0004%\t!\u0013\u0005\u0007Q\u0006\u0001\u000b\u0011\u0002&\t\u000f%\f!\u0019!C\u0001U\"1\u00010\u0001Q\u0001\n-Dq!_\u0001C\u0002\u0013\u0005!\u0010C\u0004\u0002\u0002\u0005\u0001\u000b\u0011B>\t\u0011\u0005\r\u0011A1A\u0005\u0002iDq!!\u0002\u0002A\u0003%1PB\u0003?_\u0001\t9\u0001\u0003\u0004G\u0017\u0011\u0005\u0011\u0011\u0004\u0005\b\u0003;YA\u0011AA\u0010\u0011\u001d\tId\u0003C\u0001\u0003wAq!a\u0017\f\t\u0003\tY\u0004C\u0004\u0002`-!\t!!\u0019\t\u000f\u0005U4\u0002\"\u0001\u0002x!9\u0011QS\u0006\u0005\u0002\u0005]\u0005bBAb\u0017\u0011\u0005\u0011Q\u0019\u0005\b\u0003+\\A\u0011AAl\u0011\u001d\t\u0019p\u0003C\u0001\u0003kDqA!\u0004\f\t\u0003\u0011y\u0001C\u0004\u0003&-!\tAa\n\t\u000f\tE2\u0002\"\u0001\u00034!9!\u0011J\u0006\u0005\u0002\t-\u0003\"\u0003B0\u0017\t\u0007I\u0011\u0001B1\u0011!\u0011yg\u0003Q\u0001\n\t\r\u0004b\u0002B9\u0017\u0011\u0005!1\u000f\u0005\b\u0005\u0007[A\u0011\u0001BC\u0011\u001d\u0011yi\u0003C\u0001\u0005#CqAa(\f\t\u0003\u0011\t\u000bC\u0004\u0003,.!IA!,\t\u000f\t=6\u0002\"\u0003\u00032\"9!\u0011Y\u0006\u0005\n\t\r\u0007b\u0002Bj\u0017\u0011%!Q\u001b\u0005\b\u0005?\\A\u0011\u0002Bq\u0011\u001d\u0011Io\u0003C\u0005\u0005WDqA!?\f\t\u0013\u0011Y\u0010C\u0004\u0004\n-!Iaa\u0003\t\u000f\re1\u0002\"\u0003\u0004\u001c!911E\u0006\u0005\n\r\u0015\u0002bBB\u0016\u0017\u0011%1Q\u0006\u0005\b\u0007cYA\u0011BB\u001a\u0011\u001d\u0019\u0019e\u0003C\u0005\u0007\u000bBqaa\u0017\f\t\u0013\u0019i&A\nPa\u0016t\u0017\nZ\"p]:,7\r^\"p]\u001aLwM\u0003\u00021c\u0005!1m\u001c8g\u0015\t\u00114'\u0001\u0003pS\u0012\u001c'B\u0001\u001b6\u00039\tW\u000f\u001e5f]RL7-\u0019;j_:T!AN\u001c\u0002\u0011adG-\u001a9m_fT!\u0001O\u001d\u0002\u0013a,'-[1mC\n\u001c(\"\u0001\u001e\u0002\u0007\r|Wn\u0001\u0001\u0011\u0005u\nQ\"A\u0018\u0003'=\u0003XM\\%e\u0007>tg.Z2u\u0007>tg-[4\u0014\u0005\u0005\u0001\u0005CA!E\u001b\u0005\u0011%\"A\"\u0002\u000bM\u001c\u0017\r\\1\n\u0005\u0015\u0013%AB!osJ+g-\u0001\u0004=S:LGO\u0010\u000b\u0002y\u0005)R*Q\"`\u00032;uJU%U\u00116{V*\u0011)Q\u0013:;U#\u0001&\u0011\t-\u0013V+\u001a\b\u0003\u0019B\u0003\"!\u0014\"\u000e\u00039S!aT\u001e\u0002\rq\u0012xn\u001c;?\u0013\t\t&)\u0001\u0004Qe\u0016$WMZ\u0005\u0003'R\u00131!T1q\u0015\t\t&\t\u0005\u0002WG6\tqK\u0003\u0002Y3\u0006\u0019!n^:\u000b\u0005i[\u0016\u0001\u00026pg\u0016T!\u0001X/\u0002\r=\fW\u000f\u001e53\u0015\tqv,\u0001\u0005tK\u000e,(/\u001b;z\u0015\t\u0001\u0017-A\btaJLgn\u001a4sC6,wo\u001c:l\u0015\u0005\u0011\u0017aA8sO&\u0011Am\u0016\u0002\r\u001b\u0006\u001c\u0017\t\\4pe&$\b.\u001c\t\u0003\u0017\u001aL!a\u001a+\u0003\rM#(/\u001b8h\u0003Yi\u0015iQ0B\u0019\u001e{%+\u0013+I\u001b~k\u0015\t\u0015)J\u001d\u001e\u0003\u0013aG#T\u0003~\u000bEjR(S\u0013RCUjX\"V%Z+u,T!Q!&su)F\u0001l!\u0011Y%\u000b\\8\u0011\u0005Yk\u0017B\u00018X\u00051Quo]!mO>\u0014\u0018\u000e\u001e5n!\t\u0001h/D\u0001r\u0015\t\u00118/A\u0002ko.T!A\u0017;\u000b\u0005UL\u0014\u0001\u00038j[\n,8\u000fZ:\n\u0005]\f(!B\"veZ,\u0017\u0001H#T\u0003~\u000bEjR(S\u0013RCUjX\"V%Z+u,T!Q!&su\tI\u0001\u0012\u000bN\u000bu,\u0011'H\u001fJKE\u000bS'`\u001b\u0006\u0003V#A>\u0011\t-\u0013F\u000e \t\u0003{zl\u0011a]\u0005\u0003\u007fN\u0014ABS,T\u00032<wN]5uQ6\f!#R*B?\u0006cui\u0014*J)\"ku,T!QA\u0005\t\"kU!`\u00032;uJU%U\u00116{V*\u0011)\u0002%I\u001b\u0016iX!M\u000f>\u0013\u0016\n\u0016%N?6\u000b\u0005\u000bI\n\u0005\u0017\u0001\u000bI\u0001\u0005\u0003\u0002\f\u0005UQBAA\u0007\u0015\u0011\ty!!\u0005\u0002\u000bMdg\r\u000e6\u000b\u0005\u0005M\u0011\u0001C4sSjTH.\u001a3\n\t\u0005]\u0011Q\u0002\u0002\b\u0019><w-\u001b8h)\t\tY\u0002\u0005\u0002>\u0017\u0005Qq.\u001b3d\u0007>tg-[4\u0016\u0005\u0005\u0005\u0002cA\u001f\u0002$%\u0019\u0011QE\u0018\u0003\u0015=KGmY\"p]\u001aLw\rK\u0002\u000e\u0003S\u0001B!a\u000b\u000265\u0011\u0011Q\u0006\u0006\u0005\u0003_\t\t$\u0001\u0006b]:|G/\u0019;j_:T1!a\r`\u0003\u001d\u0019wN\u001c;fqRLA!a\u000e\u0002.\t!!)Z1o\u0003Ey\u0017\u000eZ2M_\u001eLg\u000e\u0015:pm&$WM]\u000b\u0003\u0003{\u0001B!a\u0010\u0002V5\u0011\u0011\u0011\t\u0006\u0005\u0003\u0007\n)%A\u0003n_\u0012,GN\u0003\u0003\u0002H\u0005%\u0013aA:rY*!\u00111JA'\u0003\u0019!W\r\u001d7ps*!\u0011qJA)\u0003\u001d!\u0017nZ5uC2T!!a\u0015\u0002\u0005\u0005L\u0017\u0002BA,\u0003\u0003\u0012Q\u0002T8hS:\u0004&o\u001c<jI\u0016\u0014\bf\u0001\b\u0002*\u0005\u0011Bn\\2bY2{w-\u001b8Qe>4\u0018\u000eZ3sQ\ry\u0011\u0011F\u0001\u001dG2LWM\u001c;SK\u001eL7\u000f\u001e:bi&|gNU3q_NLGo\u001c:z+\t\t\u0019\u0007\u0005\u0003\u0002f\u0005=TBAA4\u0015\u0011\tI'a\u001b\u0002\u0019I,w-[:ue\u0006$\u0018n\u001c8\u000b\u0007\u000554,\u0001\u0004dY&,g\u000e^\u0005\u0005\u0003c\n9G\u0001\u0013J]6+Wn\u001c:z\u00072LWM\u001c;SK\u001eL7\u000f\u001e:bi&|gNU3q_NLGo\u001c:zQ\r\u0001\u0012\u0011F\u0001!G2\f\u0017.\\:U_\u001e\u0013\u0018M\u001c;fI\u0006+H\u000f[8sSRLWm\u001d)pY&\u001c\u00170\u0006\u0002\u0002zA!\u00111PAH\u001b\t\tiH\u0003\u0003\u0002\u0000\u0005\u0005\u0015\u0001B5na2TA!a!\u0002\u0006\u00061\u0001o\u001c7jGfT1AMAD\u0015\u0011\tI)a#\u0002\u0007M\u001cxNC\u0002\u0002\u000e^\n\u0001\u0002\u001d7bi\u001a|'/\\\u0005\u0005\u0003#\u000biHA\u0014EK\u001a\fW\u000f\u001c;DY\u0006LWn\u001d+p\u000fJ\fg\u000e^3e\u0003V$\bn\u001c:ji&,7\u000fU8mS\u000eL\bfA\t\u0002*\u0005\u00113-^:u_6\fU\u000f\u001e5pe&T\u0018\r^5p]J+\u0017/^3tiJ+7o\u001c7wKJ$B!!'\u0002&B!\u00111TAQ\u001b\t\tiJ\u0003\u0003\u0002 \u0006\u0015\u0015aA<fE&!\u00111UAO\u0005\t\u001aUo\u001d;p[\u0006+H\u000f[8sSj\fG/[8o%\u0016\fX/Z:u%\u0016\u001cx\u000e\u001c<fe\"9\u0011q\f\nA\u0002\u0005\u001d\u0006\u0003BA3\u0003SKA!a+\u0002h\ta2\t\\5f]R\u0014VmZ5tiJ\fG/[8o%\u0016\u0004xn]5u_JL\bf\u0001\n\u00020B!\u0011\u0011WA_\u001b\t\t\u0019L\u0003\u0003\u00020\u0005U&\u0002BA\\\u0003s\u000bqAZ1di>\u0014\u0018PC\u0002\u0002<~\u000bQAY3b]NLA!a0\u00024\nI\u0011)\u001e;po&\u0014X\r\u001a\u0015\u0004%\u0005%\u0012aF1vi\"|'/\u001b>fI\u000ec\u0017.\u001a8u'\u0016\u0014h/[2f)\u0011\t9-a4\u0011\t\u0005%\u00171Z\u0007\u0003\u0003WJA!!4\u0002l\t)\u0013J\\'f[>\u0014\u0018pT!vi\"\u0014\u0014)\u001e;i_JL'0\u001a3DY&,g\u000e^*feZL7-\u001a\u0005\b\u0003?\u001a\u0002\u0019AATQ\r\u0019\u0012q\u0016\u0015\u0004'\u0005%\u0012!\u0005=m\u001f&$7-V:feN+'O^5dKR!\u0011\u0011\\As!\u0011\tY.!9\u000e\u0005\u0005u'\u0002BAp\u0003\u000b\u000bqa]3sm&\u001cW-\u0003\u0003\u0002d\u0006u'!\u0005-M\u001f&$7-V:feN+'O^5dK\"9\u0011Q\u000f\u000bA\u0002\u0005\u001d\b\u0003BAu\u0003Wl!!!!\n\t\u00055\u0018\u0011\u0011\u0002!\u00072\f\u0017.\\:U_\u001e\u0013\u0018M\u001c;fI\u0006+H\u000f[8sSRLWm\u001d)pY&\u001c\u0017\u0010K\u0002\u0015\u0003_C3\u0001FA\u0015\u0003i\tW\u000f\u001e5pe&TX\rZ\"mS\u0016tGOU3q_NLGo\u001c:z)\u0011\t9P!\u0001\u0011\t\u0005e\u0018Q`\u0007\u0003\u0003wTA!a(\u0002l%!\u0011q`A~\u0005Y\nU\u000f\u001e5f]RL7-\u0019;fIB\u0013\u0018N\\2ja\u0006dw*Q;uQJ\nU\u000f\u001e5pe&TX\rZ\"mS\u0016tGOU3q_NLGo\u001c:z\u0011\u001d\t\u0019-\u0006a\u0001\u0005\u0007\u0001B!!3\u0003\u0006%!!qAA6\u0005uy\u0015)\u001e;ie\u0005+H\u000f[8sSj,Gm\u00117jK:$8+\u001a:wS\u000e,\u0007fA\u000b\u00020\"\u001aQ#!\u000b\u0002+%$Gk\\6f]\u0012+7m\u001c3fe\u001a\u000b7\r^8ssV\u0011!\u0011\u0003\t\u0007\u0005'\u0011IB!\b\u000e\u0005\tU!b\u0001B\f7\u0006\u0019!n\u001e;\n\t\tm!Q\u0003\u0002\u0012\u0015^$H)Z2pI\u0016\u0014h)Y2u_JL\b\u0003BA3\u0005?IAA!\t\u0002h\t\u00112\t\\5f]R\u0014VmZ5tiJ\fG/[8oQ\r1\u0012\u0011F\u0001\u000bU^$H)Z2pI\u0016\u0014XC\u0001B\u0015!\u0011\u0011\u0019Ba\u000b\n\t\t5\"Q\u0003\u0002\u000b\u0015^$H)Z2pI\u0016\u0014\bfA\f\u0002*\u0005Q\"n\u001e;BkRDWM\u001c;jG\u0006$\u0018n\u001c8D_:4XM\u001d;feV\u0011!Q\u0007\t\u0005\u0005o\u0011\u0019%\u0004\u0002\u0003:)\u0019AGa\u000f\u000b\t\tu\"qH\u0001\te\u0016\u001cx.\u001e:dK*\u0019!\u0011I.\u0002\rM,'O^3s\u0013\u0011\u0011)E!\u000f\u00035);H/Q;uQ\u0016tG/[2bi&|gnQ8om\u0016\u0014H/\u001a:)\u0007a\tI#\u0001\u0013bkRDwN]5{CRLwN\\\"pI\u0016$vn[3o%\u0016\u001c\bo\u001c8tK\u000ec\u0017.\u001a8u)\u0011\u0011iE!\u0017\u0011\t\t=#QK\u0007\u0003\u0005#RAAa\u0015\u0002l\u0005AQM\u001c3q_&tG/\u0003\u0003\u0003X\tE#a\u000b#fM\u0006,H\u000e^!vi\"|'/\u001b>bi&|gnQ8eKR{7.\u001a8SKN\u0004xN\\:f\u00072LWM\u001c;\t\u000f\u0005}\u0013\u00041\u0001\u0002(\"\u001a\u0011$a,)\u0007e\tI#A\u0006ko.\u0014Vm]8mm\u0016\u0014XC\u0001B2!\u001d\t%Q\rB\u000f\u0005SJ1Aa\u001aC\u0005%1UO\\2uS>t\u0017\u0007E\u0002q\u0005WJ1A!\u001cr\u0005\rQukS\u0001\rU^\\'+Z:pYZ,'\u000fI\u0001\u0018_&$7\rT8hS:4\u0015-\u001b7ve\u0016D\u0015M\u001c3mKJ,\"A!\u001e\u0011\t\t]$QP\u0007\u0003\u0005sR1\u0001\u000eB>\u0015\r\ty*X\u0005\u0005\u0005\u007f\u0012IH\u0001\u000fBkRDWM\u001c;jG\u0006$\u0018n\u001c8GC&dWO]3IC:$G.\u001a:)\u0007q\tI#\u0001\fyY\u0012dunZ5o\r\u0006LG.\u001e:f\u0011\u0006tG\r\\3s+\t\u00119\t\u0005\u0003\u0003x\t%\u0015\u0002\u0002BF\u0005s\u0012QeU5na2,WK\u001d7BkRDWM\u001c;jG\u0006$\u0018n\u001c8GC&dWO]3IC:$G.\u001a:)\u0007u\tI#\u0001\u000epa\u0016t\u0017\n\u001a'pO>,HoU;dG\u0016\u001c8\u000fS1oI2,'\u000f\u0006\u0003\u0003\u0014\ne\u0005\u0003BAN\u0005+KAAa&\u0002\u001e\nAr*\u001b3d\u0019><w.\u001e;Tk\u000e\u001cWm]:IC:$G.\u001a:\t\u000f\u0005}c\u00041\u0001\u0002(\"\u001aa$a,)\u0007y\tI#\u0001\u0011m_\u001eLg.\u0016:m\u0003V$\b.\u001a8uS\u000e\fG/[8o\u000b:$(/\u001f)pS:$XC\u0001BR!\u0011\u00119H!*\n\t\t\u001d&\u0011\u0010\u0002!\u0019><\u0017N\\+sY\u0006+H\u000f[3oi&\u001c\u0017\r^5p]\u0016sGO]=Q_&tG\u000fK\u0002 \u0003S\t!c\u00197jK:$(+Z4jgR\u0014\u0018\r^5p]V\u0011!QD\u0001\u001dO\u0016$8\t\\5f]R\u0014VmZ5tiJ\fG/[8o\u0005VLG\u000eZ3s+\t\u0011\u0019\f\u0005\u0003\u00036\nmf\u0002BA3\u0005oKAA!/\u0002h\u0005\u00112\t\\5f]R\u0014VmZ5tiJ\fG/[8o\u0013\u0011\u0011iLa0\u0003\u000f\t+\u0018\u000e\u001c3fe*!!\u0011XA4\u0003a\u0019G.[3oi\"#H\u000f\u001d*fcV,7\u000f\u001e$bGR|'/_\u000b\u0003\u0005\u000b\u0004BAa2\u0003P6\u0011!\u0011\u001a\u0006\u0005\u0003[\u0012YMC\u0002\u0003N~\u000bA\u0001\u001b;ua&!!\u0011\u001bBe\u0005a\u0019E.[3oi\"#H\u000f\u001d*fcV,7\u000f\u001e$bGR|'/_\u0001\u0010O\u0016$(j^:BY\u001e|'/\u001b;i[R)ANa6\u0003\\\"1!\u0011\\\u0012A\u0002\u0015\fAB[<t\u00032<wN]5uQ6DaA!8$\u0001\u0004)\u0017\u0001\u00049s_B,'\u000f^=OC6,\u0017aD4fi6\u000b7-\u00117h_JLG\u000f[7\u0015\u000bU\u0013\u0019Oa:\t\r\t\u0015H\u00051\u0001f\u00031i\u0017mY!mO>\u0014\u0018\u000e\u001e5n\u0011\u0019\u0011i\u000e\na\u0001K\u0006)r-\u001a;TS\u001et\u0017\r^;sK\u0006cwm\u001c:ji\"lGC\u0002Bw\u0005g\u00149\u0010E\u0002W\u0005_L1A!=X\u0005I\u0019\u0016n\u001a8biV\u0014X-\u00117h_JLG\u000f[7\t\r\tUX\u00051\u0001f\u0003I\u0019\u0018n\u001a8biV\u0014X-\u00117h_JLG\u000f[7\t\r\tuW\u00051\u0001f\u0003M9W\r^\"mS\u0016tG/Q;uQ6+G\u000f[8e+\t\u0011i\u0010\u0005\u0003\u0003\u0000\u000e\u0015QBAB\u0001\u0015\r\u0019\u0019aW\u0001\u0005G>\u0014X-\u0003\u0003\u0004\b\r\u0005!AG\"mS\u0016tG/Q;uQ\u0016tG/[2bi&|g.T3uQ>$\u0017AG4fi*;HoT!vi\"\u0014Dk\\6f]Z\u000bG.\u001b3bi>\u0014XCAB\u0007!\u0019\u0011ypa\u0004\u0004\u0014%!1\u0011CB\u0001\u0005Qy\u0015)\u001e;ieQ{7.\u001a8WC2LG-\u0019;peB!!1CB\u000b\u0013\u0011\u00199B!\u0006\u0003\u0007);H/A\rwC2LG-\u0019;f\u001f&$7mQ8oM&<WO]1uS>tGCAB\u000f!\r\t5qD\u0005\u0004\u0007C\u0011%\u0001B+oSR\fQdZ3u\u000bJ\u0014xN]'fgN\fw-\u001a$peBc\u0017mY3i_2$WM\u001d\u000b\u0004K\u000e\u001d\u0002BBB\u0015S\u0001\u0007Q-A\u0006qY\u0006\u001cW\r[8mI\u0016\u0014\u0018AB:fi*;8\u000e\u0006\u0003\u0004\u001e\r=\u0002b\u0002BVU\u0001\u0007!QD\u0001\u000bO\u0016$8*Z=QC&\u0014XCAB\u001b!\u0011\u00199da\u0010\u000e\u0005\re\"b\u00010\u0004<)\u00111QH\u0001\u0005U\u00064\u0018-\u0003\u0003\u0004B\re\"aB&fsB\u000b\u0017N]\u0001\nO\u0016$(kU!LKf$baa\u0012\u0004N\rE\u0003c\u00019\u0004J%\u001911J9\u0003\rI\u001b\u0016iS3z\u0011\u001d\u0019y\u0005\fa\u0001\u0007k\tqa[3z!\u0006L'\u000fC\u0004\u0004T1\u0002\ra!\u0016\u0002\u0013\u0005dwm\u001c:ji\"l\u0007cA?\u0004X%\u00191\u0011L:\u0003\u0013\u0005cwm\u001c:ji\"l\u0017!C4fi\u0016\u001b\u0016iS3z)!\u0019yf!\u001a\u0004h\r%\u0004c\u00019\u0004b%\u001911M9\u0003\u000b\u0015\u001b5*Z=\t\u000f\r=S\u00061\u0001\u00046!911K\u0017A\u0002\rU\u0003BBB6[\u0001\u0007q.A\u0003dkJ4X\rK\u0004\f\u0007_\u001a)ha\u001e\u0011\t\u0005-2\u0011O\u0005\u0005\u0007g\niCA\u0007D_6\u0004xN\\3oiN\u001b\u0017M\\\u0001\u0006m\u0006dW/\u001a\u0017\u0003\u0007s\n#aa\u001f\u0002O\r|WN\f=fE&\fG.\u00192t]adG-\u001a9m_ft\u0013-\u001e;i]=LGm\u0019\u0018d_:4\u0017n\u001a\u0015\u0004\u0017\r}\u0004\u0003BA\u0016\u0007\u0003KAaa!\u0002.\ti1i\u001c8gS\u001e,(/\u0019;j_:D3aCBD!\u0011\u0019Iia&\u000e\u0005\r-%\u0002BBG\u0007\u001f\u000bQbY8oM&<WO]1uS>t'\u0002BAP\u0007#SA!a\f\u0004\u0014*\u00191QS/\u0002\r\r|gNZ5h\u0013\u0011\u0019Ija#\u0003#\u0015s\u0017M\u00197f/\u0016\u00147+Z2ve&$\u0018\u0010K\u0006\f\u0007;\u001b\tla-\u0004:\u000em\u0006\u0003BBP\u0007[k!a!)\u000b\t\r\r6QU\u0001\nG>tG-\u001b;j_:TAaa*\u0004*\u0006i\u0011-\u001e;pG>tg-[4ve\u0016T1aa+`\u0003\u0011\u0011wn\u001c;\n\t\r=6\u0011\u0015\u0002\u0016\u0007>tG-\u001b;j_:\fGn\u00148Qe>\u0004XM\u001d;z\u0003\u0011q\u0017-\\3-\u0005\rU\u0016EAB\\\u0003\u0011\"W\r\u001d7ps:\u001aXM\u001d<fe:\u001aXmY;sSRLh&Y;uQ:\u0002(o\u001c<jI\u0016\u0014\u0018a\u00035bm&twMV1mk\u0016\f\u0013A\r")
public class OpenIdConnectConfig
implements Logging {
    private final Function1<ClientRegistration, JWK> jwkResolver;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;

    public static Map<JwsAlgorithm, JWSAlgorithm> RSA_ALGORITHM_MAP() {
        return OpenIdConnectConfig$.MODULE$.RSA_ALGORITHM_MAP();
    }

    public static Map<JwsAlgorithm, JWSAlgorithm> ESA_ALGORITHM_MAP() {
        return OpenIdConnectConfig$.MODULE$.ESA_ALGORITHM_MAP();
    }

    public static Map<JwsAlgorithm, Curve> ESA_ALGORITHM_CURVE_MAPPING() {
        return OpenIdConnectConfig$.MODULE$.ESA_ALGORITHM_CURVE_MAPPING();
    }

    public static Map<MacAlgorithm, String> MAC_ALGORITHM_MAPPING() {
        return OpenIdConnectConfig$.MODULE$.MAC_ALGORITHM_MAPPING();
    }

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        OpenIdConnectConfig openIdConnectConfig = this;
        synchronized (openIdConnectConfig) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        return !this.bitmap$trans$0 ? this.grizzled$slf4j$Logging$$_logger$lzycompute() : this.grizzled$slf4j$Logging$$_logger;
    }

    @Bean
    public OidcConfig oidcConfig() {
        return new OidcConfig(ConfigLoader$.MODULE$.loadWithDynamic(ConfigurationHolder$.MODULE$.get(), ConfigLoader$.MODULE$.loadWithDynamic$default$2()), ServerConfiguration.getInstance());
    }

    @Bean
    public LoginProvider oidcLoginProvider() {
        return new LoginProvider(this.oidcConfig().loginMethodDescription(), new StringBuilder(1).append(".").append(this.oidcConfig().external_login()).toString(), "./logout", false);
    }

    @Bean
    public LoginProvider localLoginProvider() {
        return new LoginProvider("XL Deploy local login", "./login", "./logout", true);
    }

    @Bean
    public InMemoryClientRegistrationRepository clientRegistrationRepository() {
        return new InMemoryClientRegistrationRepository(new ClientRegistration[]{this.clientRegistration()});
    }

    @Bean
    public DefaultClaimsToGrantedAuthoritiesPolicy claimsToGrantedAuthoritiesPolicy() {
        return new DefaultClaimsToGrantedAuthoritiesPolicy(this.oidcConfig().rolesClaimName());
    }

    @Bean
    @Autowired
    public CustomAuthorizationRequestResolver customAuthorizationRequestResolver(ClientRegistrationRepository clientRegistrationRepository) {
        return new CustomAuthorizationRequestResolver(clientRegistrationRepository, "/oauth2/authorization", this.oidcConfig().additionalParameters());
    }

    @Bean
    @Autowired
    public InMemoryOAuth2AuthorizedClientService authorizedClientService(ClientRegistrationRepository clientRegistrationRepository) {
        return new InMemoryOAuth2AuthorizedClientService(clientRegistrationRepository);
    }

    @Bean
    @Autowired
    public XLOidcUserService xlOidcUserService(ClaimsToGrantedAuthoritiesPolicy claimsToGrantedAuthoritiesPolicy) {
        return new XLOidcUserService(claimsToGrantedAuthoritiesPolicy);
    }

    @Bean
    @Autowired
    public AuthenticatedPrincipalOAuth2AuthorizedClientRepository authorizedClientRepository(OAuth2AuthorizedClientService authorizedClientService) {
        return new AuthenticatedPrincipalOAuth2AuthorizedClientRepository(authorizedClientService);
    }

    /*
     * WARNING - void declaration
     */
    @Bean
    public JwtDecoderFactory<ClientRegistration> idTokenDecoderFactory() {
        void var3_3;
        RestTemplate restTemplate = new RestTemplate();
        restTemplate.setRequestFactory(this.clientHttpRequestFactory());
        JwsAlgorithm jwsAlgorithm = this.getJwsAlgorithm(this.oidcConfig().idTokenJWSAlg(), "deploy.security.auth.providers.oidc.idTokenJWSAlg");
        CustomOidcIdTokenDecoderFactory idTokenDecoderFactory = new CustomOidcIdTokenDecoderFactory();
        idTokenDecoderFactory.setJwsAlgorithmResolver(x$1 -> jwsAlgorithm);
        idTokenDecoderFactory.setRestOperations((RestOperations)restTemplate);
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    @Bean
    public JwtDecoder jwtDecoder() {
        void var3_8;
        NimbusJwtDecoder nimbusJwtDecoder;
        JwsAlgorithm jwsAlgorithm = this.getJwsAlgorithm(this.oidcConfig().accessTokenJWSAlg(), "deploy.security.auth.providers.oidc.access-token.jwsAlg");
        JwsAlgorithm jwsAlgorithm2 = jwsAlgorithm;
        if (jwsAlgorithm2 instanceof SignatureAlgorithm) {
            SignatureAlgorithm signatureAlgorithm = (SignatureAlgorithm)jwsAlgorithm2;
            String jwkSetUri = Strings.isNotBlank((String)this.oidcConfig().accessTokenKeyUri()) ? this.oidcConfig().accessTokenKeyUri() : this.clientRegistration().getProviderDetails().getJwkSetUri();
            nimbusJwtDecoder = NimbusJwtDecoder.withJwkSetUri((String)jwkSetUri).jwsAlgorithm(signatureAlgorithm).build();
        } else if (jwsAlgorithm2 instanceof MacAlgorithm) {
            MacAlgorithm macAlgorithm = (MacAlgorithm)jwsAlgorithm2;
            Checks.checkArgument((boolean)Strings.isNotBlank((String)this.oidcConfig().accessTokenSecretKey()), (String)"No configuration setting found for key 'deploy.security.auth.providers.oidc.access-token.secretKey'", (Object[])new Object[0]);
            SecretKeySpec secretKeySpec = new SecretKeySpec(this.oidcConfig().accessTokenSecretKey().getBytes(StandardCharsets.UTF_8), (String)OpenIdConnectConfig$.MODULE$.MAC_ALGORITHM_MAPPING().getOrElse((Object)macAlgorithm, (Function0 & Serializable)() -> {
                throw new IllegalArgumentException(new StringBuilder(71).append("'").append(macAlgorithm.getName()).append("' is not supported. Ensure you have configured a valid HMAC Algorithm.").toString());
            }));
            nimbusJwtDecoder = NimbusJwtDecoder.withSecretKey((SecretKey)secretKeySpec).macAlgorithm(macAlgorithm).build();
        } else {
            throw new UnsupportedOidcConfigurationException("Failed to find a Signature Verifier. Ensure you have configured a valid JWS Algorithm.");
        }
        NimbusJwtDecoder jwtDecoder = nimbusJwtDecoder;
        jwtDecoder.setJwtValidator(this.getJwtOAuth2TokenValidator());
        return var3_8;
    }

    /*
     * WARNING - void declaration
     */
    @Bean
    public JwtAuthenticationConverter jwtAuthenticationConverter() {
        void var1_1;
        JwtAuthenticationConverter jwtAuthenticationConverter = new JwtAuthenticationConverter();
        jwtAuthenticationConverter.setPrincipalClaimName(this.oidcConfig().userNameClaimName());
        jwtAuthenticationConverter.setJwtGrantedAuthoritiesConverter((Converter)new GrantedAuthoritiesExtractor((ClaimsToGrantedAuthoritiesPolicy)this.claimsToGrantedAuthoritiesPolicy()));
        return var1_1;
    }

    @Bean
    @Autowired
    public DefaultAuthorizationCodeTokenResponseClient authorizationCodeTokenResponseClient(ClientRegistrationRepository clientRegistrationRepository) {
        DefaultAuthorizationCodeTokenResponseClient authorizationCodeTokenResponseClient;
        block1: {
            ClientRegistration clientRegistration;
            block0: {
                ListBuffer messageConverter = new ListBuffer();
                messageConverter.$plus$eq((Object)new FormHttpMessageConverter());
                messageConverter.$plus$eq((Object)new OAuth2AccessTokenResponseHttpMessageConverter());
                RestTemplate restTemplate = new RestTemplate(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)messageConverter.toList()).asJava());
                restTemplate.setRequestFactory(this.clientHttpRequestFactory());
                restTemplate.setErrorHandler((ResponseErrorHandler)new OAuth2ErrorResponseErrorHandler());
                authorizationCodeTokenResponseClient = new DefaultAuthorizationCodeTokenResponseClient();
                authorizationCodeTokenResponseClient.setRestOperations((RestOperations)restTemplate);
                clientRegistration = clientRegistrationRepository.findByRegistrationId(this.oidcConfig().registrationId());
                ClientAuthenticationMethod clientAuthenticationMethod = clientRegistration.getClientAuthenticationMethod();
                ClientAuthenticationMethod clientAuthenticationMethod2 = ClientAuthenticationMethod.CLIENT_SECRET_JWT;
                if (!(clientAuthenticationMethod == null ? clientAuthenticationMethod2 != null : !clientAuthenticationMethod.equals(clientAuthenticationMethod2))) break block0;
                ClientAuthenticationMethod clientAuthenticationMethod3 = clientRegistration.getClientAuthenticationMethod();
                ClientAuthenticationMethod clientAuthenticationMethod4 = ClientAuthenticationMethod.PRIVATE_KEY_JWT;
                if (clientAuthenticationMethod3 != null ? !clientAuthenticationMethod3.equals(clientAuthenticationMethod4) : clientAuthenticationMethod4 != null) break block1;
            }
            this.setJwk(clientRegistration);
            OAuth2AuthorizationCodeGrantRequestEntityConverter requestEntityConverter = new OAuth2AuthorizationCodeGrantRequestEntityConverter();
            requestEntityConverter.addParametersConverter((Converter)new NimbusJwtClientAuthenticationParametersConverter(FunctionWrappers.RichFunction1AsFunction$.MODULE$.asJavaFunction$extension(FunctionConverters$.MODULE$.enrichAsJavaFunction(this.jwkResolver()))));
            authorizationCodeTokenResponseClient.setRequestEntityConverter((Converter)requestEntityConverter);
        }
        return authorizationCodeTokenResponseClient;
    }

    public Function1<ClientRegistration, JWK> jwkResolver() {
        return this.jwkResolver;
    }

    @Bean
    public AuthenticationFailureHandler oidcLoginFailureHandler() {
        return (x$2, response, x$3) -> response.sendRedirect(this.oidcConfig().external_login());
    }

    @Bean
    public SimpleUrlAuthenticationFailureHandler xldLoginFailureHandler() {
        return new SimpleUrlAuthenticationFailureHandler();
    }

    @Bean
    @Autowired
    public OidcLogoutSuccessHandler openIdLogoutSuccessHandler(ClientRegistrationRepository clientRegistrationRepository) {
        return new OidcLogoutSuccessHandler(clientRegistrationRepository, this.oidcConfig().postLogoutRedirectUri(), "/login");
    }

    @Bean
    public LoginUrlAuthenticationEntryPoint loginUrlAuthenticationEntryPoint() {
        return new LoginUrlAuthenticationEntryPoint(this.oidcConfig().external_login());
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private ClientRegistration clientRegistration() {
        clientRegistrationBuilder = this.getClientRegistrationBuilder();
        authenticationMethod = this.getClientAuthMethod();
        clientRegistrationBuilder.clientId(this.oidcConfig().clientId()).clientAuthenticationMethod(authenticationMethod).authorizationGrantType(AuthorizationGrantType.AUTHORIZATION_CODE).redirectUri(this.oidcConfig().redirectUri()).userInfoUri("").scope(this.oidcConfig().scopes()).userNameAttributeName(this.oidcConfig().userNameClaimName());
        v0 = authenticationMethod;
        var3_3 = ClientAuthenticationMethod.NONE;
        if (!(v0 == null ? var3_3 != null : v0.equals(var3_3) == false)) ** GOTO lbl-1000
        v1 = authenticationMethod;
        var4_4 = ClientAuthenticationMethod.PRIVATE_KEY_JWT;
        if (v1 == null ? var4_4 != null : v1.equals(var4_4) == false) {
            Checks.checkArgument((boolean)Strings.isNotBlank((String)this.oidcConfig().clientSecret()), (String)this.getErrorMessageForPlaceholder("deploy.security.auth.providers.oidc.clientSecret"), (Object[])new Object[0]);
            v2 = clientRegistrationBuilder.clientSecret(this.oidcConfig().clientSecret());
        } else lbl-1000:
        // 2 sources

        {
            v2 = BoxedUnit.UNIT;
        }
        v3 = authenticationMethod;
        var5_5 = ClientAuthenticationMethod.PRIVATE_KEY_JWT;
        if (!(v3 != null ? v3.equals(var5_5) == false : var5_5 != null)) {
            if (Strings.isBlank((String)this.oidcConfig().keyStorePath())) {
                this.oidcConfig().keyStorePath_$eq(this.oidcConfig().defaultKeyStorePath());
                this.oidcConfig().keyStorePassword_$eq(this.oidcConfig().defaultKeyStorePassword());
            }
            Checks.checkArgument((boolean)Strings.isNotBlank((String)this.oidcConfig().keyStorePath()), (String)this.getErrorMessageForPlaceholder("deploy.security.auth.providers.oidc.clientAuthJwt.keyStore.path"), (Object[])new Object[0]);
            Checks.checkArgument((boolean)Strings.isNotBlank((String)this.oidcConfig().keyAlias()), (String)this.getErrorMessageForPlaceholder("deploy.security.auth.providers.oidc.clientAuthJwt.key.alias"), (Object[])new Object[0]);
        }
        v4 /* !! */  = Strings.isNotBlank((String)this.oidcConfig().userAuthorizationUri()) != false ? clientRegistrationBuilder.authorizationUri(this.oidcConfig().userAuthorizationUri()) : BoxedUnit.UNIT;
        v5 /* !! */  = Strings.isNotBlank((String)this.oidcConfig().accessTokenUri()) != false ? clientRegistrationBuilder.tokenUri(this.oidcConfig().accessTokenUri()) : BoxedUnit.UNIT;
        v6 /* !! */  = Strings.isNotBlank((String)this.oidcConfig().jwks_uri()) != false ? clientRegistrationBuilder.jwkSetUri(this.oidcConfig().jwks_uri()) : BoxedUnit.UNIT;
        clientRegistration = clientRegistrationBuilder.build();
        configurationMetadata = clientRegistration.getProviderDetails().getConfigurationMetadata();
        updatedConfigurationMetadata = new HashMap<String, String>(configurationMetadata);
        updatedConfigurationMetadata.put("rolesClaim", this.oidcConfig().rolesClaimName());
        v7 /* !! */  = Strings.isNotBlank((String)this.oidcConfig().logoutUri()) != false ? updatedConfigurationMetadata.put("end_session_endpoint", this.oidcConfig().logoutUri()) : BoxedUnit.UNIT;
        return ClientRegistration.withClientRegistration((ClientRegistration)clientRegistration).providerConfigurationMetadata(updatedConfigurationMetadata).build();
    }

    private ClientRegistration.Builder getClientRegistrationBuilder() {
        ClientRegistration.Builder builder;
        try {
            if (!this.oidcConfig().issuer().matches("\\S+")) {
                throw new UnsupportedOidcConfigurationException(new StringBuilder(148).append("Whitespace characters in issuer url [").append(this.oidcConfig().issuer()).append("] is not supported. Recommendation is to avoid using spaces in URLs, and instead use hyphens to separate words.").toString());
            }
            builder = ClientRegistrations.fromOidcIssuerLocation((String)this.oidcConfig().issuer()).registrationId(this.oidcConfig().registrationId());
        }
        catch (RuntimeException re) {
            RuntimeException runtimeException = re;
            if (runtimeException instanceof IllegalArgumentException) {
                this.logger().warn((Function0 & Serializable)() -> new StringBuilder(62).append("Unable to resolve Configuration with the provided Issuer of [").append(this.oidcConfig().issuer()).append("]").toString());
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (runtimeException instanceof UnsupportedOidcConfigurationException) {
                this.logger().warn((Function0 & Serializable)() -> re.getMessage());
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                throw new MatchError((Object)runtimeException);
            }
            this.validateOidcConfiguration();
            builder = ClientRegistration.withRegistrationId((String)this.oidcConfig().registrationId());
        }
        return builder;
    }

    /*
     * WARNING - void declaration
     */
    private ClientHttpRequestFactory clientHttpRequestFactory() {
        void var1_1;
        block0: {
            SimpleClientHttpRequestFactory requestFactory = new SimpleClientHttpRequestFactory();
            if (!Strings.isNotBlank((String)this.oidcConfig().proxyHost())) break block0;
            requestFactory.setProxy(new Proxy(Proxy.Type.HTTP, new InetSocketAddress(this.oidcConfig().proxyHost(), Predef$.MODULE$.Integer2int(this.oidcConfig().proxyPort()))));
        }
        return var1_1;
    }

    private JwsAlgorithm getJwsAlgorithm(String jwsAlgorithm, String propertyName) {
        Map jwsAlgorithms = (Map)Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])SignatureAlgorithm.values()), (Function1 & Serializable)v -> new Tuple2((Object)v.getName(), v), ClassTag$.MODULE$.apply(Tuple2.class))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()).$plus$plus((IterableOnce)Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])MacAlgorithm.values()), (Function1 & Serializable)v -> new Tuple2((Object)v.getName(), v), ClassTag$.MODULE$.apply(Tuple2.class))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()));
        return (JwsAlgorithm)jwsAlgorithms.getOrElse((Object)jwsAlgorithm, (Function0 & Serializable)() -> {
            throw new IllegalArgumentException(new StringBuilder(77).append(propertyName).append(" value [").append(jwsAlgorithm).append("] is not supported. Ensure you have configured a valid JWS Algorithm.").toString());
        });
    }

    private MacAlgorithm getMacAlgorithm(String macAlgorithm, String propertyName) {
        Map macAlgorithms = Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])MacAlgorithm.values()), (Function1 & Serializable)v -> new Tuple2((Object)v.getName(), v), ClassTag$.MODULE$.apply(Tuple2.class))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        return (MacAlgorithm)macAlgorithms.getOrElse((Object)macAlgorithm, (Function0 & Serializable)() -> {
            throw new IllegalArgumentException(new StringBuilder(78).append(propertyName).append(" value [").append(macAlgorithm).append("] is not supported. Ensure you have configured a valid HMAC Algorithm.").toString());
        });
    }

    private SignatureAlgorithm getSignatureAlgorithm(String signatureAlgorithm, String propertyName) {
        Map signatureAlgorithms = Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])SignatureAlgorithm.values()), (Function1 & Serializable)v -> new Tuple2((Object)v.getName(), v), ClassTag$.MODULE$.apply(Tuple2.class))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        return (SignatureAlgorithm)signatureAlgorithms.getOrElse((Object)signatureAlgorithm, (Function0 & Serializable)() -> {
            throw new IllegalArgumentException(new StringBuilder(83).append(propertyName).append(" value [").append(signatureAlgorithm).append("] is not supported. Ensure you have configured a valid Signature Algorithm.").toString());
        });
    }

    private ClientAuthenticationMethod getClientAuthMethod() {
        Map clientAuthMethods = (Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"client_secret_basic"), (Object)ClientAuthenticationMethod.CLIENT_SECRET_BASIC), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"client_secret_post"), (Object)ClientAuthenticationMethod.CLIENT_SECRET_POST), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"client_secret_jwt"), (Object)ClientAuthenticationMethod.CLIENT_SECRET_JWT), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"private_key_jwt"), (Object)ClientAuthenticationMethod.PRIVATE_KEY_JWT), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"none"), (Object)ClientAuthenticationMethod.NONE)}));
        return (ClientAuthenticationMethod)clientAuthMethods.getOrElse((Object)this.oidcConfig().clientAuthMethod().toLowerCase(), (Function0 & Serializable)() -> {
            throw new IllegalArgumentException(new StringBuilder(108).append("clientAuthMethod value [").append(this.oidcConfig().clientAuthMethod()).append(" is not supported. Ensure you have configured a valid client authentication method.]").toString());
        });
    }

    private OAuth2TokenValidator<Jwt> getJwtOAuth2TokenValidator() {
        ArrayList<Object> validators = new ArrayList<Object>();
        validators.add(new JwtTimestampValidator());
        validators.add(new JwtIssuerValidator(Strings.isNotBlank((String)this.oidcConfig().accessTokenIssuer()) ? this.oidcConfig().accessTokenIssuer() : this.oidcConfig().issuer()));
        validators.add(new JwtClaimValidator("aud", aud -> aud.contains(Strings.isNotBlank((String)this.oidcConfig().accessTokenAudience()) ? this.oidcConfig().accessTokenAudience() : this.oidcConfig().clientId())));
        return new DelegatingOAuth2TokenValidator(validators);
    }

    private void validateOidcConfiguration() {
        Checks.checkArgument((boolean)Strings.isNotBlank((String)this.oidcConfig().userAuthorizationUri()), (String)this.getErrorMessageForPlaceholder("deploy.security.auth.providers.oidc.userAuthorizationUri"), (Object[])new Object[0]);
        Checks.checkArgument((boolean)Strings.isNotBlank((String)this.oidcConfig().accessTokenUri()), (String)this.getErrorMessageForPlaceholder("deploy.security.auth.providers.oidc.accessTokenUri"), (Object[])new Object[0]);
        Checks.checkArgument((boolean)Strings.isNotBlank((String)this.oidcConfig().jwks_uri()), (String)this.getErrorMessageForPlaceholder("deploy.security.auth.providers.oidc.keyRetrievalUri"), (Object[])new Object[0]);
        Checks.checkArgument((boolean)Strings.isNotBlank((String)this.oidcConfig().logoutUri()), (String)this.getErrorMessageForPlaceholder("deploy.security.auth.providers.oidc.logoutUri"), (Object[])new Object[0]);
    }

    private String getErrorMessageForPlaceholder(String placeholder) {
        return new StringBuilder(41).append("No configuration setting found for key '").append(placeholder).append("'").toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void setJwk(ClientRegistration clientRegistration) {
        if (clientRegistration.getClientAuthenticationMethod().equals((Object)ClientAuthenticationMethod.CLIENT_SECRET_JWT)) {
            MacAlgorithm jwsAlgorithm = this.getMacAlgorithm(this.oidcConfig().clientAuthJWSAlg(), "deploy.security.auth.providers.oidc.clientAuthJwt.jwsAlg");
            MacAlgorithm macAlgorithm = jwsAlgorithm;
            if (macAlgorithm == null) throw new UnsupportedOidcConfigurationException("Failed to find a Signature Verifier. Ensure you have configured a valid JWS Algorithm.");
            MacAlgorithm macAlgorithm2 = macAlgorithm;
            SecretKeySpec secretKey = new SecretKeySpec(clientRegistration.getClientSecret().getBytes(StandardCharsets.UTF_8), (String)OpenIdConnectConfig$.MODULE$.MAC_ALGORITHM_MAPPING().getOrElse((Object)macAlgorithm2, (Function0 & Serializable)() -> {
                throw new IllegalArgumentException(new StringBuilder(0).append(new StringBuilder(10).append("'").append(macAlgorithm2.getName()).append("' is not ").toString()).append("supported. Ensure you have configured a valid HMAC Algorithm.").toString());
            }));
            this.oidcConfig().jwk_$eq((JWK)new OctetSequenceKey.Builder((SecretKey)secretKey).algorithm(new Algorithm(macAlgorithm2.getName())).keyUse(KeyUse.SIGNATURE).keyID(UUID.randomUUID().toString()).build());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return;
        } else if (clientRegistration.getClientAuthenticationMethod().equals((Object)ClientAuthenticationMethod.PRIVATE_KEY_JWT)) {
            BoxedUnit boxedUnit;
            SignatureAlgorithm jwsAlgorithm = this.getSignatureAlgorithm(this.oidcConfig().clientAuthJWSAlg(), "deploy.security.auth.providers.oidc.clientAuthJwt.jwsAlg");
            SignatureAlgorithm signatureAlgorithm = jwsAlgorithm;
            if (signatureAlgorithm == null) throw new UnsupportedOidcConfigurationException("Failed to find a Signature Verifier. Ensure you have configured a valid JWS Algorithm.");
            KeyPair keyPair = this.getKeyPair();
            if (OpenIdConnectConfig$.MODULE$.RSA_ALGORITHM_MAP().contains((Object)jwsAlgorithm)) {
                this.oidcConfig().jwk_$eq((JWK)this.getRSAKey(keyPair, (Algorithm)OpenIdConnectConfig$.MODULE$.RSA_ALGORITHM_MAP().apply((Object)jwsAlgorithm)));
                boxedUnit = BoxedUnit.UNIT;
            } else {
                if (!OpenIdConnectConfig$.MODULE$.ESA_ALGORITHM_MAP().contains((Object)jwsAlgorithm)) throw new UnsupportedOidcConfigurationException("Ensure you have configured a valid JWS Algorithm.");
                this.oidcConfig().jwk_$eq((JWK)this.getESAKey(keyPair, (Algorithm)OpenIdConnectConfig$.MODULE$.ESA_ALGORITHM_MAP().apply((Object)jwsAlgorithm), (Curve)OpenIdConnectConfig$.MODULE$.ESA_ALGORITHM_CURVE_MAPPING().apply((Object)jwsAlgorithm)));
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit2 = boxedUnit;
            return;
        } else {
            this.oidcConfig().jwk_$eq(null);
        }
    }

    private KeyPair getKeyPair() {
        KeyPair value;
        Try tryKeyPair;
        Try try_;
        File file = new File(this.oidcConfig().keyStorePath());
        if (!file.exists()) {
            throw new IllegalArgumentException(new StringBuilder(23).append("Cannot find keystore [").append(this.oidcConfig().keyStorePath()).append("]").toString());
        }
        if (Strings.isBlank((String)this.oidcConfig().keyStorePassword())) {
            this.logger().warn((Function0 & Serializable)() -> new StringBuilder(48).append(new StringBuilder(48).append("The keystore [").append(this.oidcConfig().keyStorePath()).append("] is not protected by a password. ").toString()).append("It is recommended to secure it using a password.").toString());
        }
        if (!((try_ = (tryKeyPair = Using$.MODULE$.apply((Function0 & Serializable)() -> new FileInputStream(file), (Function1 & Serializable)in -> {
            String kst = Strings.isNotBlank((String)this.oidcConfig().keyStoreType()) ? this.oidcConfig().keyStoreType() : KeyStore.getDefaultType();
            KeyStore keystore = KeyStore.getInstance(kst);
            char[] ksp = Strings.isNotBlank((String)this.oidcConfig().keyStorePassword()) ? this.oidcConfig().keyStorePassword().toCharArray() : null;
            keystore.load((InputStream)in, ksp);
            char[] kp = Strings.isNotBlank((String)this.oidcConfig().keyPassword()) ? this.oidcConfig().keyPassword().toCharArray() : null;
            PrivateKey privateKey = (PrivateKey)keystore.getKey(this.oidcConfig().keyAlias(), kp);
            Certificate cert = keystore.getCertificate(this.oidcConfig().keyAlias());
            PublicKey publicKey = cert.getPublicKey();
            return new KeyPair(publicKey, privateKey);
        }, (Using.Releasable)Using.Releasable$.AutoCloseableIsReleasable$.MODULE$))) instanceof Success)) {
            if (try_ instanceof Failure) {
                Failure failure = (Failure)try_;
                Throwable exception = failure.exception();
                throw new DeployitException(exception);
            }
            throw new MatchError((Object)try_);
        }
        Success success = (Success)try_;
        KeyPair keyPair = value = (KeyPair)success.value();
        return keyPair;
    }

    private RSAKey getRSAKey(KeyPair keyPair, Algorithm algorithm) {
        RSAKey.Builder builder;
        RSAKey.Builder builder2 = new RSAKey.Builder((RSAPublicKey)keyPair.getPublic()).privateKey(keyPair.getPrivate()).algorithm(algorithm).keyUse(KeyUse.SIGNATURE);
        if (Strings.isNotBlank((String)this.oidcConfig().tokenKeyId())) {
            builder = builder2.keyID(this.oidcConfig().tokenKeyId());
        } else {
            this.logger().debug((Function0 & Serializable)() -> "Building RSAKey without token k-id. Token key Id not provided in configuration.");
            builder = BoxedUnit.UNIT;
        }
        return builder2.build();
    }

    private ECKey getESAKey(KeyPair keyPair, Algorithm algorithm, Curve curve) {
        ECKey.Builder builder;
        ECKey.Builder builder2 = new ECKey.Builder(curve, (ECPublicKey)keyPair.getPublic()).privateKey((ECPrivateKey)keyPair.getPrivate()).algorithm(algorithm).keyUse(KeyUse.SIGNATURE);
        if (Strings.isNotBlank((String)this.oidcConfig().tokenKeyId())) {
            builder = builder2.keyID(this.oidcConfig().tokenKeyId());
        } else {
            this.logger().debug((Function0 & Serializable)() -> "Building ECKey without token k-id. Token key Id not provided in configuration.");
            builder = BoxedUnit.UNIT;
        }
        return builder2.build();
    }

    public OpenIdConnectConfig() {
        Logging.$init$((Logging)this);
        this.jwkResolver = (Function1 & Serializable)clientRegistration -> clientRegistration.getClientAuthenticationMethod().equals((Object)ClientAuthenticationMethod.CLIENT_SECRET_JWT) || clientRegistration.getClientAuthenticationMethod().equals((Object)ClientAuthenticationMethod.PRIVATE_KEY_JWT) ? this.oidcConfig().jwk() : null;
    }
}

