/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.envers.configuration.internal;

import java.security.AccessController;
import java.security.PrivilegedAction;
import org.dom4j.DocumentFactory;

final class XMLHelper {
    private final DocumentFactory documentFactory;

    XMLHelper() {
        PrivilegedAction<DocumentFactory> action = new PrivilegedAction<DocumentFactory>(){

            @Override
            public DocumentFactory run() {
                ClassLoader originalTccl = Thread.currentThread().getContextClassLoader();
                try {
                    Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
                    DocumentFactory documentFactory = DocumentFactory.getInstance();
                    return documentFactory;
                }
                finally {
                    Thread.currentThread().setContextClassLoader(originalTccl);
                }
            }
        };
        this.documentFactory = System.getSecurityManager() != null ? AccessController.doPrivileged(action) : (DocumentFactory)action.run();
    }

    DocumentFactory getDocumentFactory() {
        return this.documentFactory;
    }
}

