/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.integration.springsecurity;

import com.atlassian.crowd.exception.ApplicationPermissionException;
import com.atlassian.crowd.exception.InvalidAuthenticationException;
import com.atlassian.crowd.exception.OperationFailedException;
import com.atlassian.crowd.integration.http.CrowdHttpAuthenticator;
import com.atlassian.crowd.integration.http.util.CrowdHttpTokenHelper;
import com.atlassian.crowd.integration.springsecurity.AbstractCrowdSSOAuthenticationProcessingFilter;
import com.atlassian.crowd.model.authentication.CookieConfiguration;
import com.atlassian.crowd.service.client.ClientProperties;
import com.atlassian.crowd.service.client.CrowdClient;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CrowdSSOAuthenticationProcessingFilter
extends AbstractCrowdSSOAuthenticationProcessingFilter {
    private static final Logger logger = LoggerFactory.getLogger(CrowdSSOAuthenticationProcessingFilter.class);
    private final CrowdClient crowdClient;
    private CrowdHttpAuthenticator httpAuthenticator;

    public CrowdSSOAuthenticationProcessingFilter(CrowdHttpTokenHelper tokenHelper, CrowdClient crowdClient, ClientProperties clientProperties) {
        super(clientProperties, tokenHelper);
        this.crowdClient = crowdClient;
    }

    protected CookieConfiguration getCookieConfiguration() throws OperationFailedException, InvalidAuthenticationException, ApplicationPermissionException {
        return this.crowdClient.getCookieConfiguration();
    }

    protected void onUnsuccessfulAuthentication(HttpServletRequest request, HttpServletResponse response) {
        try {
            this.httpAuthenticator.logout(request, response);
        }
        catch (Exception e) {
            logger.error("Unable to unset Crowd SSO token", (Throwable)e);
        }
    }

    public void setHttpAuthenticator(CrowdHttpAuthenticator httpAuthenticator) {
        this.httpAuthenticator = httpAuthenticator;
    }
}

