/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.jwt;

import java.util.function.Supplier;
import org.springframework.security.oauth2.jwt.Jwt;
import org.springframework.security.oauth2.jwt.JwtDecoder;
import org.springframework.security.oauth2.jwt.JwtDecoderInitializationException;
import org.springframework.security.oauth2.jwt.JwtException;

public final class SupplierJwtDecoder
implements JwtDecoder {
    private final Supplier<JwtDecoder> jwtDecoderSupplier;
    private volatile JwtDecoder delegate;

    public SupplierJwtDecoder(Supplier<JwtDecoder> jwtDecoderSupplier) {
        this.jwtDecoderSupplier = jwtDecoderSupplier;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Jwt decode(String token) throws JwtException {
        if (this.delegate == null) {
            Supplier<JwtDecoder> supplier = this.jwtDecoderSupplier;
            synchronized (supplier) {
                if (this.delegate == null) {
                    try {
                        this.delegate = this.jwtDecoderSupplier.get();
                    }
                    catch (Exception ex) {
                        throw this.wrapException(ex);
                    }
                }
            }
        }
        return this.delegate.decode(token);
    }

    private JwtDecoderInitializationException wrapException(Exception ex) {
        return new JwtDecoderInitializationException("Failed to lazily resolve the supplied JwtDecoder instance", ex);
    }
}

