/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.core.rest.api;

import ai.digital.deploy.sql.http.enricher.PaginationService;
import ai.digital.deploy.sql.model.ReportLine;
import ai.digital.deploy.tasker.common.TaskType;
import com.google.common.collect.Sets;
import com.xebialabs.deployit.core.api.resteasy.Date;
import com.xebialabs.deployit.core.converters.ControlTaskReportLineConverter$;
import com.xebialabs.deployit.core.converters.ControlTaskReportLineField$;
import com.xebialabs.deployit.core.converters.DeploymentReportLineField$;
import com.xebialabs.deployit.core.converters.DeploymentTaskReportLineConverter$;
import com.xebialabs.deployit.core.rest.api.DownloadResource;
import com.xebialabs.deployit.core.rest.api.ReportGenerator;
import com.xebialabs.deployit.core.rest.api.SearchParametersFactory;
import com.xebialabs.deployit.core.rest.api.reports.ReportUtils;
import com.xebialabs.deployit.core.rest.resteasy.Workdir;
import com.xebialabs.deployit.core.rest.secured.AbstractSecuredResource;
import com.xebialabs.deployit.core.util.TaskFilterUtils$;
import com.xebialabs.deployit.engine.api.ReportService;
import com.xebialabs.deployit.engine.api.dto.AuditPreviewRow;
import com.xebialabs.deployit.engine.api.dto.ConfigurationItemId;
import com.xebialabs.deployit.engine.api.dto.ControlTaskReportLine;
import com.xebialabs.deployit.engine.api.dto.DeploymentTaskReportLine;
import com.xebialabs.deployit.engine.api.dto.Paging;
import com.xebialabs.deployit.engine.api.dto.report.AppEnvStatusReport;
import com.xebialabs.deployit.engine.api.dto.report.DeploymentsStatusOverview;
import com.xebialabs.deployit.engine.api.execution.FetchMode;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.Application;
import com.xebialabs.deployit.plugin.api.udm.Environment;
import com.xebialabs.deployit.report.audit.AuditPreviewReport;
import com.xebialabs.deployit.repository.SearchParameters;
import com.xebialabs.deployit.repository.sql.CiRepository;
import com.xebialabs.deployit.repository.sql.ConfigurationItemDataWithInternalId;
import com.xebialabs.deployit.security.permission.PlatformPermissions;
import com.xebialabs.deployit.task.ArchivedTaskSearchParameters;
import com.xebialabs.deployit.task.archive.TaskArchive;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import java.util.Collections;
import java.util.EnumSet;
import java.util.stream.Stream;
import javax.ws.rs.core.Context;
import org.jboss.resteasy.spi.HttpResponse;
import org.joda.time.ReadableInstant;
import org.slf4j.Marker;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.transaction.annotation.Transactional;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StrictOptimizedSeqOps;
import scala.jdk.CollectionConverters$;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@Controller
@Autowired
@ScalaSignature(bytes="\u0006\u0005\r\u001dg\u0001\u0002\u000f\u001e\u0001)B\u0001\u0002\u0011\u0001\u0003\u0002\u0003\u0006I!\u0011\u0005\t\u000b\u0002\u0011\t\u0011)A\u0005\r\"Aa\u000b\u0001B\u0001B\u0003%q\u000b\u0003\u0005_\u0001\t\u0005\t\u0015!\u0003`\u0011!9\u0007A!A!\u0002\u0013A\u0007\"B6\u0001\t\u0003a\u0007\"C:\u0001\u0001\u0004\u0005\r\u0011\"\u0003u\u0011-\t\u0019\u0001\u0001a\u0001\u0002\u0004%I!!\u0002\t\u0015\u0005]\u0001\u00011A\u0001B\u0003&Q\u000fC\u0004\u00022\u0001!\t!a\r\t\u000f\u0005]\u0002\u0001\"\u0003\u0002:!9\u0011q\r\u0001\u0005\n\u0005%\u0004bBAW\u0001\u0011%\u0011q\u0016\u0005\b\u0005K\u0001A\u0011\tB\u0014\u0011\u001d\u0011\t\u0005\u0001C!\u0005\u0007BqAa'\u0001\t\u0013\u0011i\nC\u0004\u0003J\u0002!\tEa3\t\u000f\t\r\b\u0001\"\u0011\u0003f\"9!Q \u0001\u0005\n\t}\bbBB \u0001\u0011%1\u0011\t\u0005\b\u0007\u001f\u0002A\u0011IB)\u0011\u001d\u0019\u0019\u0006\u0001C!\u0007#Bqa!\u0016\u0001\t\u0003\u001a9\u0006C\u0004\u0004V\u0001!\te!\u0018\t\u000f\r\u001d\u0004\u0001\"\u0011\u0004j!91\u0011\u0011\u0001\u0005B\r\r\u0005bBBK\u0001\u0011\u00053q\u0013\u0002\u0012%\u0016\u0004xN\u001d;TKJ4\u0018nY3J[Bd'B\u0001\u0010 \u0003\r\t\u0007/\u001b\u0006\u0003A\u0005\nAA]3ti*\u0011!eI\u0001\u0005G>\u0014XM\u0003\u0002%K\u0005AA-\u001a9m_fLGO\u0003\u0002'O\u0005I\u00010\u001a2jC2\f'm\u001d\u0006\u0002Q\u0005\u00191m\\7\u0004\u0001M!\u0001aK\u00199!\tas&D\u0001.\u0015\tqs$A\u0004tK\u000e,(/\u001a3\n\u0005Aj#aF!cgR\u0014\u0018m\u0019;TK\u000e,(/\u001a3SKN|WO]2f!\t\u0011d'D\u00014\u0015\tqBG\u0003\u00026G\u00051QM\\4j]\u0016L!aN\u001a\u0003\u001bI+\u0007o\u001c:u'\u0016\u0014h/[2f!\tId(D\u0001;\u0015\tYD(A\u0003tY\u001a$$NC\u0001>\u0003!9'/\u001b>{Y\u0016$\u0017BA ;\u0005\u001daunZ4j]\u001e\fqB]3q_J$x)\u001a8fe\u0006$xN\u001d\t\u0003\u0005\u000ek\u0011!H\u0005\u0003\tv\u0011qBU3q_J$x)\u001a8fe\u0006$xN]\u0001\u0012a\u0006<\u0017N\\1uS>t7+\u001a:wS\u000e,\u0007CA$U\u001b\u0005A%BA%K\u0003!)gN]5dQ\u0016\u0014(BA&M\u0003\u0011AG\u000f\u001e9\u000b\u00055s\u0015aA:rY*\u0011q\nU\u0001\u0007I\u0016\u0004Hn\\=\u000b\u0005E\u0013\u0016a\u00023jO&$\u0018\r\u001c\u0006\u0002'\u0006\u0011\u0011-[\u0005\u0003+\"\u0013\u0011\u0003U1hS:\fG/[8o'\u0016\u0014h/[2f\u00031\u0019\u0017NU3q_NLGo\u001c:z!\tAF,D\u0001Z\u0015\ti%L\u0003\u0002\\G\u0005Q!/\u001a9pg&$xN]=\n\u0005uK&\u0001D\"j%\u0016\u0004xn]5u_JL\u0018a\u0003;bg.\f%o\u00195jm\u0016\u0004\"\u0001Y3\u000e\u0003\u0005T!AY2\u0002\u000f\u0005\u00148\r[5wK*\u0011AmI\u0001\u0005i\u0006\u001c8.\u0003\u0002gC\nYA+Y:l\u0003J\u001c\u0007.\u001b<f\u0003A!wn\u001e8m_\u0006$'+Z:pkJ\u001cW\r\u0005\u0002CS&\u0011!.\b\u0002\u0011\t><h\u000e\\8bIJ+7o\\;sG\u0016\fa\u0001P5oSRtDCB7o_B\f(\u000f\u0005\u0002C\u0001!)\u0001I\u0002a\u0001\u0003\")QI\u0002a\u0001\r\")aK\u0002a\u0001/\")aL\u0002a\u0001?\")qM\u0002a\u0001Q\u0006A!/Z:q_:\u001cX-F\u0001v!\t1x0D\u0001x\u0015\tA\u00180A\u0002ta&T!A_>\u0002\u0011I,7\u000f^3bgfT!\u0001`?\u0002\u000b)\u0014wn]:\u000b\u0003y\f1a\u001c:h\u0013\r\t\ta\u001e\u0002\r\u0011R$\bOU3ta>t7/Z\u0001\re\u0016\u001c\bo\u001c8tK~#S-\u001d\u000b\u0005\u0003\u000f\t\u0019\u0002\u0005\u0003\u0002\n\u0005=QBAA\u0006\u0015\t\ti!A\u0003tG\u0006d\u0017-\u0003\u0003\u0002\u0012\u0005-!\u0001B+oSRD\u0001\"!\u0006\t\u0003\u0003\u0005\r!^\u0001\u0004q\u0012\n\u0014!\u0003:fgB|gn]3!Q\rI\u00111\u0004\t\u0005\u0003;\ti#\u0004\u0002\u0002 )\u0019!%!\t\u000b\t\u0005\r\u0012QE\u0001\u0003eNTA!a\n\u0002*\u0005\u0011qo\u001d\u0006\u0003\u0003W\tQA[1wCbLA!a\f\u0002 \t91i\u001c8uKb$\u0018aC:fiJ+7\u000f]8og\u0016$B!a\u0002\u00026!)1O\u0003a\u0001k\u0006a1/\u001a;DS\u001aKG\u000e^3sgR1\u0011qAA\u001e\u0003\u000fBq!!\u0010\f\u0001\u0004\ty$\u0001\ttK\u0006\u00148\r\u001b)be\u0006lW\r^3sgB!\u0011\u0011IA\"\u001b\u0005\u0019\u0017bAA#G\na\u0012I]2iSZ,G\rV1tWN+\u0017M]2i!\u0006\u0014\u0018-\\3uKJ\u001c\bbBA%\u0017\u0001\u0007\u00111J\u0001\u0015G>tg-[4ve\u0006$\u0018n\u001c8Ji\u0016l\u0017\nZ:\u0011\r\u00055\u0013qKA.\u001b\t\tyE\u0003\u0003\u0002R\u0005M\u0013\u0001B;uS2T!!!\u0016\u0002\t)\fg/Y\u0005\u0005\u00033\nyE\u0001\u0003MSN$\b\u0003BA/\u0003Gj!!a\u0018\u000b\u0007\u0005\u00054'A\u0002ei>LA!!\u001a\u0002`\t\u00192i\u001c8gS\u001e,(/\u0019;j_:LE/Z7JI\u0006a1\u000f\u001e:fC6\u0014V\r]8siV!\u00111NA?)!\ti'a$\u0002 \u0006%\u0006CBA8\u0003k\nI(\u0004\u0002\u0002r)!\u00111OA(\u0003\u0019\u0019HO]3b[&!\u0011qOA9\u0005\u0019\u0019FO]3b[B!\u00111PA?\u0019\u0001!q!a \r\u0005\u0004\t\tIA\u0001U#\u0011\t\u0019)!#\u0011\t\u0005%\u0011QQ\u0005\u0005\u0003\u000f\u000bYAA\u0004O_RD\u0017N\\4\u0011\t\u0005%\u00111R\u0005\u0005\u0003\u001b\u000bYAA\u0002B]fDq!!%\r\u0001\u0004\t\u0019*A\u0006qC\u001eLgnZ'bs\n,\u0007CBA\u0005\u0003+\u000bI*\u0003\u0003\u0002\u0018\u0006-!AB(qi&|g\u000e\u0005\u0003\u0002^\u0005m\u0015\u0002BAO\u0003?\u0012a\u0001U1hS:<\u0007bBAQ\u0019\u0001\u0007\u00111U\u0001\fEVLG\u000e\u001a)be\u0006l7\u000f\u0005\u0005\u0002\n\u0005\u0015\u0016\u0011TA \u0013\u0011\t9+a\u0003\u0003\u0013\u0019+hn\u0019;j_:\f\u0004bBA:\u0019\u0001\u0007\u00111\u0016\t\t\u0003\u0013\t)+a\u0010\u0002n\u0005Q2\u000f\u001e:fC6$U\r\u001d7ps6,g\u000e\u001e+bg.\u0014V\r]8siRQ\u0012\u0011WA]\u0003\u0013\fi-!5\u0002^\u0006e\u0018Q B\u0001\u0005#\u0011)Ba\b\u0003$A1\u0011qNA;\u0003g\u0003B!!\u0018\u00026&!\u0011qWA0\u0005a!U\r\u001d7ps6,g\u000e\u001e+bg.\u0014V\r]8si2Kg.\u001a\u0005\b\u0003wk\u0001\u0019AA_\u0003\u0015\u0011WmZ5o!\u0011\ty,!2\u000e\u0005\u0005\u0005'b\u0001>\u0002D*\u0011a$I\u0005\u0005\u0003\u000f\f\tM\u0001\u0003ECR,\u0007bBAf\u001b\u0001\u0007\u0011QX\u0001\u0004K:$\u0007bBAh\u001b\u0001\u0007\u00111S\u0001\u0007a\u0006<\u0017N\\4\t\u000f\u0005MW\u00021\u0001\u0002V\u0006)qN\u001d3feB1\u0011QJA,\u0003/\u0004B!!\u0018\u0002Z&!\u00111\\A0\u0005!y%\u000fZ3sS:<\u0007bBAp\u001b\u0001\u0007\u0011\u0011]\u0001\u0006kN,'o\u001d\t\u0007\u0003\u001b\n9&a9\u0011\t\u0005\u0015\u00181\u001f\b\u0005\u0003O\fy\u000f\u0005\u0003\u0002j\u0006-QBAAv\u0015\r\ti/K\u0001\u0007yI|w\u000e\u001e \n\t\u0005E\u00181B\u0001\u0007!J,G-\u001a4\n\t\u0005U\u0018q\u001f\u0002\u0007'R\u0014\u0018N\\4\u000b\t\u0005E\u00181\u0002\u0005\b\u0003wl\u0001\u0019AAq\u0003)!\u0018m]6Ti\u0006$Xm\u001d\u0005\b\u0003\u007fl\u0001\u0019AAq\u0003%!\u0018m]6UsB,7\u000fC\u0004\u0003\u00045\u0001\rA!\u0002\u0002\u0013\u0019,Go\u00195N_\u0012,\u0007\u0003\u0002B\u0004\u0005\u001bi!A!\u0003\u000b\u0007\t-1'A\u0005fq\u0016\u001cW\u000f^5p]&!!q\u0002B\u0005\u0005%1U\r^2i\u001b>$W\rC\u0004\u0003\u00145\u0001\r!a9\u0002\rQ\f7o[%e\u0011\u001d\u00119\"\u0004a\u0001\u00053\tab\u001c8msN+8mY3tg\u001a,H\u000e\u0005\u0003\u0002\n\tm\u0011\u0002\u0002B\u000f\u0003\u0017\u0011qAQ8pY\u0016\fg\u000eC\u0004\u0003\"5\u0001\r!a9\u0002\u0015]|'o[3s\u001d\u0006lW\rC\u0004\u0002J5\u0001\r!a\u0013\u0002\u001b\u001d,G\u000fV1tWJ+\u0007o\u001c:u)i\t\tL!\u000b\u0003,\t5\"q\u0006B\u0019\u0005g\u0011)Da\u000e\u0003:\tm\"Q\bB \u0011\u001d\tYL\u0004a\u0001\u0003{Cq!a3\u000f\u0001\u0004\ti\fC\u0004\u0002P:\u0001\r!!'\t\u000f\u0005Mg\u00021\u0001\u0002V\"9\u0011q\u001c\bA\u0002\u0005\u0005\bbBA~\u001d\u0001\u0007\u0011\u0011\u001d\u0005\b\u0003\u007ft\u0001\u0019AAq\u0011\u001d\u0011\u0019A\u0004a\u0001\u0005\u000bAqAa\u0005\u000f\u0001\u0004\t\u0019\u000fC\u0004\u0003\u00189\u0001\rA!\u0007\t\u000f\t\u0005b\u00021\u0001\u0002d\"9\u0011\u0011\n\bA\u0002\u0005-\u0013A\u00053po:dw.\u00193UCN\\'+\u001a9peR$b#a9\u0003F\t\u001d#\u0011\nB&\u0005\u001b\u0012yE!\u0015\u0003T\tU#q\u000b\u0005\b\u0003w{\u0001\u0019AA_\u0011\u001d\tYm\u0004a\u0001\u0003{Cq!a5\u0010\u0001\u0004\t)\u000eC\u0004\u0002`>\u0001\r!!9\t\u000f\u0005mx\u00021\u0001\u0002b\"9\u0011q`\bA\u0002\u0005\u0005\bb\u0002B\n\u001f\u0001\u0007\u00111\u001d\u0005\b\u0005/y\u0001\u0019\u0001B\r\u0011\u001d\u0011\tc\u0004a\u0001\u0003GDq!!\u0013\u0010\u0001\u0004\tY\u0005K\u0006\u0010\u00057\u0012yG!\u001d\u0003v\t]\u0004\u0003\u0002B/\u0005Wj!Aa\u0018\u000b\t\t\u0005$1M\u0001\u000bC:tw\u000e^1uS>t'\u0002\u0002B3\u0005O\n1\u0002\u001e:b]N\f7\r^5p]*\u0019!\u0011N?\u0002\u001fM\u0004(/\u001b8hMJ\fW.Z<pe.LAA!\u001c\u0003`\tiAK]1og\u0006\u001cG/[8oC2\fQA^1mk\u0016\f#Aa\u001d\u00027I,\u0007o\u001c:uS:<GK]1og\u0006\u001cG/[8o\u001b\u0006t\u0017mZ3s\u0003!\u0011X-\u00193P]2L\u0018$A\u0001)\u0017=\u0011YH!\"\u0003\b\n-%Q\u0012\t\u0005\u0005{\u0012\t)\u0004\u0002\u0003\u0000)\u0011!pH\u0005\u0005\u0005\u0007\u0013yHA\u0004X_J\\G-\u001b:\u0002\rA\u0014XMZ5yC\t\u0011I)\u0001\u0005e_^tGn\\1e\u0003\u0015\u0019G.Z1oI\t\u0011y)\u0003\u0003\u0003\u0012\nM\u0015AB!M/\u0006K6K\u0003\u0003\u0003\u0016\n]\u0015!B\"mK\u0006t'\u0002\u0002BM\u0005\u007f\nqaV8sW\u0012L'/A\ftiJ,\u0017-\\\"p]R\u0014x\u000e\u001c+bg.\u0014V\r]8siRA\"q\u0014BT\u0005S\u0013YKa,\u00034\nU&q\u0017B]\u0005w\u0013iLa0\u0011\r\u0005=\u0014Q\u000fBQ!\u0011\tiFa)\n\t\t\u0015\u0016q\f\u0002\u0016\u0007>tGO]8m)\u0006\u001c8NU3q_J$H*\u001b8f\u0011\u001d\tY\f\u0005a\u0001\u0003{Cq!a3\u0011\u0001\u0004\ti\fC\u0004\u0003.B\u0001\r!!9\u0002\rM$\u0018\r^3t\u0011\u001d\u0011\t\f\u0005a\u0001\u0003G\f\u0001\u0002^1tW:\u000bW.\u001a\u0005\b\u0005\u0007\u0001\u0002\u0019\u0001B\u0003\u0011\u001d\ty\u000e\u0005a\u0001\u0003CDq!a5\u0011\u0001\u0004\t)\u000eC\u0004\u0003\"A\u0001\r!a9\t\u000f\tM\u0001\u00031\u0001\u0002d\"9\u0011q\u001a\tA\u0002\u0005M\u0005b\u0002Ba!\u0001\u0007!1Y\u0001\bi\u0006\u0014x-\u001a;t!\u0019\tiE!2\u0002d&!!qYA(\u0005\r\u0019V\r^\u0001\u0016O\u0016$8i\u001c8ue>dG+Y:lgJ+\u0007o\u001c:u)a\u0011yJ!4\u0003P\nE'1\u001bBk\u0005/\u0014INa7\u0003^\n}'\u0011\u001d\u0005\b\u0003w\u000b\u0002\u0019AA_\u0011\u001d\tY-\u0005a\u0001\u0003{CqA!,\u0012\u0001\u0004\t\t\u000fC\u0004\u00032F\u0001\r!a9\t\u000f\t\r\u0011\u00031\u0001\u0003\u0006!9\u0011q\\\tA\u0002\u0005\u0005\bbBAj#\u0001\u0007\u0011Q\u001b\u0005\b\u0005C\t\u0002\u0019AAr\u0011\u001d\u0011\u0019\"\u0005a\u0001\u0003GDq!a4\u0012\u0001\u0004\tI\nC\u0004\u0003BF\u0001\rAa1\u00025\u0011|wO\u001c7pC\u0012\u001cuN\u001c;s_2$\u0016m]6t%\u0016\u0004xN\u001d;\u0015)\u0005\r(q\u001dBu\u0005W\u0014iOa<\u0003r\nM(Q\u001fB|\u0011\u001d\tYL\u0005a\u0001\u0003{Cq!a3\u0013\u0001\u0004\ti\fC\u0004\u0003.J\u0001\r!!9\t\u000f\tE&\u00031\u0001\u0002d\"9\u0011q\u001c\nA\u0002\u0005\u0005\bbBAj%\u0001\u0007\u0011Q\u001b\u0005\b\u0005C\u0011\u0002\u0019AAr\u0011\u001d\u0011\u0019B\u0005a\u0001\u0003GDqA!1\u0013\u0001\u0004\u0011\u0019\rK\u0006\u0013\u00057\u0012yG!\u001d\u0003v\t]\u0004f\u0003\n\u0003|\t\u0015%q\u0011BF\u0005\u001b\u000bq\u0003\\5ti\u0006cGnQ5t\u001f\u001a$\u0016\u0010]3He>,\b/\u001a3\u0015\r\r\u00051QDB\u001a!!\u0019\u0019a!\u0004\u0004\u0012\u0005\rXBAB\u0003\u0015\u0011\u00199a!\u0003\u0002\u0013%lW.\u001e;bE2,'\u0002BB\u0006\u0003\u0017\t!bY8mY\u0016\u001cG/[8o\u0013\u0011\u0019ya!\u0002\u0003\u00075\u000b\u0007\u000f\u0005\u0003\u0004\u0014\reQBAB\u000b\u0015\u0011\u00199\"a\u0015\u0002\t1\fgnZ\u0005\u0005\u00077\u0019)BA\u0004J]R,w-\u001a:\t\u000f\r}1\u00031\u0001\u0004\"\u000511-\u001b+za\u0016\u0004Baa\t\u000405\u00111Q\u0005\u0006\u0005\u0007O\u0019I#A\u0004sK\u001adWm\u0019;\u000b\u0007y\u0019YCC\u0002\u0004.\r\na\u0001\u001d7vO&t\u0017\u0002BB\u0019\u0007K\u0011A\u0001V=qK\"91QG\nA\u0002\r]\u0012\u0001C4fi2\u000b'-\u001a7\u0011\u0011\u0005%\u0011QUB\u001d\u0003G\u00042\u0001WB\u001e\u0013\r\u0019i$\u0017\u0002$\u0007>tg-[4ve\u0006$\u0018n\u001c8Ji\u0016lG)\u0019;b/&$\b.\u00138uKJt\u0017\r\\%e\u00035a\u0017n\u001d;UsB,\u0007+\u0019;igRA\u00111JB\"\u0007\u0017\u001ai\u0005C\u0004\u0004FQ\u0001\raa\u0012\u0002\u0017\u0005\u00148\r[5wK\u0012\u001c\u0015n\u001d\t\t\u0003K\u001cIe!\u0005\u0002b&!1qBA|\u0011\u001d\u0019)\u0004\u0006a\u0001\u0007oAqaa\b\u0015\u0001\u0004\u0019\t#\u0001\tmSN$XI\u001c<je>tW.\u001a8ugR\u0011\u00111J\u0001\u0011Y&\u001cH/\u00119qY&\u001c\u0017\r^5p]N\f1\u0003Z8x]2|\u0017\rZ!vI&$(+\u001a9peR$\"!a9)\u0017]\u0011YFa\u001c\u0003r\tU$q\u000f\u0015\f/\tm$Q\u0011BD\u0005\u0017\u0013i\t\u0006\u0003\u0002d\u000e}\u0003bBB11\u0001\u0007\u0011\u0011]\u0001\bM>dG-\u001a:tQ-A\"1\fB8\u0005c\u0012)Ha\u001e)\u0017a\u0011YH!\"\u0003\b\n-%QR\u0001\u0013aJ,g/[3x\u0003V$\u0017\u000e\u001e*fa>\u0014H\u000f\u0006\u0005\u0004l\rM4QOB<!\u0019\ty'!\u001e\u0004nA!\u0011QLB8\u0013\u0011\u0019\t(a\u0018\u0003\u001f\u0005+H-\u001b;Qe\u00164\u0018.Z<S_^Dqa!\u0019\u001a\u0001\u0004\t\t\u000fC\u0004\u0002Tf\u0001\r!!6\t\u000f\u0005=\u0017\u00041\u0001\u0002\u001a\"Z\u0011Da\u0017\u0003p\tE$Q\u000fB<Q\u001dI\"1\u0010BC\u0007{\n#aa \u0002\u000fA\u0014XM^5fo\u0006\tr-\u001a;Ti\u0006$Xo](wKJ4\u0018.Z<\u0015\r\r\u00155\u0011SBJ!\u0011\u00199i!$\u000e\u0005\r%%\u0002BBF\u0003?\naA]3q_J$\u0018\u0002BBH\u0007\u0013\u0013\u0011\u0004R3qY>LX.\u001a8ugN#\u0018\r^;t\u001fZ,'O^5fo\"9\u00111\u0018\u000eA\u0002\u0005u\u0006bBAf5\u0001\u0007\u0011QX\u0001\u0010O\u0016$\u0018\t\u001d9F]Z\u001cF/\u0019;vgR11\u0011TBQ\u0007G\u0003b!!\u0014\u0002X\rm\u0005\u0003BBD\u0007;KAaa(\u0004\n\n\u0011\u0012\t\u001d9F]Z\u001cF/\u0019;vgJ+\u0007o\u001c:u\u0011\u001d\tYl\u0007a\u0001\u0003{Cq!a3\u001c\u0001\u0004\ti\fK\u0002\u0001\u0007O\u0003Ba!+\u000466\u001111\u0016\u0006\u0005\u0005C\u001aiK\u0003\u0003\u00040\u000eE\u0016a\u00024bGR|'/\u001f\u0006\u0005\u0007g\u00139'A\u0003cK\u0006t7/\u0003\u0003\u00048\u000e-&!C!vi><\u0018N]3eQ\r\u000111\u0018\t\u0005\u0007{\u001b\u0019-\u0004\u0002\u0004@*!1\u0011\u0019B4\u0003)\u0019H/\u001a:f_RL\b/Z\u0005\u0005\u0007\u000b\u001cyL\u0001\u0006D_:$(o\u001c7mKJ\u0004")
public class ReportServiceImpl
extends AbstractSecuredResource
implements ReportService,
Logging {
    private final ReportGenerator reportGenerator;
    private final PaginationService paginationService;
    private final CiRepository ciRepository;
    private final TaskArchive taskArchive;
    private final DownloadResource downloadResource;
    @Context
    private HttpResponse response;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        ReportServiceImpl reportServiceImpl = this;
        synchronized (reportServiceImpl) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        if (!this.bitmap$trans$0) {
            return this.grizzled$slf4j$Logging$$_logger$lzycompute();
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    private HttpResponse response() {
        return this.response;
    }

    private void response_$eq(HttpResponse x$1) {
        this.response = x$1;
    }

    public void setResponse(HttpResponse response) {
        this.response_$eq(response);
    }

    private void setCiFilters(ArchivedTaskSearchParameters searchParameters, java.util.List<ConfigurationItemId> configurationItemIds) {
        Tuple2<List<String>, List<String>> tuple2 = TaskFilterUtils$.MODULE$.parseCiFilters((List<ConfigurationItemId>)((List)Option$.MODULE$.apply((Object)CollectionConverters$.MODULE$.ListHasAsScala(configurationItemIds).asScala()).toList().flatten(Predef$.MODULE$.$conforms())));
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        List applications = (List)tuple2._1();
        List environments = (List)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)applications, (Object)environments);
        List applications2 = (List)tuple22._1();
        List environments2 = (List)tuple22._2();
        applications2.foreach((Function1 & Serializable)x$1 -> searchParameters.forApplication(x$1));
        environments2.foreach((Function1 & Serializable)x$1 -> searchParameters.forEnvironment(x$1));
    }

    private <T> Stream<T> streamReport(Option<Paging> pagingMaybe, Function1<Paging, ArchivedTaskSearchParameters> buildParams, Function1<ArchivedTaskSearchParameters, Stream<T>> stream) {
        Option limitedMaybe = pagingMaybe.map((Function1 & Serializable)paging -> new Tuple2(paging, (Object)$this.paginationService.getLimitedPaging(paging)));
        ArchivedTaskSearchParameters searchParameters = (ArchivedTaskSearchParameters)buildParams.apply(limitedMaybe.map((Function1 & Serializable)x$3 -> (Paging)x$3._2()).getOrElse((Function0 & Serializable)() -> new Paging()));
        limitedMaybe.foreach((Function1 & Serializable)limitedPaging -> {
            this.paginationService.addPagingHeaderIfNeeded((Paging)limitedPaging._1(), (Paging)limitedPaging._2(), this.paginationService.toSetHeader(this.response()), () -> Predef$.MODULE$.int2Integer($this.taskArchive.countTotalResults(searchParameters$2)));
            return BoxedUnit.UNIT;
        });
        return (Stream)stream.apply((Object)searchParameters);
    }

    private Stream<DeploymentTaskReportLine> streamDeploymentTaskReport(Date begin, Date end, Option<Paging> paging, java.util.List<com.xebialabs.deployit.engine.api.dto.Ordering> order, java.util.List<String> users, java.util.List<String> taskStates, java.util.List<String> taskTypes, FetchMode fetchMode, String taskId, boolean onlySuccessful, String workerName, java.util.List<ConfigurationItemId> configurationItemIds) {
        return this.streamReport(paging, (Function1<Paging, ArchivedTaskSearchParameters>)(Function1 & Serializable)limited -> {
            ArchivedTaskSearchParameters params = $this.reportGenerator.buildFilteredTaskSearchParameters(begin, end, (Paging)limited, order, null, users, taskStates, taskTypes, fetchMode, taskId, CollectionConverters$.MODULE$.SeqHasAsJava((Seq)Nil$.MODULE$).asJava(), ReportGenerator.DEPLOYMENT_ALLOWED_SORT_FIELDS, onlySuccessful, workerName);
            this.setCiFilters(params, configurationItemIds);
            return params;
        }, (Function1 & Serializable)searchParameters -> $this.reportGenerator.streamTaskReport((ArchivedTaskSearchParameters)searchParameters));
    }

    public Stream<DeploymentTaskReportLine> getTaskReport(Date begin, Date end, Paging paging, java.util.List<com.xebialabs.deployit.engine.api.dto.Ordering> order, java.util.List<String> users, java.util.List<String> taskStates, java.util.List<String> taskTypes, FetchMode fetchMode, String taskId, boolean onlySuccessful, String workerName, java.util.List<ConfigurationItemId> configurationItemIds) {
        return this.streamDeploymentTaskReport(begin, end, (Option<Paging>)Option$.MODULE$.apply((Object)paging), order, users, taskStates, taskTypes, fetchMode, taskId, onlySuccessful, workerName, configurationItemIds);
    }

    @Workdir(prefix="download", clean=Workdir.Clean.ALWAYS)
    @Transactional(value="reportingTransactionManager", readOnly=true)
    public String downloadTaskReport(Date begin, Date end, java.util.List<com.xebialabs.deployit.engine.api.dto.Ordering> order, java.util.List<String> users, java.util.List<String> taskStates, java.util.List<String> taskTypes, String taskId, boolean onlySuccessful, String workerName, java.util.List<ConfigurationItemId> configurationItemIds) {
        Stream<ReportLine> stream = this.streamDeploymentTaskReport(begin, end, (Option<Paging>)None$.MODULE$, order, users, taskStates, taskTypes, FetchMode.SUMMARY, taskId, onlySuccessful, workerName, configurationItemIds).map(line -> DeploymentTaskReportLineConverter$.MODULE$.toReportLine((DeploymentTaskReportLine)line));
        String fileName = String.format("tasks-%s-%s.csv", ReportUtils.DATE_FORMAT.print((ReadableInstant)begin.asDateTime()), ReportUtils.DATE_FORMAT.print((ReadableInstant)end.asDateTime()));
        return ReportUtils.createDownloadToken(this.downloadResource, CollectionConverters$.MODULE$.SetHasAsJava(DeploymentReportLineField$.MODULE$.allFields()).asJava(), stream, fileName);
    }

    private Stream<ControlTaskReportLine> streamControlTaskReport(Date begin, Date end, java.util.List<String> states, String taskName, FetchMode fetchMode, java.util.List<String> users, java.util.List<com.xebialabs.deployit.engine.api.dto.Ordering> order, String workerName, String taskId, Option<Paging> paging, java.util.Set<String> targets) {
        return this.streamReport(paging, (Function1<Paging, ArchivedTaskSearchParameters>)(Function1 & Serializable)limited -> {
            ArchivedTaskSearchParameters params = $this.reportGenerator.buildTaskSearchParameters((Paging)limited, order, EnumSet.of(TaskType.CONTROL), ReportGenerator.CONTROL_ALLOWED_SORT_FIELDS);
            params.withTargets(targets);
            params.withTaskStates(states);
            params.withTaskName(taskName);
            params.withFetchMode(fetchMode);
            params.withWorkerName(workerName);
            params.inDateTimeRange($this.reportGenerator.safeDateTime(begin, null), $this.reportGenerator.safeDateTime(end, null));
            params.withUniqueId(taskId);
            Object object = users != null && !users.isEmpty() ? params.forUsers((java.util.Set)Sets.newHashSet((Iterable)users)) : BoxedUnit.UNIT;
            return params;
        }, (Function1 & Serializable)searchParameters -> $this.reportGenerator.streamControlTasksReport((ArchivedTaskSearchParameters)searchParameters));
    }

    public Stream<ControlTaskReportLine> getControlTasksReport(Date begin, Date end, java.util.List<String> states, String taskName, FetchMode fetchMode, java.util.List<String> users, java.util.List<com.xebialabs.deployit.engine.api.dto.Ordering> order, String workerName, String taskId, Paging paging, java.util.Set<String> targets) {
        return this.streamControlTaskReport(begin, end, states, taskName, fetchMode, users, order, workerName, taskId, (Option<Paging>)Option$.MODULE$.apply((Object)paging), targets);
    }

    @Workdir(prefix="download", clean=Workdir.Clean.ALWAYS)
    @Transactional(value="reportingTransactionManager", readOnly=true)
    public String downloadControlTasksReport(Date begin, Date end, java.util.List<String> states, String taskName, java.util.List<String> users, java.util.List<com.xebialabs.deployit.engine.api.dto.Ordering> order, String workerName, String taskId, java.util.Set<String> targets) {
        Stream<ReportLine> report = this.streamControlTaskReport(begin, end, states, taskName, FetchMode.SUMMARY, users, order, workerName, taskId, (Option<Paging>)None$.MODULE$, targets).map(line -> ControlTaskReportLineConverter$.MODULE$.toReportLine((ControlTaskReportLine)line));
        return ReportUtils.createDownloadToken(this.downloadResource, CollectionConverters$.MODULE$.SetHasAsJava(ControlTaskReportLineField$.MODULE$.allFields()).asJava(), report, this.reportGenerator.buildControlTaskReportFileName(begin, end));
    }

    private Map<Integer, String> listAllCisOfTypeGrouped(Type ciType, Function1<ConfigurationItemDataWithInternalId, String> getLabel) {
        SearchParameters params = SearchParametersFactory.createSearchParams((Type)ciType, (long)0L, (long)-1L);
        PlatformPermissions.READ.getPermissionHandler().applyPermission(params);
        return ((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(this.ciRepository.listInternal(params)).asScala().map((Function1 & Serializable)item -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)item.internalId()), getLabel.apply(item)))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    private java.util.List<ConfigurationItemId> listTypePaths(Map<Integer, java.util.List<String>> archivedCis, Function1<ConfigurationItemDataWithInternalId, String> getLabel, Type ciType) {
        List list;
        this.checkPermission(PlatformPermissions.REPORT_VIEW);
        Map<Integer, String> cisInRepository = this.listAllCisOfTypeGrouped(ciType, getLabel);
        scala.collection.immutable.Set matchedIds = (scala.collection.immutable.Set)archivedCis.keySet().intersect((Set)cisInRepository.keySet());
        List onlyInArchive = ((IterableOnceOps)archivedCis.flatMap((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                Integer id = (Integer)tuple2._1();
                java.util.List paths = (java.util.List)tuple2._2();
                if (matchedIds.contains((Object)id)) {
                    return (Seq)CollectionConverters$.MODULE$.ListHasAsScala(paths).asScala().filter((Function1 & Serializable)path -> BoxesRunTime.boxToBoolean((boolean)ReportServiceImpl.$anonfun$listTypePaths$2(cisInRepository, id, path)));
                }
                return Nil$.MODULE$;
            }
            throw new MatchError((Object)tuple2);
        })).toList();
        List list2 = cisInRepository.values().toList();
        List inArchiveAndRepository = onlyInArchive.$colon$colon$colon(list2);
        if (this.hasPermission(PlatformPermissions.REPORT_VIEW)) {
            List list3 = inArchiveAndRepository;
            list = ((IterableOnceOps)archivedCis.view().filterKeys((Function1 & Serializable)id -> BoxesRunTime.boxToBoolean((boolean)ReportServiceImpl.$anonfun$listTypePaths$3(cisInRepository, id))).values().flatMap((Function1 & Serializable)x$4 -> CollectionConverters$.MODULE$.ListHasAsScala(x$4).asScala())).toList().$colon$colon$colon(list3);
        } else {
            list = inArchiveAndRepository;
        }
        List result = list;
        return CollectionConverters$.MODULE$.SeqHasAsJava((Seq)((List)((StrictOptimizedSeqOps)result.distinct()).sorted((Ordering)Ordering.String$.MODULE$)).map((Function1 & Serializable)x$5 -> new ConfigurationItemId(x$5, ciType))).asJava();
    }

    public java.util.List<ConfigurationItemId> listEnvironments() {
        return this.listTypePaths((Map<Integer, java.util.List<String>>)CollectionConverters$.MODULE$.MapHasAsScala(this.reportGenerator.getEnvironments()).asScala().toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()), (Function1<ConfigurationItemDataWithInternalId, String>)(Function1 & Serializable)x$6 -> x$6.id(), Type.valueOf(Environment.class));
    }

    public java.util.List<ConfigurationItemId> listApplications() {
        return this.listTypePaths((Map<Integer, java.util.List<String>>)CollectionConverters$.MODULE$.MapHasAsScala(this.reportGenerator.getApplications()).asScala().toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()), (Function1<ConfigurationItemDataWithInternalId, String>)(Function1 & Serializable)x$7 -> x$7.name(), Type.valueOf(Application.class));
    }

    @Workdir(prefix="download", clean=Workdir.Clean.ALWAYS)
    @Transactional(value="reportingTransactionManager", readOnly=true)
    public String downloadAuditReport() {
        return this.reportGenerator.generateAuditReport(Collections.emptyList(), this.downloadResource);
    }

    @Workdir(prefix="download", clean=Workdir.Clean.ALWAYS)
    @Transactional(value="reportingTransactionManager", readOnly=true)
    public String downloadAuditReport(java.util.List<String> folders) {
        return this.reportGenerator.generateAuditReport(folders, this.downloadResource);
    }

    @Workdir(prefix="preview")
    @Transactional(value="reportingTransactionManager", readOnly=true)
    public Stream<AuditPreviewRow> previewAuditReport(java.util.List<String> folders, java.util.List<com.xebialabs.deployit.engine.api.dto.Ordering> order, Paging paging) {
        AuditPreviewReport previewReport = this.reportGenerator.previewAuditReport(folders, order, paging);
        Paging limited = this.paginationService.getLimitedPaging(paging);
        this.paginationService.addPagingHeaderIfNeeded(paging, limited, this.paginationService.toSetHeader(this.response()), () -> previewReport.total());
        return previewReport.currentPageData().stream();
    }

    public DeploymentsStatusOverview getStatusOverview(Date begin, Date end) {
        return this.reportGenerator.buildStatusOverview(begin, end);
    }

    public java.util.List<AppEnvStatusReport> getAppEnvStatus(Date begin, Date end) {
        return this.reportGenerator.buildAppEnvStatusReport(begin, end);
    }

    public static final /* synthetic */ boolean $anonfun$listTypePaths$2(Map cisInRepository$1, Integer id$1, String path) {
        Object object = cisInRepository$1.apply((Object)id$1);
        String string = path;
        return object == null ? string != null : !object.equals(string);
    }

    public static final /* synthetic */ boolean $anonfun$listTypePaths$3(Map cisInRepository$1, Integer id) {
        return !cisInRepository$1.keySet().contains((Object)id);
    }

    public ReportServiceImpl(ReportGenerator reportGenerator, PaginationService paginationService, CiRepository ciRepository, TaskArchive taskArchive, DownloadResource downloadResource) {
        this.reportGenerator = reportGenerator;
        this.paginationService = paginationService;
        this.ciRepository = ciRepository;
        this.taskArchive = taskArchive;
        this.downloadResource = downloadResource;
        Logging.$init$((Logging)this);
    }
}

