/*
 * Decompiled with CFR 0.152.
 */
package com.sksamuel.elastic4s.http;

import com.sksamuel.elastic4s.ElasticProperties;
import com.sksamuel.elastic4s.ElasticRequest;
import com.sksamuel.elastic4s.ElasticRequest$;
import com.sksamuel.elastic4s.HttpClient;
import com.sksamuel.elastic4s.HttpEntity;
import com.sksamuel.elastic4s.HttpResponse;
import com.sksamuel.elastic4s.Show$;
import com.sksamuel.elastic4s.http.JavaClient$;
import com.sksamuel.elastic4s.http.JavaClientExceptionWrapper;
import com.sksamuel.exts.Logging;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.util.zip.GZIPInputStream;
import org.apache.http.entity.AbstractHttpEntity;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.FileEntity;
import org.apache.http.entity.InputStreamEntity;
import org.apache.http.entity.StringEntity;
import org.elasticsearch.client.Request;
import org.elasticsearch.client.Response;
import org.elasticsearch.client.ResponseException;
import org.elasticsearch.client.ResponseListener;
import org.elasticsearch.client.RestClient;
import org.elasticsearch.client.RestClientBuilder;
import org.slf4j.Logger;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.immutable.Map;
import scala.io.Codec;
import scala.io.Codec$;
import scala.io.Source$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.Statics;
import scala.util.Either;

@ScalaSignature(bytes="\u0006\u0005\u00055c\u0001\u0002\t\u0012\u0001iA\u0001\"\n\u0001\u0003\u0002\u0003\u0006IA\n\u0005\u0006_\u0001!\t\u0001\r\u0005\u0006i\u0001!\t!\u000e\u0005\u0006\u0007\u0002!\t\u0001\u0012\u0005\u0006\u001b\u0002!\tE\u0014\u0005\u0006W\u0002!\t\u0005\u001c\u0005\u0006[\u0002!IA\\\u0004\u0006mFA\ta\u001e\u0004\u0006!EA\t\u0001\u001f\u0005\u0006_%!\ta \u0005\b\u0003\u0003IA\u0011AA\u0002\u0011\u001d\t9!\u0003C\u0001\u0003\u0013Aq!a\u0002\n\t\u0003\t)\u0002C\u0004\u0002\b%!\t!a\u000e\t\u000f\u0005\u001d\u0011\u0002\"\u0001\u0002F\tQ!*\u0019<b\u00072LWM\u001c;\u000b\u0005I\u0019\u0012\u0001\u00025uiBT!\u0001F\u000b\u0002\u0013\u0015d\u0017m\u001d;jGR\u001a(B\u0001\f\u0018\u0003!\u00198n]1nk\u0016d'\"\u0001\r\u0002\u0007\r|Wn\u0001\u0001\u0014\u0007\u0001Y\u0012\u0005\u0005\u0002\u001d?5\tQDC\u0001\u001f\u0003\u0015\u00198-\u00197b\u0013\t\u0001SD\u0001\u0004B]f\u0014VM\u001a\t\u0003E\rj\u0011aE\u0005\u0003IM\u0011!\u0002\u0013;ua\u000ec\u0017.\u001a8u\u0003\u0019\u0019G.[3oiB\u0011q%L\u0007\u0002Q)\u0011Q%\u000b\u0006\u0003U-\nQ\"\u001a7bgRL7m]3be\u000eD'\"\u0001\u0017\u0002\u0007=\u0014x-\u0003\u0002/Q\tQ!+Z:u\u00072LWM\u001c;\u0002\rqJg.\u001b;?)\t\t4\u0007\u0005\u00023\u00015\t\u0011\u0003C\u0003&\u0005\u0001\u0007a%\u0001\u0007ba\u0006\u001c\u0007.Z#oi&$\u0018\u0010\u0006\u00027\u007fA\u0011q'P\u0007\u0002q)\u0011\u0011HO\u0001\u0007K:$\u0018\u000e^=\u000b\u0005IY$B\u0001\u001f,\u0003\u0019\t\u0007/Y2iK&\u0011a\b\u000f\u0002\u0013\u0003\n\u001cHO]1di\"#H\u000f]#oi&$\u0018\u0010C\u0003:\u0007\u0001\u0007\u0001\t\u0005\u0002#\u0003&\u0011!i\u0005\u0002\u000b\u0011R$\b/\u00128uSRL\u0018\u0001\u00044s_6\u0014Vm\u001d9p]N,GCA#I!\t\u0011c)\u0003\u0002H'\ta\u0001\n\u001e;q%\u0016\u001c\bo\u001c8tK\")\u0011\n\u0002a\u0001\u0015\u0006\t!\u000f\u0005\u0002(\u0017&\u0011A\n\u000b\u0002\t%\u0016\u001c\bo\u001c8tK\u0006!1/\u001a8e)\ry%k\u0016\t\u00039AK!!U\u000f\u0003\tUs\u0017\u000e\u001e\u0005\u0006'\u0016\u0001\r\u0001V\u0001\u0004e\u0016\f\bC\u0001\u0012V\u0013\t16C\u0001\bFY\u0006\u001cH/[2SKF,Xm\u001d;\t\u000ba+\u0001\u0019A-\u0002\u0011\r\fG\u000e\u001c2bG.\u0004B\u0001\b.]\u001f&\u00111,\b\u0002\n\rVt7\r^5p]F\u0002B!X3i\u000b:\u0011al\u0019\b\u0003?\nl\u0011\u0001\u0019\u0006\u0003Cf\ta\u0001\u0010:p_Rt\u0014\"\u0001\u0010\n\u0005\u0011l\u0012a\u00029bG.\fw-Z\u0005\u0003M\u001e\u0014a!R5uQ\u0016\u0014(B\u00013\u001e!\ti\u0016.\u0003\u0002kO\nIA\u000b\u001b:po\u0006\u0014G.Z\u0001\u0006G2|7/\u001a\u000b\u0002\u001f\u0006q\u0011n]#oi&$\u0018p\u0012>ja\u0016$GCA8s!\ta\u0002/\u0003\u0002r;\t9!i\\8mK\u0006t\u0007\"B\u001d\b\u0001\u0004\u0019\bC\u0001;v\u001b\u0005Q\u0014B\u0001\";\u0003)Q\u0015M^1DY&,g\u000e\u001e\t\u0003e%\u00192!C\u000ez!\tQX0D\u0001|\u0015\taX#\u0001\u0003fqR\u001c\u0018B\u0001@|\u0005\u001daunZ4j]\u001e$\u0012a^\u0001\u000fMJ|WNU3ti\u000ec\u0017.\u001a8u)\r\t\u0014Q\u0001\u0005\u0006K-\u0001\rAJ\u0001\u0006CB\u0004H.\u001f\u000b\u0004c\u0005-\u0001bBA\u0007\u0019\u0001\u0007\u0011qB\u0001\u0006aJ|\u0007o\u001d\t\u0004E\u0005E\u0011bAA\n'\t\tR\t\\1ti&\u001c\u0007K]8qKJ$\u0018.Z:\u0015\u000bE\n9\"!\u0007\t\u000f\u00055Q\u00021\u0001\u0002\u0010!9\u00111D\u0007A\u0002\u0005u\u0011!\u0006:fcV,7\u000f^\"p]\u001aLwmQ1mY\n\f7m\u001b\t\u0005\u0003?\t\tD\u0004\u0003\u0002\"\u00055b\u0002BA\u0012\u0003WqA!!\n\u0002*9\u0019q,a\n\n\u00031J!AK\u0016\n\u0005\u0015J\u0013bAA\u0018Q\u0005\t\"+Z:u\u00072LWM\u001c;Ck&dG-\u001a:\n\t\u0005M\u0012Q\u0007\u0002\u0016%\u0016\fX/Z:u\u0007>tg-[4DC2d'-Y2l\u0015\r\ty\u0003\u000b\u000b\u0006c\u0005e\u00121\b\u0005\b\u0003\u001bq\u0001\u0019AA\b\u0011\u001d\tiD\u0004a\u0001\u0003\u007f\t\u0001\u0004\u001b;ua\u000ec\u0017.\u001a8u\u0007>tg-[4DC2d'-Y2l!\u0011\ty\"!\u0011\n\t\u0005\r\u0013Q\u0007\u0002\u0019\u0011R$\bo\u00117jK:$8i\u001c8gS\u001e\u001c\u0015\r\u001c7cC\u000e\\GcB\u0019\u0002H\u0005%\u00131\n\u0005\b\u0003\u001by\u0001\u0019AA\b\u0011\u001d\tYb\u0004a\u0001\u0003;Aq!!\u0010\u0010\u0001\u0004\ty\u0004")
public class JavaClient
implements HttpClient {
    private final RestClient client;
    private Logger logger;

    public static JavaClient apply(ElasticProperties elasticProperties, RestClientBuilder.RequestConfigCallback requestConfigCallback, RestClientBuilder.HttpClientConfigCallback httpClientConfigCallback) {
        return JavaClient$.MODULE$.apply(elasticProperties, requestConfigCallback, httpClientConfigCallback);
    }

    public static JavaClient apply(ElasticProperties elasticProperties, RestClientBuilder.HttpClientConfigCallback httpClientConfigCallback) {
        return JavaClient$.MODULE$.apply(elasticProperties, httpClientConfigCallback);
    }

    public static JavaClient apply(ElasticProperties elasticProperties, RestClientBuilder.RequestConfigCallback requestConfigCallback) {
        return JavaClient$.MODULE$.apply(elasticProperties, requestConfigCallback);
    }

    public static JavaClient apply(ElasticProperties elasticProperties) {
        return JavaClient$.MODULE$.apply(elasticProperties);
    }

    public static JavaClient fromRestClient(RestClient restClient) {
        return JavaClient$.MODULE$.fromRestClient(restClient);
    }

    public Logger logger() {
        return this.logger;
    }

    public void com$sksamuel$exts$Logging$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    public AbstractHttpEntity apacheEntity(HttpEntity entity) {
        ByteArrayEntity byteArrayEntity;
        HttpEntity httpEntity = entity;
        if (httpEntity instanceof HttpEntity.StringEntity) {
            HttpEntity.StringEntity stringEntity = (HttpEntity.StringEntity)httpEntity;
            this.logger().debug(stringEntity.content());
            byteArrayEntity = new StringEntity(stringEntity.content(), ContentType.APPLICATION_JSON);
        } else if (httpEntity instanceof HttpEntity.ByteArrayEntity) {
            HttpEntity.ByteArrayEntity byteArrayEntity2 = (HttpEntity.ByteArrayEntity)httpEntity;
            byteArrayEntity = new ByteArrayEntity(byteArrayEntity2.content(), ContentType.APPLICATION_JSON);
        } else if (httpEntity instanceof HttpEntity.InputStreamEntity) {
            HttpEntity.InputStreamEntity inputStreamEntity = (HttpEntity.InputStreamEntity)httpEntity;
            this.logger().debug(inputStreamEntity.content().toString());
            byteArrayEntity = new InputStreamEntity(inputStreamEntity.content(), ContentType.APPLICATION_JSON);
        } else if (httpEntity instanceof HttpEntity.FileEntity) {
            HttpEntity.FileEntity fileEntity = (HttpEntity.FileEntity)httpEntity;
            this.logger().debug(fileEntity.content().toString());
            byteArrayEntity = new FileEntity(fileEntity.content(), ContentType.APPLICATION_JSON);
        } else {
            throw new MatchError((Object)httpEntity);
        }
        return byteArrayEntity;
    }

    public HttpResponse fromResponse(Response r) {
        Option entity2 = Option$.MODULE$.apply((Object)r.getEntity()).map((Function1 & Serializable)entity -> {
            Charset contentCharset = (Charset)Option$.MODULE$.apply((Object)ContentType.get((org.apache.http.HttpEntity)entity)).fold((Function0 & Serializable)() -> Charset.forName("UTF-8"), (Function1 & Serializable)x$1 -> x$1.getCharset());
            Codec codec = Codec$.MODULE$.apply(contentCharset);
            InputStream contentStream = this.isEntityGziped((org.apache.http.HttpEntity)entity) ? new GZIPInputStream(entity.getContent()) : entity.getContent();
            String body = Source$.MODULE$.fromInputStream(contentStream, codec).mkString();
            return new HttpEntity.StringEntity(body, (Option)new Some((Object)contentCharset.name()));
        });
        Map headers = Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])r.getHeaders()), (Function1 & Serializable)header -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)header.getName()), (Object)header.getValue()), ClassTag$.MODULE$.apply(Tuple2.class))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        this.logger().debug("Http Response {}", (Object)r);
        return new HttpResponse(r.getStatusLine().getStatusCode(), entity2, headers);
    }

    public void send(ElasticRequest req, Function1<Either<Throwable, HttpResponse>, BoxedUnit> callback) {
        if (this.logger().isDebugEnabled()) {
            this.logger().debug("Executing elastic request {}", (Object)Show$.MODULE$.apply(ElasticRequest$.MODULE$.ElasticRequestShow()).show((Object)req));
        }
        ResponseListener l = new ResponseListener(this, callback){
            private final /* synthetic */ JavaClient $outer;
            private final Function1 callback$1;

            public void onSuccess(Response r) {
                this.callback$1.apply((Object)package$.MODULE$.Right().apply((Object)this.$outer.fromResponse(r)));
            }

            public void onFailure(Exception e) {
                Exception exception = e;
                if (exception instanceof ResponseException) {
                    ResponseException responseException = (ResponseException)exception;
                    BoxedUnit boxedUnit = (BoxedUnit)this.callback$1.apply((Object)package$.MODULE$.Right().apply((Object)this.$outer.fromResponse(responseException.getResponse())));
                } else {
                    BoxedUnit boxedUnit = (BoxedUnit)this.callback$1.apply((Object)package$.MODULE$.Left().apply((Object)new JavaClientExceptionWrapper(exception)));
                }
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.callback$1 = callback$1;
            }
        };
        Request request = new Request(req.method(), req.endpoint());
        req.params().foreach((Function1 & Serializable)x0$1 -> {
            JavaClient.$anonfun$send$1(request, x0$1);
            return BoxedUnit.UNIT;
        });
        req.entity().map((Function1 & Serializable)entity -> this.apacheEntity((HttpEntity)entity)).foreach((Function1 & Serializable)x$1 -> {
            request.setEntity(x$1);
            return BoxedUnit.UNIT;
        });
        this.client.performRequestAsync(request, l);
    }

    public void close() {
        this.client.close();
    }

    private boolean isEntityGziped(org.apache.http.HttpEntity entity) {
        return Option$.MODULE$.apply((Object)entity.getContentEncoding()).flatMap((Function1 & Serializable)x -> Option$.MODULE$.apply((Object)x.getValue())).contains((Object)"gzip");
    }

    public static final /* synthetic */ void $anonfun$send$1(Request request$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String key = (String)tuple2._1();
        String value = (String)tuple2._2();
        request$1.addParameter(key, value);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public JavaClient(RestClient client) {
        this.client = client;
        Logging.$init$((Logging)this);
        Statics.releaseFence();
    }
}

