/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.taskexecution.security;

import com.xebialabs.deployit.exception.NotFoundException;
import com.xebialabs.deployit.security.authentication.AuthenticationFailureException;
import com.xebialabs.deployit.taskexecution.security.TaskWorkerAuthenticationToken;
import java.util.Collection;
import java.util.Collections;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.authority.mapping.GrantedAuthoritiesMapper;
import org.springframework.security.core.authority.mapping.NullAuthoritiesMapper;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.stereotype.Component;

@Component
public class TaskWorkerAuthenticationProvider
implements AuthenticationProvider {
    private static final Logger logger = LoggerFactory.getLogger(TaskWorkerAuthenticationProvider.class);
    private final UserDetailsService userDetailsService;
    private final GrantedAuthoritiesMapper authoritiesMapper = new NullAuthoritiesMapper();

    @Autowired
    public TaskWorkerAuthenticationProvider(UserDetailsService userDetailsService) {
        this.userDetailsService = userDetailsService;
    }

    public Authentication authenticate(Authentication authentication) throws AuthenticationException {
        TaskWorkerAuthenticationToken tokenContainer = (TaskWorkerAuthenticationToken)authentication;
        String taskOwner = (String)tokenContainer.getCredentials();
        if (StringUtils.isNotBlank((String)taskOwner)) {
            logger.debug("Received Task-Owner {}", (Object)taskOwner);
            try {
                Collection mappedAuthorities = "admin".equals(taskOwner) ? this.authoritiesMapper.mapAuthorities(Collections.singletonList(new SimpleGrantedAuthority("ROLE_ADMIN"))) : this.userDetailsService.loadUserByUsername(taskOwner).getAuthorities();
                return new TaskWorkerAuthenticationToken(taskOwner, mappedAuthorities);
            }
            catch (NotFoundException | AuthenticationFailureException | UsernameNotFoundException exc) {
                throw new BadCredentialsException("Cannot authenticate " + taskOwner, exc);
            }
        }
        return null;
    }

    public boolean supports(Class<?> authentication) {
        return authentication.isAssignableFrom(TaskWorkerAuthenticationToken.class);
    }
}

