/*
 * Decompiled with CFR 0.152.
 */
package akka.http.shaded.com.twitter.hpack;

import akka.http.shaded.com.twitter.hpack.HeaderField;

final class DynamicTable {
    HeaderField[] headerFields;
    int head;
    int tail;
    private int size;
    private int capacity = -1;

    DynamicTable(int n) {
        this.setCapacity(n);
    }

    public int length() {
        int n = this.head < this.tail ? this.headerFields.length - this.tail + this.head : this.head - this.tail;
        return n;
    }

    public int size() {
        return this.size;
    }

    public int capacity() {
        return this.capacity;
    }

    public HeaderField getEntry(int n) {
        if (n <= 0 || n > this.length()) {
            throw new IndexOutOfBoundsException();
        }
        int n2 = this.head - n;
        if (n2 < 0) {
            return this.headerFields[n2 + this.headerFields.length];
        }
        return this.headerFields[n2];
    }

    public void add(HeaderField headerField) {
        int n = headerField.size();
        if (n > this.capacity) {
            this.clear();
            return;
        }
        while (this.size + n > this.capacity) {
            this.remove();
        }
        this.headerFields[this.head++] = headerField;
        this.size += headerField.size();
        if (this.head == this.headerFields.length) {
            this.head = 0;
        }
    }

    public HeaderField remove() {
        HeaderField headerField = this.headerFields[this.tail];
        if (headerField == null) {
            return null;
        }
        this.size -= headerField.size();
        this.headerFields[this.tail++] = null;
        if (this.tail == this.headerFields.length) {
            this.tail = 0;
        }
        return headerField;
    }

    public void clear() {
        while (this.tail != this.head) {
            this.headerFields[this.tail++] = null;
            if (this.tail != this.headerFields.length) continue;
            this.tail = 0;
        }
        this.head = 0;
        this.tail = 0;
        this.size = 0;
    }

    public void setCapacity(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("Illegal Capacity: " + n);
        }
        if (this.capacity == n) {
            return;
        }
        this.capacity = n;
        if (n == 0) {
            this.clear();
        } else {
            while (this.size > n) {
                this.remove();
            }
        }
        int n2 = n / 32;
        if (n % 32 != 0) {
            ++n2;
        }
        if (this.headerFields != null && this.headerFields.length == n2) {
            return;
        }
        HeaderField[] headerFieldArray = new HeaderField[n2];
        int n3 = this.length();
        int n4 = this.tail;
        for (int i = 0; i < n3; ++i) {
            HeaderField headerField;
            headerFieldArray[i] = headerField = this.headerFields[n4++];
            if (n4 != this.headerFields.length) continue;
            n4 = 0;
        }
        this.tail = 0;
        this.head = this.tail + n3;
        this.headerFields = headerFieldArray;
    }
}

