/*
 * Decompiled with CFR 0.152.
 */
package org.python.modules;

import java.math.BigInteger;
import org.python.core.ClassDictInit;
import org.python.core.Py;
import org.python.core.PyException;
import org.python.core.PyFloat;
import org.python.core.PyInteger;
import org.python.core.PyLong;
import org.python.core.PyObject;
import org.python.core.PyTuple;
import org.python.core.__builtin__;
import org.python.modules.math_erf;
import org.python.modules.math_gamma;

public class math
implements ClassDictInit {
    public static PyFloat pi = new PyFloat(Math.PI);
    public static PyFloat e = new PyFloat(Math.E);
    private static final double ZERO = 0.0;
    private static final double MINUS_ZERO = -0.0;
    private static final double ONE = 1.0;
    private static final double MINUS_ONE = -1.0;
    private static final double TWO = 2.0;
    private static final double EIGHT = 8.0;
    static final double LN2 = 0.6931471805599453;
    private static final double INF = Double.POSITIVE_INFINITY;
    private static final double NINF = Double.NEGATIVE_INFINITY;
    private static final double NAN = Double.NaN;
    private static final BigInteger MAX_LONG_BIGINTEGER = new BigInteger(String.valueOf(Long.MAX_VALUE));
    private static final BigInteger MIN_LONG_BIGINTEGER = new BigInteger(String.valueOf(Long.MIN_VALUE));

    public static void classDictInit(PyObject dict) {
    }

    public static double gamma(double v) {
        return math_gamma.gamma(v);
    }

    public static double lgamma(double v) {
        return math_gamma.lgamma(v);
    }

    public static double erf(double v) {
        return math_erf.erf(v);
    }

    public static double erfc(double v) {
        return math_erf.erfc(v);
    }

    public static double expm1(double v) {
        if (Double.POSITIVE_INFINITY == v) {
            return v;
        }
        double result2 = Math.expm1(v);
        if (Double.isInfinite(result2)) {
            throw Py.OverflowError(Double.toString(v));
        }
        return result2;
    }

    public static double acos(double v) {
        return math.exceptNaN(Math.acos(v), v);
    }

    public static double acosh(double y) {
        if (y < 1.0) {
            throw math.mathDomainError();
        }
        if (y < 2.0) {
            double u = y - 1.0;
            double s = Math.sqrt(u * (2.0 + u));
            return Math.log1p(u + s);
        }
        if (y < 1.34217728E8) {
            double u = 1.0 / y;
            double t = Math.sqrt((1.0 + u) * (1.0 - u));
            return Math.log(y * (1.0 + t));
        }
        return Math.log(y) + 0.6931471805599453;
    }

    public static double asin(double v) {
        return math.exceptNaN(Math.asin(v), v);
    }

    public static double asinh(double v) {
        if (math.isnan(v) || math.isinf(v)) {
            return v;
        }
        double ln2 = 0.6931471805599453;
        double large = 2.68435456E8;
        double small = 3.725290298461914E-9;
        boolean sign = false;
        if (v < 0.0) {
            v = -v;
            sign = true;
        }
        double temp = v > 2.68435456E8 ? math.log(v) + 0.6931471805599453 : (v > 2.0 ? math.log(2.0 * v + 1.0 / (math.sqrt(v * v + 1.0) + v)) : (v < 3.725290298461914E-9 ? v : math.log1p(v + v * v / (1.0 + math.sqrt(1.0 + v * v)))));
        return sign ? -temp : temp;
    }

    public static double atan(double v) {
        return math.exceptNaN(Math.atan(v), v);
    }

    public static double atanh(double y) {
        double absy = Math.abs(y);
        if (absy >= 1.0) {
            throw math.mathDomainError();
        }
        double u = (absy + absy) / (1.0 - absy);
        double x = 0.5 * Math.log1p(u);
        return Math.copySign(x, y);
    }

    public static double atan2(double v, double w) {
        return Math.atan2(v, w);
    }

    public static double ceil(PyObject v) {
        return math.ceil(v.asDouble());
    }

    public static double ceil(double v) {
        return Math.ceil(v);
    }

    public static double cos(double v) {
        return math.exceptNaN(Math.cos(v), v);
    }

    public static double cosh(double v) {
        return math.exceptInf(Math.cosh(v), v);
    }

    public static double exp(double v) {
        return math.exceptInf(Math.exp(v), v);
    }

    public static double floor(PyObject v) {
        return math.floor(v.asDouble());
    }

    public static double floor(double v) {
        return Math.floor(v);
    }

    public static double log(PyObject v) {
        return math.log(v, null);
    }

    public static double log(PyObject v, PyObject base2) {
        double doubleValue = v instanceof PyLong ? math.calculateLongLog((PyLong)v) : math.log(v.asDouble());
        return base2 == null ? doubleValue : math.applyLoggedBase(doubleValue, base2);
    }

    public static double pow(double v, double w) {
        if (w == 0.0) {
            return 1.0;
        }
        if (v == 1.0) {
            return v;
        }
        if (math.isnan(v) || math.isnan(w)) {
            return Double.NaN;
        }
        if (v == 0.0) {
            if (w == 0.0) {
                return 1.0;
            }
            if (w > 0.0 || math.ispinf(w)) {
                return 0.0;
            }
            throw math.mathDomainError();
        }
        if (math.isninf(v)) {
            if (math.isninf(w)) {
                return 0.0;
            }
            if (math.isinf(w)) {
                return Double.POSITIVE_INFINITY;
            }
            if (w == 0.0) {
                return 1.0;
            }
            if (w > 0.0) {
                if (math.isOdd(w)) {
                    return Double.NEGATIVE_INFINITY;
                }
                return Double.POSITIVE_INFINITY;
            }
            if (math.isOdd(w)) {
                return -0.0;
            }
            return 0.0;
        }
        if (math.isninf(w) && v < 0.0) {
            if (v == -1.0) {
                return 1.0;
            }
            if (v < -1.0) {
                return 0.0;
            }
            return Double.POSITIVE_INFINITY;
        }
        if (math.ispinf(w) && v < 0.0) {
            if (v == -1.0) {
                return 1.0;
            }
            if (v < -1.0) {
                return Double.POSITIVE_INFINITY;
            }
            return 0.0;
        }
        if (v < 0.0 && !math.isIntegral(w)) {
            throw math.mathDomainError();
        }
        return Math.pow(v, w);
    }

    public static double sin(PyObject v) {
        return math.sin(v.asDouble());
    }

    public static double sin(double v) {
        return math.exceptNaN(Math.sin(v), v);
    }

    public static double sqrt(PyObject v) {
        return math.sqrt(v.asDouble());
    }

    public static double sqrt(double v) {
        return math.exceptNaN(Math.sqrt(v), v);
    }

    public static double tan(double v) {
        return math.exceptNaN(Math.tan(v), v);
    }

    public static double log10(PyObject v) {
        if (v instanceof PyLong) {
            int[] exp = new int[1];
            double x = ((PyLong)v).scaledDoubleValue(exp);
            if (x <= 0.0) {
                throw math.mathDomainError();
            }
            return math.log10(x) + (double)exp[0] * 8.0 * math.log10(2.0);
        }
        return math.log10(v.asDouble());
    }

    public static double sinh(double v) {
        return math.exceptInf(Math.sinh(v), v);
    }

    public static double tanh(double v) {
        return math.exceptInf(Math.tanh(v), v);
    }

    public static double fabs(double v) {
        return Math.abs(v);
    }

    public static double fmod(double v, double w) {
        if (math.isnan(v) || math.isnan(w)) {
            return Double.NaN;
        }
        if (math.isinf(w)) {
            return v;
        }
        if (w == 0.0) {
            throw math.mathDomainError();
        }
        if (math.isinf(v) && w == 1.0) {
            throw math.mathDomainError();
        }
        return v % w;
    }

    public static PyTuple modf(double v) {
        if (math.isnan(v)) {
            return new PyTuple(new PyFloat(v), new PyFloat(v));
        }
        if (math.isinf(v)) {
            double first = 0.0;
            if (math.isninf(v)) {
                first = -0.0;
            }
            return new PyTuple(new PyFloat(first), new PyFloat(v));
        }
        double w = v % 1.0;
        return new PyTuple(new PyFloat(w), new PyFloat(v -= w));
    }

    public static PyTuple frexp(double x) {
        double mantissa;
        int exponent = Math.getExponent(x);
        switch (exponent) {
            default: {
                mantissa = Math.scalb(x, -(++exponent));
                break;
            }
            case 1024: {
                mantissa = x;
                exponent = 0;
                break;
            }
            case -1023: {
                if (x == 0.0) {
                    mantissa = x;
                    exponent = 0;
                    break;
                }
                exponent = Math.getExponent(x * 4.503599627370496E15) - 51;
                mantissa = Math.scalb(x, -exponent);
            }
        }
        return new PyTuple(new PyFloat(mantissa), new PyInteger(exponent));
    }

    public static PyObject trunc(PyObject number) {
        return number.__getattr__("__trunc__").__call__();
    }

    public static double ldexp(double v, PyObject wObj) {
        long w = math.getLong(wObj);
        if (w < Integer.MIN_VALUE) {
            w = Integer.MIN_VALUE;
        } else if (w > Integer.MAX_VALUE) {
            w = Integer.MAX_VALUE;
        }
        return math.exceptInf(Math.scalb(v, (int)w), v);
    }

    public static double hypot(double x, double y) {
        double mag = Math.hypot(x, y);
        if (Double.isInfinite(mag) && !Double.isInfinite(x) && !Double.isInfinite(y)) {
            throw math.mathRangeError();
        }
        return mag;
    }

    public static double radians(double v) {
        return Math.toRadians(v);
    }

    public static double degrees(double v) {
        return Math.toDegrees(v);
    }

    public static boolean isnan(double v) {
        return Double.isNaN(v);
    }

    public static boolean isinf(double v) {
        return Double.isInfinite(v);
    }

    public static double copysign(double v, double w) {
        return Math.copySign(v, w);
    }

    public static PyLong factorial(double v) {
        if (v == 0.0 || v == 1.0) {
            return new PyLong(1L);
        }
        if (v < 0.0 || math.isnan(v) || math.isinf(v)) {
            throw math.mathDomainError();
        }
        if (!math.isIntegral(v)) {
            throw math.mathDomainError();
        }
        long value = (long)v;
        BigInteger bi = new BigInteger(Long.toString(value));
        for (long l = value - 1L; l > 1L; --l) {
            bi = bi.multiply(new BigInteger(Long.toString(l)));
        }
        return new PyLong(bi);
    }

    public static double log1p(double v) {
        if (v <= -1.0) {
            throw math.mathDomainError();
        }
        return Math.log1p(v);
    }

    public static double fsum(PyObject iterable) {
        PyFloat result2 = (PyFloat)__builtin__.__import__("_fsum").invoke("fsum", iterable);
        return result2.asDouble();
    }

    private static double calculateLongLog(PyLong v) {
        int[] exp = new int[1];
        double x = v.scaledDoubleValue(exp);
        if (x <= 0.0) {
            throw math.mathDomainError();
        }
        return math.log(x) + (double)exp[0] * 8.0 * math.log(2.0);
    }

    private static double applyLoggedBase(double loggedValue, PyObject base2) {
        double loggedBase = base2 instanceof PyLong ? math.calculateLongLog((PyLong)base2) : math.log(base2.asDouble());
        return loggedValue / loggedBase;
    }

    private static double log(double v) {
        if (v <= 0.0) {
            throw math.mathDomainError();
        }
        return Math.log(v);
    }

    private static double log10(double v) {
        if (v <= 0.0) {
            throw math.mathDomainError();
        }
        return Math.log10(v);
    }

    private static boolean isninf(double v) {
        return v == Double.NEGATIVE_INFINITY;
    }

    private static boolean ispinf(double v) {
        return v == Double.POSITIVE_INFINITY;
    }

    static PyException mathDomainError() {
        return Py.ValueError("math domain error");
    }

    static PyException mathRangeError() {
        return Py.OverflowError("math range error");
    }

    private static double exceptNaN(double result2, double arg) throws PyException {
        if (Double.isNaN(result2) && !Double.isNaN(arg)) {
            throw math.mathDomainError();
        }
        return result2;
    }

    private static double exceptInf(double result2, double arg) {
        if (Double.isInfinite(result2) && !Double.isInfinite(arg)) {
            throw math.mathRangeError();
        }
        return result2;
    }

    private static long getLong(PyObject pyo) {
        if (pyo instanceof PyLong) {
            return math.getLong((PyLong)pyo);
        }
        return pyo.asLong();
    }

    private static long getLong(PyLong pyLong) {
        BigInteger value = pyLong.getValue();
        if (value.compareTo(MAX_LONG_BIGINTEGER) > 0) {
            return Long.MAX_VALUE;
        }
        if (value.compareTo(MIN_LONG_BIGINTEGER) < 0) {
            return Long.MIN_VALUE;
        }
        return value.longValue();
    }

    private static boolean isIntegral(double v) {
        return math.ceil(v) - v == 0.0;
    }

    private static boolean isOdd(double v) {
        return math.isIntegral(v) && v % 2.0 != 0.0;
    }
}

