/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.transform.sc.transformers;

import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.FieldNode;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.PropertyExpression;
import org.codehaus.groovy.ast.expr.VariableExpression;
import org.codehaus.groovy.ast.tools.GeneralUtils;
import org.codehaus.groovy.transform.sc.StaticCompilationMetadataKeys;
import org.codehaus.groovy.transform.stc.StaticTypesMarker;

public class VariableExpressionTransformer {
    public Expression transformVariableExpression(VariableExpression expr) {
        Expression trn = VariableExpressionTransformer.tryTransformDelegateToProperty(expr);
        if (trn == null) {
            trn = VariableExpressionTransformer.tryTransformPrivateFieldAccess(expr);
        }
        return trn != null ? trn : expr;
    }

    private static Expression tryTransformDelegateToProperty(VariableExpression expr) {
        Object val = expr.getNodeMetaData((Object)StaticTypesMarker.IMPLICIT_RECEIVER);
        if (val == null || val.equals(expr.getName())) {
            return null;
        }
        VariableExpression receiver = GeneralUtils.varX("owner".equals(val) ? (String)val : ("delegate".equals(val) ? (String)val : "this"));
        receiver.setLineNumber(expr.getLineNumber());
        receiver.setColumnNumber(expr.getColumnNumber());
        PropertyExpression pexp = GeneralUtils.propX((Expression)receiver, expr.getName());
        pexp.getProperty().setSourcePosition(expr);
        pexp.copyNodeMetaData(expr);
        pexp.setImplicitThis(true);
        ClassNode owner = (ClassNode)expr.getNodeMetaData((Object)StaticCompilationMetadataKeys.PROPERTY_OWNER);
        if (owner != null) {
            receiver.putNodeMetaData((Object)StaticTypesMarker.INFERRED_TYPE, owner);
            receiver.putNodeMetaData((Object)StaticTypesMarker.IMPLICIT_RECEIVER, val);
        }
        pexp.removeNodeMetaData((Object)StaticTypesMarker.IMPLICIT_RECEIVER);
        return pexp;
    }

    private static Expression tryTransformPrivateFieldAccess(VariableExpression expr) {
        FieldNode field = (FieldNode)expr.getNodeMetaData((Object)StaticTypesMarker.PV_FIELDS_ACCESS);
        if (field == null) {
            field = (FieldNode)expr.getNodeMetaData((Object)StaticTypesMarker.PV_FIELDS_MUTATION);
        }
        if (field != null) {
            PropertyExpression pexp = !field.isStatic() ? GeneralUtils.thisPropX(true, expr.getName()) : GeneralUtils.propX((Expression)GeneralUtils.classX(field.getDeclaringClass()), expr.getName());
            pexp.getObjectExpression().putNodeMetaData((Object)StaticTypesMarker.INFERRED_TYPE, field.getDeclaringClass());
            pexp.putNodeMetaData((Object)StaticTypesMarker.DECLARATION_INFERRED_TYPE, field.getOriginType());
            pexp.getProperty().setSourcePosition(expr);
            return pexp;
        }
        return null;
    }
}

