/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.marketplacemetering.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.marketplacemetering.model.Tag;
import com.amazonaws.services.marketplacemetering.model.transform.UsageAllocationMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class UsageAllocation
implements Serializable,
Cloneable,
StructuredPojo {
    private Integer allocatedUsageQuantity;
    private List<Tag> tags;

    public void setAllocatedUsageQuantity(Integer allocatedUsageQuantity) {
        this.allocatedUsageQuantity = allocatedUsageQuantity;
    }

    public Integer getAllocatedUsageQuantity() {
        return this.allocatedUsageQuantity;
    }

    public UsageAllocation withAllocatedUsageQuantity(Integer allocatedUsageQuantity) {
        this.setAllocatedUsageQuantity(allocatedUsageQuantity);
        return this;
    }

    public List<Tag> getTags() {
        return this.tags;
    }

    public void setTags(Collection<Tag> tags) {
        if (tags == null) {
            this.tags = null;
            return;
        }
        this.tags = new ArrayList<Tag>(tags);
    }

    public UsageAllocation withTags(Tag ... tags) {
        if (this.tags == null) {
            this.setTags(new ArrayList<Tag>(tags.length));
        }
        for (Tag ele : tags) {
            this.tags.add(ele);
        }
        return this;
    }

    public UsageAllocation withTags(Collection<Tag> tags) {
        this.setTags(tags);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getAllocatedUsageQuantity() != null) {
            sb.append("AllocatedUsageQuantity: ").append(this.getAllocatedUsageQuantity()).append(",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: ").append(this.getTags());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UsageAllocation)) {
            return false;
        }
        UsageAllocation other = (UsageAllocation)obj;
        if (other.getAllocatedUsageQuantity() == null ^ this.getAllocatedUsageQuantity() == null) {
            return false;
        }
        if (other.getAllocatedUsageQuantity() != null && !other.getAllocatedUsageQuantity().equals(this.getAllocatedUsageQuantity())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        return other.getTags() == null || other.getTags().equals(this.getTags());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getAllocatedUsageQuantity() == null ? 0 : this.getAllocatedUsageQuantity().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        return hashCode;
    }

    public UsageAllocation clone() {
        try {
            return (UsageAllocation)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        UsageAllocationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

