/*
 * Decompiled with CFR 0.152.
 */
package liquibase.pro.packaged;

import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Arrays;
import liquibase.pro.packaged.aA;
import liquibase.pro.packaged.aC;
import liquibase.pro.packaged.aD;
import liquibase.pro.packaged.aE;
import liquibase.pro.packaged.aI;
import liquibase.pro.packaged.aM;
import liquibase.pro.packaged.aU;
import liquibase.pro.packaged.an;
import liquibase.pro.packaged.bF;
import liquibase.pro.packaged.bH;
import liquibase.pro.packaged.bL;
import liquibase.pro.packaged.ba;
import liquibase.pro.packaged.bq;
import liquibase.pro.packaged.bs;
import liquibase.pro.packaged.bx;
import liquibase.pro.packaged.ce;
import liquibase.pro.packaged.cn;
import liquibase.pro.packaged.ct;

public abstract class aZ
extends ba {
    protected static final cn<aM> JSON_READ_CAPABILITIES = DEFAULT_READ_CAPABILITIES;
    protected final bs _ioContext;
    protected boolean _closed;
    protected int _inputPtr;
    protected int _inputEnd;
    protected long _currInputProcessed;
    protected int _currInputRow = 1;
    protected int _currInputRowStart;
    protected long _tokenInputTotal;
    protected int _tokenInputRow = 1;
    protected int _tokenInputCol;
    protected bH _parsingContext;
    protected aI _nextToken;
    protected final ct _textBuffer;
    protected char[] _nameCopyBuffer;
    protected boolean _nameCopied;
    protected ce _byteArrayBuilder;
    protected byte[] _binaryValue;
    protected int _numTypesValid = 0;
    protected int _numberInt;
    protected long _numberLong;
    protected double _numberDouble;
    protected BigInteger _numberBigInt;
    protected BigDecimal _numberBigDecimal;
    protected boolean _numberNegative;
    protected int _intLength;
    protected int _fractLength;
    protected int _expLength;

    protected aZ(bs object, int n2) {
        super(n2);
        this._ioContext = object;
        this._textBuffer = ((bs)object).constructTextBuffer();
        object = aD.STRICT_DUPLICATE_DETECTION.enabledIn(n2) ? bF.rootDetector(this) : null;
        this._parsingContext = bH.createRootContext((bF)object);
    }

    @Override
    public aU version() {
        return bL.VERSION;
    }

    @Override
    public Object getCurrentValue() {
        return this._parsingContext.getCurrentValue();
    }

    @Override
    public void setCurrentValue(Object object) {
        this._parsingContext.setCurrentValue(object);
    }

    @Override
    public aC enable(aD aD2) {
        this._features |= aD2.getMask();
        if (aD2 == aD.STRICT_DUPLICATE_DETECTION && this._parsingContext.getDupDetector() == null) {
            this._parsingContext = this._parsingContext.withDupDetector(bF.rootDetector(this));
        }
        return this;
    }

    @Override
    public aC disable(aD aD2) {
        this._features &= ~aD2.getMask();
        if (aD2 == aD.STRICT_DUPLICATE_DETECTION) {
            this._parsingContext = this._parsingContext.withDupDetector(null);
        }
        return this;
    }

    @Override
    @Deprecated
    public aC setFeatureMask(int n2) {
        int n3 = this._features ^ n2;
        if (n3 != 0) {
            this._features = n2;
            this._checkStdFeatureChanges(n2, n3);
        }
        return this;
    }

    @Override
    public aC overrideStdFeatures(int n2, int n3) {
        int n4 = this._features;
        if ((n3 = n4 ^ (n2 = n4 & ~n3 | n2 & n3)) != 0) {
            this._features = n2;
            this._checkStdFeatureChanges(n2, n3);
        }
        return this;
    }

    protected void _checkStdFeatureChanges(int n2, int n3) {
        int n4 = aD.STRICT_DUPLICATE_DETECTION.getMask();
        if ((n3 & n4) != 0 && (n2 & n4) != 0) {
            if (this._parsingContext.getDupDetector() == null) {
                this._parsingContext = this._parsingContext.withDupDetector(bF.rootDetector(this));
                return;
            }
            this._parsingContext = this._parsingContext.withDupDetector(null);
        }
    }

    @Override
    public String getCurrentName() {
        bH bH2;
        if ((this._currToken == aI.START_OBJECT || this._currToken == aI.START_ARRAY) && (bH2 = this._parsingContext.getParent()) != null) {
            return bH2.getCurrentName();
        }
        return this._parsingContext.getCurrentName();
    }

    @Override
    public void overrideCurrentName(String string) {
        bH bH2 = this._parsingContext;
        if (this._currToken == aI.START_OBJECT || this._currToken == aI.START_ARRAY) {
            bH2 = bH2.getParent();
        }
        try {
            bH2.setCurrentName(string);
            return;
        }
        catch (IOException iOException) {
            throw new IllegalStateException(iOException);
        }
    }

    @Override
    public void close() {
        if (!this._closed) {
            this._inputPtr = Math.max(this._inputPtr, this._inputEnd);
            this._closed = true;
            try {
                this._closeInput();
                return;
            }
            finally {
                this._releaseBuffers();
            }
        }
    }

    @Override
    public boolean isClosed() {
        return this._closed;
    }

    @Override
    public bH getParsingContext() {
        return this._parsingContext;
    }

    @Override
    public aA getTokenLocation() {
        return new aA(this._contentReference(), -1L, this.getTokenCharacterOffset(), this.getTokenLineNr(), this.getTokenColumnNr());
    }

    @Override
    public aA getCurrentLocation() {
        int n2 = this._inputPtr - this._currInputRowStart + 1;
        return new aA(this._contentReference(), -1L, this._currInputProcessed + (long)this._inputPtr, this._currInputRow, n2);
    }

    @Override
    public boolean hasTextCharacters() {
        if (this._currToken == aI.VALUE_STRING) {
            return true;
        }
        if (this._currToken == aI.FIELD_NAME) {
            return this._nameCopied;
        }
        return false;
    }

    @Override
    public byte[] getBinaryValue(an an2) {
        if (this._binaryValue == null) {
            if (this._currToken != aI.VALUE_STRING) {
                this._reportError("Current token (" + (Object)((Object)this._currToken) + ") not VALUE_STRING, can not access as binary");
            }
            ce ce2 = this._getByteArrayBuilder();
            aZ aZ2 = this;
            aZ2._decodeBase64(aZ2.getText(), ce2, an2);
            this._binaryValue = ce2.toByteArray();
        }
        return this._binaryValue;
    }

    public long getTokenCharacterOffset() {
        return this._tokenInputTotal;
    }

    public int getTokenLineNr() {
        return this._tokenInputRow;
    }

    public int getTokenColumnNr() {
        int n2 = this._tokenInputCol;
        if (n2 < 0) {
            return n2;
        }
        return n2 + 1;
    }

    protected abstract void _closeInput();

    protected void _releaseBuffers() {
        this._textBuffer.releaseBuffers();
        char[] cArray = this._nameCopyBuffer;
        if (this._nameCopyBuffer != null) {
            this._nameCopyBuffer = null;
            this._ioContext.releaseNameCopyBuffer(cArray);
        }
    }

    @Override
    protected void _handleEOF() {
        if (!this._parsingContext.inRoot()) {
            String string = this._parsingContext.inArray() ? "Array" : "Object";
            this._reportInvalidEOF(String.format(": expected close marker for %s (start marker at %s)", string, this._parsingContext.startLocation(this._contentReference())), null);
        }
    }

    protected final int _eofAsNextChar() {
        this._handleEOF();
        return -1;
    }

    public ce _getByteArrayBuilder() {
        if (this._byteArrayBuilder == null) {
            this._byteArrayBuilder = new ce();
        } else {
            this._byteArrayBuilder.reset();
        }
        return this._byteArrayBuilder;
    }

    protected final aI reset(boolean bl2, int n2, int n3, int n4) {
        if (n3 <= 0 && n4 <= 0) {
            return this.resetInt(bl2, n2);
        }
        return this.resetFloat(bl2, n2, n3, n4);
    }

    protected final aI resetInt(boolean bl2, int n2) {
        this._numberNegative = bl2;
        this._intLength = n2;
        this._fractLength = 0;
        this._expLength = 0;
        this._numTypesValid = 0;
        return aI.VALUE_NUMBER_INT;
    }

    protected final aI resetFloat(boolean bl2, int n2, int n3, int n4) {
        this._numberNegative = bl2;
        this._intLength = n2;
        this._fractLength = n3;
        this._expLength = n4;
        this._numTypesValid = 0;
        return aI.VALUE_NUMBER_FLOAT;
    }

    protected final aI resetAsNaN(String string, double d2) {
        this._textBuffer.resetWithString(string);
        this._numberDouble = d2;
        this._numTypesValid = 8;
        return aI.VALUE_NUMBER_FLOAT;
    }

    @Override
    public boolean isNaN() {
        if (this._currToken == aI.VALUE_NUMBER_FLOAT && (this._numTypesValid & 8) != 0) {
            double d2 = this._numberDouble;
            return Double.isNaN(d2) || Double.isInfinite(d2);
        }
        return false;
    }

    @Override
    public Number getNumberValue() {
        if (this._numTypesValid == 0) {
            this._parseNumericValue(0);
        }
        if (this._currToken == aI.VALUE_NUMBER_INT) {
            if ((this._numTypesValid & 1) != 0) {
                return this._numberInt;
            }
            if ((this._numTypesValid & 2) != 0) {
                return this._numberLong;
            }
            if ((this._numTypesValid & 4) != 0) {
                return this._numberBigInt;
            }
            this._throwInternal();
        }
        if ((this._numTypesValid & 0x10) != 0) {
            return this._numberBigDecimal;
        }
        if ((this._numTypesValid & 8) == 0) {
            this._throwInternal();
        }
        return this._numberDouble;
    }

    @Override
    public Number getNumberValueExact() {
        if (this._currToken == aI.VALUE_NUMBER_INT) {
            if (this._numTypesValid == 0) {
                this._parseNumericValue(0);
            }
            if ((this._numTypesValid & 1) != 0) {
                return this._numberInt;
            }
            if ((this._numTypesValid & 2) != 0) {
                return this._numberLong;
            }
            if ((this._numTypesValid & 4) != 0) {
                return this._numberBigInt;
            }
            this._throwInternal();
        }
        if (this._numTypesValid == 0) {
            this._parseNumericValue(16);
        }
        if ((this._numTypesValid & 0x10) != 0) {
            return this._numberBigDecimal;
        }
        if ((this._numTypesValid & 8) == 0) {
            this._throwInternal();
        }
        return this._numberDouble;
    }

    @Override
    public aE getNumberType() {
        if (this._numTypesValid == 0) {
            this._parseNumericValue(0);
        }
        if (this._currToken == aI.VALUE_NUMBER_INT) {
            if ((this._numTypesValid & 1) != 0) {
                return aE.INT;
            }
            if ((this._numTypesValid & 2) != 0) {
                return aE.LONG;
            }
            return aE.BIG_INTEGER;
        }
        if ((this._numTypesValid & 0x10) != 0) {
            return aE.BIG_DECIMAL;
        }
        return aE.DOUBLE;
    }

    @Override
    public int getIntValue() {
        if ((this._numTypesValid & 1) == 0) {
            if (this._numTypesValid == 0) {
                return this._parseIntValue();
            }
            if ((this._numTypesValid & 1) == 0) {
                this.convertNumberToInt();
            }
        }
        return this._numberInt;
    }

    @Override
    public long getLongValue() {
        if ((this._numTypesValid & 2) == 0) {
            if (this._numTypesValid == 0) {
                this._parseNumericValue(2);
            }
            if ((this._numTypesValid & 2) == 0) {
                this.convertNumberToLong();
            }
        }
        return this._numberLong;
    }

    @Override
    public BigInteger getBigIntegerValue() {
        if ((this._numTypesValid & 4) == 0) {
            if (this._numTypesValid == 0) {
                this._parseNumericValue(4);
            }
            if ((this._numTypesValid & 4) == 0) {
                this.convertNumberToBigInteger();
            }
        }
        return this._numberBigInt;
    }

    @Override
    public float getFloatValue() {
        return (float)this.getDoubleValue();
    }

    @Override
    public double getDoubleValue() {
        if ((this._numTypesValid & 8) == 0) {
            if (this._numTypesValid == 0) {
                this._parseNumericValue(8);
            }
            if ((this._numTypesValid & 8) == 0) {
                this.convertNumberToDouble();
            }
        }
        return this._numberDouble;
    }

    @Override
    public BigDecimal getDecimalValue() {
        if ((this._numTypesValid & 0x10) == 0) {
            if (this._numTypesValid == 0) {
                this._parseNumericValue(16);
            }
            if ((this._numTypesValid & 0x10) == 0) {
                this.convertNumberToBigDecimal();
            }
        }
        return this._numberBigDecimal;
    }

    protected void _parseNumericValue(int n2) {
        if (this._closed) {
            this._reportError("Internal error: _parseNumericValue called when parser instance closed");
        }
        if (this._currToken == aI.VALUE_NUMBER_INT) {
            int n3 = this._intLength;
            if (n3 <= 9) {
                int n4;
                this._numberInt = n4 = this._textBuffer.contentsAsInt(this._numberNegative);
                this._numTypesValid = 1;
                return;
            }
            if (n3 <= 18) {
                long l2 = this._textBuffer.contentsAsLong(this._numberNegative);
                if (n3 == 10) {
                    if (this._numberNegative) {
                        if (l2 >= Integer.MIN_VALUE) {
                            this._numberInt = (int)l2;
                            this._numTypesValid = 1;
                            return;
                        }
                    } else if (l2 <= Integer.MAX_VALUE) {
                        this._numberInt = (int)l2;
                        this._numTypesValid = 1;
                        return;
                    }
                }
                this._numberLong = l2;
                this._numTypesValid = 2;
                return;
            }
            this._parseSlowInt(n2);
            return;
        }
        if (this._currToken == aI.VALUE_NUMBER_FLOAT) {
            this._parseSlowFloat(n2);
            return;
        }
        this._reportError("Current token (%s) not numeric, can not use numeric value accessors", (Object)this._currToken);
    }

    protected int _parseIntValue() {
        if (this._closed) {
            this._reportError("Internal error: _parseNumericValue called when parser instance closed");
        }
        if (this._currToken == aI.VALUE_NUMBER_INT && this._intLength <= 9) {
            int n2;
            this._numberInt = n2 = this._textBuffer.contentsAsInt(this._numberNegative);
            this._numTypesValid = 1;
            return n2;
        }
        this._parseNumericValue(1);
        if ((this._numTypesValid & 1) == 0) {
            this.convertNumberToInt();
        }
        return this._numberInt;
    }

    private void _parseSlowFloat(int n2) {
        try {
            if (n2 == 16) {
                this._numberBigDecimal = this._textBuffer.contentsAsDecimal();
                this._numTypesValid = 16;
                return;
            }
            this._numberDouble = this._textBuffer.contentsAsDouble();
            this._numTypesValid = 8;
            return;
        }
        catch (NumberFormatException numberFormatException) {
            aZ aZ2 = this;
            this._wrapError("Malformed numeric value (" + aZ2._longNumberDesc(aZ2._textBuffer.contentsAsString()) + ")", numberFormatException);
            return;
        }
    }

    private void _parseSlowInt(int n2) {
        String string = this._textBuffer.contentsAsString();
        try {
            int n3 = this._intLength;
            char[] cArray = this._textBuffer.getTextBuffer();
            int n4 = this._textBuffer.getTextOffset();
            if (this._numberNegative) {
                ++n4;
            }
            if (bx.inLongRange(cArray, n4, n3, this._numberNegative)) {
                this._numberLong = Long.parseLong(string);
                this._numTypesValid = 2;
                return;
            }
            if (n2 == 1 || n2 == 2) {
                this._reportTooLongIntegral(n2, string);
            }
            if (n2 == 8 || n2 == 32) {
                this._numberDouble = bx.parseDouble(string);
                this._numTypesValid = 8;
                return;
            }
            this._numberBigInt = new BigInteger(string);
            this._numTypesValid = 4;
            return;
        }
        catch (NumberFormatException numberFormatException) {
            this._wrapError("Malformed numeric value (" + this._longNumberDesc(string) + ")", numberFormatException);
            return;
        }
    }

    protected void _reportTooLongIntegral(int n2, String string) {
        if (n2 == 1) {
            this.reportOverflowInt(string);
            return;
        }
        this.reportOverflowLong(string);
    }

    protected void convertNumberToInt() {
        if ((this._numTypesValid & 2) != 0) {
            int n2 = (int)this._numberLong;
            if ((long)n2 != this._numberLong) {
                aZ aZ2 = this;
                aZ2.reportOverflowInt(aZ2.getText(), this.currentToken());
            }
            this._numberInt = n2;
        } else if ((this._numTypesValid & 4) != 0) {
            if (BI_MIN_INT.compareTo(this._numberBigInt) > 0 || BI_MAX_INT.compareTo(this._numberBigInt) < 0) {
                this.reportOverflowInt();
            }
            this._numberInt = this._numberBigInt.intValue();
        } else if ((this._numTypesValid & 8) != 0) {
            if (this._numberDouble < -2.147483648E9 || this._numberDouble > 2.147483647E9) {
                this.reportOverflowInt();
            }
            this._numberInt = (int)this._numberDouble;
        } else if ((this._numTypesValid & 0x10) != 0) {
            if (BD_MIN_INT.compareTo(this._numberBigDecimal) > 0 || BD_MAX_INT.compareTo(this._numberBigDecimal) < 0) {
                this.reportOverflowInt();
            }
            this._numberInt = this._numberBigDecimal.intValue();
        } else {
            this._throwInternal();
        }
        this._numTypesValid |= 1;
    }

    protected void convertNumberToLong() {
        if ((this._numTypesValid & 1) != 0) {
            this._numberLong = this._numberInt;
        } else if ((this._numTypesValid & 4) != 0) {
            if (BI_MIN_LONG.compareTo(this._numberBigInt) > 0 || BI_MAX_LONG.compareTo(this._numberBigInt) < 0) {
                this.reportOverflowLong();
            }
            this._numberLong = this._numberBigInt.longValue();
        } else if ((this._numTypesValid & 8) != 0) {
            if (this._numberDouble < -9.223372036854776E18 || this._numberDouble > 9.223372036854776E18) {
                this.reportOverflowLong();
            }
            this._numberLong = (long)this._numberDouble;
        } else if ((this._numTypesValid & 0x10) != 0) {
            if (BD_MIN_LONG.compareTo(this._numberBigDecimal) > 0 || BD_MAX_LONG.compareTo(this._numberBigDecimal) < 0) {
                this.reportOverflowLong();
            }
            this._numberLong = this._numberBigDecimal.longValue();
        } else {
            this._throwInternal();
        }
        this._numTypesValid |= 2;
    }

    protected void convertNumberToBigInteger() {
        if ((this._numTypesValid & 0x10) != 0) {
            this._numberBigInt = this._numberBigDecimal.toBigInteger();
        } else if ((this._numTypesValid & 2) != 0) {
            this._numberBigInt = BigInteger.valueOf(this._numberLong);
        } else if ((this._numTypesValid & 1) != 0) {
            this._numberBigInt = BigInteger.valueOf(this._numberInt);
        } else if ((this._numTypesValid & 8) != 0) {
            this._numberBigInt = BigDecimal.valueOf(this._numberDouble).toBigInteger();
        } else {
            this._throwInternal();
        }
        this._numTypesValid |= 4;
    }

    protected void convertNumberToDouble() {
        if ((this._numTypesValid & 0x10) != 0) {
            this._numberDouble = this._numberBigDecimal.doubleValue();
        } else if ((this._numTypesValid & 4) != 0) {
            this._numberDouble = this._numberBigInt.doubleValue();
        } else if ((this._numTypesValid & 2) != 0) {
            this._numberDouble = this._numberLong;
        } else if ((this._numTypesValid & 1) != 0) {
            this._numberDouble = this._numberInt;
        } else {
            this._throwInternal();
        }
        this._numTypesValid |= 8;
    }

    protected void convertNumberToBigDecimal() {
        if ((this._numTypesValid & 8) != 0) {
            this._numberBigDecimal = bx.parseBigDecimal(this.getText());
        } else if ((this._numTypesValid & 4) != 0) {
            this._numberBigDecimal = new BigDecimal(this._numberBigInt);
        } else if ((this._numTypesValid & 2) != 0) {
            this._numberBigDecimal = BigDecimal.valueOf(this._numberLong);
        } else if ((this._numTypesValid & 1) != 0) {
            this._numberBigDecimal = BigDecimal.valueOf(this._numberInt);
        } else {
            this._throwInternal();
        }
        this._numTypesValid |= 0x10;
    }

    protected void _reportMismatchedEndMarker(int n2, char c2) {
        bH bH2 = this.getParsingContext();
        this._reportError(String.format("Unexpected close marker '%s': expected '%c' (for %s starting at %s)", Character.valueOf((char)n2), Character.valueOf(c2), bH2.typeDesc(), bH2.startLocation(this._contentReference())));
    }

    protected char _handleUnrecognizedCharacterEscape(char c2) {
        if (this.isEnabled(aD.ALLOW_BACKSLASH_ESCAPING_ANY_CHARACTER)) {
            return c2;
        }
        if (c2 == '\'' && this.isEnabled(aD.ALLOW_SINGLE_QUOTES)) {
            return c2;
        }
        this._reportError("Unrecognized character escape " + aZ._getCharDesc(c2));
        return c2;
    }

    protected void _throwUnquotedSpace(int n2, String string) {
        if (!this.isEnabled(aD.ALLOW_UNQUOTED_CONTROL_CHARS) || n2 > 32) {
            n2 = (char)n2;
            String string2 = "Illegal unquoted character (" + aZ._getCharDesc(n2) + "): has to be escaped using backslash to be included in " + string;
            this._reportError(string2);
        }
    }

    protected String _validJsonTokenList() {
        return this._validJsonValueList();
    }

    protected String _validJsonValueList() {
        if (this.isEnabled(aD.ALLOW_NON_NUMERIC_NUMBERS)) {
            return "(JSON String, Number (or 'NaN'/'INF'/'+INF'), Array, Object or token 'null', 'true' or 'false')";
        }
        return "(JSON String, Number, Array, Object or token 'null', 'true' or 'false')";
    }

    protected char _decodeEscaped() {
        throw new UnsupportedOperationException();
    }

    protected final int _decodeBase64Escape(an an2, int n2, int n3) {
        if (n2 != 92) {
            throw this.reportInvalidBase64Char(an2, n2, n3);
        }
        char c2 = this._decodeEscaped();
        n2 = c2;
        if (c2 <= ' ' && n3 == 0) {
            return -1;
        }
        int n4 = an2.decodeBase64Char(n2);
        if (n4 < 0 && n4 != -2) {
            throw this.reportInvalidBase64Char(an2, n2, n3);
        }
        return n4;
    }

    protected final int _decodeBase64Escape(an an2, char c2, int n2) {
        if (c2 != '\\') {
            throw this.reportInvalidBase64Char(an2, c2, n2);
        }
        c2 = this._decodeEscaped();
        if (c2 <= ' ' && n2 == 0) {
            return -1;
        }
        int n3 = an2.decodeBase64Char(c2);
        if (n3 < 0 && (n3 != -2 || n2 < 2)) {
            throw this.reportInvalidBase64Char(an2, c2, n2);
        }
        return n3;
    }

    protected IllegalArgumentException reportInvalidBase64Char(an an2, int n2, int n3) {
        return this.reportInvalidBase64Char(an2, n2, n3, null);
    }

    protected IllegalArgumentException reportInvalidBase64Char(an object, int n2, int n3, String string) {
        object = n2 <= 32 ? String.format("Illegal white space character (code 0x%s) as character #%d of 4-char base64 unit: can only used between units", Integer.toHexString(n2), n3 + 1) : (((an)object).usesPaddingChar(n2) ? "Unexpected padding character ('" + ((an)object).getPaddingChar() + "') as character #" + (n3 + 1) + " of 4-char base64 unit: padding only legal as 3rd or 4th character" : (!Character.isDefined(n2) || Character.isISOControl(n2) ? "Illegal character (code 0x" + Integer.toHexString(n2) + ") in base64 content" : "Illegal character '" + (char)n2 + "' (code 0x" + Integer.toHexString(n2) + ") in base64 content"));
        if (string != null) {
            object = (String)object + ": " + string;
        }
        return new IllegalArgumentException((String)object);
    }

    protected void _handleBase64MissingPadding(an an2) {
        this._reportError(an2.missingPaddingMessage());
    }

    @Deprecated
    protected Object _getSourceReference() {
        if (aD.INCLUDE_SOURCE_IN_LOCATION.enabledIn(this._features)) {
            return this._ioContext.contentReference().getRawContent();
        }
        return null;
    }

    protected bq _contentReference() {
        if (aD.INCLUDE_SOURCE_IN_LOCATION.enabledIn(this._features)) {
            return this._ioContext.contentReference();
        }
        return bq.unknown();
    }

    protected static int[] growArrayBy(int[] nArray, int n2) {
        if (nArray == null) {
            return new int[n2];
        }
        return Arrays.copyOf(nArray, nArray.length + n2);
    }

    @Deprecated
    protected void loadMoreGuaranteed() {
        if (!this.loadMore()) {
            this._reportInvalidEOF();
        }
    }

    @Deprecated
    protected boolean loadMore() {
        return false;
    }

    protected void _finishString() {
    }
}

