/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.core.rest.converters;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.ext.MessageBodyWriter;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageHeaders;
import org.springframework.messaging.converter.SmartMessageConverter;
import org.springframework.messaging.support.MessageBuilder;
import org.springframework.util.MimeType;

public abstract class AbstractMessageConverter<T>
implements SmartMessageConverter {
    private final MessageBodyWriter<T> messageBodyWriter;
    private static final int DEFAULT_SIZE = 0x100000;
    private final MediaType mediaType = MediaType.valueOf((String)"application/json");
    private final MimeType mimeType = new MimeType("application", "json", StandardCharsets.UTF_8);

    AbstractMessageConverter(MessageBodyWriter<T> messageBodyWriter) {
        this.messageBodyWriter = messageBodyWriter;
    }

    public Object fromMessage(Message<?> message, Class<?> targetClass, Object conversionHint) {
        return null;
    }

    public Message<?> toMessage(Object payload, MessageHeaders headers, Object conversionHint) {
        if (!this.canConvertTo(payload)) {
            return null;
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream(0x100000);
        try {
            this.messageBodyWriter.writeTo(payload, payload.getClass(), payload.getClass().getGenericSuperclass(), null, this.mediaType, null, (OutputStream)baos);
        }
        catch (IOException e) {
            return null;
        }
        return this.buildMessage(headers, baos);
    }

    private Message<?> buildMessage(MessageHeaders headers, ByteArrayOutputStream baos) {
        MessageBuilder builder = MessageBuilder.withPayload((Object)baos.toByteArray());
        if (headers != null) {
            builder.copyHeaders((Map)headers);
        }
        builder.setHeaderIfAbsent("contentType", (Object)this.mimeType);
        return builder.build();
    }

    public Object fromMessage(Message<?> message, Class<?> targetClass) {
        return null;
    }

    public Message<?> toMessage(Object payload, MessageHeaders headers) {
        return this.toMessage(payload, headers, null);
    }

    boolean canConvertTo(Object payload) {
        return this.messageBodyWriter.isWriteable(payload.getClass(), payload.getClass().getGenericSuperclass(), null, this.mediaType);
    }
}

