/*
 * Decompiled with CFR 0.152.
 */
package com.github.benmanes.caffeine.jcache.management;

import java.lang.management.ManagementFactory;
import javax.cache.Cache;
import javax.cache.CacheException;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;

public final class JmxRegistration {
    private JmxRegistration() {
    }

    public static void registerMXBean(Cache<?, ?> cache, Object mxbean, MBeanType type) {
        MBeanServer server = ManagementFactory.getPlatformMBeanServer();
        ObjectName objectName = JmxRegistration.getObjectName(cache, type);
        JmxRegistration.register(server, objectName, mxbean);
    }

    public static void unregisterMXBean(Cache<?, ?> cache, MBeanType type) {
        MBeanServer server = ManagementFactory.getPlatformMBeanServer();
        ObjectName objectName = JmxRegistration.getObjectName(cache, type);
        JmxRegistration.unregister(server, objectName);
    }

    static void register(MBeanServer server, ObjectName objectName, Object mbean) {
        try {
            if (!server.isRegistered(objectName)) {
                server.registerMBean(mbean, objectName);
            }
        }
        catch (InstanceAlreadyExistsException | MBeanRegistrationException | NotCompliantMBeanException e) {
            throw new CacheException("Error registering " + objectName, (Throwable)e);
        }
    }

    static void unregister(MBeanServer server, ObjectName objectName) {
        try {
            for (ObjectName name : server.queryNames(objectName, null)) {
                server.unregisterMBean(name);
            }
        }
        catch (InstanceNotFoundException | MBeanRegistrationException e) {
            throw new CacheException("Error unregistering " + objectName, (Throwable)e);
        }
    }

    static ObjectName getObjectName(Cache<?, ?> cache, MBeanType type) {
        String cacheManagerName = JmxRegistration.sanitize(cache.getCacheManager().getURI().toString());
        String cacheName = JmxRegistration.sanitize(cache.getName());
        String name = String.format("javax.cache:type=Cache%s,CacheManager=%s,Cache=%s", new Object[]{type, cacheManagerName, cacheName});
        return JmxRegistration.newObjectName(name);
    }

    static ObjectName newObjectName(String name) {
        try {
            return new ObjectName(name);
        }
        catch (MalformedObjectNameException e) {
            String msg = String.format("Illegal ObjectName: %s", name);
            throw new CacheException(msg, (Throwable)e);
        }
    }

    static String sanitize(String name) {
        return name == null ? "" : name.replaceAll("[,:=\n]", ".");
    }

    public static enum MBeanType {
        Configuration,
        Statistics;

    }
}

