/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.protocol.core.impl.wireformat;

import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.core.protocol.core.impl.PacketImpl;

public class SessionXAResponseMessage
extends PacketImpl {
    protected boolean error;
    protected int responseCode;
    protected String message;

    public SessionXAResponseMessage(boolean isError, int responseCode, String message) {
        super((byte)55);
        this.error = isError;
        this.responseCode = responseCode;
        this.message = message;
    }

    public SessionXAResponseMessage() {
        super((byte)55);
    }

    @Override
    public boolean isResponse() {
        return true;
    }

    public boolean isError() {
        return this.error;
    }

    public int getResponseCode() {
        return this.responseCode;
    }

    public String getMessage() {
        return this.message;
    }

    @Override
    public void encodeRest(ActiveMQBuffer buffer) {
        buffer.writeBoolean(this.error);
        buffer.writeInt(this.responseCode);
        buffer.writeNullableString(this.message);
    }

    @Override
    public void decodeRest(ActiveMQBuffer buffer) {
        this.error = buffer.readBoolean();
        this.responseCode = buffer.readInt();
        this.message = buffer.readNullableString();
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.error ? 1231 : 1237);
        result = 31 * result + (this.message == null ? 0 : this.message.hashCode());
        result = 31 * result + this.responseCode;
        return result;
    }

    @Override
    protected String getPacketString() {
        StringBuffer buff = new StringBuffer(super.getPacketString());
        buff.append(", error=" + this.error);
        buff.append(", message=" + this.message);
        buff.append(", responseCode=" + this.responseCode);
        buff.append("]");
        return buff.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof SessionXAResponseMessage)) {
            return false;
        }
        SessionXAResponseMessage other = (SessionXAResponseMessage)obj;
        if (this.error != other.error) {
            return false;
        }
        if (this.message == null ? other.message != null : !this.message.equals(other.message)) {
            return false;
        }
        return this.responseCode == other.responseCode;
    }
}

