/*
 * Decompiled with CFR 0.152.
 */
package com.tqdev.metrics.jdbc;

import com.tqdev.metrics.core.MetricRegistry;
import com.tqdev.metrics.jdbc.InstrumentedConnection;
import java.io.Closeable;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.logging.Logger;
import javax.sql.DataSource;

public class InstrumentedDataSource
implements DataSource,
Closeable {
    private DataSource dataSource;
    private MetricRegistry registry;

    public InstrumentedDataSource(DataSource wrapped, MetricRegistry registry) {
        this.dataSource = wrapped;
        this.registry = registry;
    }

    @Override
    public Connection getConnection() throws SQLException {
        return new InstrumentedConnection(this.dataSource.getConnection(), this.registry);
    }

    @Override
    public Connection getConnection(String username, String password) throws SQLException {
        return new InstrumentedConnection(this.dataSource.getConnection(username, password), this.registry);
    }

    @Override
    public PrintWriter getLogWriter() throws SQLException {
        return this.dataSource.getLogWriter();
    }

    @Override
    public void setLogWriter(PrintWriter out) throws SQLException {
        this.dataSource.setLogWriter(out);
    }

    @Override
    public void setLoginTimeout(int seconds) throws SQLException {
        this.dataSource.setLoginTimeout(seconds);
    }

    @Override
    public int getLoginTimeout() throws SQLException {
        return this.dataSource.getLoginTimeout();
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        return this.dataSource.getParentLogger();
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        return this.dataSource.unwrap(iface);
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return this.dataSource.isWrapperFor(iface);
    }

    @Override
    public void close() throws IOException {
        if (this.dataSource instanceof Closeable) {
            ((Closeable)((Object)this.dataSource)).close();
        } else {
            try {
                Method close = this.dataSource.getClass().getMethod("close", new Class[0]);
                close.invoke((Object)this.dataSource, new Object[0]);
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException reflectiveOperationException) {
                // empty catch block
            }
        }
    }
}

