/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.checks.basic;

import com.datical.liquibase.ext.checks.basic.AbstractNotAllowedToContainRule;
import com.datical.liquibase.ext.checks.config.cli.RuleParameter;
import com.datical.liquibase.ext.rules.api.ScopeEnum;
import com.datical.liquibase.ext.rules.api.SeverityEnum;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;

public class SqlNotAllowedToContainGrantWithGrantOption
extends AbstractNotAllowedToContainRule {
    public SqlNotAllowedToContainGrantWithGrantOption() {
        this.setSeverity(SeverityEnum.INFO);
    }

    @Override
    public String getName() {
        return "Warn on Detection of grant that contains 'WITH GRANT OPTION'";
    }

    @Override
    public List<ScopeEnum> getScope() {
        return Collections.singletonList(ScopeEnum.CHANGELOG);
    }

    @Override
    public List<String> getTags() {
        return Collections.emptyList();
    }

    @Override
    public String getMinLiquibaseVersion() {
        return null;
    }

    @Override
    public String getMaxLiquibaseVersion() {
        return null;
    }

    @Override
    public String getShortName() {
        return "SqlGrantOptionWarn";
    }

    @Override
    public List<Pattern> getReservedPhrase() {
        return Collections.singletonList(Pattern.compile(".*grant[\\s]+(.*)[\\s]+to[\\s]+.*with[\\s]+grant[\\s]+option"));
    }

    @Override
    public String getFailureMessage() {
        return "A statement granting privileges to a role or user with the GRANT OPTION was detected in your changelog. Granting privileges to users or roles with the GRANT OPTION can lead to security issues.  We recommend this changeset be carefully reviewed.";
    }

    @Override
    public String getDescription() {
        return "This check warns a user when SQL contains 'GRANT' statements that include the 'WITH GRANT OPTION' clause so that they can ensure that the privilege being granted won't lead to security issues";
    }

    @Override
    public int getPriority() {
        return 110;
    }

    @Override
    public List<RuleParameter<?>> getParameters() {
        return null;
    }
}

