/*
 * Decompiled with CFR 0.152.
 */
package liquibase.repackaged.net.sf.jsqlparser.statement.upsert;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import liquibase.repackaged.net.sf.jsqlparser.expression.Expression;
import liquibase.repackaged.net.sf.jsqlparser.expression.operators.relational.ItemsList;
import liquibase.repackaged.net.sf.jsqlparser.schema.Column;
import liquibase.repackaged.net.sf.jsqlparser.schema.Table;
import liquibase.repackaged.net.sf.jsqlparser.statement.Statement;
import liquibase.repackaged.net.sf.jsqlparser.statement.StatementVisitor;
import liquibase.repackaged.net.sf.jsqlparser.statement.select.PlainSelect;
import liquibase.repackaged.net.sf.jsqlparser.statement.select.Select;

public class Upsert
implements Statement {
    private Table table;
    private List<Column> columns;
    private ItemsList itemsList;
    private boolean useValues = true;
    private Select select;
    private boolean useSelectBrackets = true;
    private boolean useDuplicate = false;
    private List<Column> duplicateUpdateColumns;
    private List<Expression> duplicateUpdateExpressionList;

    @Override
    public void accept(StatementVisitor statementVisitor) {
        statementVisitor.visit(this);
    }

    public void setTable(Table table) {
        this.table = table;
    }

    public Table getTable() {
        return this.table;
    }

    public void setColumns(List<Column> list) {
        this.columns = list;
    }

    public List<Column> getColumns() {
        return this.columns;
    }

    public void setItemsList(ItemsList itemsList) {
        this.itemsList = itemsList;
    }

    public ItemsList getItemsList() {
        return this.itemsList;
    }

    public void setUseValues(boolean bl2) {
        this.useValues = bl2;
    }

    public boolean isUseValues() {
        return this.useValues;
    }

    public void setSelect(Select select) {
        this.select = select;
    }

    public Select getSelect() {
        return this.select;
    }

    public void setUseSelectBrackets(boolean bl2) {
        this.useSelectBrackets = bl2;
    }

    public boolean isUseSelectBrackets() {
        return this.useSelectBrackets;
    }

    public void setUseDuplicate(boolean bl2) {
        this.useDuplicate = bl2;
    }

    public boolean isUseDuplicate() {
        return this.useDuplicate;
    }

    public void setDuplicateUpdateColumns(List<Column> list) {
        this.duplicateUpdateColumns = list;
    }

    public List<Column> getDuplicateUpdateColumns() {
        return this.duplicateUpdateColumns;
    }

    public void setDuplicateUpdateExpressionList(List<Expression> list) {
        this.duplicateUpdateExpressionList = list;
    }

    public List<Expression> getDuplicateUpdateExpressionList() {
        return this.duplicateUpdateExpressionList;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("UPSERT INTO ");
        stringBuilder.append(this.table).append(" ");
        if (this.columns != null) {
            stringBuilder.append(PlainSelect.getStringList(this.columns, true, true)).append(" ");
        }
        if (this.useValues) {
            stringBuilder.append("VALUES ");
        }
        if (this.itemsList != null) {
            stringBuilder.append(this.itemsList);
        } else {
            if (this.useSelectBrackets) {
                stringBuilder.append("(");
            }
            if (this.select != null) {
                stringBuilder.append(this.select);
            }
            if (this.useSelectBrackets) {
                stringBuilder.append(")");
            }
        }
        if (this.useDuplicate) {
            stringBuilder.append(" ON DUPLICATE KEY UPDATE ");
            for (int i2 = 0; i2 < this.getDuplicateUpdateColumns().size(); ++i2) {
                if (i2 != 0) {
                    stringBuilder.append(", ");
                }
                stringBuilder.append(this.duplicateUpdateColumns.get(i2)).append(" = ");
                stringBuilder.append(this.duplicateUpdateExpressionList.get(i2));
            }
        }
        return stringBuilder.toString();
    }

    public Upsert withUseValues(boolean bl2) {
        this.setUseValues(bl2);
        return this;
    }

    public Upsert withSelect(Select select) {
        this.setSelect(select);
        return this;
    }

    public Upsert withUseSelectBrackets(boolean bl2) {
        this.setUseSelectBrackets(bl2);
        return this;
    }

    public Upsert withUseDuplicate(boolean bl2) {
        this.setUseDuplicate(bl2);
        return this;
    }

    public Upsert withDuplicateUpdateColumns(List<Column> list) {
        this.setDuplicateUpdateColumns(list);
        return this;
    }

    public Upsert withDuplicateUpdateExpressionList(List<Expression> list) {
        this.setDuplicateUpdateExpressionList(list);
        return this;
    }

    public Upsert withTable(Table table) {
        this.setTable(table);
        return this;
    }

    public Upsert withColumns(List<Column> list) {
        this.setColumns(list);
        return this;
    }

    public Upsert withItemsList(ItemsList itemsList) {
        this.setItemsList(itemsList);
        return this;
    }

    public Upsert addColumns(Column ... columnArray) {
        List list = Optional.ofNullable(this.getColumns()).orElseGet(ArrayList::new);
        Collections.addAll(list, columnArray);
        return this.withColumns(list);
    }

    public Upsert addColumns(Collection<? extends Column> collection) {
        List list = Optional.ofNullable(this.getColumns()).orElseGet(ArrayList::new);
        list.addAll(collection);
        return this.withColumns(list);
    }

    public Upsert addDuplicateUpdateColumns(Column ... columnArray) {
        List list = Optional.ofNullable(this.getDuplicateUpdateColumns()).orElseGet(ArrayList::new);
        Collections.addAll(list, columnArray);
        return this.withDuplicateUpdateColumns(list);
    }

    public Upsert addDuplicateUpdateColumns(Collection<? extends Column> collection) {
        List list = Optional.ofNullable(this.getDuplicateUpdateColumns()).orElseGet(ArrayList::new);
        list.addAll(collection);
        return this.withDuplicateUpdateColumns(list);
    }

    public Upsert addDuplicateUpdateExpressionList(Expression ... expressionArray) {
        List list = Optional.ofNullable(this.getDuplicateUpdateExpressionList()).orElseGet(ArrayList::new);
        Collections.addAll(list, expressionArray);
        return this.withDuplicateUpdateExpressionList(list);
    }

    public Upsert addDuplicateUpdateExpressionList(Collection<? extends Expression> collection) {
        List list = Optional.ofNullable(this.getDuplicateUpdateExpressionList()).orElseGet(ArrayList::new);
        list.addAll(collection);
        return this.withDuplicateUpdateExpressionList(list);
    }

    public <E extends ItemsList> E getItemsList(Class<E> clazz) {
        return (E)((ItemsList)clazz.cast(this.getItemsList()));
    }
}

