/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.demos;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.TextArea;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JTextField;
import org.jgroups.client.StompConnection;
import org.jgroups.util.Util;

public class StompChat
implements StompConnection.Listener {
    JFrame mainFrame;
    TextArea txtArea;
    JTextField txtField;
    final JLabel csLabel = new JLabel("Send: ");
    final JLabel status = new JLabel("");
    JButton leaveButton;
    JButton sendButton;
    JButton clearButton;
    final JLabel cluster = new JLabel("Cluster: ");
    final JLabel users_label = new JLabel("Users: ");
    private int num_servers = 1;
    private int num_clients = 0;
    protected String username = null;
    protected final Set<String> users = new HashSet<String>();
    private final List<String> servers = new ArrayList<String>();
    private final Set<String> clients = new HashSet<String>();
    protected StompConnection stomp_client;
    public static final String MESSAGES = "/messages";
    public static final String CLIENT_JOINED = "/client-joined";
    public static final String CLIENT_LEFT = "/client-left";
    public static final String CLIENTS = "/clients";
    public static final String USER_JOINED = "/user-joined";
    public static final String USER_LEFT = "/user-left";
    public static final String GET_USERS = "/get-users";
    public static final String USERS = "/users";
    public static final String ENDPOINTS = "endpoints";
    public static final String VIEW = "view";
    public static final String CLIENTS_KW = "clients";
    public static final String DESTINATION = "destination";
    public static final String USER = "user";
    public static final String USERS_KW = "users";
    public static final String CLIENT = "client";

    public StompChat(String host, int port, String user) {
        this.stomp_client = new StompConnection(host + ":" + port);
        this.stomp_client.addListener(this);
        this.username = user;
        try {
            if (this.username == null) {
                this.username = System.getProperty("user.name");
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void main(String[] args) throws Exception {
        String host = "localhost";
        int port = 8787;
        String user = null;
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals("-host") || args[i].equals("-h")) {
                host = args[++i];
                continue;
            }
            if (args[i].equals("-port") || args[i].equals("-p")) {
                port = Integer.parseInt(args[++i]);
                continue;
            }
            if (args[i].equals("-user") || args[i].equals("-name")) {
                user = args[++i];
                continue;
            }
            StompChat.help();
            return;
        }
        StompChat instance = new StompChat(host, port, user);
        instance.start();
    }

    void showMessage(String msg) {
        this.txtArea.append(msg + "\n");
    }

    void userJoined(String name) {
        this.users.add(name);
        this.showStatus(name + " joined the chat");
        this.users_label.setText("Users: " + String.valueOf(this.users));
    }

    void userLeft(String name) {
        this.users.remove(name);
        this.showStatus(name + " left the chat");
        this.users_label.setText("Users: " + String.valueOf(this.users));
    }

    void newView(String view) {
        this.cluster.setText("Cluster: " + view);
    }

    void usersReceived(Collection<String> users) {
        this.users.addAll(users);
        this.users_label.setText("Users: " + String.valueOf(this.users));
    }

    static void help() {
        System.out.println("Chat [-help] [-host <host>] [-port <port>] [-user <user>]");
    }

    public void start() throws Exception {
        this.mainFrame = new JFrame("Chat demo");
        this.mainFrame.setPreferredSize(new Dimension(600, 600));
        this.mainFrame.setBackground(Color.white);
        this.mainFrame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                StompChat.this.stomp_client.send(StompChat.USER_LEFT, StompChat.USER, StompChat.this.username);
                StompChat.this.stomp_client.send(StompChat.CLIENT_LEFT, StompChat.CLIENT, StompChat.this.username);
                StompChat.this.stomp_client.disconnect();
                System.exit(0);
            }
        });
        this.connect();
        Box main_box = Box.createVerticalBox();
        main_box.setBackground(Color.white);
        Box input = Box.createHorizontalBox();
        Box buttons = Box.createHorizontalBox();
        this.mainFrame.add(main_box);
        main_box.add(Box.createVerticalStrut(10));
        main_box.add(this.cluster);
        this.cluster.setAlignmentX(0.0f);
        main_box.add(Box.createVerticalStrut(10));
        main_box.add(Box.createVerticalStrut(10));
        main_box.add(this.users_label);
        main_box.add(Box.createVerticalStrut(10));
        this.txtArea = new TextArea();
        this.txtArea.setPreferredSize(new Dimension(550, 500));
        this.txtArea.setEditable(false);
        this.txtArea.setBackground(Color.white);
        main_box.add(this.txtArea);
        main_box.add(Box.createVerticalStrut(10));
        main_box.add(input);
        main_box.add(Box.createVerticalStrut(10));
        main_box.add(buttons);
        this.csLabel.setPreferredSize(new Dimension(85, 30));
        input.add(this.csLabel);
        this.txtField = new JTextField();
        this.txtField.setPreferredSize(new Dimension(200, 30));
        this.txtField.setBackground(Color.white);
        input.add(this.txtField);
        this.leaveButton = new JButton("Leave");
        this.leaveButton.setPreferredSize(new Dimension(150, 30));
        buttons.add(this.leaveButton);
        this.leaveButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                StompChat.this.stomp_client.send(StompChat.USER_LEFT, StompChat.USER, StompChat.this.username);
                StompChat.this.stomp_client.send(StompChat.CLIENT_LEFT, StompChat.CLIENT, StompChat.this.username);
                StompChat.this.stomp_client.disconnect();
                System.exit(0);
            }
        });
        this.sendButton = new JButton("Send");
        this.sendButton.setPreferredSize(new Dimension(150, 30));
        buttons.add(this.sendButton);
        this.sendButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                StompChat.this.send(StompChat.this.txtField.getText());
                StompChat.this.txtField.selectAll();
            }
        });
        this.clearButton = new JButton("Clear");
        this.clearButton.setPreferredSize(new Dimension(150, 30));
        this.clearButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                StompChat.this.txtArea.setText("");
            }
        });
        buttons.add(this.clearButton);
        this.status.setForeground(Color.red);
        main_box.add(this.status);
        this.mainFrame.pack();
        this.mainFrame.setLocation(15, 25);
        Dimension main_frame_size = this.mainFrame.getSize();
        this.txtArea.setPreferredSize(new Dimension((int)((double)main_frame_size.width * 0.9), (int)((double)main_frame_size.height * 0.8)));
        this.mainFrame.setVisible(true);
        this.txtField.setFocusable(true);
        this.txtField.requestFocusInWindow();
        this.txtField.setToolTipText("type and then press enter to send");
        this.txtField.addActionListener(e -> {
            String cmd = e.getActionCommand();
            if (cmd != null && !cmd.isEmpty()) {
                this.send(this.txtField.getText());
                this.txtField.selectAll();
            }
        });
        this.sendGetUsers();
    }

    protected void connect() throws Exception {
        this.stomp_client.connect();
        this.stomp_client.send(USER_JOINED, USER, this.username);
        this.stomp_client.subscribe(MESSAGES);
        this.stomp_client.subscribe(CLIENT_JOINED);
        this.stomp_client.subscribe(CLIENT_LEFT);
        this.stomp_client.subscribe(CLIENTS);
        this.stomp_client.subscribe(USER_JOINED);
        this.stomp_client.subscribe(USER_LEFT);
        this.stomp_client.subscribe(GET_USERS);
        this.stomp_client.subscribe(USERS);
        this.stomp_client.send(CLIENT_JOINED, CLIENT, this.username);
        this.stomp_client.send(USER_JOINED, USER, this.username);
    }

    protected void send(String msg) {
        try {
            String tmp = this.username + ": " + msg;
            byte[] buf = tmp.getBytes();
            this.stomp_client.send(MESSAGES, buf, 0, buf.length);
        }
        catch (Exception e) {
            System.err.println("Failed sending message: " + String.valueOf(e));
        }
    }

    public void sendGetUsers() {
        this.stomp_client.send(GET_USERS, new String[0]);
    }

    protected void showStatus(String msg) {
        new Thread(() -> {
            JLabel jLabel = this.status;
            synchronized (jLabel) {
                this.status.setText(msg);
                Util.sleep(2000L);
                this.status.setText("");
            }
        }).start();
    }

    @Override
    public void onInfo(Map<String, String> information) {
        String view = information.get(VIEW);
        if (view != null) {
            List<String> list = Util.parseCommaDelimitedStrings(view);
            if (list != null) {
                this.num_servers = list.size();
                if (this.mainFrame != null) {
                    this.setTitle();
                }
                this.servers.clear();
                this.servers.addAll(list);
                this.newView(view);
            } else {
                String targets = information.get(ENDPOINTS);
                if (targets != null && (list = Util.parseCommaDelimitedStrings(targets)) != null) {
                    this.num_servers = list.size();
                    if (this.mainFrame != null) {
                        this.setTitle();
                    }
                    this.servers.clear();
                    this.servers.addAll(list);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onMessage(Map<String, String> headers, byte[] buf, int offset, int length) {
        List<String> list;
        String tmp;
        String destination = headers.get(DESTINATION);
        if (destination == null) {
            return;
        }
        if (destination.equals(MESSAGES)) {
            this.showMessage(new String(buf, offset, length));
            return;
        }
        if (destination.equals(CLIENT_JOINED)) {
            String new_client = headers.get(CLIENT);
            if (new_client != null) {
                Set<String> set = this.clients;
                synchronized (set) {
                    if (this.clients.add(new_client)) {
                        this.num_clients = this.clients.size();
                        this.setTitle();
                    }
                }
                this.stomp_client.send(CLIENTS, null, 0, 0, CLIENTS_KW, this.getAllClients());
            }
            return;
        }
        if (destination.equals(CLIENT_LEFT)) {
            String left_client = headers.get(CLIENT);
            if (left_client != null) {
                Set<String> set = this.clients;
                synchronized (set) {
                    if (this.clients.remove(left_client)) {
                        this.num_clients = this.clients.size();
                        this.setTitle();
                    }
                }
            }
            return;
        }
        if (destination.equals(CLIENTS)) {
            List<String> list2;
            String all_clients = headers.get(CLIENTS_KW);
            if (all_clients != null && (list2 = Util.parseCommaDelimitedStrings(all_clients)) != null) {
                Set<String> set = this.clients;
                synchronized (set) {
                    if (this.clients.addAll(list2)) {
                        this.num_clients = this.clients.size();
                        this.setTitle();
                    }
                }
            }
            return;
        }
        if (destination.equals(USER_JOINED)) {
            String name = headers.get(USER);
            if (name != null) {
                this.userJoined(name);
            }
            return;
        }
        if (destination.equals(USER_LEFT)) {
            String name = headers.get(USER);
            if (name != null) {
                this.userLeft(name);
            }
            return;
        }
        if (destination.equals(GET_USERS)) {
            this.stomp_client.send(USERS, USERS_KW, this.usersToStr());
            return;
        }
        if (destination.equals(USERS) && (tmp = headers.get(USERS_KW)) != null && (list = Util.parseCommaDelimitedStrings(tmp)) != null) {
            this.usersReceived(list);
        }
    }

    private String usersToStr() {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (String user : this.users) {
            if (first) {
                first = false;
            } else {
                sb.append(",");
            }
            sb.append(user);
        }
        return sb.toString();
    }

    void setTitle() {
        if (this.mainFrame != null) {
            this.mainFrame.setTitle(this.num_servers + " server(s), " + this.num_clients + " client(s)");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getNumberOfClients() {
        Set<String> set = this.clients;
        synchronized (set) {
            return this.clients.size();
        }
    }

    String getAllClients() {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (String client : this.clients) {
            if (first) {
                first = false;
            } else {
                sb.append(",");
            }
            sb.append(client);
        }
        return sb.toString();
    }
}

