/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.protostream.descriptors;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.infinispan.protostream.DescriptorParserException;
import org.infinispan.protostream.config.AnnotationConfiguration;
import org.infinispan.protostream.descriptors.AnnotationElement;
import org.infinispan.protostream.descriptors.Descriptor;
import org.infinispan.protostream.descriptors.EnumValueDescriptor;
import org.infinispan.protostream.descriptors.FileDescriptor;
import org.infinispan.protostream.descriptors.GenericDescriptor;
import org.infinispan.protostream.descriptors.Option;
import org.infinispan.protostream.impl.AnnotatedDescriptorImpl;

public final class EnumDescriptor
extends AnnotatedDescriptorImpl
implements GenericDescriptor {
    private Integer typeId;
    private final List<Option> options;
    private final List<EnumValueDescriptor> values;
    private final Map<Integer, EnumValueDescriptor> valueByNumber = new HashMap<Integer, EnumValueDescriptor>();
    private final Map<String, EnumValueDescriptor> valueByName = new HashMap<String, EnumValueDescriptor>();
    private FileDescriptor fileDescriptor;
    private Descriptor containingType;

    private EnumDescriptor(Builder builder) {
        super(builder.name, builder.fullName, builder.documentation);
        this.options = Collections.unmodifiableList(builder.options);
        this.values = Collections.unmodifiableList(builder.values);
        for (EnumValueDescriptor value : this.values) {
            if (this.name.equals(value.getName())) {
                throw new DescriptorParserException("Enum constant '" + value.getName() + "' clashes with enum type name: " + this.fullName);
            }
            if (this.valueByName.containsKey(value.getName())) {
                throw new DescriptorParserException("Enum constant '" + value.getName() + "' is already defined in " + this.fullName);
            }
            value.setContainingEnum(this);
            this.checkReserved(value);
            this.valueByName.put(value.getName(), value);
            this.valueByNumber.put(value.getNumber(), value);
        }
    }

    private void checkReserved(EnumValueDescriptor value) {
    }

    @Override
    protected AnnotationConfiguration getAnnotationConfig(AnnotationElement.Annotation annotation) {
        AnnotationConfiguration annotationConfiguration = this.getAnnotationsConfig().annotations().get(annotation.getName());
        if (annotationConfiguration == null) {
            return null;
        }
        if (annotation.getPackageName() != null && !annotation.getPackageName().equals(annotationConfiguration.packageName())) {
            return null;
        }
        for (AnnotationElement.AnnotationTarget t : annotationConfiguration.target()) {
            if (t != AnnotationElement.AnnotationTarget.ENUM) continue;
            return annotationConfiguration;
        }
        throw new DescriptorParserException("Annotation '" + annotation + "' cannot be applied to enum types.");
    }

    @Override
    public FileDescriptor getFileDescriptor() {
        return this.fileDescriptor;
    }

    @Override
    public Integer getTypeId() {
        return this.typeId;
    }

    @Override
    public Descriptor getContainingType() {
        return this.containingType;
    }

    void setContainingType(Descriptor containingType) {
        this.containingType = containingType;
    }

    public List<Option> getOptions() {
        return this.options;
    }

    public Option getOption(String name) {
        for (Option o : this.options) {
            if (!o.getName().equals(name)) continue;
            return o;
        }
        return null;
    }

    public List<EnumValueDescriptor> getValues() {
        return this.values;
    }

    public EnumValueDescriptor findValueByNumber(int number) {
        return this.valueByNumber.get(number);
    }

    public EnumValueDescriptor findValueByName(String name) {
        return this.valueByName.get(name);
    }

    void setFileDescriptor(FileDescriptor fileDescriptor) {
        this.fileDescriptor = fileDescriptor;
        for (EnumValueDescriptor valueDescriptor : this.values) {
            valueDescriptor.setFileDescriptor(fileDescriptor);
        }
        this.typeId = (Integer)this.getProcessedAnnotation("TypeId");
        if (this.typeId != null && this.typeId < 0) {
            throw new DescriptorParserException("TypeId cannot be negative");
        }
    }

    public String toString() {
        return "EnumDescriptor{fullName=" + this.getFullName() + "}";
    }

    public static final class Builder {
        private String name;
        private String fullName;
        private List<Option> options;
        private List<EnumValueDescriptor> values;
        private String documentation;

        public Builder withName(String name) {
            this.name = name;
            return this;
        }

        public Builder withFullName(String fullName) {
            this.fullName = fullName;
            return this;
        }

        public Builder withOptions(List<Option> options) {
            this.options = options;
            return this;
        }

        public Builder withValues(List<EnumValueDescriptor> values) {
            this.values = values;
            return this;
        }

        public Builder withDocumentation(String documentation) {
            this.documentation = documentation;
            return this;
        }

        public EnumDescriptor build() {
            return new EnumDescriptor(this);
        }
    }
}

