/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.batch;

import net.jcip.annotations.NotThreadSafe;
import org.infinispan.batch.BatchContainer;
import org.infinispan.commons.CacheConfigurationException;
import org.infinispan.configuration.cache.Configuration;

@NotThreadSafe
public abstract class AutoBatchSupport {
    protected BatchContainer batchContainer;

    protected static void assertBatchingSupported(Configuration c) {
        if (!c.invocationBatching().enabled()) {
            throw new CacheConfigurationException("Invocation batching not enabled in current configuration! Please enable it.");
        }
    }

    protected void startAtomic() {
        this.batchContainer.startBatch(true);
    }

    protected void endAtomic() {
        this.batchContainer.endBatch(true, true);
    }

    protected void failAtomic() {
        this.batchContainer.endBatch(true, false);
    }
}

