/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.paging.impl;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.api.core.ActiveMQBuffers;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.config.storage.DatabaseStorageConfiguration;
import org.apache.activemq.artemis.core.io.IOCriticalErrorListener;
import org.apache.activemq.artemis.core.io.SequentialFile;
import org.apache.activemq.artemis.core.io.SequentialFileFactory;
import org.apache.activemq.artemis.core.paging.PagingManager;
import org.apache.activemq.artemis.core.paging.PagingStore;
import org.apache.activemq.artemis.core.paging.PagingStoreFactory;
import org.apache.activemq.artemis.core.paging.cursor.PageCursorProvider;
import org.apache.activemq.artemis.core.paging.cursor.impl.PageCursorProviderImpl;
import org.apache.activemq.artemis.core.paging.impl.PagingStoreImpl;
import org.apache.activemq.artemis.core.persistence.StorageManager;
import org.apache.activemq.artemis.core.server.files.FileStoreMonitor;
import org.apache.activemq.artemis.core.settings.HierarchicalRepository;
import org.apache.activemq.artemis.core.settings.impl.AddressSettings;
import org.apache.activemq.artemis.jdbc.store.file.JDBCSequentialFile;
import org.apache.activemq.artemis.jdbc.store.file.JDBCSequentialFileFactory;
import org.apache.activemq.artemis.jdbc.store.sql.PropertySQLProvider;
import org.apache.activemq.artemis.jdbc.store.sql.SQLProvider;
import org.apache.activemq.artemis.utils.ExecutorFactory;
import org.apache.activemq.artemis.utils.actors.ArtemisExecutor;

public class PagingStoreFactoryDatabase
implements PagingStoreFactory {
    private static final String ADDRESS_FILE = "address.txt";
    private static final String DIRECTORY_NAME = "directory.txt";
    protected final boolean syncNonTransactional;
    private PagingManager pagingManager;
    private final ScheduledExecutorService scheduledExecutor;
    private final long syncTimeout;
    protected final StorageManager storageManager;
    private DatabaseStorageConfiguration dbConf;
    private ExecutorFactory executorFactory;
    private ExecutorFactory ioExecutorFactory;
    private JDBCSequentialFileFactory pagingFactoryFileFactory;
    private boolean started = false;
    private final IOCriticalErrorListener criticalErrorListener;
    private final Map<SequentialFileFactory, String> factoryToTableName;

    @Override
    public ScheduledExecutorService getScheduledExecutor() {
        return this.scheduledExecutor;
    }

    @Override
    public Executor newExecutor() {
        return this.executorFactory.getExecutor();
    }

    public PagingStoreFactoryDatabase(DatabaseStorageConfiguration dbConf, StorageManager storageManager, long syncTimeout, ScheduledExecutorService scheduledExecutor, ExecutorFactory executorFactory, ExecutorFactory ioExecutorFactory, boolean syncNonTransactional, IOCriticalErrorListener criticalErrorListener) throws Exception {
        this.storageManager = storageManager;
        this.executorFactory = executorFactory;
        this.ioExecutorFactory = ioExecutorFactory;
        this.syncNonTransactional = syncNonTransactional;
        this.scheduledExecutor = scheduledExecutor;
        this.syncTimeout = syncTimeout;
        this.dbConf = dbConf;
        this.criticalErrorListener = criticalErrorListener;
        this.factoryToTableName = new HashMap<SequentialFileFactory, String>();
        this.start();
    }

    public synchronized void start() throws Exception {
        if (!this.started) {
            String pageStoreTableNamePrefix = this.dbConf.getPageStoreTableName();
            if (pageStoreTableNamePrefix.length() > 10) {
                throw new IllegalStateException("The maximum name size for the page store table prefix is 10 characters: THE PAGING STORE CAN'T START");
            }
            SQLProvider.Factory sqlProviderFactory = this.dbConf.getSqlProviderFactory();
            if (sqlProviderFactory == null) {
                sqlProviderFactory = new PropertySQLProvider.Factory(this.dbConf.getConnectionProvider());
            }
            this.pagingFactoryFileFactory = new JDBCSequentialFileFactory(this.dbConf.getConnectionProvider(), sqlProviderFactory.create(pageStoreTableNamePrefix, SQLProvider.DatabaseStoreType.PAGE), (Executor)this.executorFactory.getExecutor(), this.scheduledExecutor, this.dbConf.getJdbcJournalSyncPeriodMillis(), this.criticalErrorListener);
            this.pagingFactoryFileFactory.start();
            this.started = true;
        }
    }

    @Override
    public synchronized void stop() {
        if (this.started) {
            this.pagingFactoryFileFactory.stop();
            this.started = false;
        }
    }

    @Override
    public void injectMonitor(FileStoreMonitor monitor) throws Exception {
    }

    @Override
    public PageCursorProvider newCursorProvider(PagingStore store, StorageManager storageManager, AddressSettings addressSettings, ArtemisExecutor executor) {
        return new PageCursorProviderImpl(store, storageManager);
    }

    @Override
    public synchronized PagingStore newStore(SimpleString address, AddressSettings settings) {
        return new PagingStoreImpl(address, this.scheduledExecutor, this.syncTimeout, this.pagingManager, this.storageManager, null, this, address, settings, this.executorFactory.getExecutor().setFair(true), this.ioExecutorFactory.getExecutor(), this.syncNonTransactional);
    }

    @Override
    public synchronized SequentialFileFactory newFileFactory(SimpleString address) throws Exception {
        String tableName = "" + this.storageManager.generateID();
        SequentialFileFactory factory = this.newFileFactory(tableName, true);
        factory.start();
        SequentialFile file = factory.createSequentialFile(ADDRESS_FILE);
        file.open();
        ActiveMQBuffer buffer = ActiveMQBuffers.fixedBuffer((int)SimpleString.sizeofNullableString((SimpleString)address));
        buffer.writeSimpleString(address);
        file.write(buffer, true);
        file.close();
        return factory;
    }

    @Override
    public synchronized void removeFileFactory(SequentialFileFactory fileFactory) throws Exception {
        ((JDBCSequentialFileFactory)fileFactory).destroy();
        String tableName = this.factoryToTableName.remove(fileFactory);
        if (tableName != null) {
            SimpleString removeTableName = SimpleString.toSimpleString((String)tableName);
            JDBCSequentialFile directoryList = (JDBCSequentialFile)this.pagingFactoryFileFactory.createSequentialFile(DIRECTORY_NAME);
            directoryList.open();
            int size = Long.valueOf(directoryList.size()).intValue();
            ActiveMQBuffer buffer = this.readActiveMQBuffer((SequentialFile)directoryList, size);
            ActiveMQBuffer writeBuffer = ActiveMQBuffers.fixedBuffer((int)size);
            while (buffer.readableBytes() > 0) {
                SimpleString table = buffer.readSimpleString();
                if (removeTableName.equals((Object)table)) continue;
                writeBuffer.writeSimpleString(table);
            }
            directoryList.sendToDB(writeBuffer, null, false);
            directoryList.close();
        }
    }

    @Override
    public void setPagingManager(PagingManager pagingManager) {
        this.pagingManager = pagingManager;
    }

    @Override
    public synchronized List<PagingStore> reloadStores(HierarchicalRepository<AddressSettings> addressSettingsRepository) throws Exception {
        JDBCSequentialFile directoryList = (JDBCSequentialFile)this.pagingFactoryFileFactory.createSequentialFile(DIRECTORY_NAME);
        directoryList.open();
        int size = Long.valueOf(directoryList.size()).intValue();
        ActiveMQBuffer buffer = this.readActiveMQBuffer((SequentialFile)directoryList, size);
        ArrayList<PagingStore> storesReturn = new ArrayList<PagingStore>();
        while (buffer.readableBytes() > 0) {
            SimpleString table = buffer.readSimpleString();
            JDBCSequentialFileFactory factory = (JDBCSequentialFileFactory)this.newFileFactory(table.toString(), false);
            factory.start();
            JDBCSequentialFile addressFile = (JDBCSequentialFile)factory.createSequentialFile(ADDRESS_FILE);
            addressFile.open();
            size = Long.valueOf(addressFile.size()).intValue();
            if (size == 0) continue;
            ActiveMQBuffer addrBuffer = this.readActiveMQBuffer((SequentialFile)addressFile, size);
            SimpleString address = addrBuffer.readSimpleString();
            AddressSettings settings = addressSettingsRepository.getMatch(address.toString());
            PagingStoreImpl store = new PagingStoreImpl(address, this.scheduledExecutor, this.syncTimeout, this.pagingManager, this.storageManager, (SequentialFileFactory)factory, this, address, settings, this.executorFactory.getExecutor().setFair(true), this.ioExecutorFactory.getExecutor(), this.syncNonTransactional);
            storesReturn.add(store);
        }
        directoryList.close();
        return storesReturn;
    }

    private synchronized SequentialFileFactory newFileFactory(String directoryName, boolean writeToDirectory) throws Exception {
        JDBCSequentialFile directoryList = (JDBCSequentialFile)this.pagingFactoryFileFactory.createSequentialFile(DIRECTORY_NAME);
        directoryList.open();
        SimpleString simpleString = SimpleString.toSimpleString((String)directoryName);
        ActiveMQBuffer buffer = ActiveMQBuffers.fixedBuffer((int)simpleString.sizeof());
        buffer.writeSimpleString(simpleString);
        if (writeToDirectory) {
            directoryList.write(buffer, true);
        }
        directoryList.close();
        Object sqlProviderFactory = this.dbConf.getSqlProviderFactory() != null ? this.dbConf.getSqlProviderFactory() : new PropertySQLProvider.Factory(this.dbConf.getConnectionProvider());
        SQLProvider sqlProvider = sqlProviderFactory.create(this.getTableNameForGUID(directoryName), SQLProvider.DatabaseStoreType.PAGE);
        JDBCSequentialFileFactory fileFactory = new JDBCSequentialFileFactory(this.dbConf.getConnectionProvider(), sqlProvider, (Executor)this.executorFactory.getExecutor(), this.scheduledExecutor, this.dbConf.getJdbcJournalSyncPeriodMillis(), this.criticalErrorListener);
        this.factoryToTableName.put((SequentialFileFactory)fileFactory, directoryName);
        return fileFactory;
    }

    private String getTableNameForGUID(String guid) {
        return this.dbConf.getPageStoreTableName() + guid.replace("-", "");
    }

    private ActiveMQBuffer readActiveMQBuffer(SequentialFile file, int size) throws Exception {
        ByteBuffer byteBuffer = ByteBuffer.allocate(size);
        byteBuffer.mark();
        file.read(byteBuffer);
        byteBuffer.reset();
        ActiveMQBuffer buffer = ActiveMQBuffers.wrappedBuffer((ByteBuffer)byteBuffer);
        buffer.writerIndex(size);
        return buffer;
    }
}

