/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlplatform.synthetic.xml;

import com.xebialabs.deployit.plugin.api.reflect.InputHintValue;
import com.xebialabs.xlplatform.synthetic.InputHintSpecification;
import com.xebialabs.xlplatform.synthetic.TypeName;
import com.xebialabs.xlplatform.synthetic.ValidationRuleSpecification;
import com.xebialabs.xlplatform.synthetic.xml.XmlElement;
import com.xebialabs.xlplatform.synthetic.xml.XmlPropertySpecification;
import com.xebialabs.xlplatform.synthetic.xml.XmlUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.w3c.dom.Element;

public class XmlInputHintSpecification
extends XmlElement
implements InputHintSpecification {
    public XmlInputHintSpecification(Element element) {
        super(element);
    }

    @Override
    public List<InputHintValue> getValues() {
        ArrayList<InputHintValue> inputHintValues = new ArrayList<InputHintValue>();
        XmlUtils.forEach(XmlUtils.childByName(this.element, "values"::equals), valuesElement -> XmlUtils.forEach(XmlUtils.childByName(valuesElement, "value"::equals), valueElement -> {
            String value = valueElement.getTextContent();
            String label = XmlUtils.getOptionalStringAttribute(valueElement, "label", value);
            inputHintValues.add(InputHintValue.inputHintValue((String)value, (String)label));
        }));
        return inputHintValues;
    }

    @Override
    public List<ValidationRuleSpecification> getValidationRules() {
        return new XmlPropertySpecification(this.element).getValidationRules();
    }

    @Override
    public Optional<String> getPrompt() {
        return XmlUtils.getOptionalTextOfChild(this.element, "prompt");
    }

    @Override
    public Optional<String> getCopyFromProperty() {
        return XmlUtils.getOptionalTextOfChild(this.element, "copy-from-property");
    }

    @Override
    public Optional<TypeName> getReferencedType() {
        return Optional.ofNullable(XmlUtils.getOptionalTypeAttribute(this.element, "referenced-type"));
    }

    @Override
    public Optional<String> getMethodRef() {
        return XmlUtils.getOptionalString(this.element, "method-ref");
    }

    @Override
    public Optional<Boolean> getDynamicLookup() {
        return XmlUtils.getOptionalBoolean(this.element, "dynamic-lookup");
    }
}

