/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.ratelimiter.event;

import io.github.resilience4j.ratelimiter.event.RateLimiterEvent;
import java.time.ZonedDateTime;

public abstract class AbstractRateLimiterEvent
implements RateLimiterEvent {
    private final String rateLimiterName;
    private final int numberOfPermits;
    private final ZonedDateTime creationTime;

    public AbstractRateLimiterEvent(String rateLimiterName) {
        this(rateLimiterName, 1);
    }

    public AbstractRateLimiterEvent(String rateLimiterName, int numberOfPermits) {
        this.rateLimiterName = rateLimiterName;
        this.numberOfPermits = numberOfPermits;
        this.creationTime = ZonedDateTime.now();
    }

    @Override
    public String getRateLimiterName() {
        return this.rateLimiterName;
    }

    @Override
    public int getNumberOfPermits() {
        return this.numberOfPermits;
    }

    @Override
    public ZonedDateTime getCreationTime() {
        return this.creationTime;
    }

    public String toString() {
        return "RateLimiterEvent{type=" + (Object)((Object)this.getEventType()) + ", rateLimiterName='" + this.getRateLimiterName() + '\'' + ", creationTime=" + this.getCreationTime() + '}';
    }
}

