/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlplatform.synthetic.xml;

import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.xlplatform.synthetic.CreatorSpecification;
import com.xebialabs.xlplatform.synthetic.DefaultGeneratedDeployableSpecification;
import com.xebialabs.xlplatform.synthetic.GeneratedDeployableSpecification;
import com.xebialabs.xlplatform.synthetic.TypeName;
import com.xebialabs.xlplatform.synthetic.TypeSpecification;
import com.xebialabs.xlplatform.synthetic.xml.XmlBaseTypeSpecification;
import com.xebialabs.xlplatform.synthetic.xml.XmlCreatorSpecification;
import com.xebialabs.xlplatform.synthetic.xml.XmlUtils;
import java.util.Iterator;
import java.util.Optional;
import org.w3c.dom.Element;

public class XmlTypeSpecification
extends XmlBaseTypeSpecification
implements TypeSpecification {
    public XmlTypeSpecification(Element element) {
        super(element);
    }

    @Override
    public boolean hasGenerateDeployable() {
        return XmlUtils.childByName(this.element, "generate-deployable"::equals).hasNext();
    }

    @Override
    public TypeSpecification getGenerateDeployable() {
        Iterator<Element> generatedTypes = XmlUtils.childByName(this.element, "generate-deployable"::equals);
        if (generatedTypes.hasNext()) {
            return new XmlTypeSpecification(generatedTypes.next());
        }
        return null;
    }

    @Override
    public TypeName getSuperType() {
        return XmlUtils.getRequiredTypeAttribute(this.element, "extends");
    }

    @Override
    public Optional<String> getLabel() {
        return XmlUtils.getOptionalString(this.element, "label");
    }

    @Override
    public Optional<String> getDescription() {
        return XmlUtils.getOptionalString(this.element, "description");
    }

    @Override
    public Optional<Boolean> getInspectable() {
        return XmlUtils.getOptionalBoolean(this.element, "inspectable");
    }

    @Override
    public Optional<String> getIcon() {
        Iterator<Element> generateElements = XmlUtils.childByName(this.element, "icon"::equals);
        if (generateElements.hasNext()) {
            Element iconElement = generateElements.next();
            return Optional.ofNullable(iconElement.getTextContent());
        }
        return Optional.empty();
    }

    @Override
    public Optional<String> getRoot() {
        return XmlUtils.getOptionalString(this.element, "root").flatMap(rootName -> {
            for (Metadata.ConfigurationItemRoot configurationItemRoot : Metadata.ConfigurationItemRoot.values()) {
                if (!rootName.equalsIgnoreCase(configurationItemRoot.getRootNodeName())) continue;
                if (configurationItemRoot == Metadata.ConfigurationItemRoot.BY_ROOT_NAME) {
                    return Optional.of(XmlUtils.getRequiredStringAttribute(this.element, "rootName"));
                }
                return Optional.of(configurationItemRoot.getRootNodeName());
            }
            return Optional.empty();
        });
    }

    @Override
    public Optional<TypeName> getDeployedType() {
        return XmlUtils.getOptionalType(this.element, "deployable-type");
    }

    @Override
    public Optional<TypeName> getContainerType() {
        return XmlUtils.getOptionalType(this.element, "container-type");
    }

    @Override
    public GeneratedDeployableSpecification getGeneratedDeployableDescription() {
        Iterator<Element> generateElements = XmlUtils.childByName(this.element, "generate-deployable"::equals);
        if (generateElements.hasNext()) {
            Element generateDeployable = generateElements.next();
            return new DefaultGeneratedDeployableSpecification(XmlUtils.getRequiredTypeAttribute(generateDeployable, "type"), XmlUtils.getRequiredTypeAttribute(generateDeployable, "extends"), XmlUtils.getOptionalBooleanAttribute(generateDeployable, "copy-default-values", false), XmlUtils.getOptionalBooleanAttribute(generateDeployable, "virtual", false), XmlUtils.getOptionalStringAttribute(generateDeployable, "description", "Description unavailable"));
        }
        return null;
    }

    @Override
    public Optional<CreatorSpecification> getCreator() {
        Iterator<Element> creatorElements = XmlUtils.childByName(this.element, "creator"::equals);
        if (creatorElements.hasNext()) {
            Element creatorElement = creatorElements.next();
            XmlCreatorSpecification creatorSpecification = new XmlCreatorSpecification(creatorElement);
            return Optional.of(creatorSpecification);
        }
        return Optional.empty();
    }
}

