/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.booter.local;

import com.xebialabs.deployit.booter.local.ClassBasedTypeDefinition;
import com.xebialabs.deployit.booter.local.GenerateDeployableTypeDefinition;
import com.xebialabs.deployit.booter.local.GeneratedParameterTypeDefinition;
import com.xebialabs.deployit.booter.local.LocalDescriptor;
import com.xebialabs.deployit.booter.local.SyntheticBasedTypeDefinition;
import com.xebialabs.deployit.booter.local.TypeDefinition;
import com.xebialabs.deployit.booter.local.TypeDefinitionsRegistry;
import com.xebialabs.deployit.booter.local.utils.CheckUtils;
import com.xebialabs.deployit.plugin.api.reflect.IDescriptorRegistry;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.xlplatform.synthetic.BaseTypeSpecification;
import com.xebialabs.xlplatform.synthetic.MethodSpecification;
import com.xebialabs.xlplatform.synthetic.TypeModificationSpecification;
import com.xebialabs.xlplatform.synthetic.TypeSpecification;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TypeDefinitions {
    private final Map<Type, TypeDefinition> typeDefs = new HashMap<Type, TypeDefinition>();
    private IDescriptorRegistry descriptorRegistry;
    private static final Logger logger = LoggerFactory.getLogger(TypeDefinitions.class);

    public TypeDefinitions(IDescriptorRegistry descriptorRegistry, Collection<TypeDefinition> existingTypeDefinitions) {
        this.descriptorRegistry = descriptorRegistry;
        existingTypeDefinitions.forEach(this::addTypeDef);
        TypeDefinitionsRegistry.register(descriptorRegistry.getId(), this);
    }

    public TypeDefinitions(IDescriptorRegistry descriptorRegistry) {
        this(descriptorRegistry, Collections.emptyList());
    }

    public void addTypeDef(TypeDefinition typeDef) {
        CheckUtils.checkState(!this.typeDefs.containsKey(typeDef.type), "Trying to register duplicate definition for type [%s]. Existing: [%s], duplicate: [%s]", typeDef.type, this.typeDefs.get(typeDef.type), typeDef);
        this.typeDefs.put(typeDef.type, typeDef);
    }

    public Collection<TypeDefinition> getDefinitions() {
        return new ArrayList<TypeDefinition>(this.typeDefs.values());
    }

    private TypeDefinition getDefinition(Type type) {
        return CheckUtils.checkNotNull(this.typeDefs.get(type), "Could not find a type definition associated with type [%s]", type);
    }

    public void defineType(Class clazz) {
        ClassBasedTypeDefinition typeDef = new ClassBasedTypeDefinition(this.descriptorRegistry, clazz);
        this.addTypeDef(typeDef);
        logger.debug("Found: {}", (Object)typeDef);
    }

    public void defineType(TypeSpecification typeSpec) {
        this.addTypeDef(new SyntheticBasedTypeDefinition(this.descriptorRegistry, typeSpec));
        if (typeSpec.hasGenerateDeployable()) {
            Type ownerType = typeSpec.getTypeName().toType(this.descriptorRegistry);
            this.addTypeDef(new GenerateDeployableTypeDefinition(ownerType, typeSpec.getGenerateDeployable()));
        }
        this.findAllGeneratedParameterTypes(typeSpec);
    }

    public void redefineType(TypeSpecification typeSpec) {
        SyntheticBasedTypeDefinition typeDef = new SyntheticBasedTypeDefinition(this.descriptorRegistry, typeSpec);
        this.typeDefs.put(typeDef.type, typeDef);
        if (typeSpec.hasGenerateDeployable()) {
            Type ownerType = typeSpec.getTypeName().toType(this.descriptorRegistry);
            GenerateDeployableTypeDefinition generatedTypeDef = new GenerateDeployableTypeDefinition(ownerType, typeSpec.getGenerateDeployable());
            this.typeDefs.put(generatedTypeDef.type, generatedTypeDef);
        }
        this.findAllGeneratedParameterTypes(typeSpec);
    }

    void modifyType(TypeModificationSpecification typeModification) {
        Type modifiedType = typeModification.getTypeName().toType(this.descriptorRegistry);
        CheckUtils.checkState(this.typeDefs.containsKey(modifiedType), "Detected type-modification for non-existing type [%s]", modifiedType);
        this.typeDefs.get(modifiedType).addTypeModification(typeModification);
        this.findAllGeneratedParameterTypes(typeModification);
        logger.debug("Found: {}", (Object)typeModification);
    }

    private void findAllGeneratedParameterTypes(BaseTypeSpecification type) {
        for (MethodSpecification method : type.getMethods()) {
            if (method.getParameters().isEmpty()) continue;
            this.defineGeneratedParameterType(method, type);
        }
    }

    void defineGeneratedParameterType(MethodSpecification methodDef, BaseTypeSpecification baseType) {
        GeneratedParameterTypeDefinition typeDef = new GeneratedParameterTypeDefinition(this.descriptorRegistry, baseType, methodDef);
        this.addTypeDef(typeDef);
        logger.debug("Found: {}", (Object)typeDef);
    }

    public void registerTypes() {
        this.getDefinitions().forEach(definition -> this.registerAsSubtype((TypeDefinition)definition, definition.type));
        this.getDefinitions().forEach(this::register);
    }

    private void registerAsSubtype(TypeDefinition definition, Type type) {
        if (definition.superType != null) {
            this.descriptorRegistry.registerSubtype(definition.superType, type);
            this.registerAsSubtype(this.getDefinition(definition.superType), type);
        }
        for (Type anInterface : definition.getInterfaces()) {
            this.descriptorRegistry.registerSubtype(anInterface, type);
        }
    }

    private void register(TypeDefinition definition) {
        if (this.descriptorRegistry.exists(definition.type)) {
            return;
        }
        if (definition.superType != null && !this.descriptorRegistry.exists(definition.superType)) {
            this.register(this.getDefinition(definition.superType));
        }
        for (Type anInterface : definition.getInterfaces()) {
            if (this.descriptorRegistry.exists(anInterface)) continue;
            this.register(this.getDefinition(anInterface));
        }
        if (definition.getOwner() != null && !this.descriptorRegistry.exists(definition.getOwner())) {
            this.register(this.getDefinition(definition.getOwner()));
        }
        LocalDescriptor descriptor = definition.createDescriptor();
        definition.applyTypeModifications(descriptor);
    }

    public IDescriptorRegistry getDescriptorRegistry() {
        return this.descriptorRegistry;
    }
}

