/*
 * Decompiled with CFR 0.152.
 */
package akka.http.impl.engine.http2;

import akka.annotation.InternalApi;
import akka.http.impl.engine.http2.Http2$;
import akka.http.impl.engine.http2.Http2Compliance;
import akka.http.impl.engine.http2.Http2SubStream;
import akka.http.impl.engine.http2.hpack.Http2HeaderParsing$Authority$;
import akka.http.impl.engine.http2.hpack.Http2HeaderParsing$ContentLength$;
import akka.http.impl.engine.http2.hpack.Http2HeaderParsing$ContentType$;
import akka.http.impl.engine.http2.hpack.Http2HeaderParsing$Cookie$;
import akka.http.impl.engine.http2.hpack.Http2HeaderParsing$Method$;
import akka.http.impl.engine.http2.hpack.Http2HeaderParsing$OtherHeader$;
import akka.http.impl.engine.http2.hpack.Http2HeaderParsing$PathAndQuery$;
import akka.http.impl.engine.http2.hpack.Http2HeaderParsing$Scheme$;
import akka.http.impl.engine.parsing.HttpHeaderParser;
import akka.http.impl.engine.server.HttpAttributes;
import akka.http.scaladsl.model.AttributeKeys$;
import akka.http.scaladsl.model.ContentType;
import akka.http.scaladsl.model.HttpHeader;
import akka.http.scaladsl.model.HttpMethod;
import akka.http.scaladsl.model.HttpProtocols$;
import akka.http.scaladsl.model.HttpRequest;
import akka.http.scaladsl.model.RemoteAddress;
import akka.http.scaladsl.model.RemoteAddress$;
import akka.http.scaladsl.model.RequestEntity;
import akka.http.scaladsl.model.SslSessionInfo$;
import akka.http.scaladsl.model.Uri;
import akka.http.scaladsl.model.Uri$;
import akka.http.scaladsl.model.Uri$Authority$;
import akka.http.scaladsl.model.headers.Remote$minusAddress;
import akka.http.scaladsl.model.headers.Tls$minusSession$minusInfo;
import akka.http.scaladsl.settings.ServerSettings;
import akka.stream.Attributes;
import akka.util.ByteString;
import akka.util.ByteString$;
import akka.util.OptionVal;
import akka.util.OptionVal$;
import java.io.Serializable;
import javax.net.ssl.SSLSession;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.StringOps$;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.collection.immutable.VectorBuilder;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;

@InternalApi
public final class RequestParsing$ {
    public static final RequestParsing$ MODULE$ = new RequestParsing$();

    public Function1<Http2SubStream, HttpRequest> parseRequest(HttpHeaderParser httpHeaderParser, ServerSettings serverSettings, Attributes streamAttributes) {
        Map map;
        Map map2;
        None$ remoteAddressHeader = serverSettings.remoteAddressHeader() ? streamAttributes.get(ClassTag$.MODULE$.apply(HttpAttributes.RemoteAddress.class)).map((Function1 & Serializable)remote -> new Remote$minusAddress(RemoteAddress$.MODULE$.apply(remote.address()))) : None$.MODULE$;
        None$ remoteAddressAttribute = serverSettings.remoteAddressAttribute() ? streamAttributes.get(ClassTag$.MODULE$.apply(HttpAttributes.RemoteAddress.class)).map((Function1 & Serializable)remote -> RemoteAddress$.MODULE$.apply(remote.address())) : None$.MODULE$;
        None$ tlsSessionInfoHeader = serverSettings.parserSettings().includeTlsSessionInfoHeader() ? streamAttributes.get(ClassTag$.MODULE$.apply(HttpAttributes.TLSSessionInfo.class)).map((Function1 & Serializable)sslSessionInfo -> new Tls$minusSession$minusInfo(sslSessionInfo.session())) : None$.MODULE$;
        None$ sslSessionAttribute = serverSettings.parserSettings().includeSslSessionAttribute() ? streamAttributes.get(ClassTag$.MODULE$.apply(HttpAttributes.TLSSessionInfo.class)).map((Function1 & Serializable)x$1 -> x$1.session()) : None$.MODULE$;
        Map map3 = Predef$.MODULE$.Map().empty();
        None$ none$ = sslSessionAttribute;
        if (none$ instanceof Some) {
            Some some = (Some)none$;
            SSLSession sslSession = (SSLSession)some.value();
            map2 = (Map)map3.updated(AttributeKeys$.MODULE$.sslSession(), (Object)SslSessionInfo$.MODULE$.apply(sslSession));
        } else if (None$.MODULE$.equals(none$)) {
            map2 = map3;
        } else {
            throw new MatchError((Object)none$);
        }
        map3 = map2;
        None$ none$2 = remoteAddressAttribute;
        if (none$2 instanceof Some) {
            Some some = (Some)none$2;
            RemoteAddress remoteAddress = (RemoteAddress)some.value();
            map = (Map)map3.updated(AttributeKeys$.MODULE$.remoteAddress(), (Object)remoteAddress);
        } else if (None$.MODULE$.equals(none$2)) {
            map = map3;
        } else {
            throw new MatchError((Object)none$2);
        }
        Map baseAttributes = map3 = map;
        return arg_0 -> RequestParsing$.$anonfun$parseRequest$5(this, httpHeaderParser, (Option)remoteAddressHeader, (Option)tlsSessionInfoHeader, baseAttributes, serverSettings, arg_0);
    }

    public HttpHeader parseHeaderPair(HttpHeaderParser httpHeaderParser, String name, String value) {
        String concHeaderLine = new java.lang.StringBuilder(5).append(name).append(": ").append(value).append("\r\nx").toString();
        ByteString x$1 = ByteString$.MODULE$.apply(concHeaderLine);
        int x$2 = httpHeaderParser.parseHeaderLine$default$2();
        int x$3 = httpHeaderParser.parseHeaderLine$default$3(x$1, x$2);
        int x$4 = httpHeaderParser.parseHeaderLine$default$4(x$1, x$2);
        httpHeaderParser.parseHeaderLine(x$1, x$2, x$3, x$4);
        return httpHeaderParser.resultHeader();
    }

    public void checkRequiredPseudoHeader(String name, Object value) {
        if (value == null) {
            throw this.malformedRequest(new java.lang.StringBuilder(34).append("Mandatory pseudo-header '").append(name).append("' missing").toString());
        }
    }

    public void checkUniquePseudoHeader(String name, Object value) {
        if (value != null) {
            throw this.malformedRequest(new java.lang.StringBuilder(46).append("Pseudo-header '").append(name).append("' must not occur more than once").toString());
        }
    }

    public void checkNoRegularHeadersBeforePseudoHeader(String name, boolean seenRegularHeader) {
        if (seenRegularHeader) {
            throw this.malformedRequest(new java.lang.StringBuilder(61).append("Pseudo-header field '").append(name).append("' must not appear after a regular header").toString());
        }
    }

    public Nothing$ malformedRequest(String msg) {
        throw new Http2Compliance.Http2ProtocolException(new java.lang.StringBuilder(19).append("Malformed request: ").append(msg).toString());
    }

    public void validateHeader(HttpHeader httpHeader) {
        String string = httpHeader.lowercaseName();
        switch (string == null ? 0 : string.hashCode()) {
            case -775651618: {
                if ("connection".equals(string)) {
                    throw this.malformedRequest("Header 'Connection' must not be used with HTTP/2");
                }
                break;
            }
            case 3697: {
                if ("te".equals(string) && httpHeader.value().compareToIgnoreCase("trailers") != 0) {
                    throw this.malformedRequest(new java.lang.StringBuilder(69).append("Header 'TE' must not contain value other than 'trailers', value was '").append(httpHeader.value()).toString());
                }
                break;
            }
            case 1274458357: {
                if ("transfer-encoding".equals(string)) {
                    throw this.malformedRequest("Header 'Transfer-Encoding' must not be used with HTTP/2");
                }
                break;
            }
        }
    }

    private static final HttpRequest createRequest$1(HttpMethod method, String scheme, Uri.Authority authority, Tuple2 pathAndRawQuery, ContentType contentType, long contentLength, StringBuilder cookies, VectorBuilder headers2, HttpHeaderParser httpHeaderParser$1, Option remoteAddressHeader$1, Option tlsSessionInfoHeader$1, Http2SubStream subStream$1, Map baseAttributes$1) {
        MODULE$.checkRequiredPseudoHeader(":scheme", scheme);
        MODULE$.checkRequiredPseudoHeader(":method", method);
        MODULE$.checkRequiredPseudoHeader(":path", pathAndRawQuery);
        Object object = cookies != null ? headers2.$plus$eq((Object)MODULE$.parseHeaderPair(httpHeaderParser$1, "cookie", cookies.toString())) : BoxedUnit.UNIT;
        Object object2 = remoteAddressHeader$1.isDefined() ? headers2.$plus$eq(remoteAddressHeader$1.get()) : BoxedUnit.UNIT;
        Object object3 = tlsSessionInfoHeader$1.isDefined() ? headers2.$plus$eq(tlsSessionInfoHeader$1.get()) : BoxedUnit.UNIT;
        RequestEntity entity = subStream$1.createEntity(contentLength, contentType);
        Tuple2 tuple2 = pathAndRawQuery;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Uri.Path path = (Uri.Path)tuple2._1();
        Option rawQueryString = (Option)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)path, (Object)rawQueryString);
        Uri.Path path2 = (Uri.Path)tuple22._1();
        Option rawQueryString2 = (Option)tuple22._2();
        Uri.Authority authorityOrDefault = authority == null ? Uri$Authority$.MODULE$.Empty() : authority;
        Uri uri = Uri$.MODULE$.apply(scheme, authorityOrDefault, path2, (Option<String>)rawQueryString2, Uri$.MODULE$.apply$default$5());
        Map attributes = (Map)baseAttributes$1.updated(Http2$.MODULE$.streamId(), (Object)BoxesRunTime.boxToInteger((int)subStream$1.streamId()));
        return new HttpRequest(method, uri, (Seq<HttpHeader>)headers2.result(), attributes, entity, HttpProtocols$.MODULE$.HTTP$div2$u002E0());
    }

    private final HttpRequest rec$1(IndexedSeq incomingHeaders, int offset, HttpMethod method, String scheme, Uri.Authority authority, Tuple2 pathAndRawQuery, ContentType contentType, long contentLength, StringBuilder cookies, boolean seenRegularHeader, VectorBuilder headers2, HttpHeaderParser httpHeaderParser$1, Option remoteAddressHeader$1, Option tlsSessionInfoHeader$1, Http2SubStream subStream$1, Map baseAttributes$1) {
        block10: while (offset != incomingHeaders.size()) {
            Tuple2 tuple2 = (Tuple2)incomingHeaders.apply(offset);
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String name = (String)tuple2._1();
            Object value = tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)name, value);
            String name2 = (String)tuple22._1();
            Object value2 = tuple22._2();
            String string = name2;
            switch (string == null ? 0 : string.hashCode()) {
                case -1354757532: {
                    if (!"cookie".equals(string)) break;
                    StringBuilder cookiesBuilder = cookies == null ? new StringBuilder() : cookies.append("; ");
                    cookiesBuilder.append((String)Http2HeaderParsing$Cookie$.MODULE$.get(value2));
                    seenRegularHeader = true;
                    cookies = cookiesBuilder;
                    ++offset;
                    continue block10;
                }
                case -1332238263: {
                    if (!":authority".equals(string)) break;
                    this.checkUniquePseudoHeader(":authority", authority);
                    this.checkNoRegularHeadersBeforePseudoHeader(":authority", seenRegularHeader);
                    authority = (Uri.Authority)Http2HeaderParsing$Authority$.MODULE$.get(value2);
                    ++offset;
                    continue block10;
                }
                case -1141949029: {
                    if (!":method".equals(string)) break;
                    this.checkUniquePseudoHeader(":method", method);
                    this.checkNoRegularHeadersBeforePseudoHeader(":method", seenRegularHeader);
                    method = (HttpMethod)Http2HeaderParsing$Method$.MODULE$.get(value2);
                    ++offset;
                    continue block10;
                }
                case -1132779846: {
                    if (!"content-length".equals(string)) break;
                    if (contentLength == -1L) {
                        long contentLengthValue = StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString((String)Http2HeaderParsing$ContentLength$.MODULE$.get(value2)));
                        if (contentLengthValue < 0L) {
                            throw this.malformedRequest("HTTP message must not contain a negative content-length header");
                        }
                        seenRegularHeader = true;
                        contentLength = contentLengthValue;
                        ++offset;
                        continue block10;
                    }
                    throw this.malformedRequest("HTTP message must not contain more than one content-length header");
                }
                case -972381601: {
                    if (!":scheme".equals(string)) break;
                    this.checkUniquePseudoHeader(":scheme", scheme);
                    this.checkNoRegularHeadersBeforePseudoHeader(":scheme", seenRegularHeader);
                    scheme = (String)Http2HeaderParsing$Scheme$.MODULE$.get(value2);
                    ++offset;
                    continue block10;
                }
                case -956875604: {
                    if (!":status".equals(string)) break;
                    throw this.malformedRequest("Pseudo-header ':status' is for responses only; it cannot appear in a request");
                }
                case 56997727: {
                    if (!":path".equals(string)) break;
                    this.checkUniquePseudoHeader(":path", pathAndRawQuery);
                    this.checkNoRegularHeadersBeforePseudoHeader(":path", seenRegularHeader);
                    pathAndRawQuery = (Tuple2)Http2HeaderParsing$PathAndQuery$.MODULE$.get(value2);
                    ++offset;
                    continue block10;
                }
                case 785670158: {
                    if (!"content-type".equals(string)) break;
                    if (OptionVal$.MODULE$.isEmpty$extension((Object)contentType)) {
                        seenRegularHeader = true;
                        contentType = (ContentType)OptionVal.Some$.MODULE$.apply(Http2HeaderParsing$ContentType$.MODULE$.get(value2));
                        ++offset;
                        continue block10;
                    }
                    throw this.malformedRequest("HTTP message must not contain more than one content-type header");
                }
            }
            headers2 = (VectorBuilder)headers2.$plus$eq(Http2HeaderParsing$OtherHeader$.MODULE$.get(value2));
            seenRegularHeader = true;
            ++offset;
        }
        return RequestParsing$.createRequest$1(method, scheme, authority, pathAndRawQuery, contentType, contentLength, cookies, headers2, httpHeaderParser$1, remoteAddressHeader$1, tlsSessionInfoHeader$1, subStream$1, baseAttributes$1);
    }

    private static final HttpMethod rec$default$3$1() {
        return null;
    }

    private static final String rec$default$4$1() {
        return null;
    }

    private static final Uri.Authority rec$default$5$1() {
        return null;
    }

    private static final Tuple2 rec$default$6$1() {
        return null;
    }

    private static final ContentType rec$default$7$1() {
        OptionVal$.MODULE$.None();
        return null;
    }

    private static final long rec$default$8$1() {
        return -1L;
    }

    private static final StringBuilder rec$default$9$1() {
        return null;
    }

    private static final boolean rec$default$10$1() {
        return false;
    }

    private static final VectorBuilder rec$default$11$1() {
        return new VectorBuilder();
    }

    public static final /* synthetic */ HttpRequest $anonfun$parseRequest$5(RequestParsing$ $this, HttpHeaderParser httpHeaderParser$1, Option remoteAddressHeader$1, Option tlsSessionInfoHeader$1, Map baseAttributes$1, ServerSettings serverSettings$1, Http2SubStream subStream) {
        IndexedSeq incomingHeaders = subStream.initialHeaders().keyValuePairs().toIndexedSeq();
        if (incomingHeaders.size() > serverSettings$1.parserSettings().maxHeaderCount()) {
            throw MODULE$.malformedRequest(new java.lang.StringBuilder(64).append("HTTP message contains more than the configured limit of ").append(serverSettings$1.parserSettings().maxHeaderCount()).append(" headers").toString());
        }
        return $this.rec$1(incomingHeaders, 0, RequestParsing$.rec$default$3$1(), RequestParsing$.rec$default$4$1(), RequestParsing$.rec$default$5$1(), RequestParsing$.rec$default$6$1(), RequestParsing$.rec$default$7$1(), RequestParsing$.rec$default$8$1(), RequestParsing$.rec$default$9$1(), RequestParsing$.rec$default$10$1(), RequestParsing$.rec$default$11$1(), httpHeaderParser$1, remoteAddressHeader$1, tlsSessionInfoHeader$1, subStream, baseAttributes$1);
    }

    private RequestParsing$() {
    }
}

