/*
 * Decompiled with CFR 0.152.
 */
package akka.http.impl.engine.http2.framing;

import akka.annotation.InternalApi;
import akka.http.impl.engine.http2.FrameEvent;
import akka.http.impl.engine.http2.Http2Protocol;
import akka.http.impl.engine.http2.framing.FrameRenderer$;
import akka.util.ByteString;
import akka.util.ByteString$;
import java.nio.ByteOrder;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005\u0005muA\u0002\u0011\"\u0011\u0003\u0019SF\u0002\u00040C!\u00051\u0005\r\u0005\u0006o\u0005!\t!\u000f\u0005\bu\u0005\u0011\r\u0011b\u0001<\u0011\u0019!\u0015\u0001)A\u0005y!)Q)\u0001C\u0001\r\")1+\u0001C\u0001)\u001e)q/\u0001E\u0005q\u001a)!0\u0001E\u0005w\")q\u0007\u0003C\u0001y\")Q\u0010\u0003C\u0001}\u001a)!0\u0001\u0003\u0002\u0002!I\u00111A\u0006\u0003\u0002\u0003\u0006IA\u001d\u0005\t-.\u0011\t\u0011)A\u0005/\"AAn\u0003B\u0001B\u0003%Q\u000e\u0003\u0005r\u0017\t\u0005\t\u0015!\u0003s\u0011\u001994\u0002\"\u0001\u0002\u0006!I\u0011qB\u0006C\u0002\u0013%\u0011\u0011\u0003\u0005\b\u0003'Y\u0001\u0015!\u0003s\u0011%\t)b\u0003b\u0001\n\u0013\t9\u0002\u0003\u0005\u0002&-\u0001\u000b\u0011BA\r\u0011%\t9c\u0003a\u0001\n\u0013\t\t\u0002C\u0005\u0002*-\u0001\r\u0011\"\u0003\u0002,!9\u0011qG\u0006!B\u0013\u0011\bbBA\u001d\u0017\u0011\u0005\u00111\b\u0005\b\u0003sYA\u0011AA(\u0011\u001d\tIf\u0003C\u0001\u00037Bq!a\u0019\f\t\u0003\t)\u0007C\u0004\u0002l-!\t!!\u001c\t\u000f\u0005E4\u0002\"\u0001\u0002t!9\u0011qO\u0006\u0005\u0002\u0005e\u0004bBA@\u0017\u0011\u0005\u0011\u0011Q\u0001\u000e\rJ\fW.\u001a*f]\u0012,'/\u001a:\u000b\u0005\t\u001a\u0013a\u00024sC6Lgn\u001a\u0006\u0003I\u0015\nQ\u0001\u001b;uaJR!AJ\u0014\u0002\r\u0015tw-\u001b8f\u0015\tA\u0013&\u0001\u0003j[Bd'B\u0001\u0016,\u0003\u0011AG\u000f\u001e9\u000b\u00031\nA!Y6lCB\u0011a&A\u0007\u0002C\tiaI]1nKJ+g\u000eZ3sKJ\u001c\"!A\u0019\u0011\u0005I*T\"A\u001a\u000b\u0003Q\nQa]2bY\u0006L!AN\u001a\u0003\r\u0005s\u0017PU3g\u0003\u0019a\u0014N\\5u}\r\u0001A#A\u0017\u0002\u0013\tLH/Z(sI\u0016\u0014X#\u0001\u001f\u0011\u0005u\u0012U\"\u0001 \u000b\u0005}\u0002\u0015a\u00018j_*\t\u0011)\u0001\u0003kCZ\f\u0017BA\"?\u0005%\u0011\u0015\u0010^3Pe\u0012,'/\u0001\u0006csR,wJ\u001d3fe\u0002\naA]3oI\u0016\u0014HCA$N!\tA5*D\u0001J\u0015\tQ5&\u0001\u0003vi&d\u0017B\u0001'J\u0005)\u0011\u0015\u0010^3TiJLgn\u001a\u0005\u0006\u001d\u0016\u0001\raT\u0001\u0006MJ\fW.\u001a\t\u0003!Fk\u0011aI\u0005\u0003%\u000e\u0012!B\u0012:b[\u0016,e/\u001a8u\u0003-\u0011XM\u001c3fe\u001a\u0013\u0018-\\3\u0015\u000b\u001d+6\u000e];\t\u000bY3\u0001\u0019A,\u0002\u0007Q\u0004X\r\u0005\u0002YQ:\u0011\u0011L\u001a\b\u00035\u0016t!a\u00173\u000f\u0005q\u001bgBA/c\u001d\tq\u0016-D\u0001`\u0015\t\u0001\u0007(\u0001\u0004=e>|GOP\u0005\u0002Y%\u0011!fK\u0005\u0003Q%J!AJ\u0014\n\u0005\u0011*\u0013BA4$\u00035AE\u000f\u001e93!J|Go\\2pY&\u0011\u0011N\u001b\u0002\n\rJ\fW.\u001a+za\u0016T!aZ\u0012\t\u000b14\u0001\u0019A7\u0002\u000b\u0019d\u0017mZ:\u0011\u0005As\u0017BA8$\u0005!\u0011\u0015\u0010^3GY\u0006<\u0007\"B9\u0007\u0001\u0004\u0011\u0018\u0001C:ue\u0016\fW.\u00133\u0011\u0005I\u001a\u0018B\u0001;4\u0005\rIe\u000e\u001e\u0005\u0006m\u001a\u0001\raR\u0001\ba\u0006LHn\\1e\u0003\u00151%/Y7f!\tI\b\"D\u0001\u0002\u0005\u00151%/Y7f'\tA\u0011\u0007F\u0001y\u0003\u0015\t\u0007\u000f\u001d7z)%y\u00181QAC\u0003\u000f\u000bI\t\u0005\u0002z\u0017M\u00111\"M\u0001\fa\u0006LHn\\1e'&TX\rF\u0005\u0000\u0003\u000f\tI!a\u0003\u0002\u000e!1\u00111\u0001\tA\u0002IDQA\u0016\tA\u0002]CQ\u0001\u001c\tA\u00025DQ!\u001d\tA\u0002I\f!\u0002^1sO\u0016$8+\u001b>f+\u0005\u0011\u0018a\u0003;be\u001e,GoU5{K\u0002\naAY;gM\u0016\u0014XCAA\r!\u0015\u0011\u00141DA\u0010\u0013\r\tib\r\u0002\u0006\u0003J\u0014\u0018-\u001f\t\u0004e\u0005\u0005\u0012bAA\u0012g\t!!)\u001f;f\u0003\u001d\u0011WO\u001a4fe\u0002\n1\u0001]8t\u0003\u001d\u0001xn]0%KF$B!!\f\u00024A\u0019!'a\f\n\u0007\u0005E2G\u0001\u0003V]&$\b\u0002CA\u001b-\u0005\u0005\t\u0019\u0001:\u0002\u0007a$\u0013'\u0001\u0003q_N\u0004\u0013a\u00049viB\u0013\u0018n\u001c:jifLeNZ8\u0015\u0007}\fi\u0004C\u0004\u0002@a\u0001\r!!\u0011\u0002\u001bA\u0014\u0018n\u001c:jif4%/Y7f!\u0011\t\u0019%!\u0013\u000f\u0007e\u000b)%C\u0002\u0002H\r\n!B\u0012:b[\u0016,e/\u001a8u\u0013\u0011\tY%!\u0014\u0003\u001bA\u0013\u0018n\u001c:jif4%/Y7f\u0015\r\t9e\t\u000b\u0004\u007f\u0006E\u0003bBA 3\u0001\u0007\u00111\u000b\t\u0006e\u0005U\u0013\u0011I\u0005\u0004\u0003/\u001a$AB(qi&|g.A\u0004qkR\u0014\u0015\u0010^3\u0015\t\u0005u\u0013qL\u0007\u0002\u0017!9\u0011\u0011\r\u000eA\u0002\u0005}\u0011\u0001\u00022zi\u0016\f\u0001\u0002];u\u0013:$8G\r\u000b\u0005\u0003;\n9\u0007\u0003\u0004\u0002jm\u0001\rA]\u0001\u0006m\u0006dW/Z\u0001\taV$\u0018J\u001c;3iQ!\u0011QLA8\u0011\u0019\tI\u0007\ba\u0001e\u0006A\u0001/\u001e;J]R\fd\u0007\u0006\u0003\u0002^\u0005U\u0004BBA5;\u0001\u0007!/A\u0002qkR$B!!\u0018\u0002|!1\u0011Q\u0010\u0010A\u0002\u001d\u000bQAY=uKN\fQAY;jY\u0012$\u0012a\u0012\u0005\u0007\u0003\u0007Q\u0001\u0019\u0001:\t\u000bYS\u0001\u0019A,\t\u000b1T\u0001\u0019A7\t\u000bET\u0001\u0019\u0001:)\u0007\u0005\ti\t\u0005\u0003\u0002\u0010\u0006UUBAAI\u0015\r\t\u0019jK\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BAL\u0003#\u00131\"\u00138uKJt\u0017\r\\!qS\"\u001a\u0001!!$")
@InternalApi
public final class FrameRenderer {
    public static ByteString renderFrame(Http2Protocol.FrameType tpe, int flags, int streamId, ByteString payload) {
        return FrameRenderer$.MODULE$.renderFrame(tpe, flags, streamId, payload);
    }

    public static ByteString render(FrameEvent frame) {
        return FrameRenderer$.MODULE$.render(frame);
    }

    public static ByteOrder byteOrder() {
        return FrameRenderer$.MODULE$.byteOrder();
    }

    private static class Frame {
        private final int targetSize;
        private final byte[] buffer;
        private int pos;

        private int targetSize() {
            return this.targetSize;
        }

        private byte[] buffer() {
            return this.buffer;
        }

        private int pos() {
            return this.pos;
        }

        private void pos_$eq(int x$1) {
            this.pos = x$1;
        }

        public Frame putPriorityInfo(FrameEvent.PriorityFrame priorityFrame) {
            int exclusiveBit = priorityFrame.exclusiveFlag() ? Integer.MIN_VALUE : 0;
            this.putInt32(exclusiveBit | priorityFrame.streamDependency());
            return this.putByte((byte)priorityFrame.weight());
        }

        public Frame putPriorityInfo(Option<FrameEvent.PriorityFrame> priorityFrame) {
            Option<FrameEvent.PriorityFrame> option = priorityFrame;
            if (option instanceof Some) {
                Some some = (Some)option;
                FrameEvent.PriorityFrame p = (FrameEvent.PriorityFrame)some.value();
                return this.putPriorityInfo(p);
            }
            if (None$.MODULE$.equals(option)) {
                return this;
            }
            throw new MatchError(option);
        }

        public Frame putByte(byte by) {
            this.buffer()[this.pos()] = by;
            this.pos_$eq(this.pos() + 1);
            return this;
        }

        public Frame putInt32(int value) {
            this.buffer()[this.pos() + 0] = (byte)(value >> 24);
            this.buffer()[this.pos() + 1] = (byte)(value >> 16);
            this.buffer()[this.pos() + 2] = (byte)(value >> 8);
            this.buffer()[this.pos() + 3] = (byte)(value >> 0);
            this.pos_$eq(this.pos() + 4);
            return this;
        }

        public Frame putInt24(int value) {
            this.buffer()[this.pos() + 0] = (byte)(value >> 16);
            this.buffer()[this.pos() + 1] = (byte)(value >> 8);
            this.buffer()[this.pos() + 2] = (byte)(value >> 0);
            this.pos_$eq(this.pos() + 3);
            return this;
        }

        public Frame putInt16(int value) {
            this.buffer()[this.pos() + 0] = (byte)(value >> 8);
            this.buffer()[this.pos() + 1] = (byte)(value >> 0);
            this.pos_$eq(this.pos() + 2);
            return this;
        }

        public Frame put(ByteString bytes) {
            if (bytes.isEmpty()) {
                return this;
            }
            bytes.copyToArray((Object)this.buffer(), this.pos());
            this.pos_$eq(this.pos() + bytes.length());
            return this;
        }

        public ByteString build() {
            if (this.pos() != this.targetSize()) {
                throw new IllegalStateException(new StringBuilder(33).append("Did not write exactly ").append(this.targetSize()).append(" bytes but ").append(this.pos()).toString());
            }
            return ByteString$.MODULE$.fromArrayUnsafe(this.buffer());
        }

        public Frame(int payloadSize, Http2Protocol.FrameType tpe, int flags, int streamId) {
            this.targetSize = 9 + payloadSize;
            this.buffer = new byte[this.targetSize()];
            this.pos = 0;
            this.putInt24(payloadSize);
            this.putByte((byte)tpe.id());
            this.putByte((byte)flags);
            this.putInt32(streamId);
        }
    }
}

